# Tutorial - Command Line Tools

## pyInfinityFlow Tutorial

This tutorial uses the pyInfinityFlow command line tool to carry out the full analysis pipeline with an example dataset. This example is a subset of the previously published mouse lung dataset[[1]](https://www.science.org/doi/10.1126/sciadv.abg0505), the full data set was made publicly available [here](https://flowrepository.org/id/FR-FCM-Z2LP) in flowrepository.org. You can download the subset with the [pyInfinityFlow repository on GitHub](https://github.com/KyleFerchen/pyInfinityFlow), which consists of 10 InfinityMarkers and 5 Isotype controls located in the ['example_dataset'](https://github.com/KyleFerchen/pyInfinityFlow/tree/main/example_data) directory. This directory also contains the relevant InfinityMarker annotation file as well as the Backbone annotation file, which are necessary for the analysis pipeline.

You can download the repository after [Git has been installed](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git) by changing directories to where you want to install it and by using the following command:
```
git clone https://github.com/KyleFerchen/pyInfinityFlow.git
```

### Example
```
pyInfinityFlow --data_dir /home/kyle/Documents/GitHub/pyInfinityFlow/example_data/mouse_lung_dataset_subset/ \
    --out_dir /media/kyle_ssd1/example_outputs/ \
    --backbone_annotation /home/kyle/Documents/GitHub/pyInfinityFlow/example_data/mouse_lung_dataset_subset_backbone_anno.csv \
    --infinity_marker_annotation /home/kyle/Documents/GitHub/pyInfinityFlow/example_data/mouse_lung_dataset_subset_infinity_marker_anno.csv \
    --use_logicle_scaling True \
    --normalization_method None \
    --n_events_train 0 \
    --n_events_validate 0 \
    --ratio_for_validation 0.5 \
    --separate_backbone_reference None \
    --n_events_combine 10000 \
    --n_final 0 \
    --add_umap True \
    --find_clusters True \
    --find_markers True \
    --make_feature_plots True \
    --use_pca True \
    --n_pc 15 \
    --n_pc_plot_qc 50 \
    --save_h5ad True \
    --save_feather True \
    --save_file_handler True \
    --save_regression_models True \
    --verbosity 1 \
    --n_cores 12
```


### Example standard output:
```
Running InfinityFlow from single directory, with all input .fcs files using the same channels for backbone...
Isotype controls detected. Will attempt to use background correction...
Reading in data from .fcs files for model training...
Applying Logicle normalization to data...
Reading in data from .fcs files for model validation...
Applying Logicle normalization to data...
Obtaining validation metrics for regression models...
		Working on 33D1...
		Working on Allergin-1...
		Working on B7-H4...
		Working on CD1d...
		Working on CD103...
		Working on CD105...
		Working on CD106...
		Working on CD107a (Lamp-1)...
		Working on CD107b (Mac-3)...
		Working on CD115...
		Working on Isotype_rIgG2b...
		Working on Isotype_mIgG1...
		Working on Isotype_AHIgG...
		Working on Isotype_rIgG2a...
		Working on Isotype_rIgG1...
Reading in data from .fcs files for pooling into final InfinityFlow object...
Applying Logicle normalization to data...
Making predictions for final InfinityFlow object...
		Working on 33D1...
		Working on Allergin-1...
		Working on B7-H4...
		Working on CD1d...
		Working on CD103...
		Working on CD105...
		Working on CD106...
		Working on CD107a (Lamp-1)...
		Working on CD107b (Mac-3)...
		Working on CD115...
		Working on Isotype_rIgG2b...
		Working on Isotype_mIgG1...
		Working on Isotype_AHIgG...
		Working on Isotype_rIgG2a...
		Working on Isotype_rIgG1...

Finding neighbors using PCA result...
Adding umap to AnnData object...
Finding clusters using leiden clustering...
Plotting Leiden clusters over UMAP...
Finding Markers for Leiden clusters in Infinity Flow object...
Finding markers for Infinity Flow object...
Plotting markers...
Working on plotting feature 33D1...
Working on plotting feature Allergin-1...
Working on plotting feature B7-H4...
Working on plotting feature CD103...
Working on plotting feature CD105...
Working on plotting feature CD106...
Working on plotting feature CD107a (Lamp-1)...
Working on plotting feature CD107b (Mac-3)...
Working on plotting feature CD115...
Working on plotting feature CD1d...
Working on plotting feature FJComp-APC-A...
Working on plotting feature FJComp-AlexaFluor700-A...
Working on plotting feature FJComp-BUV395-A...
Working on plotting feature FJComp-BUV737-A...
Working on plotting feature FJComp-BV421-A...
Working on plotting feature FJComp-BV510-A...
Working on plotting feature FJComp-BV605-A...
Working on plotting feature FJComp-BV650-A...
Working on plotting feature FJComp-BV711-A...
Working on plotting feature FJComp-BV786-A...
Working on plotting feature FJComp-GFP-A...
Working on plotting feature FJComp-PE-Cy7(yg)-A...
Working on plotting feature FJComp-PerCP-Cy5-5-A...
Working on plotting feature FJComp-APC-eFlour780-A...
Working on plotting feature FJComp-PE(yg)-A...
Working on plotting feature FSC-A...
Working on plotting feature FSC-H...
Working on plotting feature FSC-W...
Working on plotting feature Isotype_AHIgG...
Working on plotting feature Isotype_mIgG1...
Working on plotting feature Isotype_rIgG1...
Working on plotting feature Isotype_rIgG2a...
Working on plotting feature Isotype_rIgG2b...
Working on plotting feature SSC-A...
Working on plotting feature SSC-H...
Working on plotting feature SSC-W...
Working on plotting feature Time...
Saving Infinity Flow object as h5ad file...
Saving background corrected Infinity Flow object as h5ad file...
Saving Infinity Flow object as feather file...
Writing out base prediction values to fcs file...
Omitting spillover matrix...
WARNING! TEXT segment value for key $P26S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P27S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P28S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P34S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P35S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P36S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P37S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P38S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P39S is empty. Excluding from written file.
Writing out background-corrected prediction values to fcs file...
Omitting spillover matrix...
WARNING! TEXT segment value for key $P26S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P27S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P28S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P34S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P35S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P36S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P37S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P38S is empty. Excluding from written file.
WARNING! TEXT segment value for key $P39S is empty. Excluding from written file.
Done.
Base InfinityFlow Pipeline took 392.24 seconds for input dataset.
```

---

## pyInfinityFlow-list_channels Tutorial

There is also a command line tool to list the channels in an existing FCS file. This should make it easier to create the InfinityMarker annotation file and Backbone annotation file.

We simply need to provide the path to the FCS file for which we want to list the channel names. The command will do a shallow read of the FCS file HEADER and TEXT segment values and print out the channel names.

### Example:
```
cd /home/kyle/Documents/GitHub/pyInfinityFlow/example_data/mouse_lung_dataset_subset/

pyInfinityFlow-list_channels --fcs_file backbone_Plate1_Specimen_001_A2_A02_002_target_CD1.fcs

```

### Example standard output:
```
FSC-A
FSC-H
FSC-W
SSC-A
SSC-H
SSC-W
FJComp-APC-A
FJComp-APC-eFlour780-A
FJComp-AlexaFluor700-A
FJComp-BUV395-A
FJComp-BUV737-A
FJComp-BV421-A
FJComp-BV510-A
FJComp-BV605-A
FJComp-BV650-A
FJComp-BV711-A
FJComp-BV786-A
FJComp-GFP-A
FJComp-PE(yg)-A
FJComp-PE-Cy7(yg)-A
FJComp-PerCP-Cy5-5-A
Time

```


```{note}
We can also include the user defined channel names that were entered when the data was captured to help us identify the channels to which we need to pay attention. It will be formatted as <channel_name>:<user_defined_name> so that they can be easily split by a "split text to columns" tool in a spreadsheet application (Eg. Microsoft Excel).
```

### Example with user-defined names:
```
cd /home/kyle/Documents/GitHub/pyInfinityFlow/example_data/mouse_lung_dataset_subset/

pyInfinityFlow-list_channels --fcs_file backbone_Plate1_Specimen_001_A2_A02_002_target_CD1.fcs \
    --add_user_defined_names True

```

### Example standard output with user-defined names:
```
FSC-H:
FSC-W:
SSC-A:
SSC-H:
SSC-W:
FJComp-APC-A:CD69-CD301b
FJComp-APC-eFlour780-A:Zombie
FJComp-AlexaFluor700-A:MHCII
FJComp-BUV395-A:CD4
FJComp-BUV737-A:CD44
FJComp-BV421-A:CD8
FJComp-BV510-A:CD11c
FJComp-BV605-A:CD11b
FJComp-BV650-A:F480
FJComp-BV711-A:Ly6C
FJComp-BV786-A:Lineage
FJComp-GFP-A:CD45a488
FJComp-PE(yg)-A:Legend
FJComp-PE-Cy7(yg)-A:CD24
FJComp-PerCP-Cy5-5-A:CD103
Time:
```