/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.linsol.chol;

import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.decomposition.TriangularSolver_DDRM;
import org.ejml.dense.row.decomposition.chol.CholeskyDecompositionCommon_DDRM;
import org.ejml.dense.row.linsol.LinearSolverAbstract_DDRM;
import org.ejml.interfaces.decomposition.CholeskyDecomposition_F64;

public class LinearSolverChol_DDRM
extends LinearSolverAbstract_DDRM {
    CholeskyDecompositionCommon_DDRM decomposer;
    int n;
    double[] vv;
    double[] t;

    public LinearSolverChol_DDRM(CholeskyDecompositionCommon_DDRM decomposer) {
        this.decomposer = decomposer;
    }

    @Override
    public boolean setA(DMatrixRMaj A) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("Matrix must be square");
        }
        this._setA(A);
        if (this.decomposer.decompose(A)) {
            this.n = A.numCols;
            this.vv = this.decomposer._getVV();
            this.t = this.decomposer.getT().data;
            return true;
        }
        return false;
    }

    @Override
    public double quality() {
        return SpecializedOps_DDRM.qualityTriangular(this.decomposer.getT());
    }

    @Override
    public void solve(DMatrixRMaj B, DMatrixRMaj X) {
        if (B.numRows != this.n) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        if (this.A == null) {
            throw new RuntimeException("Must call setA() first");
        }
        X.reshape(this.n, B.numCols);
        if (!this.decomposer.isLower()) {
            throw new RuntimeException("Implement");
        }
        LinearSolverChol_DDRM.solveLower(this.A, B, X, this.vv);
    }

    public static void solveLower(DMatrixRMaj L, DMatrixRMaj B, DMatrixRMaj X, double[] vv) {
        int numCols = B.numCols;
        int N = L.numCols;
        for (int j = 0; j < numCols; ++j) {
            int i;
            for (i = 0; i < N; ++i) {
                vv[i] = B.data[i * numCols + j];
            }
            TriangularSolver_DDRM.solveL(L.data, vv, N);
            TriangularSolver_DDRM.solveTranL(L.data, vv, N);
            for (i = 0; i < N; ++i) {
                X.data[i * numCols + j] = vv[i];
            }
        }
    }

    @Override
    public void invert(DMatrixRMaj inv) {
        if (inv.numRows != this.n || inv.numCols != this.n) {
            throw new RuntimeException("Unexpected matrix dimension");
        }
        if (inv.data == this.t) {
            throw new IllegalArgumentException("Passing in the same matrix that was decomposed.");
        }
        double[] a = inv.data;
        if (!this.decomposer.isLower()) {
            throw new RuntimeException("Implement");
        }
        this.setToInverseL(a);
    }

    public void setToInverseL(double[] a) {
        int k;
        double sum;
        int j;
        double el_ii;
        int i;
        for (i = 0; i < this.n; ++i) {
            el_ii = this.t[i * this.n + i];
            for (j = 0; j <= i; ++j) {
                sum = i == j ? 1.0 : 0.0;
                for (k = i - 1; k >= j; --k) {
                    sum -= this.t[i * this.n + k] * a[j * this.n + k];
                }
                a[j * this.n + i] = sum / el_ii;
            }
        }
        for (i = this.n - 1; i >= 0; --i) {
            el_ii = this.t[i * this.n + i];
            for (j = 0; j <= i; ++j) {
                sum = i < j ? 0.0 : a[j * this.n + i];
                for (k = i + 1; k < this.n; ++k) {
                    sum -= this.t[k * this.n + i] * a[j * this.n + k];
                }
                double d = sum / el_ii;
                a[j * this.n + i] = d;
                a[i * this.n + j] = d;
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public CholeskyDecomposition_F64<DMatrixRMaj> getDecomposition() {
        return this.decomposer;
    }
}

