/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.database;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import neqsim.util.util.FileSystemSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeqSimExperimentDatabase
implements FileSystemSettings,
Serializable {
    private static final long serialVersionUID = 1000L;
    public static String dataBasePath = "";
    public static String username = "";
    public static String password = "";
    static Logger logger = LogManager.getLogger(NeqSimExperimentDatabase.class);
    private static boolean createTemporaryTables = false;
    private static String dataBaseType = "MSAccessUCanAccess";
    public static String connectionString = "jdbc:ucanaccess://C:/Users/esol/OneDrive - Equinor/programming/neqsimdatabase/MSAccess/NeqSimExperimentalData.mdb;memory=true";
    private Statement statement = null;
    protected Connection databaseConnection = null;

    public boolean createTemporaryTables() {
        return createTemporaryTables;
    }

    public void setCreateTemporaryTables(boolean createTemporaryTables) {
        NeqSimExperimentDatabase.createTemporaryTables = createTemporaryTables;
    }

    public NeqSimExperimentDatabase() {
        NeqSimExperimentDatabase.setDataBaseType(dataBaseType);
        try {
            this.databaseConnection = this.openConnection();
            this.statement = this.databaseConnection.createStatement();
        }
        catch (Exception ex) {
            logger.error("SQLException " + ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    public Connection openConnection() throws SQLException, ClassNotFoundException {
        InitialContext ctx = null;
        DataSource ds = null;
        try {
            if (dataBaseType.equals("MSAccessUCanAccess")) {
                Connection connection = DriverManager.getConnection(NeqSimExperimentDatabase.getConnectionString());
                return connection;
            }
            if (dataBaseType.equals("mySQL") || dataBaseType.equals("mySQLNTNU") || dataBaseType.equals("Derby")) {
                Connection connection = DriverManager.getConnection(NeqSimExperimentDatabase.getConnectionString(), username, password);
                return connection;
            }
            if (dataBaseType.equals("mySQLNeqSimWeb")) {
                ctx = new InitialContext();
                ds = (DataSource)ctx.lookup("java:comp/env/jdbc/NeqsimDataSource");
                if (ctx != null) {
                    ctx.close();
                }
                Connection connection = ds.getConnection();
                return connection;
            }
            Connection connection = DriverManager.getConnection(NeqSimExperimentDatabase.getConnectionString(), username, password);
            return connection;
        }
        catch (Exception ex) {
            logger.error("error loading NeqSimDataBase... " + ex.toString());
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.databaseConnection;
    }

    public ResultSet getResultSet(String sqlString) {
        try {
            ResultSet result = this.getStatement().executeQuery(sqlString);
            return result;
        }
        catch (Exception e) {
            logger.error("error loading NeqSimbataBase " + e.toString());
            throw new RuntimeException(e);
        }
    }

    public void execute(String sqlString) {
        try {
            if (this.databaseConnection == null) {
                this.databaseConnection = this.openConnection();
                this.setStatement(this.databaseConnection.createStatement());
            }
            this.getStatement().execute(sqlString);
        }
        catch (Exception e) {
            logger.error("error in NeqSimDataBase " + e.toString(), (Throwable)e);
            logger.error("The database must be rgistered on the local DBMS to work.");
            throw new RuntimeException(e);
        }
    }

    public static String getDataBaseType() {
        return dataBaseType;
    }

    public static void setDataBaseType(String aDataBaseType) {
        NeqSimExperimentDatabase.setDataBaseType(aDataBaseType, null);
    }

    public static void setDataBaseType(String aDataBaseType, String connectionString) {
        dataBaseType = aDataBaseType;
        if (connectionString != null) {
            NeqSimExperimentDatabase.connectionString = connectionString;
        }
        try {
            if (dataBaseType.equals("MSAccess")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("H2")) {
                Class.forName("org.h2.Driver");
            } else if (dataBaseType.equals("H2RT")) {
                Class.forName("org.h2.Driver");
            } else if (dataBaseType.equals("MSAccessUCanAccess")) {
                Class.forName("net.ucanaccess.jdbc.UcanaccessDriver");
            } else if (dataBaseType.equals("mySQL")) {
                Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("mySQLNTNU")) {
                Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("Derby")) {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("oracle")) {
                Class.forName("oracle.jdbc.driver.OracleDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("oracleST")) {
                Class.forName("oracle.jdbc.driver.OracleDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
        }
        catch (Exception ex) {
            logger.error("error loading database driver.. " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public static void setUsername(String aUsername) {
        username = aUsername;
    }

    public static void setPassword(String aPassword) {
        password = aPassword;
    }

    public static String getConnectionString() {
        return connectionString;
    }

    public static void setConnectionString(String aConnectionString) {
        connectionString = aConnectionString;
    }
}

