/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.propertyGenerator;

import Jama.Matrix;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.BaseOperation;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLGApropertyTableGeneratorWaterStudents
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(OLGApropertyTableGeneratorWaterStudents.class);
    SystemInterface thermoSystem = null;
    SystemInterface gasSystem = null;
    SystemInterface oilSystem = null;
    SystemInterface waterSystem = null;
    ThermodynamicOperations thermoOps = null;
    double[] pressures;
    double[] temperatureLOG;
    double[] temperatures;
    double[] pressureLOG = null;
    double[] bubP;
    double[] bubT;
    double[] dewP;
    double[] bubPLOG;
    double[] dewPLOG;
    Matrix XMatrixgas;
    Matrix XMatrixoil;
    Matrix XMatrixwater;
    double[][] ROG = null;
    double maxPressure;
    double minPressure;
    double maxTemperature;
    double TLC;
    double GLW;
    double GL;
    double GW;
    double minTemperature;
    double VLS;
    double VWS;
    double LWS;
    double TC;
    double PC;
    double RSWTOB;
    double[][][] props;
    int nProps;
    String[] names;
    Matrix[] xcoef = new Matrix[9];
    String[] units;
    int temperatureSteps;
    int pressureSteps;
    boolean continuousDerivativesExtrapolation = true;
    boolean hasGasValues = false;
    boolean hasOilValues = false;
    boolean hasWaterValues = false;
    boolean[][][] hasValue;
    Matrix aMatrix = new Matrix(4, 4);
    Matrix s = new Matrix(1, 4);
    String fileName = "c:/Appl/OLGAneqsim.tab";

    public OLGApropertyTableGeneratorWaterStudents(SystemInterface system) {
        this.thermoSystem = system;
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.XMatrixgas = new Matrix(9, 4);
        this.XMatrixoil = new Matrix(9, 4);
        this.XMatrixwater = new Matrix(9, 4);
        this.gasSystem = new SystemSrkEos(298.0, 10.0);
        this.gasSystem.addComponent("methane", 1.0);
        this.gasSystem.init(0);
        this.gasSystem.setNumberOfPhases(1);
        this.waterSystem = new SystemSrkCPAstatoil(298.0, 10.0);
        this.waterSystem.addComponent("water", 1.0);
        this.waterSystem.init(0);
        this.waterSystem.setNumberOfPhases(1);
        this.oilSystem = new SystemSrkEos(298.0, 10.0);
        this.oilSystem.addComponent("nC10", 1.0);
        this.oilSystem.init(0);
        this.oilSystem.setNumberOfPhases(1);
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public void setPressureRange(double minPressure, double maxPressure, int numberOfSteps) {
        this.pressures = new double[numberOfSteps];
        this.pressureLOG = new double[numberOfSteps];
        double step = (maxPressure - minPressure) / ((double)numberOfSteps * 1.0 - 1.0);
        int i = 0;
        while (i < numberOfSteps) {
            this.pressures[i] = minPressure + (double)i * step;
            this.pressureLOG[i] = this.pressures[i] * 100000.0;
            ++i;
        }
    }

    public void setTemperatureRange(double minTemperature, double maxTemperature, int numberOfSteps) {
        this.temperatures = new double[numberOfSteps];
        this.temperatureLOG = new double[numberOfSteps];
        double step = (maxTemperature - minTemperature) / ((double)numberOfSteps * 1.0 - 1.0);
        int i = 0;
        while (i < numberOfSteps) {
            this.temperatures[i] = minTemperature + (double)i * step;
            this.temperatureLOG[i] = this.temperatures[i] - 273.15;
            ++i;
        }
    }

    public void calcPhaseEnvelope() {
        try {
            this.thermoOps.calcPTphaseEnvelope();
            this.TC = this.thermoSystem.getTC() - 273.15;
            this.PC = this.thermoSystem.getPC() * 100000.0;
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
    }

    public double[] calcBubP(double[] temperatures) {
        double[] bubP = new double[temperatures.length];
        this.bubPLOG = new double[temperatures.length];
        int i = 0;
        while (i < temperatures.length) {
            this.thermoSystem.setTemperature(temperatures[i]);
            try {
                this.thermoOps.bubblePointPressureFlash(false);
                bubP[i] = this.thermoSystem.getPressure();
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                bubP[i] = 0.0;
                return bubP;
            }
            this.bubPLOG[i] = bubP[i] * 100000.0;
            ++i;
        }
        return bubP;
    }

    public double[] calcDewP(double[] temperatures) {
        double[] dewP = new double[temperatures.length];
        this.dewPLOG = new double[temperatures.length];
        int i = 0;
        while (i < temperatures.length) {
            this.thermoSystem.setTemperature(temperatures[i]);
            try {
                this.thermoOps.dewPointPressureFlashHC();
                dewP[i] = this.thermoSystem.getPressure();
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                dewP[i] = 0.0;
                return dewP;
            }
            this.dewPLOG[i] = dewP[i] * 100000.0;
            ++i;
        }
        return dewP;
    }

    public double[] calcBubT(double[] pressures) {
        double[] bubTemps = new double[pressures.length];
        int i = 0;
        while (i < pressures.length) {
            this.thermoSystem.setPressure(pressures[i]);
            try {
                this.thermoOps.bubblePointTemperatureFlash();
                this.bubT[i] = this.thermoSystem.getPressure();
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                this.bubT[i] = 0.0;
            }
            ++i;
        }
        return bubTemps;
    }

    public void initCalc() {
        double stdTemp = 288.15;
        double stdPres = 1.01325;
        double[] molfracs = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        double[] MW = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        double[] dens = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        String[] components = new String[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        int i = 0;
        while (i < molfracs.length) {
            molfracs[i] = this.thermoSystem.getPhase(0).getComponent(i).getz();
            components[i] = this.thermoSystem.getPhase(0).getComponent(i).getComponentName();
            MW[i] = this.thermoSystem.getPhase(0).getComponent(i).getMolarMass() * 1000.0;
            dens[i] = this.thermoSystem.getPhase(0).getComponent(i).getNormalLiquidDensity();
            ++i;
        }
        this.thermoSystem.setTemperature(stdTemp);
        this.thermoSystem.setPressure(stdPres);
        this.thermoOps.TPflash();
    }

    public void calcRSWTOB() {
        this.thermoSystem.init(0);
        this.thermoSystem.init(1);
        this.RSWTOB = this.thermoSystem.getPhase(0).hasComponent("water") ? this.thermoSystem.getPhase(0).getComponent("water").getNumberOfmoles() * this.thermoSystem.getPhase(0).getComponent("water").getMolarMass() / (this.thermoSystem.getTotalNumberOfMoles() * this.thermoSystem.getMolarMass()) : 0.0;
    }

    @Override
    public void run() {
        this.calcRSWTOB();
        logger.info("RSWTOB " + this.RSWTOB);
        this.nProps = 29;
        this.props = new double[this.nProps][this.pressures.length][this.temperatures.length];
        this.units = new String[this.nProps];
        this.names = new String[this.nProps];
        this.GLW = 0.0;
        this.GL = 0.0;
        this.GW = 0.0;
        this.VLS = 0.0;
        this.LWS = 0.0;
        this.VWS = 0.0;
        this.maxPressure = this.pressures[this.pressures.length - 1];
        this.minPressure = this.pressures[0];
        this.maxTemperature = this.temperatures[this.temperatures.length - 1];
        this.minTemperature = this.temperatures[0];
        this.thermoSystem.setTemperature(this.minTemperature);
        this.thermoSystem.setPressure(this.maxPressure);
        this.thermoOps.TPflash();
        if (this.thermoSystem.hasPhaseType("gas") && this.thermoSystem.hasPhaseType("aqueous") && this.thermoSystem.hasPhaseType("oil")) {
            this.GLW = 1.0;
        }
        if (this.thermoSystem.hasPhaseType("gas") && this.thermoSystem.hasPhaseType("aqueous")) {
            this.GW = 1.0;
        }
        if (this.thermoSystem.hasPhaseType("gas") && this.thermoSystem.hasPhaseType("oil")) {
            this.GL = 1.0;
        }
        boolean acceptedFlash = true;
        int j = 0;
        while (j < this.temperatures.length) {
            this.thermoSystem.setTemperature(this.temperatures[j]);
            int i = 0;
            while (i < this.pressures.length) {
                int phaseNumb;
                this.thermoSystem.setPressure(this.pressures[i]);
                try {
                    this.thermoOps.TPflash();
                    this.thermoSystem.init(3);
                    this.thermoSystem.initPhysicalProperties();
                    acceptedFlash = true;
                }
                catch (Exception e) {
                    acceptedFlash = false;
                    logger.info("fail temperature " + this.thermoSystem.getTemperature() + " fail pressure " + this.thermoSystem.getPressure());
                    this.thermoSystem.display();
                    logger.error("error", (Throwable)e);
                }
                int k = 0;
                if (this.thermoSystem.hasPhaseType("gas") && acceptedFlash) {
                    phaseNumb = this.thermoSystem.getPhaseNumberOfPhase("gas");
                    this.props[k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getDensity();
                    this.names[k] = "GAS DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOG/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodT();
                    this.names[k] = "DRHOG/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.thermoSystem.hasPhaseType("oil") ? this.thermoSystem.getPhase(phaseNumb).getBeta() * this.thermoSystem.getPhase(phaseNumb).getMolarMass() / (this.thermoSystem.getPhase(phaseNumb).getBeta() * this.thermoSystem.getPhase(phaseNumb).getMolarMass() + this.thermoSystem.getPhase("oil").getBeta() * this.thermoSystem.getPhase("oil").getMolarMass()) : 1.0;
                    this.names[k] = "GAS MASS FRACTION";
                    this.units[k] = "-";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getViscosity();
                    this.names[k] = "GAS VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getCp() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "GAS HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEnthalpy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "GAS ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getConductivity();
                    this.names[k] = "GAS THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEntropy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "GAS ENTROPY";
                    this.units[k] = "J/KG/K";
                    ++k;
                    this.hasGasValues = true;
                } else if (this.continuousDerivativesExtrapolation && this.hasGasValues) {
                    do {
                        if (i > 1) {
                            this.props[k][i][j] = this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]);
                            if (this.names[k].equals("GAS MASS FRACTION") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                            if (this.names[k].equals("GAS DENSITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.1;
                            }
                            if (this.names[k].equals("GAS VISCOSITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                            if (this.names[k].equals("GAS THERMAL CONDUCTIVITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                        }
                        if (j <= 1) continue;
                        this.props[k][i][j] = this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]);
                        if (this.names[k].equals("GAS MASS FRACTION") && this.props[k][i][j] < 0.0) {
                            this.props[k][i][j] = 0.0;
                        }
                        if (this.names[k].equals("GAS MASS FRACTION") && this.props[k][i][j] < 0.0) {
                            this.props[k][i][j] = 0.0;
                        }
                        if (this.names[k].equals("GAS DENSITY") && this.props[k][i][j] <= 0.0) {
                            this.props[k][i][j] = 0.1;
                        }
                        if (this.names[k].equals("GAS VISCOSITY") && this.props[k][i][j] < 0.0) {
                            this.props[k][i][j] = 0.0;
                        }
                        if (this.names[k].equals("GAS THERMAL CONDUCTIVITY") && this.props[k][i][j] < 0.0) {
                            this.props[k][i][j] = 0.0;
                        }
                        if (!this.names[k].equals("GAS HEAT CAPACITY") || !(this.props[k][i][j] < 0.0)) continue;
                        this.props[k][i][j] = 0.0;
                    } while (++k < 9);
                } else {
                    this.gasSystem.setTemperature(this.temperatures[j]);
                    this.gasSystem.setPressure(this.pressures[i]);
                    this.gasSystem.init(3);
                    this.gasSystem.initPhysicalProperties();
                    this.props[k][i][j] = this.gasSystem.getPhase(0).getPhysicalProperties().getDensity();
                    this.names[k] = "GAS DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOG/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getdrhodT();
                    this.names[k] = "DRHOG/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = 0.0;
                    this.names[k] = "GAS MASS FRACTION";
                    this.units[k] = "-";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getPhysicalProperties().getViscosity();
                    this.names[k] = "GAS VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getCp() / this.gasSystem.getPhase(0).getNumberOfMolesInPhase() / this.gasSystem.getPhase(0).getMolarMass();
                    this.names[k] = "GAS HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getEnthalpy() / this.gasSystem.getPhase(0).getNumberOfMolesInPhase() / this.gasSystem.getPhase(0).getMolarMass();
                    this.names[k] = "GAS ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getPhysicalProperties().getConductivity();
                    this.names[k] = "GAS THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    this.props[++k][i][j] = this.gasSystem.getPhase(0).getEntropy() / this.gasSystem.getPhase(0).getNumberOfMolesInPhase() / this.gasSystem.getPhase(0).getMolarMass();
                    this.names[k] = "GAS ENTROPY";
                    this.units[k] = "J/KG/K";
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("oil") && acceptedFlash) {
                    phaseNumb = this.thermoSystem.getPhaseNumberOfPhase("oil");
                    this.props[k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getDensity();
                    this.names[k] = "LIQUID DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOL/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodT();
                    this.names[k] = "DRHOL/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getViscosity();
                    this.names[k] = "LIQUID VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getCp() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "LIQUID HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEnthalpy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "LIQUID ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEntropy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "LIQUID ENTROPY";
                    this.units[k] = "J/KG/K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getConductivity();
                    this.names[k] = "LIQUID THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    ++k;
                    this.hasOilValues = true;
                } else if (this.continuousDerivativesExtrapolation && this.hasOilValues) {
                    do {
                        if (j < 2 && i < 2) {
                            if (this.names[k].equals("LIQUID DENSITY") && this.props[k][i][j] <= 0.0) {
                                this.props[k][i][j] = 100.0;
                            }
                            if (this.names[k].equals("LIQUID DENSITY") && this.props[k][i][j] > 900.0) {
                                this.props[k][i][j] = 900.0;
                            }
                            if (this.names[k].equals("LIQUID VISCOSITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                            if (this.names[k].equals("LIQUID THERMAL CONDUCTIVITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                            if (this.names[k].equals("LIQUID HEAT CAPACITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                        }
                        if (j > 1) {
                            this.props[k][i][j] = this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]);
                            if (this.names[k].equals("LIQUID DENSITY") && this.props[k][i][j] <= 0.0) {
                                this.props[k][i][j] = 100.0;
                            }
                            if (this.names[k].equals("LIQUID DENSITY") && this.props[k][i][j] > 900.0) {
                                this.props[k][i][j] = 900.0;
                            }
                            if (this.names[k].equals("LIQUID VISCOSITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                            if (this.names[k].equals("LIQUID THERMAL CONDUCTIVITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                            if (this.names[k].equals("LIQUID HEAT CAPACITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                        }
                        if (i <= 1) continue;
                        this.props[k][i][j] = this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]);
                        if (this.names[k].equals("LIQUID DENSITY") && this.props[k][i][j] <= 0.0) {
                            this.props[k][i][j] = 100.0;
                        }
                        if (this.names[k].equals("LIQUID DENSITY") && this.props[k][i][j] > 900.0) {
                            this.props[k][i][j] = 900.0;
                        }
                        if (this.names[k].equals("LIQUID VISCOSITY") && this.props[k][i][j] < 0.0) {
                            this.props[k][i][j] = 0.0;
                        }
                        if (this.names[k].equals("LIQUID THERMAL CONDUCTIVITY") && this.props[k][i][j] < 0.0) {
                            this.props[k][i][j] = 0.0;
                        }
                        if (!this.names[k].equals("LIQUID HEAT CAPACITY") || !(this.props[k][i][j] < 0.0)) continue;
                        this.props[k][i][j] = 0.0;
                    } while (++k < 17);
                } else {
                    this.oilSystem.setPhaseType(0, 0);
                    this.oilSystem.setTemperature(this.temperatures[j]);
                    this.oilSystem.setPressure(this.pressures[i]);
                    this.oilSystem.init(3);
                    this.oilSystem.initPhysicalProperties();
                    this.props[k][i][j] = this.oilSystem.getPhase(0).getPhysicalProperties().getDensity();
                    this.names[k] = "LIQUID DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOL/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getdrhodT();
                    this.names[k] = "DRHOL/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getPhysicalProperties().getViscosity();
                    this.names[k] = "LIQUID VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getCp() / this.oilSystem.getPhase(0).getNumberOfMolesInPhase() / this.oilSystem.getPhase(0).getMolarMass();
                    this.names[k] = "LIQUID HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getEnthalpy() / this.oilSystem.getPhase(0).getNumberOfMolesInPhase() / this.oilSystem.getPhase(0).getMolarMass();
                    this.names[k] = "LIQUID ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getEntropy() / this.oilSystem.getPhase(0).getNumberOfMolesInPhase() / this.oilSystem.getPhase(0).getMolarMass();
                    this.names[k] = "LIQUID ENTROPY";
                    this.units[k] = "J/KG/K";
                    this.props[++k][i][j] = this.oilSystem.getPhase(0).getPhysicalProperties().getConductivity();
                    this.names[k] = "LIQUID THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("aqueous") && acceptedFlash) {
                    phaseNumb = this.thermoSystem.getPhaseNumberOfPhase("aqueous");
                    if (this.thermoSystem.hasPhaseType("gas")) {
                        this.props[k][i][j] = this.thermoSystem.getPhase("gas").getComponent("water").getx() * this.thermoSystem.getPhase("gas").getComponent("water").getMolarMass() / this.thermoSystem.getPhase("gas").getMolarMass();
                    }
                    if (this.thermoSystem.hasPhaseType("oil")) {
                        double[] dArray = this.props[k][i];
                        int n = j;
                        dArray[n] = dArray[n] + this.thermoSystem.getPhase("oil").getComponent("water").getx() * this.thermoSystem.getPhase("oil").getComponent("water").getMolarMass() / this.thermoSystem.getPhase("oil").getMolarMass();
                    }
                    this.names[k] = "WATER VAPOR MASS FRACTION";
                    this.units[k] = "-";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getDensity();
                    this.names[k] = "WATER DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOWAT/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getdrhodT();
                    this.names[k] = "DRHOWAT/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getViscosity();
                    this.names[k] = "WATER VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getCp() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "WATER HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEnthalpy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "WATER ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getEntropy() / this.thermoSystem.getPhase(phaseNumb).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(phaseNumb).getMolarMass();
                    this.names[k] = "WATER ENTROPY";
                    this.units[k] = "J/KG/K";
                    this.props[++k][i][j] = this.thermoSystem.getPhase(phaseNumb).getPhysicalProperties().getConductivity();
                    this.names[k] = "WATER THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    ++k;
                    this.hasWaterValues = true;
                } else if (this.continuousDerivativesExtrapolation && this.hasWaterValues) {
                    do {
                        if (j > 1) {
                            this.props[k][i][j] = this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]);
                            if (this.names[k].equals("WATER VAPOR MASS FRACTION") && this.props[k][i][j] > 1.0) {
                                this.props[k][i][j] = 1.0;
                            }
                            if (this.names[k].equals("WATER DENSITY") && this.props[k][i][j] <= 0.0) {
                                this.props[k][i][j] = 1000.0;
                            }
                            if (this.names[k].equals("WATER VISCOSITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                            if (this.names[k].equals("WATER THERMAL CONDUCTIVITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                            if (this.names[k].equals("WATER VAPOR MASS FRACTION") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                            if (this.names[k].equals("WATER HEAT CAPACITY") && this.props[k][i][j] < 0.0) {
                                this.props[k][i][j] = 0.0;
                            }
                        }
                        if (i <= 1) continue;
                        this.props[k][i][j] = this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]);
                        if (this.names[k].equals("WATER VAPOR MASS FRACTION") && this.props[k][i][j] > 1.0) {
                            this.props[k][i][j] = 1.0;
                        }
                        if (this.names[k].equals("WATER DENSITY") && this.props[k][i][j] <= 0.0) {
                            this.props[k][i][j] = 1000.0;
                        }
                        if (this.names[k].equals("WATER VISCOSITY") && this.props[k][i][j] < 0.0) {
                            this.props[k][i][j] = 0.0;
                        }
                        if (this.names[k].equals("WATER THERMAL CONDUCTIVITY") && this.props[k][i][j] < 0.0) {
                            this.props[k][i][j] = 0.0;
                        }
                        if (this.names[k].equals("WATER VAPOR MASS FRACTION") && this.props[k][i][j] < 0.0) {
                            this.props[k][i][j] = 0.0;
                        }
                        if (!this.names[k].equals("WATER HEAT CAPACITY") || !(this.props[k][i][j] < 0.0)) continue;
                        this.props[k][i][j] = 0.0;
                    } while (++k < 26);
                } else {
                    this.waterSystem.setTemperature(this.temperatures[j]);
                    this.waterSystem.setPressure(this.pressures[i]);
                    this.waterSystem.setPhaseType(0, 0);
                    this.waterSystem.init(3);
                    this.waterSystem.initPhysicalProperties();
                    this.props[k][i][j] = this.thermoSystem.getPhase(0).hasComponent("water") ? this.thermoSystem.getPhase(0).getComponent("water").getz() * this.thermoSystem.getPhase(0).getComponent("water").getMolarMass() / this.thermoSystem.getPhase(0).getMolarMass() : 0.0;
                    this.names[k] = "WATER VAPOR MASS FRACTION";
                    this.units[k] = "-";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getPhysicalProperties().getDensity();
                    this.names[k] = "WATER DENSITY";
                    this.units[k] = "KG/M3";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getdrhodP() / 100000.0;
                    this.names[k] = "DRHOWAT/DP";
                    this.units[k] = "S2/M2";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getdrhodT();
                    this.names[k] = "DRHOWAT/DT";
                    this.units[k] = "KG/M3-K";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getPhysicalProperties().getViscosity();
                    this.names[k] = "WATER VISCOSITY";
                    this.units[k] = "NS/M2";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getCp() / this.waterSystem.getPhase(0).getNumberOfMolesInPhase() / this.waterSystem.getPhase(0).getMolarMass();
                    this.names[k] = "WATER HEAT CAPACITY";
                    this.units[k] = "J/KG-K";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getEnthalpy() / this.waterSystem.getPhase(0).getNumberOfMolesInPhase() / this.waterSystem.getPhase(0).getMolarMass();
                    this.names[k] = "WATER ENTHALPY";
                    this.units[k] = "J/KG";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getEntropy() / this.waterSystem.getPhase(0).getNumberOfMolesInPhase() / this.waterSystem.getPhase(0).getMolarMass();
                    this.names[k] = "WATER ENTROPY";
                    this.units[k] = "J/KG/K";
                    this.props[++k][i][j] = this.waterSystem.getPhase(0).getPhysicalProperties().getConductivity();
                    this.names[k] = "WATER THERMAL CONDUCTIVITY";
                    this.units[k] = "W/M-K";
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("gas") && this.thermoSystem.hasPhaseType("oil") && acceptedFlash) {
                    this.props[k][i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(this.thermoSystem.getPhaseNumberOfPhase("gas"), this.thermoSystem.getPhaseNumberOfPhase("oil"));
                    this.names[k] = "VAPOR-LIQUID SURFACE TENSION";
                    this.units[k] = "N/M";
                    ++k;
                } else {
                    if (this.continuousDerivativesExtrapolation && (i >= 2 || j >= 2)) {
                        if (this.VLS == 1.0) {
                            this.props[k][i][j] = 0.005;
                        }
                        if (j > 1 && (this.GLW == 1.0 || this.GL == 1.0) && this.VLS == 0.0) {
                            this.props[k][i][j] = this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]);
                            if (this.props[k][i][j] < 0.005) {
                                this.props[k][i][j] = 0.005;
                                this.VLS = 1.0;
                            }
                            if (this.props[k][i][j] > 1.1 * this.props[k][i][j - 1]) {
                                this.props[k][i][j] = this.props[k][i][j - 1];
                            }
                            if (this.props[k][i][j] < 0.9 * this.props[k][i][j - 1]) {
                                this.props[k][i][j] = this.props[k][i][j - 1];
                            }
                        } else if (i > 1 && (this.GLW == 0.0 || this.GL == 0.0) && this.VLS == 0.0) {
                            this.props[k][i][j] = this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]);
                            if (this.props[k][i][j] < 0.005) {
                                this.props[k][i][j] = 0.005;
                                this.VLS = 1.0;
                            }
                            if (this.props[k][i][j] > 1.1 * this.props[k][i - 1][j]) {
                                this.props[k][i][j] = this.props[k][i - 1][j];
                            }
                            if (this.props[k][i][j] < 0.9 * this.props[k][i - 1][j]) {
                                this.props[k][i][j] = this.props[k][i - 1][j];
                            }
                        } else {
                            this.props[k][i][j] = j > 0 && i > 0 ? 0.5 * (this.props[k][i - 1][j] + this.props[k][i][j - 1]) : (j > 0 ? this.props[k][i][j - 1] : (i > 0 ? this.props[k][i - 1][j] : 0.01));
                        }
                    } else if (j > 0 && i > 0) {
                        this.props[k][i][j] = 0.5 * (this.props[k][i - 1][j] + this.props[k][i][j - 1]);
                    } else if (j > 0) {
                        this.props[k][i][j] = this.props[k][i][j - 1];
                    } else if (i > 0) {
                        this.props[k][i][j] = this.props[k][i - 1][j];
                    } else {
                        this.props[k][i][j] = 0.01;
                        this.names[k] = "VAPOR-LIQUID SURFACE TENSION";
                        this.units[k] = "N/M";
                    }
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("gas") && this.thermoSystem.hasPhaseType("aqueous") && acceptedFlash) {
                    this.props[k][i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(this.thermoSystem.getPhaseNumberOfPhase("gas"), this.thermoSystem.getPhaseNumberOfPhase("aqueous"));
                    this.names[k] = "VAPOR-WATER SURFACE TENSION";
                    this.units[k] = "N/M";
                    ++k;
                } else {
                    if (this.continuousDerivativesExtrapolation && (i >= 2 || j >= 2)) {
                        if (this.VWS == 1.0) {
                            this.props[k][i][j] = 0.005;
                        }
                        if (j > 1 && (this.GLW == 1.0 || this.GW == 1.0) && this.VWS == 0.0) {
                            this.props[k][i][j] = this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]);
                            if (this.props[k][i][j] < 0.005) {
                                this.props[k][i][j] = 0.005;
                                this.VWS = 1.0;
                            }
                            if (this.props[k][i][j] > 1.1 * this.props[k][i][j - 1]) {
                                this.props[k][i][j] = this.props[k][i][j - 1];
                            }
                            if (this.props[k][i][j] < 0.9 * this.props[k][i][j - 1]) {
                                this.props[k][i][j] = this.props[k][i][j - 1];
                            }
                        } else if (i > 1 && (this.GLW == 0.0 || this.GL == 0.0) && this.VWS == 0.0) {
                            this.props[k][i][j] = this.props[k][i - 1][j] + (this.props[k][i - 1][j] - this.props[k][i - 2][j]) / (this.pressures[i - 1] - this.pressures[i - 2]) * (this.pressures[i] - this.pressures[i - 1]);
                            if (this.props[k][i][j] < 0.005) {
                                this.props[k][i][j] = 0.005;
                                this.VWS = 1.0;
                            }
                            if (this.props[k][i][j] > 1.1 * this.props[k][i - 1][j]) {
                                this.props[k][i][j] = this.props[k][i - 1][j];
                            }
                            if (this.props[k][i][j] < 0.9 * this.props[k][i - 1][j]) {
                                this.props[k][i][j] = this.props[k][i - 1][j];
                            }
                        } else {
                            this.props[k][i][j] = j > 0 && i > 0 ? 0.5 * (this.props[k][i - 1][j] + this.props[k][i][j - 1]) : (j > 0 ? this.props[k][i][j - 1] : (i > 0 ? this.props[k][i - 1][j] : 0.06));
                        }
                    } else if (j > 0 && i > 0) {
                        this.props[k][i][j] = 0.5 * (this.props[k][i - 1][j] + this.props[k][i][j - 1]);
                    } else if (j > 0) {
                        this.props[k][i][j] = this.props[k][i][j - 1];
                    } else if (i > 0) {
                        this.props[k][i][j] = this.props[k][i - 1][j];
                    } else {
                        this.props[k][i][j] = 0.06;
                        this.names[k] = "VAPOR-WATER SURFACE TENSION";
                        this.units[k] = "N/M";
                    }
                    ++k;
                }
                if (this.thermoSystem.hasPhaseType("oil") && this.thermoSystem.hasPhaseType("aqueous") && acceptedFlash) {
                    this.props[k][i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(this.thermoSystem.getPhaseNumberOfPhase("oil"), this.thermoSystem.getPhaseNumberOfPhase("aqueous"));
                    this.names[k] = "LIQUID-WATER SURFACE TENSION";
                    this.units[k] = "N/M";
                    ++k;
                } else {
                    if (this.continuousDerivativesExtrapolation && (i >= 2 || j >= 2)) {
                        if (this.LWS == 1.0) {
                            this.props[k][i][j] = 0.005;
                        }
                        if (j > 1 && this.LWS == 0.0) {
                            this.props[k][i][j] = this.props[k][i][j - 1] + (this.props[k][i][j - 1] - this.props[k][i][j - 2]) / (this.temperatures[j - 1] - this.temperatures[j - 2]) * (this.temperatures[j] - this.temperatures[j - 1]);
                            if (this.props[k][i][j] < 0.005) {
                                this.props[k][i][j] = 0.005;
                                this.LWS = 1.0;
                            }
                            if (this.props[k][i][j] > 1.1 * this.props[k][i][j - 1]) {
                                this.props[k][i][j] = this.props[k][i][j - 1];
                            }
                            if (this.props[k][i][j] < 0.9 * this.props[k][i][j - 1]) {
                                this.props[k][i][j] = this.props[k][i][j - 1];
                            }
                        } else {
                            this.props[k][i][j] = j > 0 ? this.props[k][i][j - 1] : (i > 0 ? this.props[k][i - 1][j] : 0.04);
                        }
                    } else if (j > 0) {
                        this.props[k][i][j] = this.props[k][i][j - 1];
                    } else if (i > 0) {
                        this.props[k][i][j] = this.props[k][i - 1][j];
                    } else {
                        this.props[k][i][j] = 0.04;
                        this.names[k] = "LIQUID-WATER SURFACE TENSION";
                        this.units[k] = "N/M";
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        logger.info("Finished TPflash...");
        if (this.thermoSystem.getPhase(0).hasComponent("water")) {
            this.thermoSystem.removeComponent("water");
        }
        this.bubP = this.calcBubP(this.temperatures);
        this.dewP = this.calcDewP(this.temperatures);
    }

    @Override
    public void displayResult() {
        this.writeOLGAinpFile(this.fileName);
    }

    public void writeOLGAinpFile2(String filename) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), "utf-8"));){
                writer.write("'WATER-OPTION ENTROPY NONEQ '\n");
                writer.write(String.valueOf(this.pressures.length) + "   " + this.temperatures.length + "    " + this.RSWTOB + "\n");
                int Pcounter = 0;
                int i = 0;
                while (i < this.pressures.length) {
                    if (Pcounter > 4) {
                        writer.write("\n");
                        Pcounter = 0;
                    }
                    writer.write(String.valueOf(this.pressureLOG[i]) + "    ");
                    ++Pcounter;
                    ++i;
                }
                writer.write("\n");
                int Tcounter = 0;
                int i2 = 0;
                while (i2 < this.temperatures.length) {
                    if (Tcounter > 4) {
                        writer.write("\n");
                        Tcounter = 0;
                    }
                    writer.write(String.valueOf(this.temperatureLOG[i2]) + "    ");
                    ++Tcounter;
                    ++i2;
                }
                writer.write("\n");
                int bubPcounter = 0;
                int i3 = 0;
                while (i3 < this.temperatures.length) {
                    if (bubPcounter > 4) {
                        writer.write("\n");
                        bubPcounter = 0;
                    }
                    writer.write(String.valueOf(this.bubPLOG[i3]) + "    ");
                    ++bubPcounter;
                    ++i3;
                }
                writer.write("\n");
                int dewPcounter = 0;
                int i4 = 0;
                while (i4 < this.temperatures.length) {
                    if (dewPcounter > 4) {
                        writer.write("\n");
                        dewPcounter = 0;
                    }
                    writer.write(String.valueOf(this.dewPLOG[i4]) + "    ");
                    ++dewPcounter;
                    ++i4;
                }
                writer.write("\n");
                int k = 0;
                while (k < this.nProps) {
                    if (this.names[k] != null) {
                        writer.write(String.valueOf(this.names[k]) + " (" + this.units[k] + ")\n");
                        int i5 = 0;
                        while (i5 < this.pressures.length) {
                            int counter = 0;
                            int j = 0;
                            while (j < this.temperatures.length) {
                                if (counter > 4) {
                                    writer.write("\n");
                                    counter = 0;
                                }
                                writer.write(String.valueOf(this.props[k][i5][j]) + "    ");
                                ++counter;
                                ++j;
                            }
                            writer.write("\n");
                            ++i5;
                        }
                    }
                    ++k;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void writeOLGAinpFile(String filename) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "utf-8"));){
                int j;
                int counter;
                writer.write("'WATER-OPTION ENTROPY NONEQ '\n");
                writer.write(String.valueOf(this.pressures.length) + "   " + this.temperatures.length + "    " + this.RSWTOB + "\n");
                int Pcounter = 0;
                int i = 0;
                while (i < this.pressures.length) {
                    if (Pcounter > 4) {
                        writer.write("\n");
                        Pcounter = 0;
                    }
                    writer.write(String.valueOf(this.pressureLOG[i]) + "    ");
                    ++Pcounter;
                    ++i;
                }
                writer.write("\n");
                int Tcounter = 0;
                int i2 = 0;
                while (i2 < this.temperatures.length) {
                    if (Tcounter > 4) {
                        writer.write("\n");
                        Tcounter = 0;
                    }
                    writer.write(String.valueOf(this.temperatureLOG[i2]) + "    ");
                    ++Tcounter;
                    ++i2;
                }
                writer.write("\n");
                int bubPcounter = 0;
                int i3 = 0;
                while (i3 < this.temperatures.length) {
                    if (bubPcounter > 4) {
                        writer.write("\n");
                        bubPcounter = 0;
                    }
                    writer.write(String.valueOf(this.bubPLOG[i3]) + "    ");
                    ++bubPcounter;
                    ++i3;
                }
                writer.write("\n");
                int dewPcounter = 0;
                int i4 = 0;
                while (i4 < this.temperatures.length) {
                    if (dewPcounter > 4) {
                        writer.write("\n");
                        dewPcounter = 0;
                    }
                    writer.write(String.valueOf(this.dewPLOG[i4]) + "    ");
                    ++dewPcounter;
                    ++i4;
                }
                writer.write("\n");
                writer.write("GAS DENSITY (KG/M3)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[0][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("LIQUID DENSITY (KG/M3)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[9][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("WATER DENSITY (KG/M3)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[18][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("DRHOG/DP (S2/M2)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[1][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("DRHOL/DP (S2/M2)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[10][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("DRHOWAT/DP (S2/M2)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[19][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("DRHOG/DT (KG/M3-K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[2][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("DRHOL/DT (KG/M3-K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[11][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("DRHOWAT/DT (KG/M3-K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[20][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("GAS MASS FRACTION (-)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[3][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("WATER VAPOR MASS FRACTION (-)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[17][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("GAS VISCOSITY (NS/M2)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[4][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("LIQUID VISCOSITY (NS/M2)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[12][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("WATER VISCOSITY (NS/M2)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[21][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("GAS HEAT CAPACITY (J/KG-K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[5][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("LIQUID HEAT CAPACITY (J/KG-K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[13][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("WATER HEAT CAPACITY (J/KG-K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[22][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("GAS ENTHALPY (J/KG)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[6][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("LIQUID ENTHALPY (J/KG)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[14][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("WATER ENTHALPY (J/KG)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[23][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("GAS THERMAL CONDUCTIVITY (W/M-K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[7][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("LIQUID THERMAL CONDUCTIVITY (W/M-K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[16][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("WATER THERMAL CONDUCTIVITY (W/M-K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[25][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("VAPOR-LIQUID SURFACE TENSION (N/M)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[26][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("VAPOR-WATER SURFACE TENSION (N/M)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[27][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("LIQUID-WATER SURFACE TENSION (N/M)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[28][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("GAS ENTROPY (J/KG/K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[8][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("LIQUID ENTROPY (J/KG/K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[15][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
                writer.write("WATER ENTROPY (J/KG/K)\n");
                i4 = 0;
                while (i4 < this.pressures.length) {
                    counter = 0;
                    j = 0;
                    while (j < this.temperatures.length) {
                        if (counter > 4) {
                            writer.write("\n");
                            counter = 0;
                        }
                        writer.write(String.valueOf(this.props[24][i4][j]) + "    ");
                        ++counter;
                        ++j;
                    }
                    writer.write("\n");
                    ++i4;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void extrapolateTable() {
        int j = 0;
        while (j < this.temperatures.length) {
            int i = 0;
            while (i < this.pressures.length) {
                boolean cfr_ignored_0 = this.hasValue[26][i][j];
                ++i;
            }
            ++j;
        }
    }
}

