/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.MathLib.nonLinearSolver.newtonRhapson;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class sysNewtonRhapsonPhaseEnvelope
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(sysNewtonRhapsonPhaseEnvelope.class);
    double sumx = 0.0;
    double sumy = 0.0;
    int neq = 0;
    int iter = 0;
    int iter2 = 0;
    int ic02p = -100;
    int ic03p = -100;
    int testcrit = 0;
    int npCrit = 0;
    double beta = 0.0;
    double ds = 0.0;
    double dTmax = 10.0;
    double dPmax = 10.0;
    double TC1 = 0.0;
    double TC2 = 0.0;
    double PC1 = 0.0;
    double PC2 = 0.0;
    double specVal = 0.0;
    int lc = 0;
    int hc = 0;
    double sumlnKvals;
    Matrix Jac;
    Matrix fvec;
    Matrix u;
    Matrix uold;
    Matrix uolder;
    Matrix ucrit;
    Matrix ucritold;
    Matrix Xgij;
    SystemInterface system;
    int numberOfComponents;
    int speceq = 0;
    Matrix a = new Matrix(4, 4);
    Matrix dxds = null;
    Matrix s = new Matrix(1, 4);
    Matrix xg;
    Matrix xcoef;
    newtonRhapson solver;
    boolean etterCP = false;
    boolean etterCP2 = false;
    boolean calcCP = false;
    boolean ettercricoT = false;
    Matrix xcoefOld;
    double sign = 1.0;
    double dt;
    double dp;
    double norm;
    double vol = Math.pow(10.0, 5.0);
    double volold = Math.pow(10.0, 5.0);
    double volold2 = Math.pow(10.0, 5.0);

    public sysNewtonRhapsonPhaseEnvelope() {
    }

    public sysNewtonRhapsonPhaseEnvelope(SystemInterface system, int numberOfPhases, int numberOfComponents) {
        this.system = system;
        this.numberOfComponents = numberOfComponents;
        this.neq = numberOfComponents + 2;
        this.Jac = new Matrix(this.neq, this.neq);
        this.fvec = new Matrix(this.neq, 1);
        this.u = new Matrix(this.neq, 1);
        this.Xgij = new Matrix(this.neq, 4);
        this.setu();
        this.uold = this.u.copy();
        this.findSpecEqInit();
        this.solver = new newtonRhapson();
        this.solver.setOrder(3);
    }

    public void setfvec22() {
        int i = 0;
        while (i < this.numberOfComponents) {
            this.fvec.set(i, 0, Math.log(this.system.getPhase(0).getComponents()[i].getFugacityCoefficient() * this.system.getPhase(0).getComponents()[i].getx()) - Math.log(this.system.getPhase(1).getComponents()[i].getFugacityCoefficient() * this.system.getPhase(1).getComponents()[i].getx()));
            ++i;
        }
        double fsum = 0.0;
        int i2 = 0;
        while (i2 < this.numberOfComponents) {
            fsum += this.system.getPhase(0).getComponents()[i2].getx() - this.system.getPhase(1).getComponents()[i2].getx();
            ++i2;
        }
        this.fvec.set(this.numberOfComponents, 0, fsum);
        this.fvec.set(this.numberOfComponents, 0, this.sumy - this.sumx);
        this.fvec.set(this.numberOfComponents + 1, 0, this.u.get(this.speceq, 0) - this.specVal);
    }

    public void setfvec() {
        int i = 0;
        while (i < this.numberOfComponents) {
            this.fvec.set(i, 0, this.u.get(i, 0) + this.system.getPhase(0).getComponents()[i].getLogFugacityCoefficient() - this.system.getPhase(1).getComponents()[i].getLogFugacityCoefficient());
            ++i;
        }
        this.fvec.set(this.numberOfComponents, 0, this.sumy - this.sumx);
        this.fvec.set(this.numberOfComponents + 1, 0, this.u.get(this.speceq, 0) - this.specVal);
    }

    public void findSpecEqInit() {
        this.speceq = 0;
        int speceqmin = 0;
        this.system.getPhase(0).getComponents()[this.numberOfComponents - 1].getPC();
        this.system.getPhase(0).getComponents()[this.numberOfComponents - 1].getTC();
        this.system.getPhase(0).getComponents()[this.numberOfComponents - 1].getAcentricFactor();
        int i = 0;
        while (i < this.numberOfComponents) {
            if (!(this.system.getComponent(i).getz() < 1.0E-10)) {
                if (this.system.getPhase(0).getComponents()[i].getTC() > this.system.getPhase(0).getComponents()[this.speceq].getTC()) {
                    this.speceq = this.system.getPhase(0).getComponents()[i].getComponentNumber();
                    this.specVal = this.u.get(i, 0);
                    this.hc = i;
                }
                if (this.system.getPhase(0).getComponents()[i].getTC() < this.system.getPhase(0).getComponents()[speceqmin].getTC()) {
                    speceqmin = this.system.getPhase(0).getComponents()[i].getComponentNumber();
                    this.lc = i;
                }
            }
            ++i;
        }
    }

    public void findSpecEq() {
        double max = 0.0;
        double max2 = 0.0;
        int speceq2 = 0;
        int i = 0;
        while (i < this.numberOfComponents + 2) {
            double testVal = Math.abs((Math.exp(this.u.get(i, 0)) - Math.exp(this.uold.get(i, 0))) / Math.exp(this.uold.get(i, 0)));
            if (testVal > max) {
                this.speceq = i;
                this.specVal = this.u.get(i, 0);
                max = testVal;
            }
            if ((testVal = Math.abs(this.dxds.get(i, 0))) > max2) {
                speceq2 = i;
                max2 = testVal;
            }
            ++i;
        }
        if (Double.isNaN(this.dxds.get(1, 0))) {
            speceq2 = this.numberOfComponents + 3;
        }
        if (this.speceq != speceq2) {
            this.speceq = speceq2;
        }
    }

    public void useAsSpecEq(int i) {
        this.speceq = i;
        this.specVal = this.u.get(i, 0);
        System.out.println("Enforced Scec Variable" + this.speceq + "  " + this.specVal);
    }

    public final void calc_x_y() {
        this.sumx = 0.0;
        this.sumy = 0.0;
        int j = 0;
        while (j < this.system.getNumberOfPhases()) {
            int i = 0;
            while (i < this.system.getPhase(0).getNumberOfComponents()) {
                if (j == 0) {
                    this.sumy += this.system.getPhase(j).getComponents()[i].getK() * this.system.getPhase(j).getComponents()[i].getz() / (1.0 - this.system.getBeta(0) + this.system.getBeta(0) * this.system.getPhase(0).getComponents()[i].getK());
                }
                if (j == 1) {
                    this.sumx += this.system.getPhase(0).getComponents()[i].getz() / (1.0 - this.system.getBeta(0) + this.system.getBeta(0) * this.system.getPhase(0).getComponents()[i].getK());
                }
                ++i;
            }
            ++j;
        }
    }

    public void setJac2() {
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double[] dxidlnk = new double[this.numberOfComponents];
        double[] dyidlnk = new double[this.numberOfComponents];
        double tempJ = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            dxidlnk[i] = -this.system.getBeta() * this.system.getPhase(1).getComponents()[i].getx() * this.system.getPhase(0).getComponents()[i].getx() / this.system.getPhase(0).getComponents()[i].getz();
            dyidlnk[i] = this.system.getPhase(0).getComponents()[i].getx() + this.system.getPhase(1).getComponents()[i].getK() * dxidlnk[i];
            ++i;
        }
        i = 0;
        while (i < this.numberOfComponents) {
            double dlnxdlnK = -1.0 / (1.0 + this.system.getBeta() * this.system.getPhase(0).getComponents()[i].getK() - this.system.getBeta()) * this.system.getBeta() * this.system.getPhase(0).getComponents()[i].getK();
            double dlnydlnK = 1.0 - 1.0 / (this.system.getPhase(0).getComponents()[i].getK() * this.system.getBeta() + 1.0 - this.system.getBeta()) * this.system.getBeta() * this.system.getPhase(0).getComponents()[i].getK();
            int j = 0;
            while (j < this.numberOfComponents) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = -dij + dij * dlnydlnK - dij * dlnxdlnK;
                this.Jac.set(i, j, tempJ);
                ++j;
            }
            tempJ = this.system.getTemperature() * (this.system.getPhase(0).getComponents()[i].getdfugdt() - this.system.getPhase(1).getComponents()[i].getdfugdt());
            this.Jac.set(i, this.numberOfComponents, tempJ);
            tempJ = this.system.getPressure() * (this.system.getPhase(0).getComponents()[i].getdfugdp() - this.system.getPhase(1).getComponents()[i].getdfugdp());
            this.Jac.set(i, this.numberOfComponents + 1, tempJ);
            this.Jac.set(this.numberOfComponents, i, dyidlnk[i] - dxidlnk[i]);
            ++i;
        }
        this.Jac.set(this.numberOfComponents + 1, this.speceq, 1.0);
    }

    public void setJac() {
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double[] dxidlnk = new double[this.numberOfComponents];
        double[] dyidlnk = new double[this.numberOfComponents];
        double tempJ = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            dxidlnk[i] = -this.system.getPhase(1).getComponents()[i].getz() * Math.pow(this.system.getPhase(0).getComponents()[i].getK() * this.system.getBeta() + 1.0 - this.system.getBeta(), -2.0) * this.system.getBeta() * this.system.getPhase(1).getComponents()[i].getK();
            dyidlnk[i] = this.system.getPhase(1).getComponents()[i].getz() / (this.system.getPhase(0).getComponents()[i].getK() * this.system.getBeta() + 1.0 - this.system.getBeta()) * this.system.getPhase(1).getComponents()[i].getK() - this.system.getPhase(0).getComponents()[i].getK() * this.system.getPhase(1).getComponents()[i].getz() / Math.pow(1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhase(0).getComponents()[i].getK(), 2.0) * this.system.getBeta() * this.system.getPhase(0).getComponents()[i].getK();
            ++i;
        }
        i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.numberOfComponents) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij + this.system.getPhase(0).getComponents()[i].getdfugdx(j) * dyidlnk[j] - this.system.getPhase(1).getComponents()[i].getdfugdx(j) * dxidlnk[j];
                this.Jac.set(i, j, tempJ);
                ++j;
            }
            tempJ = this.system.getTemperature() * (this.system.getPhase(0).getComponents()[i].getdfugdt() - this.system.getPhase(1).getComponents()[i].getdfugdt());
            this.Jac.set(i, this.numberOfComponents, tempJ);
            tempJ = this.system.getPressure() * (this.system.getPhase(0).getComponents()[i].getdfugdp() - this.system.getPhase(1).getComponents()[i].getdfugdp());
            this.Jac.set(i, this.numberOfComponents + 1, tempJ);
            this.Jac.set(this.numberOfComponents, i, dyidlnk[i] - dxidlnk[i]);
            this.Jac.set(this.numberOfComponents + 1, i, 0.0);
            ++i;
        }
        this.Jac.set(this.numberOfComponents + 1, this.speceq, 1.0);
    }

    public void setu() {
        int i = 0;
        while (i < this.numberOfComponents) {
            this.u.set(i, 0, Math.log(this.system.getPhase(0).getComponents()[i].getK()));
            ++i;
        }
        this.u.set(this.numberOfComponents, 0, Math.log(this.system.getTemperature()));
        this.u.set(this.numberOfComponents + 1, 0, Math.log(this.system.getPressure()));
    }

    public void init() {
        int i = 0;
        while (i < this.numberOfComponents) {
            this.system.getPhase(0).getComponents()[i].setK(Math.exp(this.u.get(i, 0)));
            this.system.getPhase(1).getComponents()[i].setK(Math.exp(this.u.get(i, 0)));
            ++i;
        }
        this.system.setTemperature(Math.exp(this.u.get(this.numberOfComponents, 0)));
        this.system.setPressure(Math.exp(this.u.get(this.numberOfComponents + 1, 0)));
        this.calc_x_y();
        this.system.calc_x_y();
        this.system.init(3);
    }

    public void calcInc(int np) {
        this.init();
        if (np < 5) {
            this.setu();
            this.speceq = this.numberOfComponents + 1;
            this.specVal = this.u.get(this.speceq, 0);
            this.setJac();
            this.fvec.timesEquals(0.0);
            this.fvec.set(this.speceq, 0, 1.0);
            this.dxds = this.Jac.solve(this.fvec);
            double dp = 0.1;
            this.ds = dp / this.dxds.get(this.numberOfComponents + 1, 0);
            this.Xgij.setMatrix(0, this.numberOfComponents + 1, np - 1, np - 1, this.u.copy());
            this.u.plusEquals(this.dxds.times(this.ds));
            this.specVal = this.u.get(this.speceq, 0);
        } else {
            int speceqOld = this.speceq;
            this.findSpecEq();
            if (this.speceq == this.numberOfComponents + 3) {
                this.speceq = speceqOld;
            }
            int intsign = Math.round(Math.round(this.dxds.get(this.speceq, 0) * 1.0E8));
            int sign1 = Integer.signum(intsign);
            this.ds = (double)sign1 * this.ds;
            this.setfvec();
            this.setJac();
            this.fvec.timesEquals(0.0);
            this.fvec.set(this.numberOfComponents + 1, 0, 1.0);
            this.dxds = this.Jac.solve(this.fvec);
            double Kvallc = this.system.getPhase(0).getComponent(this.lc).getx() / this.system.getPhase(1).getComponent(this.lc).getx();
            double Kvalhc = this.system.getPhase(0).getComponent(this.hc).getx() / this.system.getPhase(1).getComponent(this.hc).getx();
            if (!this.etterCP && Kvallc < 1.05 && Kvalhc > 0.95) {
                this.calcCP = true;
                this.etterCP = true;
                this.npCrit = np;
                this.system.invertPhaseTypes();
            }
            if (this.iter > 6) {
                this.ds *= 0.5;
            } else {
                if (this.iter < 3) {
                    this.ds *= 1.1;
                }
                if (this.iter == 3) {
                    this.ds *= 1.0;
                }
                if (this.iter == 4) {
                    this.ds *= 0.9;
                }
                if (this.iter > 4) {
                    this.ds *= 0.7;
                }
            }
            intsign = Math.round(Math.round(this.ds * 1.0E8));
            int sign2 = Integer.signum(intsign);
            if (1.0 + this.dTmax / this.system.getTemperature() < Math.exp(this.dxds.get(this.numberOfComponents, 0) * this.ds)) {
                this.ds = Math.log(1.0 + this.dTmax / this.system.getTemperature()) / this.dxds.get(this.numberOfComponents, 0);
            } else if (1.0 - this.dTmax / this.system.getTemperature() > Math.exp(this.dxds.get(this.numberOfComponents, 0) * this.ds)) {
                this.ds = Math.log(1.0 - this.dTmax / this.system.getTemperature()) / this.dxds.get(this.numberOfComponents, 0);
            } else if (1.0 + this.dPmax / this.system.getPressure() < Math.exp(this.dxds.get(this.numberOfComponents + 1, 0) * this.ds)) {
                this.ds = Math.log(1.0 + this.dPmax / this.system.getPressure()) / this.dxds.get(this.numberOfComponents + 1, 0);
            } else if (1.0 - this.dPmax / this.system.getPressure() > Math.exp(this.dxds.get(this.numberOfComponents + 1, 0) * this.ds)) {
                this.ds = Math.log(1.0 - this.dPmax / this.system.getPressure()) / this.dxds.get(this.numberOfComponents + 1, 0);
            }
            this.ds = (double)sign2 * Math.abs(this.ds);
            this.Xgij.setMatrix(0, this.numberOfComponents + 1, 0, 2, this.Xgij.getMatrix(0, this.numberOfComponents + 1, 1, 3));
            this.Xgij.setMatrix(0, this.numberOfComponents + 1, 3, 3, this.u.copy());
            this.s.setMatrix(0, 0, 0, 3, this.Xgij.getMatrix(this.speceq, this.speceq, 0, 3));
            this.calcInc2(np);
        }
        this.iter = 0;
        this.iter2 = 0;
    }

    public void calcInc2(int np) {
        double sny;
        int i = 0;
        while (i < 4) {
            this.a.set(i, 0, 1.0);
            this.a.set(i, 1, this.s.get(0, i));
            this.a.set(i, 2, this.s.get(0, i) * this.s.get(0, i));
            this.a.set(i, 3, this.a.get(i, 2) * this.s.get(0, i));
            ++i;
        }
        this.specVal = sny = this.ds * this.dxds.get(this.speceq, 0) + this.s.get(0, 3);
        int j = 0;
        while (j < this.neq) {
            this.xg = this.Xgij.getMatrix(j, j, 0, 3);
            try {
                this.xcoef = this.a.solve(this.xg.transpose());
            }
            catch (Exception e) {
                this.xcoef = this.xcoefOld.copy();
            }
            this.u.set(j, 0, this.xcoef.get(0, 0) + sny * (this.xcoef.get(1, 0) + sny * (this.xcoef.get(2, 0) + sny * this.xcoef.get(3, 0))));
            ++j;
        }
        this.xcoefOld = this.xcoef.copy();
    }

    public void calcCrit() {
        Matrix aa = this.a.copy();
        Matrix ss = this.s.copy();
        Matrix xx = this.Xgij.copy();
        Matrix uu = this.u.copy();
        int i = 0;
        while (i < 4) {
            this.a.set(i, 0, 1.0);
            this.a.set(i, 1, this.s.get(0, i));
            this.a.set(i, 2, this.s.get(0, i) * this.s.get(0, i));
            this.a.set(i, 3, this.a.get(i, 2) * this.s.get(0, i));
            ++i;
        }
        double sny = 0.0;
        try {
            int j = 0;
            while (j < this.neq) {
                this.xg = this.Xgij.getMatrix(j, j, 0, 3);
                try {
                    this.xcoef = this.a.solve(this.xg.transpose());
                }
                catch (Exception e) {
                    this.xcoef = this.xcoefOld.copy();
                }
                this.u.set(j, 0, this.xcoef.get(0, 0) + sny * (this.xcoef.get(1, 0) + sny * (this.xcoef.get(2, 0) + sny * this.xcoef.get(3, 0))));
                ++j;
            }
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        this.system.setTC(Math.exp(this.u.get(this.numberOfComponents, 0)));
        this.system.setPC(Math.exp(this.u.get(this.numberOfComponents + 1, 0)));
        this.a = aa.copy();
        this.s = ss.copy();
        this.Xgij = xx.copy();
        this.u = uu.copy();
    }

    public int getNpCrit() {
        return this.npCrit;
    }

    public double sign(double a, double b) {
        a = Math.abs(a);
        b = b >= 0.0 ? 1.0 : -1.0;
        return a * b;
    }

    public void solve(int np) {
        double dxOldNorm = 1.0E10;
        do {
            ++this.iter;
            this.init();
            this.setfvec();
            this.setJac();
            Matrix dx = this.Jac.solve(this.fvec);
            this.u.minusEquals(dx);
            if (Double.isNaN(dx.norm2()) || Double.isInfinite(dx.norm2())) {
                if (this.iter2 >= 15) {
                    this.ds = Double.NaN;
                    this.u.set(this.numberOfComponents, 0, this.ds);
                    this.u.set(this.numberOfComponents + 1, 0, this.ds);
                }
                ++this.iter2;
                this.u = this.uold.copy();
                this.ds *= 0.5;
                this.calcInc2(np);
                this.solve(np);
            } else if (dxOldNorm < dx.norm2()) {
                if (this.iter2 == 0) {
                    this.uolder = this.uold.copy();
                }
                if (this.iter2 >= 15) {
                    this.ds = Double.NaN;
                    this.u.set(this.numberOfComponents, 0, this.ds);
                    this.u.set(this.numberOfComponents + 1, 0, this.ds);
                }
                ++this.iter2;
                this.u = this.uold.copy();
                this.ds *= 0.5;
                this.calcInc2(np);
                this.solve(np);
            }
            if (Double.isNaN(dx.norm2())) {
                this.norm = 1.0E10;
                continue;
            }
            dxOldNorm = this.norm = dx.norm2();
        } while (this.norm > 1.0E-5);
        this.init();
        this.findSpecEq();
        this.volold2 = this.volold;
        this.volold = this.vol;
        this.vol = this.system.getPhase(0).getMolarVolume();
        this.uold = this.u.copy();
    }

    public static void main(String[] args) {
    }
}

