/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.dataPresentation.JFreeChart.graph2b;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FugTestConstP
extends constantDutyTemperatureFlash
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(FugTestConstP.class);
    public double temp = 0.0;
    public double pres = 0.0;
    public SystemInterface testSystem;
    public SystemInterface testSystem2;
    public ThermodynamicOperations testOps;
    public ThermodynamicOperations testOps2;
    public int compNumber = 0;
    public String compName;
    public boolean compNameGiven = false;

    public FugTestConstP() {
    }

    public FugTestConstP(SystemInterface system) {
        this.testSystem = system;
        this.testOps = new ThermodynamicOperations(this.testSystem);
        this.pres = this.testSystem.getPressure();
    }

    public FugTestConstP(SystemInterface system, double pres) {
        this.testSystem = system;
        this.testOps = new ThermodynamicOperations(this.testSystem);
        this.pres = pres;
    }

    public void initTestSystem2(int K) {
        this.testSystem2 = new SystemSrkSchwartzentruberEos(this.temp, this.pres);
        this.testSystem2.addComponent(this.compName, 1.0);
        this.testSystem2.setPhaseType(0, 1);
        this.testOps2 = new ThermodynamicOperations(this.testSystem2);
    }

    @Override
    public void run() {
        double SolidFug = 0.0;
        double Pvapsolid = 0.0;
        double SolVapFugCoeff = 0.0;
        double solvol = 0.0;
        double soldens = 0.0;
        double trpTemp = 0.0;
        boolean CCequation = true;
        double[][] Fug = new double[4][20];
        double[][] Fugrel = new double[2][20];
        int k = 0;
        while (k < this.testSystem.getPhases()[0].getNumberOfComponents()) {
            if (this.testSystem.getPhase(0).getComponent(k).doSolidCheck()) {
                this.compName = this.testSystem.getPhase(0).getComponent(k).getComponentName();
                trpTemp = this.testSystem.getPhases()[0].getComponents()[k].getTriplePointTemperature();
                this.initTestSystem2(k);
                if (Math.abs(this.testSystem.getPhases()[0].getComponents()[k].getHsub()) < 1.0E-6) {
                    CCequation = false;
                }
                int i = 0;
                while (i < 20) {
                    logger.info("--- calculating --- " + this.compName + " at ");
                    this.temp = trpTemp + 2.0 - (double)i * trpTemp / 40.0;
                    this.testSystem.setTemperature(this.temp);
                    this.testSystem2.setTemperature(this.temp);
                    logger.info("temperature " + this.temp);
                    if (this.temp > trpTemp + 0.1) {
                        this.temp = trpTemp;
                    }
                    if (CCequation) {
                        Pvapsolid = this.testSystem.getPhase(0).getComponent(k).getCCsolidVaporPressure(this.temp);
                        logger.info("pvap solid CC " + Pvapsolid);
                    } else {
                        Pvapsolid = this.testSystem.getPhase(0).getComponent(k).getSolidVaporPressure(this.temp);
                        logger.info("pvap solid Antonie " + Pvapsolid);
                    }
                    soldens = this.testSystem.getPhase(0).getComponent(k).getPureComponentSolidDensity(this.temp) * 1000.0;
                    if (soldens > 2000.0) {
                        soldens = 1000.0;
                    }
                    logger.info("Solid_vapour_____solid density" + soldens);
                    solvol = 1.0 / soldens * this.testSystem.getPhase(0).getComponent(k).getMolarMass();
                    SolidFug = Pvapsolid * Math.exp(solvol / (8.3144621 * this.temp) * (this.pres - Pvapsolid));
                    this.testSystem2.setPressure(Pvapsolid);
                    this.testOps.TPflash();
                    this.testOps2.TPflash();
                    SolVapFugCoeff = this.testSystem2.getPhase(0).getComponent(0).getFugacityCoefficient();
                    Fug[3][i] = this.testSystem.getPhase(0).getFugacity(k);
                    Fug[1][i] = SolidFug * SolVapFugCoeff;
                    Fug[0][i] = this.testSystem.getTemperature();
                    Fug[2][i] = this.testSystem.getTemperature();
                    Fugrel[0][i] = this.testSystem.getTemperature();
                    Fugrel[1][i] = Fug[1][i] / Fug[3][i];
                    ++i;
                }
                String[] title = new String[]{"Solid Fugacity", "Fluid Fugacity"};
                graph2b graffug = new graph2b(Fug, title, String.valueOf(this.compName) + " Fugacity  VS T, constant P= " + this.pres, "Temperature [K]", "Fugacity [bar]");
                graffug.setVisible(true);
                String[] title2 = new String[]{"Solid/Fluid"};
                graph2b grafvapor = new graph2b(Fugrel, title2, String.valueOf(this.compName) + " Fugacity Ratio", "Temperature [K]", "Fsolid/Ffluid");
                grafvapor.setVisible(true);
            }
            ++k;
        }
    }

    public void PrintToFile(String FileName) {
    }
}

