/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import java.util.ArrayList;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ejml.simple.SimpleMatrix;

public class TPmultiflash
extends TPflash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TPmultiflash.class);
    boolean multiPhaseTest = false;
    double[][] dQdbeta;
    double[][] Qmatrix;
    double[] Erow;
    double Q = 0.0;
    boolean doStabilityAnalysis = true;
    boolean removePhase = false;
    boolean checkOneRemove = false;
    boolean secondTime = false;
    double[] multTerm;
    double[] multTerm2;

    public TPmultiflash() {
    }

    public TPmultiflash(SystemInterface system) {
        super(system);
        this.Erow = new double[system.getPhase(0).getNumberOfComponents()];
    }

    public TPmultiflash(SystemInterface system, boolean check) {
        super(system, check);
        this.Erow = new double[system.getPhase(0).getNumberOfComponents()];
        this.multTerm = new double[system.getPhase(0).getNumberOfComponents()];
        this.multTerm2 = new double[system.getPhase(0).getNumberOfComponents()];
    }

    public void calcMultiPhaseBeta() {
    }

    public void setDoubleArrays() {
        this.dQdbeta = new double[this.system.getNumberOfPhases()][1];
        this.Qmatrix = new double[this.system.getNumberOfPhases()][this.system.getNumberOfPhases()];
    }

    public void setXY() {
        int k = 0;
        while (k < this.system.getNumberOfPhases()) {
            int i = 0;
            while (i < this.system.getPhase(0).getNumberOfComponents()) {
                if (this.system.getPhase(0).getComponent(i).getz() > 1.0E-100) {
                    this.system.getPhase(k).getComponents()[i].setx(this.system.getPhase(0).getComponents()[i].getz() / this.Erow[i] / this.system.getPhase(k).getComponent(i).getFugacityCoefficient());
                }
                if (this.system.getPhase(0).getComponent(i).getIonicCharge() != 0.0 && !this.system.getPhase(k).getPhaseTypeName().equals("aqueous")) {
                    this.system.getPhase(k).getComponents()[i].setx(1.0E-50);
                }
                if (this.system.getPhase(0).getComponent(i).getIonicCharge() != 0.0 && this.system.getPhase(k).getPhaseTypeName().equals("aqueous")) {
                    this.system.getPhase(k).getComponents()[i].setx(this.system.getPhase(k).getComponents()[i].getNumberOfmoles() / this.system.getPhase(k).getNumberOfMolesInPhase());
                }
                ++i;
            }
            this.system.getPhase(k).normalize();
            ++k;
        }
    }

    public void calcE() {
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            this.Erow[i] = 0.0;
            int k = 0;
            while (k < this.system.getNumberOfPhases()) {
                int n = i;
                this.Erow[n] = this.Erow[n] + this.system.getPhase(k).getBeta() / this.system.getPhase(k).getComponent(i).getFugacityCoefficient();
                ++k;
            }
            ++i;
        }
    }

    public double calcQ() {
        this.calcE();
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            this.multTerm[i] = this.system.getPhase(0).getComponent(i).getz() / this.Erow[i];
            this.multTerm2[i] = this.system.getPhase(0).getComponent(i).getz() / (this.Erow[i] * this.Erow[i]);
            ++i;
        }
        int k = 0;
        while (k < this.system.getNumberOfPhases()) {
            this.dQdbeta[k][0] = 1.0;
            int i2 = 0;
            while (i2 < this.system.getPhase(0).getNumberOfComponents()) {
                double[] dArray = this.dQdbeta[k];
                dArray[0] = dArray[0] - this.multTerm[i2] / this.system.getPhase(k).getComponent(i2).getFugacityCoefficient();
                ++i2;
            }
            ++k;
        }
        i = 0;
        while (i < this.system.getNumberOfPhases()) {
            int j = 0;
            while (j < this.system.getNumberOfPhases()) {
                this.Qmatrix[i][j] = 0.0;
                int k2 = 0;
                while (k2 < this.system.getPhase(0).getNumberOfComponents()) {
                    double[] dArray = this.Qmatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.multTerm2[k2] / (this.system.getPhase(j).getComponent(k2).getFugacityCoefficient() * this.system.getPhase(i).getComponent(k2).getFugacityCoefficient());
                    ++k2;
                }
                if (i == j) {
                    double[] dArray = this.Qmatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + 0.001;
                }
                ++j;
            }
            ++i;
        }
        return this.Q;
    }

    public double solveBeta() {
        SimpleMatrix betaMatrix = new SimpleMatrix(1, this.system.getNumberOfPhases());
        SimpleMatrix ans = null;
        double err = 1.0;
        int iter = 1;
        do {
            ++iter;
            int k = 0;
            while (k < this.system.getNumberOfPhases()) {
                betaMatrix.set(0, k, this.system.getPhase(k).getBeta());
                ++k;
            }
            this.calcQ();
            SimpleMatrix dQM = new SimpleMatrix(this.dQdbeta);
            SimpleMatrix dQdBM = new SimpleMatrix(this.Qmatrix);
            try {
                ans = (SimpleMatrix)dQdBM.solve(dQM).transpose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            betaMatrix = betaMatrix.minus((SimpleMatrix)ans.scale((double)iter / ((double)iter + 3.0)));
            this.removePhase = false;
            int k2 = 0;
            while (k2 < this.system.getNumberOfPhases()) {
                this.system.setBeta(k2, betaMatrix.get(0, k2));
                if (betaMatrix.get(0, k2) < 1.0E-12) {
                    this.system.setBeta(k2, 1.0E-12);
                    if (this.checkOneRemove) {
                        this.checkOneRemove = false;
                        this.removePhase = true;
                    }
                    this.checkOneRemove = true;
                } else if (betaMatrix.get(0, k2) > 0.999999999999) {
                    this.system.setBeta(k2, 0.999999999999);
                }
                ++k2;
            }
            this.system.normalizeBeta();
            this.system.init(1);
            this.calcE();
            this.setXY();
            this.system.init(1);
        } while ((err = ans.normF()) > 1.0E-12 && iter < 50 || iter < 3);
        return err;
    }

    @Override
    public void stabilityAnalysis() {
        double[] logWi = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] Wi = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        double[] deltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] sumw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double err = 0.0;
        double[] oldlogw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] oldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] d = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] x = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        this.tm = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] alpha = null;
        ArrayList<SystemInterface> clonedSystem = new ArrayList<SystemInterface>(1);
        this.minimumGibbsEnergySystem = this.system;
        clonedSystem.add(this.system.clone());
        this.lowestGibbsEnergyPhase = 0;
        int k = 0;
        while (k < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            if (this.system.getPhase(0).getComponent(k).getx() > 1.0E-100) {
                d[k] = Math.log(this.system.getPhase(0).getComponents()[k].getx()) + this.system.getPhase(0).getComponents()[k].getLogFugacityCoefficient();
            }
            ++k;
        }
        int j = 0;
        while (j < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            logWi[j] = this.system.getPhase(0).getComponent(j).getz() > 1.0E-100 ? 1.0 : -10000.0;
            ++j;
        }
        int hydrocarbonTestCompNumb = 0;
        int lightTestCompNumb = 0;
        double Mmax = 0.0;
        double Mmin = 1.0E10;
        int i = 0;
        while (i < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).isHydrocarbon()) {
                if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() > Mmax) {
                    Mmax = this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass();
                }
                if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() < Mmin) {
                    Mmin = this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass();
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).isHydrocarbon() && this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getz() > 1.0E-50 && Math.abs(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() - Mmax) < 1.0E-5) {
                hydrocarbonTestCompNumb = i;
            }
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).isHydrocarbon() && this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getz() > 1.0E-50 && Math.abs(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() - Mmin) < 1.0E-5) {
                lightTestCompNumb = i;
            }
            ++i;
        }
        int j2 = this.system.getPhase(0).getNumberOfComponents() - 1;
        while (j2 >= 0) {
            if (!(this.minimumGibbsEnergySystem.getPhase(0).getComponent(j2).getx() < 1.0E-100 || this.minimumGibbsEnergySystem.getPhase(0).getComponent(j2).getIonicCharge() != 0.0 || this.minimumGibbsEnergySystem.getPhase(0).getComponent(j2).isHydrocarbon() && j2 != hydrocarbonTestCompNumb && j2 != lightTestCompNumb)) {
                double nomb = 0.0;
                int cc = 0;
                while (cc < this.system.getPhase(0).getNumberOfComponents()) {
                    double d2 = nomb = cc == j2 ? 1.0 : 1.0E-12;
                    if (this.system.getPhase(0).getComponent(cc).getz() < 1.0E-100) {
                        nomb = 0.0;
                    }
                    ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[cc].setx(nomb);
                    ++cc;
                }
                int iter = 0;
                double errOld = 1.0E100;
                do {
                    errOld = err;
                    err = 0.0;
                    if (++iter <= 150 || !this.system.isImplementedCompositionDeriativesofFugacity()) {
                        if (iter % 7 == 0) {
                            double vec1 = 0.0;
                            double vec2 = 0.0;
                            double prod1 = 0.0;
                            double prod2 = 0.0;
                            this.i = 0;
                            while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                                vec1 = oldDeltalogWi[this.i] * oldoldDeltalogWi[this.i];
                                vec2 = Math.pow(oldoldDeltalogWi[this.i], 2.0);
                                prod1 += vec1 * vec2;
                                prod2 += vec2 * vec2;
                                ++this.i;
                            }
                            double lambda = prod1 / prod2;
                            this.i = 0;
                            while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                                int n = this.i;
                                logWi[n] = logWi[n] + lambda / (1.0 - lambda) * deltalogWi[this.i];
                                err += Math.abs((logWi[this.i] - oldlogw[this.i]) / oldlogw[this.i]);
                                Wi[j2][this.i] = Math.exp(logWi[this.i]);
                                ++this.i;
                            }
                        } else {
                            int i2 = 0;
                            while (i2 < this.system.getPhase(0).getNumberOfComponents()) {
                                oldoldoldlogw[i2] = oldoldlogw[i2];
                                oldoldlogw[i2] = oldlogw[i2];
                                oldlogw[i2] = logWi[i2];
                                oldoldDeltalogWi[i2] = oldoldlogw[i2] - oldoldoldlogw[i2];
                                oldDeltalogWi[i2] = oldlogw[i2] - oldoldlogw[i2];
                                ++i2;
                            }
                            ((SystemInterface)clonedSystem.get(0)).init(1, 1);
                            i2 = 0;
                            while (i2 < this.system.getPhase(0).getNumberOfComponents()) {
                                if (!Double.isInfinite(((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i2].getLogFugacityCoefficient()) && this.system.getPhase(0).getComponent(i2).getx() > 1.0E-100) {
                                    logWi[i2] = d[i2] - ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i2].getLogFugacityCoefficient();
                                    if (((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i2].getIonicCharge() != 0.0) {
                                        logWi[i2] = -1000.0;
                                    }
                                }
                                deltalogWi[i2] = logWi[i2] - oldlogw[i2];
                                err += Math.abs(logWi[i2] - oldlogw[i2]);
                                Wi[j2][i2] = Math.exp(logWi[i2]);
                                ++i2;
                            }
                        }
                    } else {
                        SimpleMatrix f = new SimpleMatrix(this.system.getPhases()[0].getNumberOfComponents(), 1);
                        SimpleMatrix df = null;
                        SimpleMatrix identitytimesConst = null;
                        int i3 = 0;
                        while (i3 < this.system.getPhase(0).getNumberOfComponents()) {
                            oldoldoldlogw[i3] = oldoldlogw[i3];
                            oldoldlogw[i3] = oldlogw[i3];
                            oldlogw[i3] = logWi[i3];
                            oldoldDeltalogWi[i3] = oldoldlogw[i3] - oldoldoldlogw[i3];
                            oldDeltalogWi[i3] = oldlogw[i3] - oldoldlogw[i3];
                            ++i3;
                        }
                        ((SystemInterface)clonedSystem.get(0)).init(3, 1);
                        alpha = new double[((SystemInterface)clonedSystem.get(0)).getPhases()[0].getNumberOfComponents()];
                        df = new SimpleMatrix(this.system.getPhases()[0].getNumberOfComponents(), this.system.getPhases()[0].getNumberOfComponents());
                        identitytimesConst = SimpleMatrix.identity(this.system.getPhases()[0].getNumberOfComponents());
                        i3 = 0;
                        while (i3 < ((SystemInterface)clonedSystem.get(0)).getPhases()[0].getNumberOfComponents()) {
                            alpha[i3] = 2.0 * Math.sqrt(Wi[j2][i3]);
                            ++i3;
                        }
                        i3 = 0;
                        while (i3 < this.system.getPhase(0).getNumberOfComponents()) {
                            if (this.system.getPhase(0).getComponent(i3).getz() > 1.0E-100) {
                                f.set(i3, 0, Math.sqrt(Wi[j2][i3]) * (Math.log(Wi[j2][i3]) + ((SystemInterface)clonedSystem.get(0)).getPhases()[1].getComponents()[i3].getLogFugacityCoefficient() - d[i3]));
                            }
                            int k2 = 0;
                            while (k2 < ((SystemInterface)clonedSystem.get(0)).getPhases()[0].getNumberOfComponents()) {
                                double kronDelt;
                                double d3 = kronDelt = i3 == k2 ? 1.0 : 0.0;
                                if (this.system.getPhase(0).getComponent(i3).getz() > 1.0E-100) {
                                    df.set(i3, k2, kronDelt + Math.sqrt(Wi[j2][k2] * Wi[j2][i3]) * ((SystemInterface)clonedSystem.get(0)).getPhases()[1].getComponents()[i3].getdfugdn(k2));
                                } else {
                                    df.set(i3, k2, 0.0);
                                }
                                ++k2;
                            }
                            ++i3;
                        }
                        SimpleMatrix dx = (SimpleMatrix)df.plus(identitytimesConst).solve(f).negative();
                        int i4 = 0;
                        while (i4 < this.system.getPhase(0).getNumberOfComponents()) {
                            double alphaNew = alpha[i4] + dx.get(i4, 0);
                            Wi[j2][i4] = Math.pow(alphaNew / 2.0, 2.0);
                            if (this.system.getPhase(0).getComponent(i4).getz() > 1.0E-100) {
                                logWi[i4] = Math.log(Wi[j2][i4]);
                            }
                            if (this.system.getPhase(0).getComponent(i4).getIonicCharge() != 0.0) {
                                logWi[i4] = -1000.0;
                            }
                            err += Math.abs((logWi[i4] - oldlogw[i4]) / oldlogw[i4]);
                            ++i4;
                        }
                    }
                    sumw[j2] = 0.0;
                    int i5 = 0;
                    while (i5 < this.system.getPhase(0).getNumberOfComponents()) {
                        int n = j2;
                        sumw[n] = sumw[n] + Math.exp(logWi[i5]);
                        ++i5;
                    }
                    i5 = 0;
                    while (i5 < this.system.getPhase(0).getNumberOfComponents()) {
                        if (this.system.getPhase(0).getComponent(i5).getx() > 1.0E-100) {
                            ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i5].setx(Math.exp(logWi[i5]) / sumw[j2]);
                        }
                        if (this.system.getPhase(0).getComponent(i5).getIonicCharge() != 0.0) {
                            ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i5].setx(1.0E-50);
                        }
                        ++i5;
                    }
                } while ((Math.abs(err) > 1.0E-9 || err > errOld) && iter < 600);
                double xTrivialCheck0 = 0.0;
                double xTrivialCheck1 = 0.0;
                this.tm[j2] = 1.0;
                int i6 = 0;
                while (i6 < this.system.getPhase(1).getNumberOfComponents()) {
                    if (this.system.getPhase(0).getComponent(i6).getx() > 1.0E-100) {
                        int n = j2;
                        this.tm[n] = this.tm[n] - Math.exp(logWi[i6]);
                    }
                    x[j2][i6] = ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i6].getx();
                    xTrivialCheck0 += Math.abs(x[j2][i6] - this.system.getPhase(0).getComponent(i6).getx());
                    xTrivialCheck1 += Math.abs(x[j2][i6] - this.system.getPhase(1).getComponent(i6).getx());
                    ++i6;
                }
                if (Math.abs(xTrivialCheck0) < 1.0E-4 || Math.abs(xTrivialCheck1) < 1.0E-4) {
                    this.tm[j2] = 10.0;
                }
                if (this.tm[j2] < -1.0E-8) break;
            }
            --j2;
        }
        int unstabcomp = 0;
        int k3 = this.system.getPhase(0).getNumberOfComponents() - 1;
        while (k3 >= 0) {
            if (this.tm[k3] < -1.0E-8 && !Double.isNaN(this.tm[k3])) {
                this.system.addPhase();
                unstabcomp = k3;
                int i7 = 0;
                while (i7 < this.system.getPhase(1).getNumberOfComponents()) {
                    this.system.getPhase(this.system.getNumberOfPhases() - 1).getComponents()[i7].setx(x[k3][i7]);
                    ++i7;
                }
                this.system.getPhases()[this.system.getNumberOfPhases() - 1].normalize();
                this.multiPhaseTest = true;
                this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhase(0).getComponent(unstabcomp).getz());
                this.system.init(1);
                this.system.normalizeBeta();
                return;
            }
            --k3;
        }
        this.system.normalizeBeta();
    }

    public void stabilityAnalysis2() {
        double[] logWi = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] Wi = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        double[] deltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] sumw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double err = 0.0;
        double[] oldlogw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] oldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] d = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] x = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        this.tm = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] alpha = null;
        ArrayList<SystemInterface> clonedSystem = new ArrayList<SystemInterface>(1);
        this.minimumGibbsEnergySystem = this.system;
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            if (this.system.getPhase(0).getComponent(i).getx() < 1.0E-100) {
                clonedSystem.add(null);
            } else {
                double numb = 0.0;
                clonedSystem.add(this.system.clone());
                int j = 0;
                while (j < this.system.getPhase(0).getNumberOfComponents()) {
                    double d2 = numb = i == j ? 1.0 : 1.0E-12;
                    if (this.system.getPhase(0).getComponent(j).getz() < 1.0E-100) {
                        numb = 0.0;
                    }
                    ((SystemInterface)clonedSystem.get(i)).getPhase(1).getComponents()[j].setx(numb);
                    ++j;
                }
                if (this.system.getPhase(0).getComponent(i).getIonicCharge() == 0.0) {
                    ((SystemInterface)clonedSystem.get(i)).init(1);
                }
            }
            ++i;
        }
        this.lowestGibbsEnergyPhase = 0;
        int k = 0;
        while (k < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            int i2 = 0;
            while (i2 < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
                if (clonedSystem.get(k) != null) {
                    int n = k;
                    sumw[n] = sumw[n] + ((SystemInterface)clonedSystem.get(k)).getPhase(1).getComponents()[i2].getx();
                }
                ++i2;
            }
            ++k;
        }
        k = 0;
        while (k < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            int i3 = 0;
            while (i3 < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
                if (clonedSystem.get(k) != null && this.system.getPhase(0).getComponent(k).getx() > 1.0E-100) {
                    ((SystemInterface)clonedSystem.get(k)).getPhase(1).getComponents()[i3].setx(((SystemInterface)clonedSystem.get(k)).getPhase(1).getComponents()[i3].getx() / sumw[0]);
                }
                ++i3;
            }
            if (this.system.getPhase(0).getComponent(k).getx() > 1.0E-100) {
                d[k] = Math.log(this.system.getPhase(0).getComponents()[k].getx()) + this.system.getPhase(0).getComponents()[k].getLogFugacityCoefficient();
            }
            ++k;
        }
        int j = 0;
        while (j < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            logWi[j] = this.system.getPhase(0).getComponent(j).getz() > 1.0E-100 ? 1.0 : -10000.0;
            ++j;
        }
        int hydrocarbonTestCompNumb = 0;
        int lightTestCompNumb = 0;
        double Mmax = 0.0;
        double Mmin = 1.0E10;
        int i4 = 0;
        while (i4 < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).isHydrocarbon()) {
                if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).getMolarMass() > Mmax) {
                    Mmax = this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).getMolarMass();
                }
                if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).getMolarMass() < Mmin) {
                    Mmin = this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).getMolarMass();
                }
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).isHydrocarbon() && this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).getz() > 1.0E-50 && Math.abs(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).getMolarMass() - Mmax) < 1.0E-5) {
                hydrocarbonTestCompNumb = i4;
            }
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).isHydrocarbon() && this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).getz() > 1.0E-50 && Math.abs(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i4).getMolarMass() - Mmin) < 1.0E-5) {
                lightTestCompNumb = i4;
            }
            ++i4;
        }
        int j2 = this.system.getPhase(0).getNumberOfComponents() - 1;
        while (j2 >= 0) {
            if (!(this.minimumGibbsEnergySystem.getPhase(0).getComponent(j2).getx() < 1.0E-100 || this.minimumGibbsEnergySystem.getPhase(0).getComponent(j2).getIonicCharge() != 0.0 || this.minimumGibbsEnergySystem.getPhase(0).getComponent(j2).isHydrocarbon() && j2 != hydrocarbonTestCompNumb && j2 != lightTestCompNumb)) {
                int iter = 0;
                double errOld = 1.0E100;
                do {
                    errOld = err;
                    err = 0.0;
                    if (++iter <= 20 || !this.system.isImplementedCompositionDeriativesofFugacity()) {
                        if (iter % 7 == 0) {
                            double vec1 = 0.0;
                            double vec2 = 0.0;
                            double prod1 = 0.0;
                            double prod2 = 0.0;
                            this.i = 0;
                            while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                                vec1 = oldDeltalogWi[this.i] * oldoldDeltalogWi[this.i];
                                vec2 = Math.pow(oldoldDeltalogWi[this.i], 2.0);
                                prod1 += vec1 * vec2;
                                prod2 += vec2 * vec2;
                                ++this.i;
                            }
                            double lambda = prod1 / prod2;
                            this.i = 0;
                            while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                                int n = this.i;
                                logWi[n] = logWi[n] + lambda / (1.0 - lambda) * deltalogWi[this.i];
                                err += Math.abs((logWi[this.i] - oldlogw[this.i]) / oldlogw[this.i]);
                                Wi[j2][this.i] = Math.exp(logWi[this.i]);
                                ++this.i;
                            }
                        } else {
                            int i5 = 0;
                            while (i5 < this.system.getPhase(0).getNumberOfComponents()) {
                                oldoldoldlogw[i5] = oldoldlogw[i5];
                                oldoldlogw[i5] = oldlogw[i5];
                                oldlogw[i5] = logWi[i5];
                                oldoldDeltalogWi[i5] = oldoldlogw[i5] - oldoldoldlogw[i5];
                                oldDeltalogWi[i5] = oldlogw[i5] - oldoldlogw[i5];
                                ++i5;
                            }
                            ((SystemInterface)clonedSystem.get(j2)).init(1, 1);
                            i5 = 0;
                            while (i5 < this.system.getPhase(0).getNumberOfComponents()) {
                                if (!Double.isInfinite(((SystemInterface)clonedSystem.get(j2)).getPhase(1).getComponents()[i5].getLogFugacityCoefficient()) && this.system.getPhase(0).getComponent(i5).getx() > 1.0E-100) {
                                    logWi[i5] = d[i5] - ((SystemInterface)clonedSystem.get(j2)).getPhase(1).getComponents()[i5].getLogFugacityCoefficient();
                                    if (((SystemInterface)clonedSystem.get(j2)).getPhase(1).getComponents()[i5].getIonicCharge() != 0.0) {
                                        logWi[i5] = -1000.0;
                                    }
                                }
                                deltalogWi[i5] = logWi[i5] - oldlogw[i5];
                                err += Math.abs(logWi[i5] - oldlogw[i5]);
                                Wi[j2][i5] = Math.exp(logWi[i5]);
                                ++i5;
                            }
                        }
                    } else {
                        SimpleMatrix f = new SimpleMatrix(this.system.getPhases()[0].getNumberOfComponents(), 1);
                        SimpleMatrix df = null;
                        SimpleMatrix identitytimesConst = null;
                        int i6 = 0;
                        while (i6 < this.system.getPhase(0).getNumberOfComponents()) {
                            oldoldoldlogw[i6] = oldoldlogw[i6];
                            oldoldlogw[i6] = oldlogw[i6];
                            oldlogw[i6] = logWi[i6];
                            oldoldDeltalogWi[i6] = oldoldlogw[i6] - oldoldoldlogw[i6];
                            oldDeltalogWi[i6] = oldlogw[i6] - oldoldlogw[i6];
                            ++i6;
                        }
                        ((SystemInterface)clonedSystem.get(j2)).init(3, 1);
                        alpha = new double[((SystemInterface)clonedSystem.get(j2)).getPhases()[0].getNumberOfComponents()];
                        df = new SimpleMatrix(this.system.getPhases()[0].getNumberOfComponents(), this.system.getPhases()[0].getNumberOfComponents());
                        identitytimesConst = SimpleMatrix.identity(this.system.getPhases()[0].getNumberOfComponents());
                        i6 = 0;
                        while (i6 < ((SystemInterface)clonedSystem.get(j2)).getPhases()[0].getNumberOfComponents()) {
                            alpha[i6] = 2.0 * Math.sqrt(Wi[j2][i6]);
                            ++i6;
                        }
                        i6 = 0;
                        while (i6 < this.system.getPhase(0).getNumberOfComponents()) {
                            if (this.system.getPhase(0).getComponent(i6).getz() > 1.0E-100) {
                                f.set(i6, 0, Math.sqrt(Wi[j2][i6]) * (Math.log(Wi[j2][i6]) + ((SystemInterface)clonedSystem.get(j2)).getPhases()[1].getComponents()[i6].getLogFugacityCoefficient() - d[i6]));
                            }
                            int k2 = 0;
                            while (k2 < ((SystemInterface)clonedSystem.get(j2)).getPhases()[0].getNumberOfComponents()) {
                                double kronDelt;
                                double d3 = kronDelt = i6 == k2 ? 1.0 : 0.0;
                                if (this.system.getPhase(0).getComponent(i6).getz() > 1.0E-100) {
                                    df.set(i6, k2, kronDelt + Math.sqrt(Wi[j2][k2] * Wi[j2][i6]) * ((SystemInterface)clonedSystem.get(j2)).getPhases()[1].getComponents()[i6].getdfugdn(k2));
                                } else {
                                    df.set(i6, k2, 0.0);
                                }
                                ++k2;
                            }
                            ++i6;
                        }
                        SimpleMatrix dx = (SimpleMatrix)df.plus(identitytimesConst).solve(f).negative();
                        int i7 = 0;
                        while (i7 < this.system.getPhase(0).getNumberOfComponents()) {
                            double alphaNew = alpha[i7] + dx.get(i7, 0);
                            Wi[j2][i7] = Math.pow(alphaNew / 2.0, 2.0);
                            if (this.system.getPhase(0).getComponent(i7).getz() > 1.0E-100) {
                                logWi[i7] = Math.log(Wi[j2][i7]);
                            }
                            if (this.system.getPhase(0).getComponent(i7).getIonicCharge() != 0.0) {
                                logWi[i7] = -1000.0;
                            }
                            err += Math.abs((logWi[i7] - oldlogw[i7]) / oldlogw[i7]);
                            ++i7;
                        }
                    }
                    sumw[j2] = 0.0;
                    int i8 = 0;
                    while (i8 < this.system.getPhase(0).getNumberOfComponents()) {
                        int n = j2;
                        sumw[n] = sumw[n] + Math.exp(logWi[i8]);
                        ++i8;
                    }
                    i8 = 0;
                    while (i8 < this.system.getPhase(0).getNumberOfComponents()) {
                        if (this.system.getPhase(0).getComponent(i8).getx() > 1.0E-100) {
                            ((SystemInterface)clonedSystem.get(j2)).getPhase(1).getComponents()[i8].setx(Math.exp(logWi[i8]) / sumw[j2]);
                        }
                        if (this.system.getPhase(0).getComponent(i8).getIonicCharge() != 0.0) {
                            ((SystemInterface)clonedSystem.get(j2)).getPhase(1).getComponents()[i8].setx(1.0E-50);
                        }
                        ++i8;
                    }
                } while ((Math.abs(err) > 1.0E-9 || err > errOld) && iter < 200);
                double xTrivialCheck0 = 0.0;
                double xTrivialCheck1 = 0.0;
                this.tm[j2] = 1.0;
                int i9 = 0;
                while (i9 < this.system.getPhase(1).getNumberOfComponents()) {
                    if (this.system.getPhase(0).getComponent(i9).getx() > 1.0E-100) {
                        int n = j2;
                        this.tm[n] = this.tm[n] - Math.exp(logWi[i9]);
                    }
                    x[j2][i9] = ((SystemInterface)clonedSystem.get(j2)).getPhase(1).getComponents()[i9].getx();
                    xTrivialCheck0 += Math.abs(x[j2][i9] - this.system.getPhase(0).getComponent(i9).getx());
                    xTrivialCheck1 += Math.abs(x[j2][i9] - this.system.getPhase(1).getComponent(i9).getx());
                    ++i9;
                }
                if (iter >= 199) {
                    logger.info("iter > maxiter multiphase stability ");
                    logger.info("error " + Math.abs(err));
                    logger.info("tm: " + this.tm[j2]);
                }
                if (Math.abs(xTrivialCheck0) < 1.0E-6 || Math.abs(xTrivialCheck1) < 1.0E-6) {
                    this.tm[j2] = 10.0;
                }
                if (this.tm[j2] < -1.0E-8) break;
            }
            --j2;
        }
        int unstabcomp = 0;
        int k3 = this.system.getPhase(0).getNumberOfComponents() - 1;
        while (k3 >= 0) {
            if (this.tm[k3] < -1.0E-8 && !Double.isNaN(this.tm[k3])) {
                this.system.addPhase();
                unstabcomp = k3;
                int i10 = 0;
                while (i10 < this.system.getPhase(1).getNumberOfComponents()) {
                    this.system.getPhase(this.system.getNumberOfPhases() - 1).getComponents()[i10].setx(x[k3][i10]);
                    ++i10;
                }
                this.system.getPhases()[this.system.getNumberOfPhases() - 1].normalize();
                this.multiPhaseTest = true;
                this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhase(0).getComponent(unstabcomp).getz());
                this.system.init(1);
                this.system.normalizeBeta();
                return;
            }
            --k3;
        }
        this.system.normalizeBeta();
    }

    @Override
    public void run() {
        int aqueousPhaseNumber = 0;
        if (this.doStabilityAnalysis) {
            this.stabilityAnalysis();
        }
        this.doStabilityAnalysis = true;
        aqueousPhaseNumber = this.system.getPhaseNumberOfPhase("aqueous");
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(this.system.getPhaseNumberOfPhase("aqueous"), 0);
            this.system.getChemicalReactionOperations().solveChemEq(this.system.getPhaseNumberOfPhase("aqueous"), 1);
        }
        int iterations = 0;
        if (this.multiPhaseTest) {
            double diff = 1.0E10;
            double oldDiff = 1.0E10;
            double chemdev = 0.0;
            int iterOut = 0;
            do {
                ++iterOut;
                if (this.system.isChemicalSystem()) {
                    if (this.system.getPhaseNumberOfPhase("aqueous") != aqueousPhaseNumber) {
                        aqueousPhaseNumber = this.system.getPhaseNumberOfPhase("aqueous");
                        this.system.getChemicalReactionOperations().solveChemEq(this.system.getPhaseNumberOfPhase("aqueous"), 0);
                    }
                    int phase = this.system.getPhaseNumberOfPhase("aqueous");
                    while (phase < this.system.getPhaseNumberOfPhase("aqueous") + 1) {
                        chemdev = 0.0;
                        double[] xchem = new double[this.system.getPhase(phase).getNumberOfComponents()];
                        this.i = 0;
                        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                            xchem[this.i] = this.system.getPhase(phase).getComponents()[this.i].getx();
                            ++this.i;
                        }
                        this.system.init(1);
                        this.system.getChemicalReactionOperations().solveChemEq(this.system.getPhaseNumberOfPhase("aqueous"), 1);
                        this.i = 0;
                        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                            chemdev += Math.abs(xchem[this.i] - this.system.getPhase(phase).getComponents()[this.i].getx());
                            ++this.i;
                        }
                        ++phase;
                    }
                }
                this.setDoubleArrays();
                iterations = 0;
                do {
                    oldDiff = diff;
                } while ((diff = this.solveBeta()) > 1.0E-12 && !this.removePhase && (diff < oldDiff || ++iterations < 50) && iterations < 200);
                if (iterations < 199) continue;
                logger.error("error in multiphase flash..did not solve in 200 iterations");
                diff = this.solveBeta();
            } while (Math.abs(chemdev) > 1.0E-10 && iterOut < 100 || iterOut < 3 && this.system.isChemicalSystem());
            boolean hasRemovedPhase = false;
            int i = 0;
            while (i < this.system.getNumberOfPhases()) {
                if (this.system.getBeta(i) < 1.1000000000000002E-12) {
                    this.system.removePhaseKeepTotalComposition(i);
                    this.doStabilityAnalysis = false;
                    hasRemovedPhase = true;
                }
                ++i;
            }
            boolean trivialSolution = false;
            int i2 = 0;
            while (i2 < this.system.getNumberOfPhases() - 1) {
                int j = 0;
                while (j < this.system.getPhase(i2).getNumberOfComponents()) {
                    if (Math.abs(this.system.getPhase(i2).getDensity() - this.system.getPhase(i2 + 1).getDensity()) < 1.1E-5) {
                        trivialSolution = true;
                    }
                    ++j;
                }
                ++i2;
            }
            if (trivialSolution && !hasRemovedPhase) {
                i2 = 0;
                while (i2 < this.system.getNumberOfPhases() - 1) {
                    if (Math.abs(this.system.getPhase(i2).getDensity() - this.system.getPhase(i2 + 1).getDensity()) < 1.1E-5) {
                        this.system.removePhaseKeepTotalComposition(i2 + 1);
                        this.doStabilityAnalysis = false;
                        hasRemovedPhase = true;
                    }
                    ++i2;
                }
            }
            if (hasRemovedPhase && !this.secondTime) {
                this.secondTime = true;
                this.run();
            }
        }
    }
}

