/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.Flash;
import org.jfree.chart.JFreeChart;

public class PHflashSingleComp
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Hspec = 0.0;

    public PHflashSingleComp() {
    }

    public PHflashSingleComp(SystemInterface system, double Hspec, int type) {
        this.system = system;
        this.Hspec = Hspec;
    }

    @Override
    public void run() {
        double initTemp;
        ThermodynamicOperations bubOps;
        block6: {
            bubOps = new ThermodynamicOperations(this.system);
            initTemp = this.system.getTemperature();
            if (this.system.getPressure() < this.system.getPhase(0).getComponent(0).getPC()) {
                try {
                    bubOps.TPflash();
                    if (this.system.getPhase(0).getPhaseTypeName().equals("gas")) {
                        bubOps.dewPointTemperatureFlash();
                        break block6;
                    }
                    bubOps.bubblePointTemperatureFlash();
                }
                catch (Exception e) {
                    this.system.setTemperature(initTemp);
                    logger.error("error", (Throwable)e);
                }
            } else {
                bubOps.PHflash2(this.Hspec, 0);
                return;
            }
        }
        this.system.init(3);
        double gasEnthalpy = this.system.getPhase(0).getEnthalpy() / this.system.getPhase(0).getNumberOfMolesInPhase() * this.system.getTotalNumberOfMoles();
        double liqEnthalpy = this.system.getPhase(1).getEnthalpy() / this.system.getPhase(1).getNumberOfMolesInPhase() * this.system.getTotalNumberOfMoles();
        if (this.Hspec < liqEnthalpy || this.Hspec > gasEnthalpy) {
            this.system.setTemperature(initTemp);
            bubOps.PHflash2(this.Hspec, 0);
            return;
        }
        double beta = (this.Hspec - liqEnthalpy) / (gasEnthalpy - liqEnthalpy);
        this.system.setBeta(beta);
        this.system.init(3);
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

