/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.Flash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ejml.simple.SimpleMatrix;

public class CriticalPointFlash
extends Flash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(CriticalPointFlash.class);
    SimpleMatrix Mmatrix = null;
    SimpleMatrix HeidemannMmatrix = null;
    SimpleMatrix Nmatrix = null;
    SimpleMatrix fmatrix = null;
    int numberOfComponents;
    double Vc0;
    double Tc0;

    public CriticalPointFlash(SystemInterface system) {
        this.system = system;
        this.numberOfComponents = system.getPhase(0).getNumberOfComponents();
        this.Mmatrix = new SimpleMatrix(this.numberOfComponents, this.numberOfComponents);
        this.Nmatrix = new SimpleMatrix(this.numberOfComponents, this.numberOfComponents);
        this.HeidemannMmatrix = new SimpleMatrix(this.numberOfComponents, this.numberOfComponents);
        this.fmatrix = new SimpleMatrix(this.numberOfComponents, 1);
    }

    public void calcMmatrixHeidemann() {
        this.Tc0 = this.system.getPhase(0).getPseudoCriticalTemperature();
        this.Vc0 = 4.0 * this.system.getPhase(0).getB() / this.system.getPhase(0).getNumberOfMolesInPhase();
        this.system.setUseTVasIndependentVariables(true);
        this.system.setNumberOfPhases(1);
        this.system.setTemperature(this.Tc0);
        this.system.getPhase(0).setTotalVolume(this.Vc0 * this.system.getTotalNumberOfMoles());
        this.system.init(3);
        double dt = 1.0;
        int iii = 0;
        while (iii < 100) {
            this.system.setTemperature(this.system.getTemperature() + dt);
            this.system.init(3);
            double dij = 0.0;
            double tempJ = 0.0;
            int i = 0;
            while (i < this.numberOfComponents) {
                int j = 0;
                while (j < this.numberOfComponents) {
                    dij = i == j ? 1.0 : 0.0;
                    tempJ = dij / this.system.getPhase(0).getComponent(i).getNumberOfMolesInPhase() - 1.0 / this.system.getPhase(0).getNumberOfMolesInPhase() + (this.system.getPhase(0).getComponent(i).getdfugdn(j) + this.system.getPhase(0).getComponent(i).getdfugdp() * this.system.getPhase(0).getComponent(j).getVoli() * this.system.getPhase(0).getdPdVTn() * -1.0);
                    this.HeidemannMmatrix.set(i, j, tempJ);
                    ++j;
                }
                ++i;
            }
            this.HeidemannMmatrix.print();
            logger.info("Q det " + this.HeidemannMmatrix.determinant() + " temperature " + this.system.getTemperature() + " pressure " + this.system.getPressure());
            ++iii;
        }
    }

    public void calcMmatrix() {
        double dij = 0.0;
        double tempJ = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.numberOfComponents) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij / this.system.getPhase(0).getComponent(i).getNumberOfMolesInPhase() - 1.0 / this.system.getPhase(0).getNumberOfMolesInPhase() + (this.system.getPhase(0).getComponent(i).getdfugdn(j) + this.system.getPhase(0).getComponent(i).getdfugdp() * this.system.getPhase(0).getComponent(j).getVoli() * this.system.getPhase(0).getdPdVTn() * -1.0);
                this.Mmatrix.set(i, j, Math.sqrt(this.system.getPhase(0).getComponent(i).getz() * this.system.getPhase(0).getComponent(j).getz()) * tempJ);
                ++j;
            }
            ++i;
        }
    }

    public double calcdpd() {
        double[] oldz = this.system.getMolarRate();
        this.i = this.Mmatrix.eig().getNumberOfEigenvalues();
        SimpleMatrix eigenVector = (SimpleMatrix)this.Mmatrix.eig().getEigenVector(0);
        double[] newz1 = new double[this.numberOfComponents];
        double[] newz2 = new double[this.numberOfComponents];
        double sperturb = 0.001;
        int ii = 0;
        while (ii < this.numberOfComponents) {
            newz1[ii] = this.system.getPhase(0).getComponent(ii).getz() + sperturb * eigenVector.get(ii) * Math.sqrt(this.system.getPhase(0).getComponent(ii).getz());
            newz2[ii] = this.system.getPhase(0).getComponent(ii).getz() - sperturb * eigenVector.get(ii) * Math.sqrt(this.system.getPhase(0).getComponent(ii).getz());
            ++ii;
        }
        this.system.setMolarComposition(newz1);
        this.system.init(3);
        this.calcMmatrix();
        SimpleMatrix evalMatrix = ((SimpleMatrix)eigenVector.transpose()).mult(this.Mmatrix).mult(eigenVector);
        double perturb1 = evalMatrix.get(0, 0);
        this.system.setMolarComposition(newz2);
        this.system.init(3);
        this.calcMmatrix();
        evalMatrix = ((SimpleMatrix)eigenVector.transpose()).mult(this.Mmatrix).mult(eigenVector);
        double perturb2 = evalMatrix.get(0, 0);
        this.system.setMolarComposition(oldz);
        this.system.init(3);
        double dtpddsss = (perturb1 + perturb2) / (sperturb * sperturb);
        return dtpddsss;
    }

    @Override
    public void run() {
        this.system.init(0);
        this.system.setTotalNumberOfMoles(1.0);
        this.system.init(3);
        this.calcMmatrixHeidemann();
        this.system.setNumberOfPhases(1);
        this.Tc0 = this.system.getPhase(0).getPseudoCriticalTemperature();
        this.Vc0 = 4.0 * this.system.getPhase(0).getB() / this.system.getPhase(0).getNumberOfMolesInPhase();
        this.system.setUseTVasIndependentVariables(true);
        this.system.setNumberOfPhases(1);
        this.system.setTemperature(this.Tc0);
        this.system.getPhase(0).setTotalVolume(this.Vc0 * this.system.getTotalNumberOfMoles());
        this.system.init(3);
        this.system.init(3);
        int k = 0;
        while (k < 13) {
            double dT = 0.1;
            this.calcMmatrix();
            SimpleMatrix eigenVector = (SimpleMatrix)this.Mmatrix.eig().getEigenVector(0);
            SimpleMatrix evalMatrix = ((SimpleMatrix)eigenVector.transpose()).mult(this.Mmatrix).mult(eigenVector);
            double detM = this.Mmatrix.determinant();
            int iter = 0;
            this.system.setTemperature(this.system.getTemperature() + dT);
            do {
                this.system.init(3);
                ++iter;
                double olddetM = detM;
                this.calcMmatrix();
                this.i = this.Mmatrix.eig().getNumberOfEigenvalues();
                eigenVector = (SimpleMatrix)this.Mmatrix.eig().getEigenVector(0);
                evalMatrix = ((SimpleMatrix)eigenVector.transpose()).mult(this.Mmatrix).mult(eigenVector);
                detM = this.Mmatrix.determinant();
                double ddetdT = (detM - olddetM) / dT;
                dT = -detM / ddetdT;
                Math.abs(dT);
                double oldTemp = this.system.getTemperature();
                this.system.setTemperature(oldTemp + dT);
                logger.info("Temperature " + oldTemp + " dT " + dT + " evalMatrix " + evalMatrix.get(0, 0));
            } while (Math.abs(dT) > 1.0E-8 && iter < 112);
            double dVc = this.Vc0 / 100.0;
            this.system.init(3);
            double valstart = this.calcdpd();
            iter = 0;
            this.system.getPhase(0).setTotalVolume(this.system.getPhase(0).getTotalVolume() + dVc);
            double dVOld = 1111110.0;
            do {
                double oldVal = valstart;
                this.system.init(3);
                ++iter;
                valstart = this.calcdpd();
                double ddetdV = (valstart - oldVal) / dVc;
                dVOld = dVc;
                dVc = -valstart / ddetdV;
                this.system.getPhase(0).setTotalVolume(this.system.getPhase(0).getVolume() + 0.5 * dVc);
                logger.info("Volume " + this.system.getPhase(0).getVolume() + " dVc " + dVc + " tddpp " + valstart + " pressure " + this.system.getPressure());
            } while (Math.abs(dVc) > 1.0E-5 && iter < 112 && (Math.abs(dVc) < Math.abs(dVOld) || iter < 3));
            ++k;
        }
        this.system.display();
    }
}

