/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MathiasCopeman
extends LevenbergMarquardtFunction {
    static Logger logger = LogManager.getLogger(MathiasCopeman.class);

    public MathiasCopeman() {
        this.params = new double[3];
    }

    @Override
    public double calcValue(double[] dependentValues) {
        this.system.setTemperature(dependentValues[0]);
        this.system.init(0);
        this.system.init(1);
        try {
            this.thermoOps.bubblePointPressureFlash(false);
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return Math.log(this.system.getPressure());
    }

    @Override
    public double calcTrueValue(double val) {
        return Math.exp(val);
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        this.system.getPhases()[0].getComponents()[0].setMatiascopemanParams(i, value);
        this.system.getPhases()[1].getComponents()[0].setMatiascopemanParams(i, value);
        this.system.getPhases()[0].getComponents()[0].getAttractiveTerm().setParameters(i, value);
        this.system.getPhases()[1].getComponents()[0].getAttractiveTerm().setParameters(i, value);
    }
}

