/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting.IonicInteractionParameterFittingFunctionCo2nacl;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestIonicInteractionParameterFittingCo2nacl {
    static Logger logger = LogManager.getLogger(TestIonicInteractionParameterFittingCo2nacl.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM co2wation WHERE comp3='K+' AND temperature>340 AND pressure<190");
        double[] guess = new double[]{2.67226E-5};
        try {
            int i = 0;
            while (dataSet.next() && i < 403) {
                ++i;
                IonicInteractionParameterFittingFunctionCo2nacl function = new IonicInteractionParameterFittingFunctionCo2nacl();
                double temperature = Double.parseDouble(dataSet.getString("temperature"));
                double pressure = Double.parseDouble(dataSet.getString("pressure"));
                SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(temperature, pressure);
                testSystem.addComponent("CO2", 10.1);
                testSystem.addComponent("water", 1.0, "kg/sec");
                testSystem.addComponent(dataSet.getString("comp3"), Double.parseDouble(dataSet.getString("x3-molal")));
                testSystem.addComponent(dataSet.getString("comp4"), Double.parseDouble(dataSet.getString("x4-molal")));
                testSystem.setPressure(pressure);
                testSystem.setTemperature(temperature);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                double[] sample1 = new double[]{pressure};
                double[] standardDeviation1 = new double[]{0.01};
                double value = Double.parseDouble(dataSet.getString("x1-molfrac"));
                SampleValue sample = new SampleValue(value, value / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setDescription(Double.toString(pressure));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToCdfFile("c:/testFit.nc");
        optim.writeToTextFile("c:/testFit.txt");
    }
}

