/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryWSParameterFittingToSolubilityData;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryWSParameterFittingToSolubilityData_Lucia {
    static Logger logger = LogManager.getLogger(TestBinaryWSParameterFittingToSolubilityData_Lucia.class);

    public static void main(String[] args) {
        double[] parameterGuess;
        SampleValue sample;
        double sdev;
        double val;
        double[] standardDeviation1;
        double[] sample1;
        SystemSrkSchwartzentruberEos testSystem;
        BinaryWSParameterFittingToSolubilityData function;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM LuciaData WHERE Component='methane' AND Temperature<520 AND L2<>NULL AND L2>0.00000001 ORDER BY Temperature,Pressure");
        try {
            int p = 0;
            while (dataSet.next() && p < 100) {
                ++p;
                function = new BinaryWSParameterFittingToSolubilityData();
                testSystem = new SystemSrkSchwartzentruberEos(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                testSystem.addComponent("methane", 10.0);
                testSystem.addComponent("water", 10.0);
                testSystem.setMixingRule(5);
                testSystem.init(0);
                sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                standardDeviation1 = new double[]{0.01};
                val = Double.parseDouble(dataSet.getString("L2"));
                sdev = val / 100.0;
                sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                parameterGuess = new double[]{4802.7795779589, -440.663871123, -7.6109236981, 4.8742002317, 0.1, -0.0420817811};
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        dataSet = database.getResultSet("SELECT * FROM LuciaData WHERE Component='methane' AND ID<3000 AND Temperature<520 AND Y<>NULL AND Y>0.00000001 ORDER BY Temperature,Pressure");
        try {
            int p = 0;
            while (dataSet.next() && p < 100) {
                ++p;
                function = new BinaryWSParameterFittingToSolubilityData(0, 0);
                testSystem = new SystemSrkSchwartzentruberEos(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                testSystem.addComponent("methane", 10.0);
                testSystem.addComponent("water", 10.0);
                testSystem.setMixingRule(5);
                testSystem.init(0);
                sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                standardDeviation1 = new double[]{0.01};
                val = 1.0 - Double.parseDouble(dataSet.getString("Y"));
                sdev = val / 100.0;
                sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                parameterGuess = new double[]{4802.7795779589, -440.663871123, -7.6109236981, 4.8742002317, 0.1, -0.0420817811};
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.displayResult();
    }
}

