/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToSolubilityData;
import neqsim.util.database.NeqSimExperimentDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCPAParameterFittingToSolubilityData {
    static Logger logger = LogManager.getLogger(TestCPAParameterFittingToSolubilityData.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimExperimentDatabase database = new NeqSimExperimentDatabase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM binarySolubilityData WHERE ComponentSolute='CO2' AND ComponentSolvent='water' AND Reference='Houghton1957' AND Reference<>'Nighswander1989' AND Temperature>283.15 AND Temperature<373.15 AND Pressure<60.01325 ORDER BY Temperature");
        double[] parameterGuess = new double[]{-0.27686, 0.001121};
        try {
            int p = 0;
            logger.info("adding....");
            while (dataSet.next() && p < 200) {
                ++p;
                CPAParameterFittingToSolubilityData function = new CPAParameterFittingToSolubilityData(1, 0);
                SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(290.0, 1.0);
                testSystem.addComponent("CO2", 1.0);
                testSystem.addComponent("water", 10.0);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(10);
                testSystem.setMultiPhaseCheck(true);
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.init(0);
                double[] sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{0.13, 0.12};
                double expVal = Double.parseDouble(dataSet.getString("x1"));
                SampleValue sample = new SampleValue(expVal, Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                function.setInitialGuess(parameterGuess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.calcDeviation();
        optim.displayResult();
        optim.displayCurveFit();
    }
}

