/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Statoil.Acids;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Acids {
    static Logger logger = LogManager.getLogger(Acids.class);

    public static void main(String[] args) {
        int AcidNumb = 0;
        int AcnNumb = 0;
        int CO2Numb = 0;
        int WaterNumb = 0;
        int MDEANumb = 0;
        int HCO3Numb = 0;
        int MDEAHpNumb = 0;
        int CO3Numb = 0;
        double MDEAwt = 39.43955905;
        double Acidwt = 2.0;
        double loading = 0.2;
        double temperature = 338.16;
        double PressureCO2 = 1.0;
        loading = 1.0E-5;
        while (loading <= 1.0) {
            PrintStream p;
            Object var82_31;
            Throwable e2;
            int OHNumb;
            double n4 = MDEAwt / 119.16;
            double n3 = Acidwt / 60.05;
            double n2 = (100.0 - MDEAwt - Acidwt) / 18.015;
            double n1 = loading * n4;
            SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(temperature, PressureCO2);
            testSystem.addComponent("CO2", n1);
            testSystem.addComponent("AceticAcid", n3);
            testSystem.addComponent("MDEA", n4);
            testSystem.addComponent("water", n2);
            testSystem.chemicalReactionInit();
            testSystem.createDatabase(true);
            testSystem.setMixingRule(4);
            testSystem.init(0);
            int j = 0;
            do {
                CO2Numb = j++;
            } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("CO2"));
            j = 0;
            do {
                MDEANumb = j++;
            } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA"));
            j = 0;
            do {
                WaterNumb = j++;
            } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("water"));
            j = 0;
            do {
                HCO3Numb = j++;
            } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("HCO3-"));
            j = 0;
            do {
                CO3Numb = j++;
            } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("CO3--"));
            j = 0;
            do {
                OHNumb = j++;
            } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("OH-"));
            j = 0;
            do {
                MDEAHpNumb = j++;
            } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA+"));
            j = 0;
            do {
                AcidNumb = j++;
            } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("AceticAcid"));
            j = 0;
            do {
                AcnNumb = j++;
            } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("Ac-"));
            logger.info("CO2 number " + CO2Numb);
            ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
            try {
                testOps.bubblePointPressureFlash(false);
            }
            catch (Exception e2) {
                logger.error(e2.toString());
            }
            double nCO2 = testSystem.getPhase(1).getComponent(CO2Numb).getx();
            double nMDEA = testSystem.getPhase(1).getComponent(MDEANumb).getx();
            double nHCO3 = testSystem.getPhase(1).getComponent(HCO3Numb).getx();
            double nCO3 = testSystem.getPhase(1).getComponent(CO3Numb).getx();
            double nMDEAp = testSystem.getPhase(1).getComponent(MDEAHpNumb).getx();
            double nOH = testSystem.getPhase(1).getComponent(OHNumb).getx();
            double nHAc = testSystem.getPhase(1).getComponent(AcidNumb).getx();
            double nAcn = testSystem.getPhase(1).getComponent(AcnNumb).getx();
            double aMDEA = testSystem.getPhase(1).getActivityCoefficient(MDEANumb, WaterNumb);
            double awater = testSystem.getPhase(1).getActivityCoefficient(WaterNumb);
            double aCO2 = testSystem.getPhase(1).getActivityCoefficient(CO2Numb, WaterNumb);
            double aMDEAp = testSystem.getPhase(1).getActivityCoefficient(MDEAHpNumb, WaterNumb);
            double aHCO3 = testSystem.getPhase(1).getActivityCoefficient(HCO3Numb, WaterNumb);
            double aOH = testSystem.getPhase(1).getActivityCoefficient(OHNumb, WaterNumb);
            double aCO3 = testSystem.getPhase(1).getActivityCoefficient(CO3Numb, WaterNumb);
            double aHAc = testSystem.getPhase(1).getActivityCoefficient(AcidNumb, WaterNumb);
            double aAcn = testSystem.getPhase(1).getActivityCoefficient(AcnNumb, WaterNumb);
            try {
                e2 = null;
                var82_31 = null;
                try {
                    p = new PrintStream(new FileOutputStream("C:/Documents and Settings/agrawalnj/Desktop/Statoil/Statoil.txt", true));
                    try {
                        p.println(String.valueOf(loading) + " " + testSystem.getPressure() * testSystem.getPhase(0).getComponent(CO2Numb).getx() + " " + nCO2 + " " + nMDEA + " " + nHCO3 + " " + nMDEAp + " " + nCO3 + " " + nOH + " " + nHAc + " " + nAcn);
                    }
                    finally {
                        if (p != null) {
                            p.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                    } else if (e2 != throwable) {
                        e2.addSuppressed(throwable);
                    }
                    throw e2;
                }
            }
            catch (FileNotFoundException e3) {
                logger.error("Could not find file " + e3.getMessage());
            }
            try {
                e2 = null;
                var82_31 = null;
                try {
                    p = new PrintStream(new FileOutputStream("C:/Documents and Settings/agrawalnj/Desktop/Statoil/activity.txt", true));
                    try {
                        p.println(String.valueOf(loading) + " " + awater + " " + aCO2 + " " + aMDEA + " " + aHCO3 + " " + aMDEAp + " " + aCO3 + " " + aOH + " " + aHAc + " " + aAcn);
                    }
                    finally {
                        if (p != null) {
                            p.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                    } else if (e2 != throwable) {
                        e2.addSuppressed(throwable);
                    }
                    throw e2;
                }
            }
            catch (FileNotFoundException e4) {
                logger.error("Could not find file" + e4.getMessage());
            }
            if (loading < 0.1) {
                loading *= 10.0;
                continue;
            }
            loading += 0.1;
        }
        logger.info("Finished");
    }
}

