/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.Density;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.Procede.Density.RackettZ;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestRackettZ {
    static Logger logger = LogManager.getLogger(TestRackettZ.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM PureComponentDensity WHERE ComponentName = 'Water'");
        try {
            logger.info("adding....");
            while (dataSet.next()) {
                RackettZ function = new RackettZ();
                double[] guess = new double[]{0.2356623744};
                function.setInitialGuess(guess);
                double T = Double.parseDouble(dataSet.getString("Temperature"));
                double P = Double.parseDouble(dataSet.getString("Pressure"));
                double density2 = Double.parseDouble(dataSet.getString("Density"));
                SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(T, P);
                testSystem.addComponent("water", 1.0);
                testSystem.createDatabase(true);
                testSystem.useVolumeCorrection(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                testSystem.init(1);
                double[] sample1 = new double[]{T};
                double[] standardDeviation1 = new double[]{T / 100.0};
                SampleValue sample = new SampleValue(density2, density2 / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

