/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CO2Water;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Diamond {
    static Logger logger = LogManager.getLogger(Diamond.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM Diamond");
        try {
            while (dataSet.next()) {
                double ID = Double.parseDouble(dataSet.getString("ID"));
                double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                double pressure = Double.parseDouble(dataSet.getString("Pressure"));
                double x = Double.parseDouble(dataSet.getString("x"));
                SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(temperature, 0.9 * pressure);
                testSystem.addComponent("CO2", x);
                testSystem.addComponent("water", 1.0 - x);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                testSystem.init(1);
                logger.info(ID);
                ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
                try {
                    testOps.bubblePointPressureFlash(false);
                }
                catch (Exception e) {
                    logger.error(e.toString());
                }
                try {
                    Throwable e = null;
                    Object var14_14 = null;
                    try (PrintStream p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/Patrick.txt", true));){
                        p.println(String.valueOf(ID) + " " + x + " " + pressure + " " + testSystem.getPressure());
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                            throw e;
                        }
                        if (e == throwable) throw e;
                        e.addSuppressed(throwable);
                        throw e;
                    }
                }
                catch (FileNotFoundException e) {
                    logger.error("Could not find file");
                    logger.error("Could not read from Patrick.txt" + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        logger.info("Finished");
    }
}

