/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CO2MDEA;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.Procede.CO2MDEA.BinaryHVParameterFittingFunction_N2O;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVParameterFittingToEquilibriumData_N2O {
    static Logger logger = LogManager.getLogger(TestBinaryHVParameterFittingToEquilibriumData_N2O.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        double error = 5.0;
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM CO2MDEA WHERE Reference='Jou' OR  Reference = 'Pawlak' OR Reference = 'Versteeg' OR Reference ='Haimour'");
        double[] guess = new double[]{-387.8913684529, -2028.8216959926, 6.185139671, 3.4677644464, -0.2029288678};
        try {
            while (dataSet.next()) {
                BinaryHVParameterFittingFunction_N2O function = new BinaryHVParameterFittingFunction_N2O();
                function.setInitialGuess(guess);
                SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(280.0, 1.0);
                int ID = dataSet.getInt("ID");
                double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                double pressure = Double.parseDouble(dataSet.getString("Pressure"));
                double x1 = Double.parseDouble(dataSet.getString("x1"));
                double x2 = Double.parseDouble(dataSet.getString("x2"));
                double x3 = Double.parseDouble(dataSet.getString("x3"));
                if (ID == 96 || ID == 115 || ID == 124 || ID == 132) continue;
                testSystem.setTemperature(temperature);
                testSystem.setPressure(pressure);
                testSystem.addComponent("CO2", x1);
                testSystem.addComponent("Water", x2);
                testSystem.addComponent("MDEA", x3);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                double[] sample1 = new double[]{x3, temperature};
                double[] standardDeviation1 = new double[]{x3 / 100.0, temperature / 100.0};
                SampleValue sample = new SampleValue(pressure, error * pressure / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(ID));
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

