/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.GERG;

import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class GERG2008 {
    static double RGERG;
    static int NcGERG;
    static int MaxFlds;
    static int MaxMdl;
    static int MaxTrmM;
    static int MaxTrmP;
    static double epsilon;
    static int[][] intcoik;
    static int[][] coik;
    static int[][] doik;
    static int[][] dijk;
    static double Drold;
    static double Trold;
    static double Told;
    static double Trold2;
    static double[] xold;
    static int[][] mNumb;
    static int[] kpol;
    static int[] kexp;
    static int[] kpolij;
    static int[] kexpij;
    static double[] Dc;
    static double[] Tc;
    static double[] MMiGERG;
    static double[] Vc3;
    static double[] Tc2;
    static double[][] noik;
    static double[][] toik;
    static double[][] cijk;
    static double[][] eijk;
    static double[][] gijk;
    static double[][] nijk;
    static double[][] tijk;
    static double[][] btij;
    static double[][] bvij;
    static double[][] gtij;
    static double[][] gvij;
    static double[][] fij;
    static double[][] th0i;
    static double[][] n0i;
    static double[][] taup;
    static double[][] taupijk;
    static double dPdDsave;

    static {
        NcGERG = 21;
        MaxFlds = 21;
        MaxMdl = 10;
        MaxTrmM = 12;
        MaxTrmP = 24;
        epsilon = 1.0E-15;
        intcoik = new int[MaxFlds + 1][MaxTrmP + 1];
        coik = new int[MaxFlds + 1][MaxTrmP + 1];
        doik = new int[MaxFlds + 1][MaxTrmP + 1];
        dijk = new int[MaxMdl + 1][MaxTrmM + 1];
        xold = new double[MaxFlds + 1];
        mNumb = new int[MaxFlds + 1][MaxFlds + 1];
        kpol = new int[MaxFlds + 1];
        kexp = new int[MaxFlds + 1];
        kpolij = new int[MaxMdl + 1];
        kexpij = new int[MaxMdl + 1];
        Dc = new double[MaxFlds + 1];
        Tc = new double[MaxFlds + 1];
        MMiGERG = new double[MaxFlds + 1];
        Vc3 = new double[MaxFlds + 1];
        Tc2 = new double[MaxFlds + 1];
        noik = new double[MaxFlds + 1][MaxTrmP + 1];
        toik = new double[MaxFlds + 1][MaxTrmP + 1];
        cijk = new double[MaxMdl + 1][MaxTrmM + 1];
        eijk = new double[MaxMdl + 1][MaxTrmM + 1];
        gijk = new double[MaxMdl + 1][MaxTrmM + 1];
        nijk = new double[MaxMdl + 1][MaxTrmM + 1];
        tijk = new double[MaxMdl + 1][MaxTrmM + 1];
        btij = new double[MaxFlds + 1][MaxFlds + 1];
        bvij = new double[MaxFlds + 1][MaxFlds + 1];
        gtij = new double[MaxFlds + 1][MaxFlds + 1];
        gvij = new double[MaxFlds + 1][MaxFlds + 1];
        fij = new double[MaxFlds + 1][MaxFlds + 1];
        th0i = new double[MaxFlds + 1][8];
        n0i = new double[MaxFlds + 1][8];
        taup = new double[MaxFlds + 1][MaxTrmP + 1];
        taupijk = new double[MaxFlds + 1][MaxTrmM + 1];
    }

    public static void MolarMassGERG(double[] x, doubleW Mm) {
        Mm.val = 0.0;
        int i = 1;
        while (i <= NcGERG) {
            Mm.val += x[i] * MMiGERG[i];
            ++i;
        }
    }

    public static void PressureGERG(double T, double D, double[] x, doubleW P, doubleW Z) {
        doubleW[][] ar = new doubleW[4][4];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                ar[i][j] = new doubleW(0.0);
                ++j;
            }
            ++i;
        }
        GERG2008.AlpharGERG(0, 0, T, D, x, ar);
        Z.val = 1.0 + ar[0][1].val;
        P.val = D * RGERG * T * Z.val;
        dPdDsave = RGERG * T * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val);
    }

    public static void DensityGERG(int iFlag, double T, double P, double[] x, doubleW D, intW ierr, StringW herr) {
        doubleW Tcx = new doubleW(0.0);
        doubleW Dcx = new doubleW(0.0);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        ierr.val = 0;
        herr.val = "";
        int nFail = 0;
        boolean iFail = false;
        if (P < epsilon) {
            D.val = 0.0;
            return;
        }
        double tolr = 1.0E-7;
        GERG2008.PseudoCriticalPointGERG(x, Tcx, Dcx);
        if (D.val > -epsilon) {
            D.val = P / RGERG / T;
            if (iFlag == 2) {
                D.val = Dcx.val * 3.0;
            }
        } else {
            D.val = Math.abs(D.val);
        }
        double plog = Math.log(P);
        double vlog = -Math.log(D.val);
        int it = 1;
        while (it <= 50) {
            if (vlog < -7.0 || vlog > 100.0 || it == 20 || it == 30 || it == 40 || iFail) {
                iFail = false;
                if (nFail > 2) {
                    ierr.val = 1;
                    herr.val = "Calculation failed to converge in GERG method, ideal gas density returned.";
                    D.val = P / RGERG / T;
                }
                if (++nFail == 1) {
                    D.val = Dcx.val * 3.0;
                } else if (nFail == 2) {
                    D.val = Dcx.val * 2.5;
                } else if (nFail == 3) {
                    D.val = Dcx.val * 2.0;
                }
                vlog = -Math.log(D.val);
            }
            D.val = Math.exp(-vlog);
            GERG2008.PressureGERG(T, D.val, x, P2, Z);
            if (dPdDsave < epsilon || P2.val < epsilon) {
                double vinc = 0.1;
                if (D.val > Dcx.val) {
                    vinc = -0.1;
                }
                if (it > 5) {
                    vinc /= 2.0;
                }
                if (it > 10 && it < 20) {
                    vinc /= 5.0;
                }
                vlog += vinc;
            } else {
                double dpdlv = -D.val * dPdDsave;
                double vdiff = (Math.log(P2.val) - plog) * P2.val / dpdlv;
                vlog += -vdiff;
                if (Math.abs(vdiff) < tolr) {
                    if (dPdDsave < 0.0) {
                        iFail = true;
                    } else {
                        D.val = Math.exp(-vlog);
                        if (iFlag > 0) {
                            GERG2008.PropertiesGERG(T, D.val, x, PP, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa, A);
                            if (PP.val <= 0.0 || dPdD.val <= 0.0 || d2PdTD.val <= 0.0 || Cv.val <= 0.0 || Cp.val <= 0.0 || W.val <= 0.0) {
                                ierr.val = 1;
                                herr.val = "Calculation failed to converge in GERG method, ideal gas density returned.";
                                D.val = P / RGERG / T;
                            }
                            return;
                        }
                        return;
                    }
                }
            }
            ++it;
        }
        ierr.val = 1;
        herr.val = "Calculation failed to converge in GERG method, ideal gas density returned.";
        D.val = P / RGERG / T;
    }

    public static void PropertiesGERG(double T, double D, double[] x, doubleW P, doubleW Z, doubleW dPdD, doubleW d2PdD2, doubleW d2PdTD, doubleW dPdT, doubleW U, doubleW H, doubleW S, doubleW Cv, doubleW Cp, doubleW W, doubleW G, doubleW JT, doubleW Kappa, doubleW A) {
        doubleW[] a0 = new doubleW[3];
        int i = 0;
        while (i < 3) {
            a0[i] = new doubleW(0.0);
            ++i;
        }
        doubleW[][] ar = new doubleW[4][4];
        int i2 = 0;
        while (i2 < 4) {
            int j = 0;
            while (j < 4) {
                ar[i2][j] = new doubleW(0.0);
                ++j;
            }
            ++i2;
        }
        doubleW Mm = new doubleW(0.0);
        GERG2008.MolarMassGERG(x, Mm);
        GERG2008.Alpha0GERG(T, D, x, a0);
        GERG2008.AlpharGERG(1, 0, T, D, x, ar);
        double R = RGERG;
        double RT = R * T;
        Z.val = 1.0 + ar[0][1].val;
        P.val = D * RT * Z.val;
        dPdD.val = RT * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val);
        dPdT.val = D * R * (1.0 + ar[0][1].val - ar[1][1].val);
        d2PdTD.val = R * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val - 2.0 * ar[1][1].val - ar[1][2].val);
        A.val = RT * (a0[0].val + ar[0][0].val);
        G.val = RT * (1.0 + ar[0][1].val + a0[0].val + ar[0][0].val);
        U.val = RT * (a0[1].val + ar[1][0].val);
        H.val = RT * (1.0 + ar[0][1].val + a0[1].val + ar[1][0].val);
        S.val = R * (a0[1].val + ar[1][0].val - a0[0].val - ar[0][0].val);
        Cv.val = -R * (a0[2].val + ar[2][0].val);
        if (D > epsilon) {
            Cp.val = Cv.val + T * (dPdT.val / D) * (dPdT.val / D) / dPdD.val;
            d2PdD2.val = RT * (2.0 * ar[0][1].val + 4.0 * ar[0][2].val + ar[0][3].val) / D;
            JT.val = (T / D * dPdT.val / dPdD.val - 1.0) / Cp.val / D;
        } else {
            Cp.val = Cv.val + R;
            d2PdD2.val = 0.0;
            JT.val = 1.0E20;
        }
        W.val = 1000.0 * Cp.val / Cv.val * dPdD.val / Mm.val;
        if (W.val < 0.0) {
            W.val = 0.0;
        }
        W.val = Math.sqrt(W.val);
        Kappa.val = Math.pow(W.val, 2.0) * Mm.val / (RT * 1000.0 * Z.val);
    }

    static void ReducingParametersGERG(double[] x, doubleW Tr, doubleW Dr) {
        boolean icheck = false;
        int i = 1;
        while (i <= NcGERG) {
            if (Math.abs(x[i] - xold[i]) > 1.0E-7) {
                icheck = true;
            }
            GERG2008.xold[i] = x[i];
            ++i;
        }
        if (!icheck) {
            Dr.val = Drold;
            Tr.val = Trold;
            return;
        }
        Told = 0.0;
        Trold2 = 0.0;
        Dr.val = 0.0;
        double Vr = 0.0;
        Tr.val = 0.0;
        i = 1;
        while (i <= NcGERG) {
            if (x[i] > epsilon) {
                double F = 1.0;
                int j = i;
                while (j <= NcGERG) {
                    if (x[j] > epsilon) {
                        double xij = F * (x[i] * x[j]) * (x[i] + x[j]);
                        Vr += xij * gvij[i][j] / (bvij[i][j] * x[i] + x[j]);
                        Tr.val += xij * gtij[i][j] / (btij[i][j] * x[i] + x[j]);
                        F = 2.0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (Vr > epsilon) {
            Dr.val = 1.0 / Vr;
        }
        Drold = Dr.val;
        Trold = Tr.val;
    }

    static void Alpha0GERG(double T, double D, double[] x, doubleW[] a0) {
        a0[0].val = 0.0;
        a0[1].val = 0.0;
        a0[2].val = 0.0;
        double LogD = D > epsilon ? Math.log(D) : Math.log(epsilon);
        double LogT = Math.log(T);
        int i = 1;
        while (i <= NcGERG) {
            if (x[i] > epsilon) {
                double LogxD = LogD + Math.log(x[i]);
                double SumHyp0 = 0.0;
                double SumHyp1 = 0.0;
                double SumHyp2 = 0.0;
                int j = 4;
                while (j <= 7) {
                    if (th0i[i][j] > epsilon) {
                        double LogHyp;
                        double th0T = th0i[i][j] / T;
                        double ep = Math.exp(th0T);
                        double em = 1.0 / ep;
                        double hsn = (ep - em) / 2.0;
                        double hcn = (ep + em) / 2.0;
                        if (j == 4 || j == 6) {
                            LogHyp = Math.log(Math.abs(hsn));
                            SumHyp0 += n0i[i][j] * LogHyp;
                            SumHyp1 += n0i[i][j] * th0T * hcn / hsn;
                            SumHyp2 += n0i[i][j] * (th0T / hsn) * (th0T / hsn);
                        } else {
                            LogHyp = Math.log(Math.abs(hcn));
                            SumHyp0 -= n0i[i][j] * LogHyp;
                            SumHyp1 -= n0i[i][j] * th0T * hsn / hcn;
                            SumHyp2 += n0i[i][j] * (th0T / hcn) * (th0T / hcn);
                        }
                    }
                    ++j;
                }
                a0[0].val += x[i] * (LogxD + n0i[i][1] + n0i[i][2] / T - n0i[i][3] * LogT + SumHyp0);
                a0[1].val += x[i] * (n0i[i][3] + n0i[i][2] / T + SumHyp1);
                a0[2].val += -x[i] * (n0i[i][3] + SumHyp2);
            }
            ++i;
        }
    }

    static void AlpharGERG(int itau, int idelta, double T, double D, double[] x, doubleW[][] ar) {
        double ex2;
        double ex;
        double ndtt;
        double ndtd;
        double ndt;
        int j;
        doubleW Tr = new doubleW(0.0);
        doubleW Dr = new doubleW(0.0);
        double[] delp = new double[8];
        double[] Expd = new double[8];
        int i = 0;
        while (i <= 3) {
            j = 0;
            while (j <= 3) {
                ar[i][j].val = 0.0;
                ++j;
            }
            ++i;
        }
        GERG2008.ReducingParametersGERG(x, Tr, Dr);
        double del = D / Dr.val;
        double tau = Tr.val / T;
        double lntau = Math.log(tau);
        delp[1] = del;
        Expd[1] = Math.exp(-delp[1]);
        i = 2;
        while (i <= 7) {
            delp[i] = delp[i - 1] * del;
            Expd[i] = Math.exp(-delp[i]);
            ++i;
        }
        if (Math.abs(T - Told) > 1.0E-7 || Math.abs(Tr.val - Trold2) > 1.0E-7) {
            GERG2008.tTermsGERG(lntau, x);
        }
        Told = T;
        Trold2 = Tr.val;
        i = 1;
        while (i <= NcGERG) {
            if (x[i] > epsilon) {
                int k = 1;
                while (k <= kpol[i]) {
                    ndt = x[i] * delp[doik[i][k]] * taup[i][k];
                    ndtd = ndt * (double)doik[i][k];
                    ar[0][1].val += ndtd;
                    ar[0][2].val += ndtd * (double)(doik[i][k] - 1);
                    if (itau > 0) {
                        ndtt = ndt * toik[i][k];
                        ar[0][0].val += ndt;
                        ar[1][0].val += ndtt;
                        ar[2][0].val += ndtt * (toik[i][k] - 1.0);
                        ar[1][1].val += ndtt * (double)doik[i][k];
                        ar[1][2].val += ndtt * (double)doik[i][k] * (double)(doik[i][k] - 1);
                        ar[0][3].val += ndtd * (double)(doik[i][k] - 1) * (double)(doik[i][k] - 2);
                    }
                    ++k;
                }
                k = 1 + kpol[i];
                while (k <= kpol[i] + kexp[i]) {
                    ndt = x[i] * delp[doik[i][k]] * taup[i][k] * Expd[coik[i][k]];
                    ex = (double)coik[i][k] * delp[coik[i][k]];
                    ex2 = (double)doik[i][k] - ex;
                    double ex3 = ex2 * (ex2 - 1.0);
                    ar[0][1].val += ndt * ex2;
                    ar[0][2].val += ndt * (ex3 - (double)coik[i][k] * ex);
                    if (itau > 0) {
                        ndtt = ndt * toik[i][k];
                        ar[0][0].val += ndt;
                        ar[1][0].val += ndtt;
                        ar[2][0].val += ndtt * (toik[i][k] - 1.0);
                        ar[1][1].val += ndtt * ex2;
                        ar[1][2].val += ndtt * (ex3 - (double)coik[i][k] * ex);
                        ar[0][3].val += ndt * (ex3 * (ex2 - 2.0) - ex * (3.0 * ex2 - 3.0 + (double)coik[i][k]) * (double)coik[i][k]);
                    }
                    ++k;
                }
            }
            ++i;
        }
        i = 1;
        while (i <= NcGERG - 1) {
            if (x[i] > epsilon) {
                j = i + 1;
                while (j <= NcGERG) {
                    int mn;
                    if (x[j] > epsilon && (mn = mNumb[i][j]) >= 0) {
                        double xijf = x[i] * x[j] * fij[i][j];
                        int k = 1;
                        while (k <= kpolij[mn]) {
                            ndt = xijf * delp[dijk[mn][k]] * taupijk[mn][k];
                            ndtd = ndt * (double)dijk[mn][k];
                            ar[0][1].val += ndtd;
                            ar[0][2].val += ndtd * (double)(dijk[mn][k] - 1);
                            if (itau > 0) {
                                ndtt = ndt * tijk[mn][k];
                                ar[0][0].val += ndt;
                                ar[1][0].val += ndtt;
                                ar[2][0].val += ndtt * (tijk[mn][k] - 1.0);
                                ar[1][1].val += ndtt * (double)dijk[mn][k];
                                ar[1][2].val += ndtt * (double)dijk[mn][k] * (double)(dijk[mn][k] - 1);
                                ar[0][3].val += ndtd * (double)(dijk[mn][k] - 1) * (double)(dijk[mn][k] - 2);
                            }
                            ++k;
                        }
                        k = 1 + kpolij[mn];
                        while (k <= kpolij[mn] + kexpij[mn]) {
                            double cij0 = cijk[mn][k] * delp[2];
                            double eij0 = eijk[mn][k] * del;
                            ndt = xijf * nijk[mn][k] * delp[dijk[mn][k]] * Math.exp(cij0 + eij0 + gijk[mn][k] + tijk[mn][k] * lntau);
                            ex = (double)dijk[mn][k] + 2.0 * cij0 + eij0;
                            ex2 = ex * ex - (double)dijk[mn][k] + 2.0 * cij0;
                            ar[0][1].val += ndt * ex;
                            ar[0][2].val += ndt * ex2;
                            if (itau > 0) {
                                ndtt = ndt * tijk[mn][k];
                                ar[0][0].val += ndt;
                                ar[1][0].val += ndtt;
                                ar[2][0].val += ndtt * (tijk[mn][k] - 1.0);
                                ar[1][1].val += ndtt * ex;
                                ar[1][2].val += ndtt * ex2;
                                ar[0][3].val += ndt * (ex * (ex2 - 2.0 * ((double)dijk[mn][k] - 2.0 * cij0)) + (double)(2 * dijk[mn][k]));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    static void tTermsGERG(double lntau, double[] x) {
        double[] taup0 = new double[13];
        int i = 5;
        int k = 1;
        while (k <= kpol[i] + kexp[i]) {
            taup0[k] = Math.exp(toik[i][k] * lntau);
            ++k;
        }
        i = 1;
        while (i <= NcGERG) {
            if (x[i] > epsilon) {
                if (i > 4 && i != 15 && i != 18 && i != 20) {
                    k = 1;
                    while (k <= kpol[i] + kexp[i]) {
                        GERG2008.taup[i][k] = noik[i][k] * taup0[k];
                        ++k;
                    }
                } else {
                    k = 1;
                    while (k <= kpol[i] + kexp[i]) {
                        GERG2008.taup[i][k] = noik[i][k] * Math.exp(toik[i][k] * lntau);
                        ++k;
                    }
                }
            }
            ++i;
        }
        i = 1;
        while (i <= NcGERG - 1) {
            if (x[i] > epsilon) {
                int j = i + 1;
                while (j <= NcGERG) {
                    int mn;
                    if (x[j] > epsilon && (mn = mNumb[i][j]) >= 0) {
                        int k2 = 1;
                        while (k2 <= kpolij[mn]) {
                            GERG2008.taupijk[mn][k2] = nijk[mn][k2] * Math.exp(tijk[mn][k2] * lntau);
                            ++k2;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    static void PseudoCriticalPointGERG(double[] x, doubleW Tcx, doubleW Dcx) {
        Tcx.val = 0.0;
        double Vcx = 0.0;
        Dcx.val = 0.0;
        int i = 1;
        while (i <= NcGERG) {
            Tcx.val += x[i] * Tc[i];
            Vcx += x[i] / Dc[i];
            ++i;
        }
        if (Vcx > epsilon) {
            Dcx.val = 1.0 / Vcx;
        }
    }

    /*
     * Opcode count of 13605 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void SetupGERG() {
        int j;
        double[][] bijk = new double[MaxMdl + 1][MaxTrmM + 1];
        RGERG = 8.314472;
        double Rs = 8.31451;
        double Rsr = Rs / RGERG;
        double o13 = 0.3333333333333333;
        int i = 1;
        while (i <= MaxFlds) {
            GERG2008.xold[i] = 0.0;
            ++i;
        }
        Told = 0.0;
        GERG2008.MMiGERG[1] = 16.04246;
        GERG2008.MMiGERG[2] = 28.0134;
        GERG2008.MMiGERG[3] = 44.0095;
        GERG2008.MMiGERG[4] = 30.06904;
        GERG2008.MMiGERG[5] = 44.09562;
        GERG2008.MMiGERG[6] = 58.1222;
        GERG2008.MMiGERG[7] = 58.1222;
        GERG2008.MMiGERG[8] = 72.14878;
        GERG2008.MMiGERG[9] = 72.14878;
        GERG2008.MMiGERG[10] = 86.17536;
        GERG2008.MMiGERG[11] = 100.20194;
        GERG2008.MMiGERG[12] = 114.22852;
        GERG2008.MMiGERG[13] = 128.2551;
        GERG2008.MMiGERG[14] = 142.28168;
        GERG2008.MMiGERG[15] = 2.01588;
        GERG2008.MMiGERG[16] = 31.9988;
        GERG2008.MMiGERG[17] = 28.0101;
        GERG2008.MMiGERG[18] = 18.01528;
        GERG2008.MMiGERG[19] = 34.08088;
        GERG2008.MMiGERG[20] = 4.002602;
        GERG2008.MMiGERG[21] = 39.948;
        i = 1;
        while (i <= MaxFlds) {
            GERG2008.kpol[i] = 6;
            GERG2008.kexp[i] = 6;
            ++i;
        }
        GERG2008.kexp[1] = 18;
        GERG2008.kexp[2] = 18;
        GERG2008.kexp[4] = 18;
        GERG2008.kpol[3] = 4;
        GERG2008.kexp[3] = 18;
        GERG2008.kpol[15] = 5;
        GERG2008.kexp[15] = 9;
        GERG2008.kpol[18] = 7;
        GERG2008.kexp[18] = 9;
        GERG2008.kpol[20] = 4;
        GERG2008.kexp[20] = 8;
        GERG2008.kpolij[1] = 2;
        GERG2008.kexpij[1] = 10;
        GERG2008.kpolij[2] = 5;
        GERG2008.kexpij[2] = 4;
        GERG2008.kpolij[3] = 2;
        GERG2008.kexpij[3] = 7;
        GERG2008.kpolij[4] = 3;
        GERG2008.kexpij[4] = 3;
        GERG2008.kpolij[5] = 2;
        GERG2008.kexpij[5] = 4;
        GERG2008.kpolij[6] = 3;
        GERG2008.kexpij[6] = 3;
        GERG2008.kpolij[7] = 4;
        GERG2008.kexpij[7] = 0;
        GERG2008.kpolij[10] = 10;
        GERG2008.kexpij[10] = 0;
        GERG2008.Dc[1] = 10.139342719;
        GERG2008.Dc[2] = 11.1839;
        GERG2008.Dc[3] = 10.624978698;
        GERG2008.Dc[4] = 6.87085454;
        GERG2008.Dc[5] = 5.000043088;
        GERG2008.Dc[6] = 3.86014294;
        GERG2008.Dc[7] = 3.920016792;
        GERG2008.Dc[8] = 3.271;
        GERG2008.Dc[9] = 3.215577588;
        GERG2008.Dc[10] = 2.705877875;
        GERG2008.Dc[11] = 2.315324434;
        GERG2008.Dc[12] = 2.056404127;
        GERG2008.Dc[13] = 1.81;
        GERG2008.Dc[14] = 1.64;
        GERG2008.Dc[15] = 14.94;
        GERG2008.Dc[16] = 13.63;
        GERG2008.Dc[17] = 10.85;
        GERG2008.Dc[18] = 17.87371609;
        GERG2008.Dc[19] = 10.19;
        GERG2008.Dc[20] = 17.399;
        GERG2008.Dc[21] = 13.407429659;
        GERG2008.Tc[1] = 190.564;
        GERG2008.Tc[2] = 126.192;
        GERG2008.Tc[3] = 304.1282;
        GERG2008.Tc[4] = 305.322;
        GERG2008.Tc[5] = 369.825;
        GERG2008.Tc[6] = 407.817;
        GERG2008.Tc[7] = 425.125;
        GERG2008.Tc[8] = 460.35;
        GERG2008.Tc[9] = 469.7;
        GERG2008.Tc[10] = 507.82;
        GERG2008.Tc[11] = 540.13;
        GERG2008.Tc[12] = 569.32;
        GERG2008.Tc[13] = 594.55;
        GERG2008.Tc[14] = 617.7;
        GERG2008.Tc[15] = 33.19;
        GERG2008.Tc[16] = 154.595;
        GERG2008.Tc[17] = 132.86;
        GERG2008.Tc[18] = 647.096;
        GERG2008.Tc[19] = 373.1;
        GERG2008.Tc[20] = 5.1953;
        GERG2008.Tc[21] = 150.687;
        i = 1;
        while (i <= MaxFlds) {
            GERG2008.Vc3[i] = 1.0 / Math.pow(Dc[i], o13) / 2.0;
            GERG2008.Tc2[i] = Math.sqrt(Tc[i]);
            GERG2008.coik[i][1] = 0;
            GERG2008.doik[i][1] = 1;
            GERG2008.toik[i][1] = 0.25;
            GERG2008.coik[i][2] = 0;
            GERG2008.doik[i][2] = 1;
            GERG2008.toik[i][2] = 1.125;
            GERG2008.coik[i][3] = 0;
            GERG2008.doik[i][3] = 1;
            GERG2008.toik[i][3] = 1.5;
            GERG2008.coik[i][4] = 0;
            GERG2008.doik[i][4] = 2;
            GERG2008.toik[i][4] = 1.375;
            GERG2008.coik[i][5] = 0;
            GERG2008.doik[i][5] = 3;
            GERG2008.toik[i][5] = 0.25;
            GERG2008.coik[i][6] = 0;
            GERG2008.doik[i][6] = 7;
            GERG2008.toik[i][6] = 0.875;
            GERG2008.coik[i][7] = 1;
            GERG2008.doik[i][7] = 2;
            GERG2008.toik[i][7] = 0.625;
            GERG2008.coik[i][8] = 1;
            GERG2008.doik[i][8] = 5;
            GERG2008.toik[i][8] = 1.75;
            GERG2008.coik[i][9] = 2;
            GERG2008.doik[i][9] = 1;
            GERG2008.toik[i][9] = 3.625;
            GERG2008.coik[i][10] = 2;
            GERG2008.doik[i][10] = 4;
            GERG2008.toik[i][10] = 3.625;
            GERG2008.coik[i][11] = 3;
            GERG2008.doik[i][11] = 3;
            GERG2008.toik[i][11] = 14.5;
            GERG2008.coik[i][12] = 3;
            GERG2008.doik[i][12] = 4;
            GERG2008.toik[i][12] = 12.0;
            ++i;
        }
        i = 1;
        while (i <= 4) {
            if (i != 3) {
                GERG2008.coik[i][1] = 0;
                GERG2008.doik[i][1] = 1;
                GERG2008.toik[i][1] = 0.125;
                GERG2008.coik[i][2] = 0;
                GERG2008.doik[i][2] = 1;
                GERG2008.toik[i][2] = 1.125;
                GERG2008.coik[i][3] = 0;
                GERG2008.doik[i][3] = 2;
                GERG2008.toik[i][3] = 0.375;
                GERG2008.coik[i][4] = 0;
                GERG2008.doik[i][4] = 2;
                GERG2008.toik[i][4] = 1.125;
                GERG2008.coik[i][5] = 0;
                GERG2008.doik[i][5] = 4;
                GERG2008.toik[i][5] = 0.625;
                GERG2008.coik[i][6] = 0;
                GERG2008.doik[i][6] = 4;
                GERG2008.toik[i][6] = 1.5;
                GERG2008.coik[i][7] = 1;
                GERG2008.doik[i][7] = 1;
                GERG2008.toik[i][7] = 0.625;
                GERG2008.coik[i][8] = 1;
                GERG2008.doik[i][8] = 1;
                GERG2008.toik[i][8] = 2.625;
                GERG2008.coik[i][9] = 1;
                GERG2008.doik[i][9] = 1;
                GERG2008.toik[i][9] = 2.75;
                GERG2008.coik[i][10] = 1;
                GERG2008.doik[i][10] = 2;
                GERG2008.toik[i][10] = 2.125;
                GERG2008.coik[i][11] = 1;
                GERG2008.doik[i][11] = 3;
                GERG2008.toik[i][11] = 2.0;
                GERG2008.coik[i][12] = 1;
                GERG2008.doik[i][12] = 6;
                GERG2008.toik[i][12] = 1.75;
                GERG2008.coik[i][13] = 2;
                GERG2008.doik[i][13] = 2;
                GERG2008.toik[i][13] = 4.5;
                GERG2008.coik[i][14] = 2;
                GERG2008.doik[i][14] = 3;
                GERG2008.toik[i][14] = 4.75;
                GERG2008.coik[i][15] = 2;
                GERG2008.doik[i][15] = 3;
                GERG2008.toik[i][15] = 5.0;
                GERG2008.coik[i][16] = 2;
                GERG2008.doik[i][16] = 4;
                GERG2008.toik[i][16] = 4.0;
                GERG2008.coik[i][17] = 2;
                GERG2008.doik[i][17] = 4;
                GERG2008.toik[i][17] = 4.5;
                GERG2008.coik[i][18] = 3;
                GERG2008.doik[i][18] = 2;
                GERG2008.toik[i][18] = 7.5;
                GERG2008.coik[i][19] = 3;
                GERG2008.doik[i][19] = 3;
                GERG2008.toik[i][19] = 14.0;
                GERG2008.coik[i][20] = 3;
                GERG2008.doik[i][20] = 4;
                GERG2008.toik[i][20] = 11.5;
                GERG2008.coik[i][21] = 6;
                GERG2008.doik[i][21] = 5;
                GERG2008.toik[i][21] = 26.0;
                GERG2008.coik[i][22] = 6;
                GERG2008.doik[i][22] = 6;
                GERG2008.toik[i][22] = 28.0;
                GERG2008.coik[i][23] = 6;
                GERG2008.doik[i][23] = 6;
                GERG2008.toik[i][23] = 30.0;
                GERG2008.coik[i][24] = 6;
                GERG2008.doik[i][24] = 7;
                GERG2008.toik[i][24] = 16.0;
            }
            ++i;
        }
        GERG2008.noik[1][1] = 0.57335704239162;
        GERG2008.noik[1][2] = -1.676068752373;
        GERG2008.noik[1][3] = 0.23405291834916;
        GERG2008.noik[1][4] = -0.21947376343441;
        GERG2008.noik[1][5] = 0.016369201404128;
        GERG2008.noik[1][6] = 0.01500440638928;
        GERG2008.noik[1][7] = 0.098990489492918;
        GERG2008.noik[1][8] = 0.58382770929055;
        GERG2008.noik[1][9] = -0.7478686756039;
        GERG2008.noik[1][10] = 0.30033302857974;
        GERG2008.noik[1][11] = 0.20985543806568;
        GERG2008.noik[1][12] = -0.018590151133061;
        GERG2008.noik[1][13] = -0.15782558339049;
        GERG2008.noik[1][14] = 0.12716735220791;
        GERG2008.noik[1][15] = -0.032019743894346;
        GERG2008.noik[1][16] = -0.068049729364536;
        GERG2008.noik[1][17] = 0.024291412853736;
        GERG2008.noik[1][18] = 0.0051440451639444;
        GERG2008.noik[1][19] = -0.019084949733532;
        GERG2008.noik[1][20] = 0.0055229677241291;
        GERG2008.noik[1][21] = -0.0044197392976085;
        GERG2008.noik[1][22] = 0.040061416708429;
        GERG2008.noik[1][23] = -0.033752085907575;
        GERG2008.noik[1][24] = -0.0025127658213357;
        GERG2008.noik[2][1] = 0.59889711801201;
        GERG2008.noik[2][2] = -1.6941557480731;
        GERG2008.noik[2][3] = 0.24579736191718;
        GERG2008.noik[2][4] = -0.23722456755175;
        GERG2008.noik[2][5] = 0.017954918715141;
        GERG2008.noik[2][6] = 0.014592875720215;
        GERG2008.noik[2][7] = 0.10008065936206;
        GERG2008.noik[2][8] = 0.73157115385532;
        GERG2008.noik[2][9] = -0.88372272336366;
        GERG2008.noik[2][10] = 0.31887660246708;
        GERG2008.noik[2][11] = 0.20766491728799;
        GERG2008.noik[2][12] = -0.019379315454158;
        GERG2008.noik[2][13] = -0.16936641554983;
        GERG2008.noik[2][14] = 0.13546846041701;
        GERG2008.noik[2][15] = -0.033066712095307;
        GERG2008.noik[2][16] = -0.060690817018557;
        GERG2008.noik[2][17] = 0.012797548292871;
        GERG2008.noik[2][18] = 0.0058743664107299;
        GERG2008.noik[2][19] = -0.018451951971969;
        GERG2008.noik[2][20] = 0.0047226622042472;
        GERG2008.noik[2][21] = -0.0052024079680599;
        GERG2008.noik[2][22] = 0.043563505956635;
        GERG2008.noik[2][23] = -0.036251690750939;
        GERG2008.noik[2][24] = -0.0028974026866543;
        GERG2008.noik[4][1] = 0.63596780450714;
        GERG2008.noik[4][2] = -1.7377981785459;
        GERG2008.noik[4][3] = 0.28914060926272;
        GERG2008.noik[4][4] = -0.33714276845694;
        GERG2008.noik[4][5] = 0.022405964699561;
        GERG2008.noik[4][6] = 0.015715424886913;
        GERG2008.noik[4][7] = 0.11450634253745;
        GERG2008.noik[4][8] = 1.0612049379745;
        GERG2008.noik[4][9] = -1.2855224439423;
        GERG2008.noik[4][10] = 0.39414630777652;
        GERG2008.noik[4][11] = 0.31390924682041;
        GERG2008.noik[4][12] = -0.021592277117247;
        GERG2008.noik[4][13] = -0.21723666564905;
        GERG2008.noik[4][14] = -0.28999574439489;
        GERG2008.noik[4][15] = 0.42321173025732;
        GERG2008.noik[4][16] = 0.04643410025926;
        GERG2008.noik[4][17] = -0.13138398329741;
        GERG2008.noik[4][18] = 0.011492850364368;
        GERG2008.noik[4][19] = -0.033387688429909;
        GERG2008.noik[4][20] = 0.015183171583644;
        GERG2008.noik[4][21] = -0.0047610805647657;
        GERG2008.noik[4][22] = 0.046917166277885;
        GERG2008.noik[4][23] = -0.039401755804649;
        GERG2008.noik[4][24] = -0.0032569956247611;
        GERG2008.noik[5][1] = 1.0403973107358;
        GERG2008.noik[5][2] = -2.8318404081403;
        GERG2008.noik[5][3] = 0.84393809606294;
        GERG2008.noik[5][4] = -0.076559591850023;
        GERG2008.noik[5][5] = 0.09469737305728;
        GERG2008.noik[5][6] = 2.4796475497006E-4;
        GERG2008.noik[5][7] = 0.2774376042287;
        GERG2008.noik[5][8] = -0.043846000648377;
        GERG2008.noik[5][9] = -0.2699106478435;
        GERG2008.noik[5][10] = -0.06931341308986;
        GERG2008.noik[5][11] = -0.029632145981653;
        GERG2008.noik[5][12] = 0.01404012675138;
        GERG2008.noik[6][1] = 1.04293315891;
        GERG2008.noik[6][2] = -2.8184272548892;
        GERG2008.noik[6][3] = 0.8617623239785;
        GERG2008.noik[6][4] = -0.10613619452487;
        GERG2008.noik[6][5] = 0.098615749302134;
        GERG2008.noik[6][6] = 2.3948208682322E-4;
        GERG2008.noik[6][7] = 0.3033000485695;
        GERG2008.noik[6][8] = -0.041598156135099;
        GERG2008.noik[6][9] = -0.29991937470058;
        GERG2008.noik[6][10] = -0.080369342764109;
        GERG2008.noik[6][11] = -0.029761373251151;
        GERG2008.noik[6][12] = 0.01305963030314;
        GERG2008.noik[7][1] = 1.0626277411455;
        GERG2008.noik[7][2] = -2.862095182835;
        GERG2008.noik[7][3] = 0.88738233403777;
        GERG2008.noik[7][4] = -0.12570581155345;
        GERG2008.noik[7][5] = 0.10286308708106;
        GERG2008.noik[7][6] = 2.5358040602654E-4;
        GERG2008.noik[7][7] = 0.32325200233982;
        GERG2008.noik[7][8] = -0.037950761057432;
        GERG2008.noik[7][9] = -0.32534802014452;
        GERG2008.noik[7][10] = -0.079050969051011;
        GERG2008.noik[7][11] = -0.020636720547775;
        GERG2008.noik[7][12] = 0.005705380933475;
        GERG2008.noik[8][1] = 1.0963;
        GERG2008.noik[8][2] = -3.0402;
        GERG2008.noik[8][3] = 1.0317;
        GERG2008.noik[8][4] = -0.1541;
        GERG2008.noik[8][5] = 0.11535;
        GERG2008.noik[8][6] = 2.9809E-4;
        GERG2008.noik[8][7] = 0.39571;
        GERG2008.noik[8][8] = -0.045881;
        GERG2008.noik[8][9] = -0.35804;
        GERG2008.noik[8][10] = -0.10107;
        GERG2008.noik[8][11] = -0.035484;
        GERG2008.noik[8][12] = 0.018156;
        GERG2008.noik[9][1] = 1.0968643098001;
        GERG2008.noik[9][2] = -2.9988888298061;
        GERG2008.noik[9][3] = 0.99516886799212;
        GERG2008.noik[9][4] = -0.16170708558539;
        GERG2008.noik[9][5] = 0.11334460072775;
        GERG2008.noik[9][6] = 2.6760595150748E-4;
        GERG2008.noik[9][7] = 0.40979881986931;
        GERG2008.noik[9][8] = -0.040876423083075;
        GERG2008.noik[9][9] = -0.38169482469447;
        GERG2008.noik[9][10] = -0.10931956843993;
        GERG2008.noik[9][11] = -0.03207322332799;
        GERG2008.noik[9][12] = 0.016877016216975;
        GERG2008.noik[10][1] = 1.0553238013661;
        GERG2008.noik[10][2] = -2.6120615890629;
        GERG2008.noik[10][3] = 0.7661388296726;
        GERG2008.noik[10][4] = -0.29770320622459;
        GERG2008.noik[10][5] = 0.11879907733358;
        GERG2008.noik[10][6] = 2.7922861062617E-4;
        GERG2008.noik[10][7] = 0.46347589844105;
        GERG2008.noik[10][8] = 0.011433196980297;
        GERG2008.noik[10][9] = -0.48256968738131;
        GERG2008.noik[10][10] = -0.093750558924659;
        GERG2008.noik[10][11] = -0.0067273247155994;
        GERG2008.noik[10][12] = -0.0051141583585428;
        GERG2008.noik[11][1] = 1.0543747645262;
        GERG2008.noik[11][2] = -2.6500681506144;
        GERG2008.noik[11][3] = 0.81730047827543;
        GERG2008.noik[11][4] = -0.30451391253428;
        GERG2008.noik[11][5] = 0.122538687108;
        GERG2008.noik[11][6] = 2.7266472743928E-4;
        GERG2008.noik[11][7] = 0.4986582568167;
        GERG2008.noik[11][8] = -7.1432815084176E-4;
        GERG2008.noik[11][9] = -0.5423689552545;
        GERG2008.noik[11][10] = -0.13801821610756;
        GERG2008.noik[11][11] = -0.0061595287380011;
        GERG2008.noik[11][12] = 4.8602510393022E-4;
        GERG2008.noik[12][1] = 1.0722544875633;
        GERG2008.noik[12][2] = -2.4632951172003;
        GERG2008.noik[12][3] = 0.65386674054928;
        GERG2008.noik[12][4] = -0.36324974085628;
        GERG2008.noik[12][5] = 0.12713269626764;
        GERG2008.noik[12][6] = 3.071357277793E-4;
        GERG2008.noik[12][7] = 0.5265685698754;
        GERG2008.noik[12][8] = 0.019362862857653;
        GERG2008.noik[12][9] = -0.58939426849155;
        GERG2008.noik[12][10] = -0.14069963991934;
        GERG2008.noik[12][11] = -0.0078966330500036;
        GERG2008.noik[12][12] = 0.0033036597968109;
        GERG2008.noik[13][1] = 1.1151;
        GERG2008.noik[13][2] = -2.702;
        GERG2008.noik[13][3] = 0.83416;
        GERG2008.noik[13][4] = -0.38828;
        GERG2008.noik[13][5] = 0.1376;
        GERG2008.noik[13][6] = 2.8185E-4;
        GERG2008.noik[13][7] = 0.62037;
        GERG2008.noik[13][8] = 0.015847;
        GERG2008.noik[13][9] = -0.61726;
        GERG2008.noik[13][10] = -0.15043;
        GERG2008.noik[13][11] = -0.012982;
        GERG2008.noik[13][12] = 0.0044325;
        GERG2008.noik[14][1] = 1.0461;
        GERG2008.noik[14][2] = -2.4807;
        GERG2008.noik[14][3] = 0.74372;
        GERG2008.noik[14][4] = -0.52579;
        GERG2008.noik[14][5] = 0.15315;
        GERG2008.noik[14][6] = 3.2865E-4;
        GERG2008.noik[14][7] = 0.84178;
        GERG2008.noik[14][8] = 0.055424;
        GERG2008.noik[14][9] = -0.73555;
        GERG2008.noik[14][10] = -0.18507;
        GERG2008.noik[14][11] = -0.020775;
        GERG2008.noik[14][12] = 0.012335;
        GERG2008.noik[16][1] = 0.88878286369701;
        GERG2008.noik[16][2] = -2.4879433312148;
        GERG2008.noik[16][3] = 0.59750190775886;
        GERG2008.noik[16][4] = 0.0096501817061881;
        GERG2008.noik[16][5] = 0.07197042871277;
        GERG2008.noik[16][6] = 2.2337443000195E-4;
        GERG2008.noik[16][7] = 0.18558686391474;
        GERG2008.noik[16][8] = -0.03812936803576;
        GERG2008.noik[16][9] = -0.15352245383006;
        GERG2008.noik[16][10] = -0.026726814910919;
        GERG2008.noik[16][11] = -0.025675298677127;
        GERG2008.noik[16][12] = 0.0095714302123668;
        GERG2008.noik[17][1] = 0.90554;
        GERG2008.noik[17][2] = -2.4515;
        GERG2008.noik[17][3] = 0.53149;
        GERG2008.noik[17][4] = 0.024173;
        GERG2008.noik[17][5] = 0.072156;
        GERG2008.noik[17][6] = 1.8818E-4;
        GERG2008.noik[17][7] = 0.19405;
        GERG2008.noik[17][8] = -0.043268;
        GERG2008.noik[17][9] = -0.12778;
        GERG2008.noik[17][10] = -0.027896;
        GERG2008.noik[17][11] = -0.034154;
        GERG2008.noik[17][12] = 0.016329;
        GERG2008.noik[19][1] = 0.87641;
        GERG2008.noik[19][2] = -2.0367;
        GERG2008.noik[19][3] = 0.21634;
        GERG2008.noik[19][4] = -0.050199;
        GERG2008.noik[19][5] = 0.066994;
        GERG2008.noik[19][6] = 1.9076E-4;
        GERG2008.noik[19][7] = 0.20227;
        GERG2008.noik[19][8] = -0.0045348;
        GERG2008.noik[19][9] = -0.2223;
        GERG2008.noik[19][10] = -0.034714;
        GERG2008.noik[19][11] = -0.014885;
        GERG2008.noik[19][12] = 0.0074154;
        GERG2008.noik[21][1] = 0.85095714803969;
        GERG2008.noik[21][2] = -2.400322294348;
        GERG2008.noik[21][3] = 0.54127841476466;
        GERG2008.noik[21][4] = 0.016919770692538;
        GERG2008.noik[21][5] = 0.068825965019035;
        GERG2008.noik[21][6] = 2.1428032815338E-4;
        GERG2008.noik[21][7] = 0.17429895321992;
        GERG2008.noik[21][8] = -0.033654495604194;
        GERG2008.noik[21][9] = -0.13526799857691;
        GERG2008.noik[21][10] = -0.016387350791552;
        GERG2008.noik[21][11] = -0.024987666851475;
        GERG2008.noik[21][12] = 0.0088769204815709;
        GERG2008.coik[3][1] = 0;
        GERG2008.doik[3][1] = 1;
        GERG2008.toik[3][1] = 0.0;
        GERG2008.noik[3][1] = 0.52646564804653;
        GERG2008.coik[3][2] = 0;
        GERG2008.doik[3][2] = 1;
        GERG2008.toik[3][2] = 1.25;
        GERG2008.noik[3][2] = -1.4995725042592;
        GERG2008.coik[3][3] = 0;
        GERG2008.doik[3][3] = 2;
        GERG2008.toik[3][3] = 1.625;
        GERG2008.noik[3][3] = 0.27329786733782;
        GERG2008.coik[3][4] = 0;
        GERG2008.doik[3][4] = 3;
        GERG2008.toik[3][4] = 0.375;
        GERG2008.noik[3][4] = 0.12949500022786;
        GERG2008.coik[3][5] = 1;
        GERG2008.doik[3][5] = 3;
        GERG2008.toik[3][5] = 0.375;
        GERG2008.noik[3][5] = 0.15404088341841;
        GERG2008.coik[3][6] = 1;
        GERG2008.doik[3][6] = 3;
        GERG2008.toik[3][6] = 1.375;
        GERG2008.noik[3][6] = -0.58186950946814;
        GERG2008.coik[3][7] = 1;
        GERG2008.doik[3][7] = 4;
        GERG2008.toik[3][7] = 1.125;
        GERG2008.noik[3][7] = -0.18022494838296;
        GERG2008.coik[3][8] = 1;
        GERG2008.doik[3][8] = 5;
        GERG2008.toik[3][8] = 1.375;
        GERG2008.noik[3][8] = -0.095389904072812;
        GERG2008.coik[3][9] = 1;
        GERG2008.doik[3][9] = 6;
        GERG2008.toik[3][9] = 0.125;
        GERG2008.noik[3][9] = -0.0080486819317679;
        GERG2008.coik[3][10] = 1;
        GERG2008.doik[3][10] = 6;
        GERG2008.toik[3][10] = 1.625;
        GERG2008.noik[3][10] = -0.03554775127309;
        GERG2008.coik[3][11] = 2;
        GERG2008.doik[3][11] = 1;
        GERG2008.toik[3][11] = 3.75;
        GERG2008.noik[3][11] = -0.28079014882405;
        GERG2008.coik[3][12] = 2;
        GERG2008.doik[3][12] = 4;
        GERG2008.toik[3][12] = 3.5;
        GERG2008.noik[3][12] = -0.082435890081677;
        GERG2008.coik[3][13] = 3;
        GERG2008.doik[3][13] = 1;
        GERG2008.toik[3][13] = 7.5;
        GERG2008.noik[3][13] = 0.010832427979006;
        GERG2008.coik[3][14] = 3;
        GERG2008.doik[3][14] = 1;
        GERG2008.toik[3][14] = 8.0;
        GERG2008.noik[3][14] = -0.0067073993161097;
        GERG2008.coik[3][15] = 3;
        GERG2008.doik[3][15] = 3;
        GERG2008.toik[3][15] = 6.0;
        GERG2008.noik[3][15] = -0.0046827907600524;
        GERG2008.coik[3][16] = 3;
        GERG2008.doik[3][16] = 3;
        GERG2008.toik[3][16] = 16.0;
        GERG2008.noik[3][16] = -0.028359911832177;
        GERG2008.coik[3][17] = 3;
        GERG2008.doik[3][17] = 4;
        GERG2008.toik[3][17] = 11.0;
        GERG2008.noik[3][17] = 0.019500174744098;
        GERG2008.coik[3][18] = 5;
        GERG2008.doik[3][18] = 5;
        GERG2008.toik[3][18] = 24.0;
        GERG2008.noik[3][18] = -0.21609137507166;
        GERG2008.coik[3][19] = 5;
        GERG2008.doik[3][19] = 5;
        GERG2008.toik[3][19] = 26.0;
        GERG2008.noik[3][19] = 0.43772794926972;
        GERG2008.coik[3][20] = 5;
        GERG2008.doik[3][20] = 5;
        GERG2008.toik[3][20] = 28.0;
        GERG2008.noik[3][20] = -0.22130790113593;
        GERG2008.coik[3][21] = 6;
        GERG2008.doik[3][21] = 5;
        GERG2008.toik[3][21] = 24.0;
        GERG2008.noik[3][21] = 0.015190189957331;
        GERG2008.coik[3][22] = 6;
        GERG2008.doik[3][22] = 5;
        GERG2008.toik[3][22] = 26.0;
        GERG2008.noik[3][22] = -0.0153809489533;
        GERG2008.coik[15][1] = 0;
        GERG2008.doik[15][1] = 1;
        GERG2008.toik[15][1] = 0.5;
        GERG2008.noik[15][1] = 5.3579928451252;
        GERG2008.coik[15][2] = 0;
        GERG2008.doik[15][2] = 1;
        GERG2008.toik[15][2] = 0.625;
        GERG2008.noik[15][2] = -6.2050252530595;
        GERG2008.coik[15][3] = 0;
        GERG2008.doik[15][3] = 2;
        GERG2008.toik[15][3] = 0.375;
        GERG2008.noik[15][3] = 0.13830241327086;
        GERG2008.coik[15][4] = 0;
        GERG2008.doik[15][4] = 2;
        GERG2008.toik[15][4] = 0.625;
        GERG2008.noik[15][4] = -0.071397954896129;
        GERG2008.coik[15][5] = 0;
        GERG2008.doik[15][5] = 4;
        GERG2008.toik[15][5] = 1.125;
        GERG2008.noik[15][5] = 0.015474053959733;
        GERG2008.coik[15][6] = 1;
        GERG2008.doik[15][6] = 1;
        GERG2008.toik[15][6] = 2.625;
        GERG2008.noik[15][6] = -0.14976806405771;
        GERG2008.coik[15][7] = 1;
        GERG2008.doik[15][7] = 5;
        GERG2008.toik[15][7] = 0.0;
        GERG2008.noik[15][7] = -0.026368723988451;
        GERG2008.coik[15][8] = 1;
        GERG2008.doik[15][8] = 5;
        GERG2008.toik[15][8] = 0.25;
        GERG2008.noik[15][8] = 0.056681303156066;
        GERG2008.coik[15][9] = 1;
        GERG2008.doik[15][9] = 5;
        GERG2008.toik[15][9] = 1.375;
        GERG2008.noik[15][9] = -0.060063958030436;
        GERG2008.coik[15][10] = 2;
        GERG2008.doik[15][10] = 1;
        GERG2008.toik[15][10] = 4.0;
        GERG2008.noik[15][10] = -0.45043942027132;
        GERG2008.coik[15][11] = 2;
        GERG2008.doik[15][11] = 1;
        GERG2008.toik[15][11] = 4.25;
        GERG2008.noik[15][11] = 0.424788402445;
        GERG2008.coik[15][12] = 3;
        GERG2008.doik[15][12] = 2;
        GERG2008.toik[15][12] = 5.0;
        GERG2008.noik[15][12] = -0.021997640827139;
        GERG2008.coik[15][13] = 3;
        GERG2008.doik[15][13] = 5;
        GERG2008.toik[15][13] = 8.0;
        GERG2008.noik[15][13] = -0.01049952137453;
        GERG2008.coik[15][14] = 5;
        GERG2008.doik[15][14] = 1;
        GERG2008.toik[15][14] = 8.0;
        GERG2008.noik[15][14] = -0.0028955902866816;
        GERG2008.coik[18][1] = 0;
        GERG2008.doik[18][1] = 1;
        GERG2008.toik[18][1] = 0.5;
        GERG2008.noik[18][1] = 0.82728408749586;
        GERG2008.coik[18][2] = 0;
        GERG2008.doik[18][2] = 1;
        GERG2008.toik[18][2] = 1.25;
        GERG2008.noik[18][2] = -1.8602220416584;
        GERG2008.coik[18][3] = 0;
        GERG2008.doik[18][3] = 1;
        GERG2008.toik[18][3] = 1.875;
        GERG2008.noik[18][3] = -1.1199009613744;
        GERG2008.coik[18][4] = 0;
        GERG2008.doik[18][4] = 2;
        GERG2008.toik[18][4] = 0.125;
        GERG2008.noik[18][4] = 0.15635753976056;
        GERG2008.coik[18][5] = 0;
        GERG2008.doik[18][5] = 2;
        GERG2008.toik[18][5] = 1.5;
        GERG2008.noik[18][5] = 0.87375844859025;
        GERG2008.coik[18][6] = 0;
        GERG2008.doik[18][6] = 3;
        GERG2008.toik[18][6] = 1.0;
        GERG2008.noik[18][6] = -0.36674403715731;
        GERG2008.coik[18][7] = 0;
        GERG2008.doik[18][7] = 4;
        GERG2008.toik[18][7] = 0.75;
        GERG2008.noik[18][7] = 0.053987893432436;
        GERG2008.coik[18][8] = 1;
        GERG2008.doik[18][8] = 1;
        GERG2008.toik[18][8] = 1.5;
        GERG2008.noik[18][8] = 1.0957690214499;
        GERG2008.coik[18][9] = 1;
        GERG2008.doik[18][9] = 5;
        GERG2008.toik[18][9] = 0.625;
        GERG2008.noik[18][9] = 0.053213037828563;
        GERG2008.coik[18][10] = 1;
        GERG2008.doik[18][10] = 5;
        GERG2008.toik[18][10] = 2.625;
        GERG2008.noik[18][10] = 0.013050533930825;
        GERG2008.coik[18][11] = 2;
        GERG2008.doik[18][11] = 1;
        GERG2008.toik[18][11] = 5.0;
        GERG2008.noik[18][11] = -0.41079520434476;
        GERG2008.coik[18][12] = 2;
        GERG2008.doik[18][12] = 2;
        GERG2008.toik[18][12] = 4.0;
        GERG2008.noik[18][12] = 0.1463744334412;
        GERG2008.coik[18][13] = 2;
        GERG2008.doik[18][13] = 4;
        GERG2008.toik[18][13] = 4.5;
        GERG2008.noik[18][13] = -0.055726838623719;
        GERG2008.coik[18][14] = 3;
        GERG2008.doik[18][14] = 4;
        GERG2008.toik[18][14] = 3.0;
        GERG2008.noik[18][14] = -0.0112017741438;
        GERG2008.coik[18][15] = 5;
        GERG2008.doik[18][15] = 1;
        GERG2008.toik[18][15] = 4.0;
        GERG2008.noik[18][15] = -0.0066062758068099;
        GERG2008.coik[18][16] = 5;
        GERG2008.doik[18][16] = 1;
        GERG2008.toik[18][16] = 6.0;
        GERG2008.noik[18][16] = 0.0046918522004538;
        GERG2008.coik[20][1] = 0;
        GERG2008.doik[20][1] = 1;
        GERG2008.toik[20][1] = 0.0;
        GERG2008.noik[20][1] = -0.45579024006737;
        GERG2008.coik[20][2] = 0;
        GERG2008.doik[20][2] = 1;
        GERG2008.toik[20][2] = 0.125;
        GERG2008.noik[20][2] = 1.2516390754925;
        GERG2008.coik[20][3] = 0;
        GERG2008.doik[20][3] = 1;
        GERG2008.toik[20][3] = 0.75;
        GERG2008.noik[20][3] = -1.5438231650621;
        GERG2008.coik[20][4] = 0;
        GERG2008.doik[20][4] = 4;
        GERG2008.toik[20][4] = 1.0;
        GERG2008.noik[20][4] = 0.020467489707221;
        GERG2008.coik[20][5] = 1;
        GERG2008.doik[20][5] = 1;
        GERG2008.toik[20][5] = 0.75;
        GERG2008.noik[20][5] = -0.34476212380781;
        GERG2008.coik[20][6] = 1;
        GERG2008.doik[20][6] = 3;
        GERG2008.toik[20][6] = 2.625;
        GERG2008.noik[20][6] = -0.020858459512787;
        GERG2008.coik[20][7] = 1;
        GERG2008.doik[20][7] = 5;
        GERG2008.toik[20][7] = 0.125;
        GERG2008.noik[20][7] = 0.016227414711778;
        GERG2008.coik[20][8] = 1;
        GERG2008.doik[20][8] = 5;
        GERG2008.toik[20][8] = 1.25;
        GERG2008.noik[20][8] = -0.057471818200892;
        GERG2008.coik[20][9] = 1;
        GERG2008.doik[20][9] = 5;
        GERG2008.toik[20][9] = 2.0;
        GERG2008.noik[20][9] = 0.019462416430715;
        GERG2008.coik[20][10] = 2;
        GERG2008.doik[20][10] = 2;
        GERG2008.toik[20][10] = 1.0;
        GERG2008.noik[20][10] = -0.03329568012302;
        GERG2008.coik[20][11] = 3;
        GERG2008.doik[20][11] = 1;
        GERG2008.toik[20][11] = 4.5;
        GERG2008.noik[20][11] = -0.010863577372367;
        GERG2008.coik[20][12] = 3;
        GERG2008.doik[20][12] = 2;
        GERG2008.toik[20][12] = 5.0;
        GERG2008.noik[20][12] = -0.022173365245954;
        GERG2008.dijk[3][1] = 1;
        GERG2008.tijk[3][1] = 0.0;
        GERG2008.cijk[3][1] = 0.0;
        GERG2008.eijk[3][1] = 0.0;
        bijk[3][1] = 0.0;
        GERG2008.gijk[3][1] = 0.0;
        GERG2008.nijk[3][1] = -0.0098038985517335;
        GERG2008.dijk[3][2] = 4;
        GERG2008.tijk[3][2] = 1.85;
        GERG2008.cijk[3][2] = 0.0;
        GERG2008.eijk[3][2] = 0.0;
        bijk[3][2] = 0.0;
        GERG2008.gijk[3][2] = 0.0;
        GERG2008.nijk[3][2] = 4.2487270143005E-4;
        GERG2008.dijk[3][3] = 1;
        GERG2008.tijk[3][3] = 7.85;
        GERG2008.cijk[3][3] = 1.0;
        GERG2008.eijk[3][3] = 0.5;
        bijk[3][3] = 1.0;
        GERG2008.gijk[3][3] = 0.5;
        GERG2008.nijk[3][3] = -0.034800214576142;
        GERG2008.dijk[3][4] = 2;
        GERG2008.tijk[3][4] = 5.4;
        GERG2008.cijk[3][4] = 1.0;
        GERG2008.eijk[3][4] = 0.5;
        bijk[3][4] = 1.0;
        GERG2008.gijk[3][4] = 0.5;
        GERG2008.nijk[3][4] = -0.13333813013896;
        GERG2008.dijk[3][5] = 2;
        GERG2008.tijk[3][5] = 0.0;
        GERG2008.cijk[3][5] = 0.25;
        GERG2008.eijk[3][5] = 0.5;
        bijk[3][5] = 2.5;
        GERG2008.gijk[3][5] = 0.5;
        GERG2008.nijk[3][5] = -0.011993694974627;
        GERG2008.dijk[3][6] = 2;
        GERG2008.tijk[3][6] = 0.75;
        GERG2008.cijk[3][6] = 0.0;
        GERG2008.eijk[3][6] = 0.5;
        bijk[3][6] = 3.0;
        GERG2008.gijk[3][6] = 0.5;
        GERG2008.nijk[3][6] = 0.069243379775168;
        GERG2008.dijk[3][7] = 2;
        GERG2008.tijk[3][7] = 2.8;
        GERG2008.cijk[3][7] = 0.0;
        GERG2008.eijk[3][7] = 0.5;
        bijk[3][7] = 3.0;
        GERG2008.gijk[3][7] = 0.5;
        GERG2008.nijk[3][7] = -0.31022508148249;
        GERG2008.dijk[3][8] = 2;
        GERG2008.tijk[3][8] = 4.45;
        GERG2008.cijk[3][8] = 0.0;
        GERG2008.eijk[3][8] = 0.5;
        bijk[3][8] = 3.0;
        GERG2008.gijk[3][8] = 0.5;
        GERG2008.nijk[3][8] = 0.24495491753226;
        GERG2008.dijk[3][9] = 3;
        GERG2008.tijk[3][9] = 4.25;
        GERG2008.cijk[3][9] = 0.0;
        GERG2008.eijk[3][9] = 0.5;
        bijk[3][9] = 3.0;
        GERG2008.gijk[3][9] = 0.5;
        GERG2008.nijk[3][9] = 0.22369816716981;
        GERG2008.dijk[4][1] = 1;
        GERG2008.tijk[4][1] = 2.6;
        GERG2008.cijk[4][1] = 0.0;
        GERG2008.eijk[4][1] = 0.0;
        bijk[4][1] = 0.0;
        GERG2008.gijk[4][1] = 0.0;
        GERG2008.nijk[4][1] = -0.10859387354942;
        GERG2008.dijk[4][2] = 2;
        GERG2008.tijk[4][2] = 1.95;
        GERG2008.cijk[4][2] = 0.0;
        GERG2008.eijk[4][2] = 0.0;
        bijk[4][2] = 0.0;
        GERG2008.gijk[4][2] = 0.0;
        GERG2008.nijk[4][2] = 0.080228576727389;
        GERG2008.dijk[4][3] = 3;
        GERG2008.tijk[4][3] = 0.0;
        GERG2008.cijk[4][3] = 0.0;
        GERG2008.eijk[4][3] = 0.0;
        bijk[4][3] = 0.0;
        GERG2008.gijk[4][3] = 0.0;
        GERG2008.nijk[4][3] = -0.0093303985115717;
        GERG2008.dijk[4][4] = 1;
        GERG2008.tijk[4][4] = 3.95;
        GERG2008.cijk[4][4] = 1.0;
        GERG2008.eijk[4][4] = 0.5;
        bijk[4][4] = 1.0;
        GERG2008.gijk[4][4] = 0.5;
        GERG2008.nijk[4][4] = 0.040989274005848;
        GERG2008.dijk[4][5] = 2;
        GERG2008.tijk[4][5] = 7.95;
        GERG2008.cijk[4][5] = 0.5;
        GERG2008.eijk[4][5] = 0.5;
        bijk[4][5] = 2.0;
        GERG2008.gijk[4][5] = 0.5;
        GERG2008.nijk[4][5] = -0.24338019772494;
        GERG2008.dijk[4][6] = 3;
        GERG2008.tijk[4][6] = 8.0;
        GERG2008.cijk[4][6] = 0.0;
        GERG2008.eijk[4][6] = 0.5;
        bijk[4][6] = 3.0;
        GERG2008.gijk[4][6] = 0.5;
        GERG2008.nijk[4][6] = 0.23855347281124;
        GERG2008.dijk[1][1] = 3;
        GERG2008.tijk[1][1] = 0.65;
        GERG2008.cijk[1][1] = 0.0;
        GERG2008.eijk[1][1] = 0.0;
        bijk[1][1] = 0.0;
        GERG2008.gijk[1][1] = 0.0;
        GERG2008.nijk[1][1] = -8.0926050298746E-4;
        GERG2008.dijk[1][2] = 4;
        GERG2008.tijk[1][2] = 1.55;
        GERG2008.cijk[1][2] = 0.0;
        GERG2008.eijk[1][2] = 0.0;
        bijk[1][2] = 0.0;
        GERG2008.gijk[1][2] = 0.0;
        GERG2008.nijk[1][2] = -7.5381925080059E-4;
        GERG2008.dijk[1][3] = 1;
        GERG2008.tijk[1][3] = 3.1;
        GERG2008.cijk[1][3] = 1.0;
        GERG2008.eijk[1][3] = 0.5;
        bijk[1][3] = 1.0;
        GERG2008.gijk[1][3] = 0.5;
        GERG2008.nijk[1][3] = -0.041618768891219;
        GERG2008.dijk[1][4] = 2;
        GERG2008.tijk[1][4] = 5.9;
        GERG2008.cijk[1][4] = 1.0;
        GERG2008.eijk[1][4] = 0.5;
        bijk[1][4] = 1.0;
        GERG2008.gijk[1][4] = 0.5;
        GERG2008.nijk[1][4] = -0.23452173681569;
        GERG2008.dijk[1][5] = 2;
        GERG2008.tijk[1][5] = 7.05;
        GERG2008.cijk[1][5] = 1.0;
        GERG2008.eijk[1][5] = 0.5;
        bijk[1][5] = 1.0;
        GERG2008.gijk[1][5] = 0.5;
        GERG2008.nijk[1][5] = 0.14003840584586;
        GERG2008.dijk[1][6] = 2;
        GERG2008.tijk[1][6] = 3.35;
        GERG2008.cijk[1][6] = 0.875;
        GERG2008.eijk[1][6] = 0.5;
        bijk[1][6] = 1.25;
        GERG2008.gijk[1][6] = 0.5;
        GERG2008.nijk[1][6] = 0.063281744807738;
        GERG2008.dijk[1][7] = 2;
        GERG2008.tijk[1][7] = 1.2;
        GERG2008.cijk[1][7] = 0.75;
        GERG2008.eijk[1][7] = 0.5;
        bijk[1][7] = 1.5;
        GERG2008.gijk[1][7] = 0.5;
        GERG2008.nijk[1][7] = -0.034660425848809;
        GERG2008.dijk[1][8] = 2;
        GERG2008.tijk[1][8] = 5.8;
        GERG2008.cijk[1][8] = 0.5;
        GERG2008.eijk[1][8] = 0.5;
        bijk[1][8] = 2.0;
        GERG2008.gijk[1][8] = 0.5;
        GERG2008.nijk[1][8] = -0.23918747334251;
        GERG2008.dijk[1][9] = 2;
        GERG2008.tijk[1][9] = 2.7;
        GERG2008.cijk[1][9] = 0.0;
        GERG2008.eijk[1][9] = 0.5;
        bijk[1][9] = 3.0;
        GERG2008.gijk[1][9] = 0.5;
        GERG2008.nijk[1][9] = 0.0019855255066891;
        GERG2008.dijk[1][10] = 3;
        GERG2008.tijk[1][10] = 0.45;
        GERG2008.cijk[1][10] = 0.0;
        GERG2008.eijk[1][10] = 0.5;
        bijk[1][10] = 3.0;
        GERG2008.gijk[1][10] = 0.5;
        GERG2008.nijk[1][10] = 6.1777746171555;
        GERG2008.dijk[1][11] = 3;
        GERG2008.tijk[1][11] = 0.55;
        GERG2008.cijk[1][11] = 0.0;
        GERG2008.eijk[1][11] = 0.5;
        bijk[1][11] = 3.0;
        GERG2008.gijk[1][11] = 0.5;
        GERG2008.nijk[1][11] = -6.9575358271105;
        GERG2008.dijk[1][12] = 3;
        GERG2008.tijk[1][12] = 1.95;
        GERG2008.cijk[1][12] = 0.0;
        GERG2008.eijk[1][12] = 0.5;
        bijk[1][12] = 3.0;
        GERG2008.gijk[1][12] = 0.5;
        GERG2008.nijk[1][12] = 1.0630185306388;
        GERG2008.dijk[2][1] = 3;
        GERG2008.tijk[2][1] = 1.85;
        GERG2008.cijk[2][1] = 0.0;
        GERG2008.eijk[2][1] = 0.0;
        bijk[2][1] = 0.0;
        GERG2008.gijk[2][1] = 0.0;
        GERG2008.nijk[2][1] = 0.013746429958576;
        GERG2008.dijk[2][2] = 3;
        GERG2008.tijk[2][2] = 3.95;
        GERG2008.cijk[2][2] = 0.0;
        GERG2008.eijk[2][2] = 0.0;
        bijk[2][2] = 0.0;
        GERG2008.gijk[2][2] = 0.0;
        GERG2008.nijk[2][2] = -0.0074425012129552;
        GERG2008.dijk[2][3] = 4;
        GERG2008.tijk[2][3] = 0.0;
        GERG2008.cijk[2][3] = 0.0;
        GERG2008.eijk[2][3] = 0.0;
        bijk[2][3] = 0.0;
        GERG2008.gijk[2][3] = 0.0;
        GERG2008.nijk[2][3] = -0.0045516600213685;
        GERG2008.dijk[2][4] = 4;
        GERG2008.tijk[2][4] = 1.85;
        GERG2008.cijk[2][4] = 0.0;
        GERG2008.eijk[2][4] = 0.0;
        bijk[2][4] = 0.0;
        GERG2008.gijk[2][4] = 0.0;
        GERG2008.nijk[2][4] = -0.0054546603350237;
        GERG2008.dijk[2][5] = 4;
        GERG2008.tijk[2][5] = 3.85;
        GERG2008.cijk[2][5] = 0.0;
        GERG2008.eijk[2][5] = 0.0;
        bijk[2][5] = 0.0;
        GERG2008.gijk[2][5] = 0.0;
        GERG2008.nijk[2][5] = 0.0023682016824471;
        GERG2008.dijk[2][6] = 1;
        GERG2008.tijk[2][6] = 5.25;
        GERG2008.cijk[2][6] = 0.25;
        GERG2008.eijk[2][6] = 0.5;
        bijk[2][6] = 0.75;
        GERG2008.gijk[2][6] = 0.5;
        GERG2008.nijk[2][6] = 0.18007763721438;
        GERG2008.dijk[2][7] = 1;
        GERG2008.tijk[2][7] = 3.85;
        GERG2008.cijk[2][7] = 0.25;
        GERG2008.eijk[2][7] = 0.5;
        bijk[2][7] = 1.0;
        GERG2008.gijk[2][7] = 0.5;
        GERG2008.nijk[2][7] = -0.44773942932486;
        GERG2008.dijk[2][8] = 1;
        GERG2008.tijk[2][8] = 0.2;
        GERG2008.cijk[2][8] = 0.0;
        GERG2008.eijk[2][8] = 0.5;
        bijk[2][8] = 2.0;
        GERG2008.gijk[2][8] = 0.5;
        GERG2008.nijk[2][8] = 0.0193273748882;
        GERG2008.dijk[2][9] = 2;
        GERG2008.tijk[2][9] = 6.5;
        GERG2008.cijk[2][9] = 0.0;
        GERG2008.eijk[2][9] = 0.5;
        bijk[2][9] = 3.0;
        GERG2008.gijk[2][9] = 0.5;
        GERG2008.nijk[2][9] = -0.30632197804624;
        GERG2008.dijk[5][1] = 2;
        GERG2008.tijk[5][1] = 1.85;
        GERG2008.cijk[5][1] = 0.0;
        GERG2008.eijk[5][1] = 0.0;
        bijk[5][1] = 0.0;
        GERG2008.gijk[5][1] = 0.0;
        GERG2008.nijk[5][1] = 0.28661625028399;
        GERG2008.dijk[5][2] = 3;
        GERG2008.tijk[5][2] = 1.4;
        GERG2008.cijk[5][2] = 0.0;
        GERG2008.eijk[5][2] = 0.0;
        bijk[5][2] = 0.0;
        GERG2008.gijk[5][2] = 0.0;
        GERG2008.nijk[5][2] = -0.10919833861247;
        GERG2008.dijk[5][3] = 1;
        GERG2008.tijk[5][3] = 3.2;
        GERG2008.cijk[5][3] = 0.25;
        GERG2008.eijk[5][3] = 0.5;
        bijk[5][3] = 0.75;
        GERG2008.gijk[5][3] = 0.5;
        GERG2008.nijk[5][3] = -1.137403208227;
        GERG2008.dijk[5][4] = 1;
        GERG2008.tijk[5][4] = 2.5;
        GERG2008.cijk[5][4] = 0.25;
        GERG2008.eijk[5][4] = 0.5;
        bijk[5][4] = 1.0;
        GERG2008.gijk[5][4] = 0.5;
        GERG2008.nijk[5][4] = 0.76580544237358;
        GERG2008.dijk[5][5] = 1;
        GERG2008.tijk[5][5] = 8.0;
        GERG2008.cijk[5][5] = 0.0;
        GERG2008.eijk[5][5] = 0.5;
        bijk[5][5] = 2.0;
        GERG2008.gijk[5][5] = 0.5;
        GERG2008.nijk[5][5] = 0.0042638000926819;
        GERG2008.dijk[5][6] = 2;
        GERG2008.tijk[5][6] = 3.75;
        GERG2008.cijk[5][6] = 0.0;
        GERG2008.eijk[5][6] = 0.5;
        bijk[5][6] = 3.0;
        GERG2008.gijk[5][6] = 0.5;
        GERG2008.nijk[5][6] = 0.17673538204534;
        GERG2008.dijk[6][1] = 2;
        GERG2008.tijk[6][1] = 0.0;
        GERG2008.cijk[6][1] = 0.0;
        GERG2008.eijk[6][1] = 0.0;
        bijk[6][1] = 0.0;
        GERG2008.gijk[6][1] = 0.0;
        GERG2008.nijk[6][1] = -0.47376518126608;
        GERG2008.dijk[6][2] = 2;
        GERG2008.tijk[6][2] = 0.05;
        GERG2008.cijk[6][2] = 0.0;
        GERG2008.eijk[6][2] = 0.0;
        bijk[6][2] = 0.0;
        GERG2008.gijk[6][2] = 0.0;
        GERG2008.nijk[6][2] = 0.48961193461001;
        GERG2008.dijk[6][3] = 3;
        GERG2008.tijk[6][3] = 0.0;
        GERG2008.cijk[6][3] = 0.0;
        GERG2008.eijk[6][3] = 0.0;
        bijk[6][3] = 0.0;
        GERG2008.gijk[6][3] = 0.0;
        GERG2008.nijk[6][3] = -0.0057011062090535;
        GERG2008.dijk[6][4] = 1;
        GERG2008.tijk[6][4] = 3.65;
        GERG2008.cijk[6][4] = 1.0;
        GERG2008.eijk[6][4] = 0.5;
        bijk[6][4] = 1.0;
        GERG2008.gijk[6][4] = 0.5;
        GERG2008.nijk[6][4] = -0.1996682004132;
        GERG2008.dijk[6][5] = 2;
        GERG2008.tijk[6][5] = 4.9;
        GERG2008.cijk[6][5] = 1.0;
        GERG2008.eijk[6][5] = 0.5;
        bijk[6][5] = 1.0;
        GERG2008.gijk[6][5] = 0.5;
        GERG2008.nijk[6][5] = -0.69411103101723;
        GERG2008.dijk[6][6] = 2;
        GERG2008.tijk[6][6] = 4.45;
        GERG2008.cijk[6][6] = 0.875;
        GERG2008.eijk[6][6] = 0.5;
        bijk[6][6] = 1.25;
        GERG2008.gijk[6][6] = 0.5;
        GERG2008.nijk[6][6] = 0.69226192739021;
        GERG2008.dijk[7][1] = 1;
        GERG2008.tijk[7][1] = 2.0;
        GERG2008.cijk[7][1] = 0.0;
        GERG2008.eijk[7][1] = 0.0;
        bijk[7][1] = 0.0;
        GERG2008.gijk[7][1] = 0.0;
        GERG2008.nijk[7][1] = -0.25157134971934;
        GERG2008.dijk[7][2] = 3;
        GERG2008.tijk[7][2] = -1.0;
        GERG2008.cijk[7][2] = 0.0;
        GERG2008.eijk[7][2] = 0.0;
        bijk[7][2] = 0.0;
        GERG2008.gijk[7][2] = 0.0;
        GERG2008.nijk[7][2] = -0.0062203841111983;
        GERG2008.dijk[7][3] = 3;
        GERG2008.tijk[7][3] = 1.75;
        GERG2008.cijk[7][3] = 0.0;
        GERG2008.eijk[7][3] = 0.0;
        bijk[7][3] = 0.0;
        GERG2008.gijk[7][3] = 0.0;
        GERG2008.nijk[7][3] = 0.088850315184396;
        GERG2008.dijk[7][4] = 4;
        GERG2008.tijk[7][4] = 1.4;
        GERG2008.cijk[7][4] = 0.0;
        GERG2008.eijk[7][4] = 0.0;
        bijk[7][4] = 0.0;
        GERG2008.gijk[7][4] = 0.0;
        GERG2008.nijk[7][4] = -0.035592212573239;
        GERG2008.dijk[10][1] = 1;
        GERG2008.tijk[10][1] = 1.0;
        GERG2008.cijk[10][1] = 0.0;
        GERG2008.eijk[10][1] = 0.0;
        bijk[10][1] = 0.0;
        GERG2008.gijk[10][1] = 0.0;
        GERG2008.nijk[10][1] = 2.5574776844118;
        GERG2008.dijk[10][2] = 1;
        GERG2008.tijk[10][2] = 1.55;
        GERG2008.cijk[10][2] = 0.0;
        GERG2008.eijk[10][2] = 0.0;
        bijk[10][2] = 0.0;
        GERG2008.gijk[10][2] = 0.0;
        GERG2008.nijk[10][2] = -7.9846357136353;
        GERG2008.dijk[10][3] = 1;
        GERG2008.tijk[10][3] = 1.7;
        GERG2008.cijk[10][3] = 0.0;
        GERG2008.eijk[10][3] = 0.0;
        bijk[10][3] = 0.0;
        GERG2008.gijk[10][3] = 0.0;
        GERG2008.nijk[10][3] = 4.7859131465806;
        GERG2008.dijk[10][4] = 2;
        GERG2008.tijk[10][4] = 0.25;
        GERG2008.cijk[10][4] = 0.0;
        GERG2008.eijk[10][4] = 0.0;
        bijk[10][4] = 0.0;
        GERG2008.gijk[10][4] = 0.0;
        GERG2008.nijk[10][4] = -0.73265392369587;
        GERG2008.dijk[10][5] = 2;
        GERG2008.tijk[10][5] = 1.35;
        GERG2008.cijk[10][5] = 0.0;
        GERG2008.eijk[10][5] = 0.0;
        bijk[10][5] = 0.0;
        GERG2008.gijk[10][5] = 0.0;
        GERG2008.nijk[10][5] = 1.3805471345312;
        GERG2008.dijk[10][6] = 3;
        GERG2008.tijk[10][6] = 0.0;
        GERG2008.cijk[10][6] = 0.0;
        GERG2008.eijk[10][6] = 0.0;
        bijk[10][6] = 0.0;
        GERG2008.gijk[10][6] = 0.0;
        GERG2008.nijk[10][6] = 0.28349603476365;
        GERG2008.dijk[10][7] = 3;
        GERG2008.tijk[10][7] = 1.25;
        GERG2008.cijk[10][7] = 0.0;
        GERG2008.eijk[10][7] = 0.0;
        bijk[10][7] = 0.0;
        GERG2008.gijk[10][7] = 0.0;
        GERG2008.nijk[10][7] = -0.49087385940425;
        GERG2008.dijk[10][8] = 4;
        GERG2008.tijk[10][8] = 0.0;
        GERG2008.cijk[10][8] = 0.0;
        GERG2008.eijk[10][8] = 0.0;
        bijk[10][8] = 0.0;
        GERG2008.gijk[10][8] = 0.0;
        GERG2008.nijk[10][8] = -0.10291888921447;
        GERG2008.dijk[10][9] = 4;
        GERG2008.tijk[10][9] = 0.7;
        GERG2008.cijk[10][9] = 0.0;
        GERG2008.eijk[10][9] = 0.0;
        bijk[10][9] = 0.0;
        GERG2008.gijk[10][9] = 0.0;
        GERG2008.nijk[10][9] = 0.11836314681968;
        GERG2008.dijk[10][10] = 4;
        GERG2008.tijk[10][10] = 5.4;
        GERG2008.cijk[10][10] = 0.0;
        GERG2008.eijk[10][10] = 0.0;
        bijk[10][10] = 0.0;
        GERG2008.gijk[10][10] = 0.0;
        GERG2008.nijk[10][10] = 5.5527385721943E-5;
        GERG2008.fij[1][2] = 1.0;
        GERG2008.fij[1][3] = 1.0;
        GERG2008.fij[1][4] = 1.0;
        GERG2008.fij[1][5] = 1.0;
        GERG2008.fij[2][3] = 1.0;
        GERG2008.fij[2][4] = 1.0;
        GERG2008.fij[1][15] = 1.0;
        GERG2008.fij[1][6] = 0.771035405688;
        GERG2008.fij[1][7] = 1.0;
        GERG2008.fij[4][5] = 0.13042476515;
        GERG2008.fij[4][6] = 0.260632376098;
        GERG2008.fij[4][7] = 0.281570073085;
        GERG2008.fij[5][6] = -0.0551609771024;
        GERG2008.fij[5][7] = 0.0312572600489;
        GERG2008.fij[6][7] = -0.0551240293009;
        i = 1;
        while (i <= MaxFlds) {
            GERG2008.mNumb[i][i] = -1;
            j = i + 1;
            while (j <= MaxFlds) {
                GERG2008.fij[j][i] = fij[i][j];
                GERG2008.mNumb[i][j] = -1;
                GERG2008.mNumb[j][i] = -1;
                ++j;
            }
            ++i;
        }
        GERG2008.mNumb[1][2] = 3;
        GERG2008.mNumb[1][3] = 4;
        GERG2008.mNumb[1][4] = 1;
        GERG2008.mNumb[1][5] = 2;
        GERG2008.mNumb[1][6] = 10;
        GERG2008.mNumb[1][7] = 10;
        GERG2008.mNumb[1][15] = 7;
        GERG2008.mNumb[2][3] = 5;
        GERG2008.mNumb[2][4] = 6;
        GERG2008.mNumb[4][5] = 10;
        GERG2008.mNumb[4][6] = 10;
        GERG2008.mNumb[4][7] = 10;
        GERG2008.mNumb[5][6] = 10;
        GERG2008.mNumb[5][7] = 10;
        GERG2008.mNumb[6][7] = 10;
        GERG2008.n0i[1][3] = 4.00088;
        GERG2008.n0i[1][4] = 0.76315;
        GERG2008.n0i[1][5] = 0.0046;
        GERG2008.n0i[1][6] = 8.74432;
        GERG2008.n0i[1][7] = -4.46921;
        GERG2008.n0i[1][1] = 29.83843397;
        GERG2008.n0i[1][2] = -15999.69151;
        GERG2008.n0i[2][3] = 3.50031;
        GERG2008.n0i[2][4] = 0.13732;
        GERG2008.n0i[2][5] = -0.1466;
        GERG2008.n0i[2][6] = 0.90066;
        GERG2008.n0i[2][7] = 0.0;
        GERG2008.n0i[2][1] = 17.56770785;
        GERG2008.n0i[2][2] = -2801.729072;
        GERG2008.n0i[3][3] = 3.50002;
        GERG2008.n0i[3][4] = 2.04452;
        GERG2008.n0i[3][5] = -1.06044;
        GERG2008.n0i[3][6] = 2.03366;
        GERG2008.n0i[3][7] = 0.01393;
        GERG2008.n0i[3][1] = 20.65844696;
        GERG2008.n0i[3][2] = -4902.171516;
        GERG2008.n0i[4][3] = 4.00263;
        GERG2008.n0i[4][4] = 4.33939;
        GERG2008.n0i[4][5] = 1.23722;
        GERG2008.n0i[4][6] = 13.1974;
        GERG2008.n0i[4][7] = -6.01989;
        GERG2008.n0i[4][1] = 36.73005938;
        GERG2008.n0i[4][2] = -23639.65301;
        GERG2008.n0i[5][3] = 4.02939;
        GERG2008.n0i[5][4] = 6.60569;
        GERG2008.n0i[5][5] = 3.197;
        GERG2008.n0i[5][6] = 19.1921;
        GERG2008.n0i[5][7] = -8.37267;
        GERG2008.n0i[5][1] = 44.70909619;
        GERG2008.n0i[5][2] = -31236.63551;
        GERG2008.n0i[6][3] = 4.06714;
        GERG2008.n0i[6][4] = 8.97575;
        GERG2008.n0i[6][5] = 5.25156;
        GERG2008.n0i[6][6] = 25.1423;
        GERG2008.n0i[6][7] = 16.1388;
        GERG2008.n0i[6][1] = 34.30180349;
        GERG2008.n0i[6][2] = -38525.50276;
        GERG2008.n0i[7][3] = 4.33944;
        GERG2008.n0i[7][4] = 9.44893;
        GERG2008.n0i[7][5] = 6.89406;
        GERG2008.n0i[7][6] = 24.4618;
        GERG2008.n0i[7][7] = 14.7824;
        GERG2008.n0i[7][1] = 36.53237783;
        GERG2008.n0i[7][2] = -38957.80933;
        GERG2008.n0i[8][3] = 4.0;
        GERG2008.n0i[8][4] = 11.7618;
        GERG2008.n0i[8][5] = 20.1101;
        GERG2008.n0i[8][6] = 33.1688;
        GERG2008.n0i[8][7] = 0.0;
        GERG2008.n0i[8][1] = 43.17218626;
        GERG2008.n0i[8][2] = -51198.30946;
        GERG2008.n0i[9][3] = 4.0;
        GERG2008.n0i[9][4] = 8.95043;
        GERG2008.n0i[9][5] = 21.836;
        GERG2008.n0i[9][6] = 33.4032;
        GERG2008.n0i[9][7] = 0.0;
        GERG2008.n0i[9][1] = 42.67837089;
        GERG2008.n0i[9][2] = -45215.83;
        GERG2008.n0i[10][3] = 4.0;
        GERG2008.n0i[10][4] = 11.6977;
        GERG2008.n0i[10][5] = 26.8142;
        GERG2008.n0i[10][6] = 38.6164;
        GERG2008.n0i[10][7] = 0.0;
        GERG2008.n0i[10][1] = 46.99717188;
        GERG2008.n0i[10][2] = -52746.83318;
        GERG2008.n0i[11][3] = 4.0;
        GERG2008.n0i[11][4] = 13.7266;
        GERG2008.n0i[11][5] = 30.4707;
        GERG2008.n0i[11][6] = 43.5561;
        GERG2008.n0i[11][7] = 0.0;
        GERG2008.n0i[11][1] = 52.07631631;
        GERG2008.n0i[11][2] = -57104.81056;
        GERG2008.n0i[12][3] = 4.0;
        GERG2008.n0i[12][4] = 15.6865;
        GERG2008.n0i[12][5] = 33.8029;
        GERG2008.n0i[12][6] = 48.1731;
        GERG2008.n0i[12][7] = 0.0;
        GERG2008.n0i[12][1] = 57.25830934;
        GERG2008.n0i[12][2] = -60546.76385;
        GERG2008.n0i[13][3] = 4.0;
        GERG2008.n0i[13][4] = 18.0241;
        GERG2008.n0i[13][5] = 38.1235;
        GERG2008.n0i[13][6] = 53.3415;
        GERG2008.n0i[13][7] = 0.0;
        GERG2008.n0i[13][1] = 62.09646901;
        GERG2008.n0i[13][2] = -66600.12837;
        GERG2008.n0i[14][3] = 4.0;
        GERG2008.n0i[14][4] = 21.0069;
        GERG2008.n0i[14][5] = 43.4931;
        GERG2008.n0i[14][6] = 58.3657;
        GERG2008.n0i[14][7] = 0.0;
        GERG2008.n0i[14][1] = 65.93909154;
        GERG2008.n0i[14][2] = -74131.45483;
        GERG2008.n0i[15][3] = 2.47906;
        GERG2008.n0i[15][4] = 0.95806;
        GERG2008.n0i[15][5] = 0.45444;
        GERG2008.n0i[15][6] = 1.56039;
        GERG2008.n0i[15][7] = -1.3756;
        GERG2008.n0i[15][1] = 13.07520288;
        GERG2008.n0i[15][2] = -5836.943696;
        GERG2008.n0i[16][3] = 3.50146;
        GERG2008.n0i[16][4] = 1.07558;
        GERG2008.n0i[16][5] = 1.01334;
        GERG2008.n0i[16][6] = 0.0;
        GERG2008.n0i[16][7] = 0.0;
        GERG2008.n0i[16][1] = 16.8017173;
        GERG2008.n0i[16][2] = -2318.32269;
        GERG2008.n0i[17][3] = 3.50055;
        GERG2008.n0i[17][4] = 1.02865;
        GERG2008.n0i[17][5] = 0.00493;
        GERG2008.n0i[17][6] = 0.0;
        GERG2008.n0i[17][7] = 0.0;
        GERG2008.n0i[17][1] = 17.45786899;
        GERG2008.n0i[17][2] = -2635.244116;
        GERG2008.n0i[18][3] = 4.00392;
        GERG2008.n0i[18][4] = 0.01059;
        GERG2008.n0i[18][5] = 0.98763;
        GERG2008.n0i[18][6] = 3.06904;
        GERG2008.n0i[18][7] = 0.0;
        GERG2008.n0i[18][1] = 21.57882705;
        GERG2008.n0i[18][2] = -7766.733078;
        GERG2008.n0i[19][3] = 4.0;
        GERG2008.n0i[19][4] = 3.11942;
        GERG2008.n0i[19][5] = 1.00243;
        GERG2008.n0i[19][6] = 0.0;
        GERG2008.n0i[19][7] = 0.0;
        GERG2008.n0i[19][1] = 21.5830944;
        GERG2008.n0i[19][2] = -6069.035869;
        GERG2008.n0i[20][3] = 2.5;
        GERG2008.n0i[20][4] = 0.0;
        GERG2008.n0i[20][5] = 0.0;
        GERG2008.n0i[20][6] = 0.0;
        GERG2008.n0i[20][7] = 0.0;
        GERG2008.n0i[20][1] = 10.04639507;
        GERG2008.n0i[20][2] = -745.375;
        GERG2008.n0i[21][3] = 2.5;
        GERG2008.n0i[21][4] = 0.0;
        GERG2008.n0i[21][5] = 0.0;
        GERG2008.n0i[21][6] = 0.0;
        GERG2008.n0i[21][7] = 0.0;
        GERG2008.n0i[21][1] = 10.04639507;
        GERG2008.n0i[21][2] = -745.375;
        GERG2008.th0i[1][4] = 820.659;
        GERG2008.th0i[1][5] = 178.41;
        GERG2008.th0i[1][6] = 1062.82;
        GERG2008.th0i[1][7] = 1090.53;
        GERG2008.th0i[2][4] = 662.738;
        GERG2008.th0i[2][5] = 680.562;
        GERG2008.th0i[2][6] = 1740.06;
        GERG2008.th0i[2][7] = 0.0;
        GERG2008.th0i[3][4] = 919.306;
        GERG2008.th0i[3][5] = 865.07;
        GERG2008.th0i[3][6] = 483.553;
        GERG2008.th0i[3][7] = 341.109;
        GERG2008.th0i[4][4] = 559.314;
        GERG2008.th0i[4][5] = 223.284;
        GERG2008.th0i[4][6] = 1031.38;
        GERG2008.th0i[4][7] = 1071.29;
        GERG2008.th0i[5][4] = 479.856;
        GERG2008.th0i[5][5] = 200.893;
        GERG2008.th0i[5][6] = 955.312;
        GERG2008.th0i[5][7] = 1027.29;
        GERG2008.th0i[6][4] = 438.27;
        GERG2008.th0i[6][5] = 198.018;
        GERG2008.th0i[6][6] = 1905.02;
        GERG2008.th0i[6][7] = 893.765;
        GERG2008.th0i[7][4] = 468.27;
        GERG2008.th0i[7][5] = 183.636;
        GERG2008.th0i[7][6] = 1914.1;
        GERG2008.th0i[7][7] = 903.185;
        GERG2008.th0i[8][4] = 292.503;
        GERG2008.th0i[8][5] = 910.237;
        GERG2008.th0i[8][6] = 1919.37;
        GERG2008.th0i[8][7] = 0.0;
        GERG2008.th0i[9][4] = 178.67;
        GERG2008.th0i[9][5] = 840.538;
        GERG2008.th0i[9][6] = 1774.25;
        GERG2008.th0i[9][7] = 0.0;
        GERG2008.th0i[10][4] = 182.326;
        GERG2008.th0i[10][5] = 859.207;
        GERG2008.th0i[10][6] = 1826.59;
        GERG2008.th0i[10][7] = 0.0;
        GERG2008.th0i[11][4] = 169.789;
        GERG2008.th0i[11][5] = 836.195;
        GERG2008.th0i[11][6] = 1760.46;
        GERG2008.th0i[11][7] = 0.0;
        GERG2008.th0i[12][4] = 158.922;
        GERG2008.th0i[12][5] = 815.064;
        GERG2008.th0i[12][6] = 1693.07;
        GERG2008.th0i[12][7] = 0.0;
        GERG2008.th0i[13][4] = 156.854;
        GERG2008.th0i[13][5] = 814.882;
        GERG2008.th0i[13][6] = 1693.79;
        GERG2008.th0i[13][7] = 0.0;
        GERG2008.th0i[14][4] = 164.947;
        GERG2008.th0i[14][5] = 836.264;
        GERG2008.th0i[14][6] = 1750.24;
        GERG2008.th0i[14][7] = 0.0;
        GERG2008.th0i[15][4] = 228.734;
        GERG2008.th0i[15][5] = 326.843;
        GERG2008.th0i[15][6] = 1651.71;
        GERG2008.th0i[15][7] = 1671.69;
        GERG2008.th0i[16][4] = 2235.71;
        GERG2008.th0i[16][5] = 1116.69;
        GERG2008.th0i[16][6] = 0.0;
        GERG2008.th0i[16][7] = 0.0;
        GERG2008.th0i[17][4] = 1550.45;
        GERG2008.th0i[17][5] = 704.525;
        GERG2008.th0i[17][6] = 0.0;
        GERG2008.th0i[17][7] = 0.0;
        GERG2008.th0i[18][4] = 268.795;
        GERG2008.th0i[18][5] = 1141.41;
        GERG2008.th0i[18][6] = 2507.37;
        GERG2008.th0i[18][7] = 0.0;
        GERG2008.th0i[19][4] = 1833.63;
        GERG2008.th0i[19][5] = 847.181;
        GERG2008.th0i[19][6] = 0.0;
        GERG2008.th0i[19][7] = 0.0;
        GERG2008.th0i[20][4] = 0.0;
        GERG2008.th0i[20][5] = 0.0;
        GERG2008.th0i[20][6] = 0.0;
        GERG2008.th0i[20][7] = 0.0;
        GERG2008.th0i[21][4] = 0.0;
        GERG2008.th0i[21][5] = 0.0;
        GERG2008.th0i[21][6] = 0.0;
        GERG2008.th0i[21][7] = 0.0;
        GERG2008.bvij[1][2] = 0.998721377;
        GERG2008.gvij[1][2] = 1.013950311;
        GERG2008.btij[1][2] = 0.99809883;
        GERG2008.gtij[1][2] = 0.979273013;
        GERG2008.bvij[1][3] = 0.999518072;
        GERG2008.gvij[1][3] = 1.002806594;
        GERG2008.btij[1][3] = 1.02262449;
        GERG2008.gtij[1][3] = 0.975665369;
        GERG2008.bvij[1][4] = 0.997547866;
        GERG2008.gvij[1][4] = 1.006617867;
        GERG2008.btij[1][4] = 0.996336508;
        GERG2008.gtij[1][4] = 1.049707697;
        GERG2008.bvij[1][5] = 1.00482707;
        GERG2008.gvij[1][5] = 1.038470657;
        GERG2008.btij[1][5] = 0.989680305;
        GERG2008.gtij[1][5] = 1.098655531;
        GERG2008.bvij[1][6] = 1.011240388;
        GERG2008.gvij[1][6] = 1.054319053;
        GERG2008.btij[1][6] = 0.980315756;
        GERG2008.gtij[1][6] = 1.161117729;
        GERG2008.bvij[1][7] = 0.979105972;
        GERG2008.gvij[1][7] = 1.045375122;
        GERG2008.btij[1][7] = 0.99417491;
        GERG2008.gtij[1][7] = 1.171607691;
        GERG2008.bvij[1][8] = 1.0;
        GERG2008.gvij[1][8] = 1.343685343;
        GERG2008.btij[1][8] = 1.0;
        GERG2008.gtij[1][8] = 1.188899743;
        GERG2008.bvij[1][9] = 0.94833012;
        GERG2008.gvij[1][9] = 1.124508039;
        GERG2008.btij[1][9] = 0.992127525;
        GERG2008.gtij[1][9] = 1.249173968;
        GERG2008.bvij[1][10] = 0.958015294;
        GERG2008.gvij[1][10] = 1.052643846;
        GERG2008.btij[1][10] = 0.981844797;
        GERG2008.gtij[1][10] = 1.330570181;
        GERG2008.bvij[1][11] = 0.962050831;
        GERG2008.gvij[1][11] = 1.156655935;
        GERG2008.btij[1][11] = 0.977431529;
        GERG2008.gtij[1][11] = 1.379850328;
        GERG2008.bvij[1][12] = 0.994740603;
        GERG2008.gvij[1][12] = 1.116549372;
        GERG2008.btij[1][12] = 0.957473785;
        GERG2008.gtij[1][12] = 1.449245409;
        GERG2008.bvij[1][13] = 1.002852287;
        GERG2008.gvij[1][13] = 1.141895355;
        GERG2008.btij[1][13] = 0.947716769;
        GERG2008.gtij[1][13] = 1.528532478;
        GERG2008.bvij[1][14] = 1.033086292;
        GERG2008.gvij[1][14] = 1.146089637;
        GERG2008.btij[1][14] = 0.937777823;
        GERG2008.gtij[1][14] = 1.568231489;
        GERG2008.bvij[1][15] = 1.0;
        GERG2008.gvij[1][15] = 1.018702573;
        GERG2008.btij[1][15] = 1.0;
        GERG2008.gtij[1][15] = 1.352643115;
        GERG2008.bvij[1][16] = 1.0;
        GERG2008.gvij[1][16] = 1.0;
        GERG2008.btij[1][16] = 1.0;
        GERG2008.gtij[1][16] = 0.95;
        GERG2008.bvij[1][17] = 0.997340772;
        GERG2008.gvij[1][17] = 1.006102927;
        GERG2008.btij[1][17] = 0.987411732;
        GERG2008.gtij[1][17] = 0.987473033;
        GERG2008.bvij[1][18] = 1.012783169;
        GERG2008.gvij[1][18] = 1.585018334;
        GERG2008.btij[1][18] = 1.063333913;
        GERG2008.gtij[1][18] = 0.775810513;
        GERG2008.bvij[1][19] = 1.012599087;
        GERG2008.gvij[1][19] = 1.040161207;
        GERG2008.btij[1][19] = 1.011090031;
        GERG2008.gtij[1][19] = 0.961155729;
        GERG2008.bvij[1][20] = 1.0;
        GERG2008.gvij[1][20] = 0.881405683;
        GERG2008.btij[1][20] = 1.0;
        GERG2008.gtij[1][20] = 3.159776855;
        GERG2008.bvij[1][21] = 1.034630259;
        GERG2008.gvij[1][21] = 1.014678542;
        GERG2008.btij[1][21] = 0.990954281;
        GERG2008.gtij[1][21] = 0.989843388;
        GERG2008.bvij[2][3] = 0.977794634;
        GERG2008.gvij[2][3] = 1.047578256;
        GERG2008.btij[2][3] = 1.005894529;
        GERG2008.gtij[2][3] = 1.107654104;
        GERG2008.bvij[2][4] = 0.978880168;
        GERG2008.gvij[2][4] = 1.042352891;
        GERG2008.btij[2][4] = 1.007671428;
        GERG2008.gtij[2][4] = 1.098650964;
        GERG2008.bvij[2][5] = 0.974424681;
        GERG2008.gvij[2][5] = 1.081025408;
        GERG2008.btij[2][5] = 1.002677329;
        GERG2008.gtij[2][5] = 1.201264026;
        GERG2008.bvij[2][6] = 0.98641583;
        GERG2008.gvij[2][6] = 1.100576129;
        GERG2008.btij[2][6] = 0.99286813;
        GERG2008.gtij[2][6] = 1.284462634;
        GERG2008.bvij[2][7] = 0.99608261;
        GERG2008.gvij[2][7] = 1.146949309;
        GERG2008.btij[2][7] = 0.994515234;
        GERG2008.gtij[2][7] = 1.304886838;
        GERG2008.bvij[2][8] = 1.0;
        GERG2008.gvij[2][8] = 1.154135439;
        GERG2008.btij[2][8] = 1.0;
        GERG2008.gtij[2][8] = 1.38177077;
        GERG2008.bvij[2][9] = 1.0;
        GERG2008.gvij[2][9] = 1.078877166;
        GERG2008.btij[2][9] = 1.0;
        GERG2008.gtij[2][9] = 1.419029041;
        GERG2008.bvij[2][10] = 1.0;
        GERG2008.gvij[2][10] = 1.195952177;
        GERG2008.btij[2][10] = 1.0;
        GERG2008.gtij[2][10] = 1.472607971;
        GERG2008.bvij[2][11] = 1.0;
        GERG2008.gvij[2][11] = 1.40455409;
        GERG2008.btij[2][11] = 1.0;
        GERG2008.gtij[2][11] = 1.520975334;
        GERG2008.bvij[2][12] = 1.0;
        GERG2008.gvij[2][12] = 1.186067025;
        GERG2008.btij[2][12] = 1.0;
        GERG2008.gtij[2][12] = 1.733280051;
        GERG2008.bvij[2][13] = 1.0;
        GERG2008.gvij[2][13] = 1.100405929;
        GERG2008.btij[2][13] = 0.95637945;
        GERG2008.gtij[2][13] = 1.749119996;
        GERG2008.bvij[2][14] = 1.0;
        GERG2008.gvij[2][14] = 1.0;
        GERG2008.btij[2][14] = 0.957934447;
        GERG2008.gtij[2][14] = 1.822157123;
        GERG2008.bvij[2][15] = 0.972532065;
        GERG2008.gvij[2][15] = 0.970115357;
        GERG2008.btij[2][15] = 0.946134337;
        GERG2008.gtij[2][15] = 1.175696583;
        GERG2008.bvij[2][16] = 0.99952177;
        GERG2008.gvij[2][16] = 0.997082328;
        GERG2008.btij[2][16] = 0.997190589;
        GERG2008.gtij[2][16] = 0.995157044;
        GERG2008.bvij[2][17] = 1.0;
        GERG2008.gvij[2][17] = 1.008690943;
        GERG2008.btij[2][17] = 1.0;
        GERG2008.gtij[2][17] = 0.993425388;
        GERG2008.bvij[2][18] = 1.0;
        GERG2008.gvij[2][18] = 1.094749685;
        GERG2008.btij[2][18] = 1.0;
        GERG2008.gtij[2][18] = 0.968808467;
        GERG2008.bvij[2][19] = 0.910394249;
        GERG2008.gvij[2][19] = 1.256844157;
        GERG2008.btij[2][19] = 1.004692366;
        GERG2008.gtij[2][19] = 0.9601742;
        GERG2008.bvij[2][20] = 0.969501055;
        GERG2008.gvij[2][20] = 0.932629867;
        GERG2008.btij[2][20] = 0.692868765;
        GERG2008.gtij[2][20] = 1.47183158;
        GERG2008.bvij[2][21] = 1.004166412;
        GERG2008.gvij[2][21] = 1.002212182;
        GERG2008.btij[2][21] = 0.999069843;
        GERG2008.gtij[2][21] = 0.990034831;
        GERG2008.bvij[3][4] = 1.002525718;
        GERG2008.gvij[3][4] = 1.032876701;
        GERG2008.btij[3][4] = 1.013871147;
        GERG2008.gtij[3][4] = 0.90094953;
        GERG2008.bvij[3][5] = 0.996898004;
        GERG2008.gvij[3][5] = 1.047596298;
        GERG2008.btij[3][5] = 1.033620538;
        GERG2008.gtij[3][5] = 0.908772477;
        GERG2008.bvij[3][6] = 1.076551882;
        GERG2008.gvij[3][6] = 1.081909003;
        GERG2008.btij[3][6] = 1.023339824;
        GERG2008.gtij[3][6] = 0.929982936;
        GERG2008.bvij[3][7] = 1.174760923;
        GERG2008.gvij[3][7] = 1.222437324;
        GERG2008.btij[3][7] = 1.018171004;
        GERG2008.gtij[3][7] = 0.911498231;
        GERG2008.bvij[3][8] = 1.060793104;
        GERG2008.gvij[3][8] = 1.116793198;
        GERG2008.btij[3][8] = 1.019180957;
        GERG2008.gtij[3][8] = 0.961218039;
        GERG2008.bvij[3][9] = 1.024311498;
        GERG2008.gvij[3][9] = 1.068406078;
        GERG2008.btij[3][9] = 1.027000795;
        GERG2008.gtij[3][9] = 0.979217302;
        GERG2008.bvij[3][10] = 1.0;
        GERG2008.gvij[3][10] = 0.851343711;
        GERG2008.btij[3][10] = 1.0;
        GERG2008.gtij[3][10] = 1.038675574;
        GERG2008.bvij[3][11] = 1.205469976;
        GERG2008.gvij[3][11] = 1.164585914;
        GERG2008.btij[3][11] = 1.011806317;
        GERG2008.gtij[3][11] = 1.046169823;
        GERG2008.bvij[3][12] = 1.026169373;
        GERG2008.gvij[3][12] = 1.104043935;
        GERG2008.btij[3][12] = 1.02969078;
        GERG2008.gtij[3][12] = 1.074455386;
        GERG2008.bvij[3][13] = 1.0;
        GERG2008.gvij[3][13] = 0.973386152;
        GERG2008.btij[3][13] = 1.00768862;
        GERG2008.gtij[3][13] = 1.140671202;
        GERG2008.bvij[3][14] = 1.000151132;
        GERG2008.gvij[3][14] = 1.183394668;
        GERG2008.btij[3][14] = 1.02002879;
        GERG2008.gtij[3][14] = 1.145512213;
        GERG2008.bvij[3][15] = 0.904142159;
        GERG2008.gvij[3][15] = 1.15279255;
        GERG2008.btij[3][15] = 0.942320195;
        GERG2008.gtij[3][15] = 1.782924792;
        GERG2008.bvij[3][16] = 1.0;
        GERG2008.gvij[3][16] = 1.0;
        GERG2008.btij[3][16] = 1.0;
        GERG2008.gtij[3][16] = 1.0;
        GERG2008.bvij[3][17] = 1.0;
        GERG2008.gvij[3][17] = 1.0;
        GERG2008.btij[3][17] = 1.0;
        GERG2008.gtij[3][17] = 1.0;
        GERG2008.bvij[3][18] = 0.949055959;
        GERG2008.gvij[3][18] = 1.542328793;
        GERG2008.btij[3][18] = 0.997372205;
        GERG2008.gtij[3][18] = 0.775453996;
        GERG2008.bvij[3][19] = 0.906630564;
        GERG2008.gvij[3][19] = 1.024085837;
        GERG2008.btij[3][19] = 1.016034583;
        GERG2008.gtij[3][19] = 0.92601888;
        GERG2008.bvij[3][20] = 0.846647561;
        GERG2008.gvij[3][20] = 0.864141549;
        GERG2008.btij[3][20] = 0.76837763;
        GERG2008.gtij[3][20] = 3.207456948;
        GERG2008.bvij[3][21] = 1.008392428;
        GERG2008.gvij[3][21] = 1.029205465;
        GERG2008.btij[3][21] = 0.996512863;
        GERG2008.gtij[3][21] = 1.050971635;
        GERG2008.bvij[4][5] = 0.997607277;
        GERG2008.gvij[4][5] = 1.00303472;
        GERG2008.btij[4][5] = 0.996199694;
        GERG2008.gtij[4][5] = 1.01473019;
        GERG2008.bvij[4][6] = 1.0;
        GERG2008.gvij[4][6] = 1.006616886;
        GERG2008.btij[4][6] = 1.0;
        GERG2008.gtij[4][6] = 1.033283811;
        GERG2008.bvij[4][7] = 0.999157205;
        GERG2008.gvij[4][7] = 1.006179146;
        GERG2008.btij[4][7] = 0.999130554;
        GERG2008.gtij[4][7] = 1.034832749;
        GERG2008.bvij[4][8] = 1.0;
        GERG2008.gvij[4][8] = 1.045439935;
        GERG2008.btij[4][8] = 1.0;
        GERG2008.gtij[4][8] = 1.021150247;
        GERG2008.bvij[4][9] = 0.993851009;
        GERG2008.gvij[4][9] = 1.026085655;
        GERG2008.btij[4][9] = 0.998688946;
        GERG2008.gtij[4][9] = 1.066665676;
        GERG2008.bvij[4][10] = 1.0;
        GERG2008.gvij[4][10] = 1.169701102;
        GERG2008.btij[4][10] = 1.0;
        GERG2008.gtij[4][10] = 1.092177796;
        GERG2008.bvij[4][11] = 1.0;
        GERG2008.gvij[4][11] = 1.057666085;
        GERG2008.btij[4][11] = 1.0;
        GERG2008.gtij[4][11] = 1.134532014;
        GERG2008.bvij[4][12] = 1.007469726;
        GERG2008.gvij[4][12] = 1.071917985;
        GERG2008.btij[4][12] = 0.984068272;
        GERG2008.gtij[4][12] = 1.168636194;
        GERG2008.bvij[4][13] = 1.0;
        GERG2008.gvij[4][13] = 1.14353473;
        GERG2008.btij[4][13] = 1.0;
        GERG2008.gtij[4][13] = 1.05603303;
        GERG2008.bvij[4][14] = 0.995676258;
        GERG2008.gvij[4][14] = 1.098361281;
        GERG2008.btij[4][14] = 0.970918061;
        GERG2008.gtij[4][14] = 1.237191558;
        GERG2008.bvij[4][15] = 0.925367171;
        GERG2008.gvij[4][15] = 1.10607204;
        GERG2008.btij[4][15] = 0.932969831;
        GERG2008.gtij[4][15] = 1.902008495;
        GERG2008.bvij[4][16] = 1.0;
        GERG2008.gvij[4][16] = 1.0;
        GERG2008.btij[4][16] = 1.0;
        GERG2008.gtij[4][16] = 1.0;
        GERG2008.bvij[4][17] = 1.0;
        GERG2008.gvij[4][17] = 1.201417898;
        GERG2008.btij[4][17] = 1.0;
        GERG2008.gtij[4][17] = 1.069224728;
        GERG2008.bvij[4][18] = 1.0;
        GERG2008.gvij[4][18] = 1.0;
        GERG2008.btij[4][18] = 1.0;
        GERG2008.gtij[4][18] = 1.0;
        GERG2008.bvij[4][19] = 1.010817909;
        GERG2008.gvij[4][19] = 1.030988277;
        GERG2008.btij[4][19] = 0.990197354;
        GERG2008.gtij[4][19] = 0.90273666;
        GERG2008.bvij[4][20] = 1.0;
        GERG2008.gvij[4][20] = 1.0;
        GERG2008.btij[4][20] = 1.0;
        GERG2008.gtij[4][20] = 1.0;
        GERG2008.bvij[4][21] = 1.0;
        GERG2008.gvij[4][21] = 1.0;
        GERG2008.btij[4][21] = 1.0;
        GERG2008.gtij[4][21] = 1.0;
        GERG2008.bvij[5][6] = 0.999243146;
        GERG2008.gvij[5][6] = 1.001156119;
        GERG2008.btij[5][6] = 0.998012298;
        GERG2008.gtij[5][6] = 1.005250774;
        GERG2008.bvij[5][7] = 0.999795868;
        GERG2008.gvij[5][7] = 1.003264179;
        GERG2008.btij[5][7] = 1.000310289;
        GERG2008.gtij[5][7] = 1.007392782;
        GERG2008.bvij[5][8] = 1.040459289;
        GERG2008.gvij[5][8] = 0.999432118;
        GERG2008.btij[5][8] = 0.994364425;
        GERG2008.gtij[5][8] = 1.0032695;
        GERG2008.bvij[5][9] = 1.044919431;
        GERG2008.gvij[5][9] = 1.019921513;
        GERG2008.btij[5][9] = 0.996484021;
        GERG2008.gtij[5][9] = 1.008344412;
        GERG2008.bvij[5][10] = 1.0;
        GERG2008.gvij[5][10] = 1.057872566;
        GERG2008.btij[5][10] = 1.0;
        GERG2008.gtij[5][10] = 1.025657518;
        GERG2008.bvij[5][11] = 1.0;
        GERG2008.gvij[5][11] = 1.079648053;
        GERG2008.btij[5][11] = 1.0;
        GERG2008.gtij[5][11] = 1.050044169;
        GERG2008.bvij[5][12] = 1.0;
        GERG2008.gvij[5][12] = 1.102764612;
        GERG2008.btij[5][12] = 1.0;
        GERG2008.gtij[5][12] = 1.063694129;
        GERG2008.bvij[5][13] = 1.0;
        GERG2008.gvij[5][13] = 1.199769134;
        GERG2008.btij[5][13] = 1.0;
        GERG2008.gtij[5][13] = 1.109973833;
        GERG2008.bvij[5][14] = 0.984104227;
        GERG2008.gvij[5][14] = 1.053040574;
        GERG2008.btij[5][14] = 0.985331233;
        GERG2008.gtij[5][14] = 1.140905252;
        GERG2008.bvij[5][15] = 1.0;
        GERG2008.gvij[5][15] = 1.07400611;
        GERG2008.btij[5][15] = 1.0;
        GERG2008.gtij[5][15] = 2.308215191;
        GERG2008.bvij[5][16] = 1.0;
        GERG2008.gvij[5][16] = 1.0;
        GERG2008.btij[5][16] = 1.0;
        GERG2008.gtij[5][16] = 1.0;
        GERG2008.bvij[5][17] = 1.0;
        GERG2008.gvij[5][17] = 1.108143673;
        GERG2008.btij[5][17] = 1.0;
        GERG2008.gtij[5][17] = 1.197564208;
        GERG2008.bvij[5][18] = 1.0;
        GERG2008.gvij[5][18] = 1.011759763;
        GERG2008.btij[5][18] = 1.0;
        GERG2008.gtij[5][18] = 0.600340961;
        GERG2008.bvij[5][19] = 0.936811219;
        GERG2008.gvij[5][19] = 1.010593999;
        GERG2008.btij[5][19] = 0.992573556;
        GERG2008.gtij[5][19] = 0.905829247;
        GERG2008.bvij[5][20] = 1.0;
        GERG2008.gvij[5][20] = 1.0;
        GERG2008.btij[5][20] = 1.0;
        GERG2008.gtij[5][20] = 1.0;
        GERG2008.bvij[5][21] = 1.0;
        GERG2008.gvij[5][21] = 1.0;
        GERG2008.btij[5][21] = 1.0;
        GERG2008.gtij[5][21] = 1.0;
        GERG2008.bvij[6][7] = 0.999120311;
        GERG2008.gvij[6][7] = 1.00041444;
        GERG2008.btij[6][7] = 0.999922459;
        GERG2008.gtij[6][7] = 1.001432824;
        GERG2008.bvij[6][8] = 1.0;
        GERG2008.gvij[6][8] = 1.002284353;
        GERG2008.btij[6][8] = 1.0;
        GERG2008.gtij[6][8] = 1.001835788;
        GERG2008.bvij[6][9] = 1.0;
        GERG2008.gvij[6][9] = 1.002779804;
        GERG2008.btij[6][9] = 1.0;
        GERG2008.gtij[6][9] = 1.002495889;
        GERG2008.bvij[6][10] = 1.0;
        GERG2008.gvij[6][10] = 1.010493989;
        GERG2008.btij[6][10] = 1.0;
        GERG2008.gtij[6][10] = 1.006018054;
        GERG2008.bvij[6][11] = 1.0;
        GERG2008.gvij[6][11] = 1.021668316;
        GERG2008.btij[6][11] = 1.0;
        GERG2008.gtij[6][11] = 1.00988576;
        GERG2008.bvij[6][12] = 1.0;
        GERG2008.gvij[6][12] = 1.032807063;
        GERG2008.btij[6][12] = 1.0;
        GERG2008.gtij[6][12] = 1.013945424;
        GERG2008.bvij[6][13] = 1.0;
        GERG2008.gvij[6][13] = 1.047298475;
        GERG2008.btij[6][13] = 1.0;
        GERG2008.gtij[6][13] = 1.017817492;
        GERG2008.bvij[6][14] = 1.0;
        GERG2008.gvij[6][14] = 1.060243344;
        GERG2008.btij[6][14] = 1.0;
        GERG2008.gtij[6][14] = 1.021624748;
        GERG2008.bvij[6][15] = 1.0;
        GERG2008.gvij[6][15] = 1.147595688;
        GERG2008.btij[6][15] = 1.0;
        GERG2008.gtij[6][15] = 1.895305393;
        GERG2008.bvij[6][16] = 1.0;
        GERG2008.gvij[6][16] = 1.0;
        GERG2008.btij[6][16] = 1.0;
        GERG2008.gtij[6][16] = 1.0;
        GERG2008.bvij[6][17] = 1.0;
        GERG2008.gvij[6][17] = 1.087272232;
        GERG2008.btij[6][17] = 1.0;
        GERG2008.gtij[6][17] = 1.161390082;
        GERG2008.bvij[6][18] = 1.0;
        GERG2008.gvij[6][18] = 1.0;
        GERG2008.btij[6][18] = 1.0;
        GERG2008.gtij[6][18] = 1.0;
        GERG2008.bvij[6][19] = 1.012994431;
        GERG2008.gvij[6][19] = 0.988591117;
        GERG2008.btij[6][19] = 0.974550548;
        GERG2008.gtij[6][19] = 0.937130844;
        GERG2008.bvij[6][20] = 1.0;
        GERG2008.gvij[6][20] = 1.0;
        GERG2008.btij[6][20] = 1.0;
        GERG2008.gtij[6][20] = 1.0;
        GERG2008.bvij[6][21] = 1.0;
        GERG2008.gvij[6][21] = 1.0;
        GERG2008.btij[6][21] = 1.0;
        GERG2008.gtij[6][21] = 1.0;
        GERG2008.bvij[7][8] = 1.0;
        GERG2008.gvij[7][8] = 1.002728434;
        GERG2008.btij[7][8] = 1.0;
        GERG2008.gtij[7][8] = 1.000792201;
        GERG2008.bvij[7][9] = 1.0;
        GERG2008.gvij[7][9] = 1.01815965;
        GERG2008.btij[7][9] = 1.0;
        GERG2008.gtij[7][9] = 1.00214364;
        GERG2008.bvij[7][10] = 1.0;
        GERG2008.gvij[7][10] = 1.034995284;
        GERG2008.btij[7][10] = 1.0;
        GERG2008.gtij[7][10] = 1.00915706;
        GERG2008.bvij[7][11] = 1.0;
        GERG2008.gvij[7][11] = 1.019174227;
        GERG2008.btij[7][11] = 1.0;
        GERG2008.gtij[7][11] = 1.021283378;
        GERG2008.bvij[7][12] = 1.0;
        GERG2008.gvij[7][12] = 1.046905515;
        GERG2008.btij[7][12] = 1.0;
        GERG2008.gtij[7][12] = 1.033180106;
        GERG2008.bvij[7][13] = 1.0;
        GERG2008.gvij[7][13] = 1.049219137;
        GERG2008.btij[7][13] = 1.0;
        GERG2008.gtij[7][13] = 1.014096448;
        GERG2008.bvij[7][14] = 0.976951968;
        GERG2008.gvij[7][14] = 1.027845529;
        GERG2008.btij[7][14] = 0.993688386;
        GERG2008.gtij[7][14] = 1.076466918;
        GERG2008.bvij[7][15] = 1.0;
        GERG2008.gvij[7][15] = 1.232939523;
        GERG2008.btij[7][15] = 1.0;
        GERG2008.gtij[7][15] = 2.509259945;
        GERG2008.bvij[7][16] = 1.0;
        GERG2008.gvij[7][16] = 1.0;
        GERG2008.btij[7][16] = 1.0;
        GERG2008.gtij[7][16] = 1.0;
        GERG2008.bvij[7][17] = 1.0;
        GERG2008.gvij[7][17] = 1.084740904;
        GERG2008.btij[7][17] = 1.0;
        GERG2008.gtij[7][17] = 1.173916162;
        GERG2008.bvij[7][18] = 1.0;
        GERG2008.gvij[7][18] = 1.223638763;
        GERG2008.btij[7][18] = 1.0;
        GERG2008.gtij[7][18] = 0.615512682;
        GERG2008.bvij[7][19] = 0.908113163;
        GERG2008.gvij[7][19] = 1.033366041;
        GERG2008.btij[7][19] = 0.985962886;
        GERG2008.gtij[7][19] = 0.926156602;
        GERG2008.bvij[7][20] = 1.0;
        GERG2008.gvij[7][20] = 1.0;
        GERG2008.btij[7][20] = 1.0;
        GERG2008.gtij[7][20] = 1.0;
        GERG2008.bvij[7][21] = 1.0;
        GERG2008.gvij[7][21] = 1.214638734;
        GERG2008.btij[7][21] = 1.0;
        GERG2008.gtij[7][21] = 1.245039498;
        GERG2008.bvij[8][9] = 1.0;
        GERG2008.gvij[8][9] = 1.000024335;
        GERG2008.btij[8][9] = 1.0;
        GERG2008.gtij[8][9] = 1.000050537;
        GERG2008.bvij[8][10] = 1.0;
        GERG2008.gvij[8][10] = 1.002995876;
        GERG2008.btij[8][10] = 1.0;
        GERG2008.gtij[8][10] = 1.001204174;
        GERG2008.bvij[8][11] = 1.0;
        GERG2008.gvij[8][11] = 1.009928206;
        GERG2008.btij[8][11] = 1.0;
        GERG2008.gtij[8][11] = 1.003194615;
        GERG2008.bvij[8][12] = 1.0;
        GERG2008.gvij[8][12] = 1.017880545;
        GERG2008.btij[8][12] = 1.0;
        GERG2008.gtij[8][12] = 1.00564748;
        GERG2008.bvij[8][13] = 1.0;
        GERG2008.gvij[8][13] = 1.028994325;
        GERG2008.btij[8][13] = 1.0;
        GERG2008.gtij[8][13] = 1.008191499;
        GERG2008.bvij[8][14] = 1.0;
        GERG2008.gvij[8][14] = 1.039372957;
        GERG2008.btij[8][14] = 1.0;
        GERG2008.gtij[8][14] = 1.010825138;
        GERG2008.bvij[8][15] = 1.0;
        GERG2008.gvij[8][15] = 1.184340443;
        GERG2008.btij[8][15] = 1.0;
        GERG2008.gtij[8][15] = 1.996386669;
        GERG2008.bvij[8][16] = 1.0;
        GERG2008.gvij[8][16] = 1.0;
        GERG2008.btij[8][16] = 1.0;
        GERG2008.gtij[8][16] = 1.0;
        GERG2008.bvij[8][17] = 1.0;
        GERG2008.gvij[8][17] = 1.116694577;
        GERG2008.btij[8][17] = 1.0;
        GERG2008.gtij[8][17] = 1.199326059;
        GERG2008.bvij[8][18] = 1.0;
        GERG2008.gvij[8][18] = 1.0;
        GERG2008.btij[8][18] = 1.0;
        GERG2008.gtij[8][18] = 1.0;
        GERG2008.bvij[8][19] = 1.0;
        GERG2008.gvij[8][19] = 0.835763343;
        GERG2008.btij[8][19] = 1.0;
        GERG2008.gtij[8][19] = 0.982651529;
        GERG2008.bvij[8][20] = 1.0;
        GERG2008.gvij[8][20] = 1.0;
        GERG2008.btij[8][20] = 1.0;
        GERG2008.gtij[8][20] = 1.0;
        GERG2008.bvij[8][21] = 1.0;
        GERG2008.gvij[8][21] = 1.0;
        GERG2008.btij[8][21] = 1.0;
        GERG2008.gtij[8][21] = 1.0;
        GERG2008.bvij[9][10] = 1.0;
        GERG2008.gvij[9][10] = 1.002480637;
        GERG2008.btij[9][10] = 1.0;
        GERG2008.gtij[9][10] = 1.000761237;
        GERG2008.bvij[9][11] = 1.0;
        GERG2008.gvij[9][11] = 1.008972412;
        GERG2008.btij[9][11] = 1.0;
        GERG2008.gtij[9][11] = 1.002441051;
        GERG2008.bvij[9][12] = 1.0;
        GERG2008.gvij[9][12] = 1.069223964;
        GERG2008.btij[9][12] = 1.0;
        GERG2008.gtij[9][12] = 1.016422347;
        GERG2008.bvij[9][13] = 1.0;
        GERG2008.gvij[9][13] = 1.034910633;
        GERG2008.btij[9][13] = 1.0;
        GERG2008.gtij[9][13] = 1.103421755;
        GERG2008.bvij[9][14] = 1.0;
        GERG2008.gvij[9][14] = 1.016370338;
        GERG2008.btij[9][14] = 1.0;
        GERG2008.gtij[9][14] = 1.049035838;
        GERG2008.bvij[9][15] = 1.0;
        GERG2008.gvij[9][15] = 1.188334783;
        GERG2008.btij[9][15] = 1.0;
        GERG2008.gtij[9][15] = 2.013859174;
        GERG2008.bvij[9][16] = 1.0;
        GERG2008.gvij[9][16] = 1.0;
        GERG2008.btij[9][16] = 1.0;
        GERG2008.gtij[9][16] = 1.0;
        GERG2008.bvij[9][17] = 1.0;
        GERG2008.gvij[9][17] = 1.119954454;
        GERG2008.btij[9][17] = 1.0;
        GERG2008.gtij[9][17] = 1.206043295;
        GERG2008.bvij[9][18] = 1.0;
        GERG2008.gvij[9][18] = 0.95667731;
        GERG2008.btij[9][18] = 1.0;
        GERG2008.gtij[9][18] = 0.447666011;
        GERG2008.bvij[9][19] = 0.984613203;
        GERG2008.gvij[9][19] = 1.076539234;
        GERG2008.btij[9][19] = 0.962006651;
        GERG2008.gtij[9][19] = 0.959065662;
        GERG2008.bvij[9][20] = 1.0;
        GERG2008.gvij[9][20] = 1.0;
        GERG2008.btij[9][20] = 1.0;
        GERG2008.gtij[9][20] = 1.0;
        GERG2008.bvij[9][21] = 1.0;
        GERG2008.gvij[9][21] = 1.0;
        GERG2008.btij[9][21] = 1.0;
        GERG2008.gtij[9][21] = 1.0;
        GERG2008.bvij[10][11] = 1.0;
        GERG2008.gvij[10][11] = 1.001508227;
        GERG2008.btij[10][11] = 1.0;
        GERG2008.gtij[10][11] = 0.999762786;
        GERG2008.bvij[10][12] = 1.0;
        GERG2008.gvij[10][12] = 1.006268954;
        GERG2008.btij[10][12] = 1.0;
        GERG2008.gtij[10][12] = 1.001633952;
        GERG2008.bvij[10][13] = 1.0;
        GERG2008.gvij[10][13] = 1.02076168;
        GERG2008.btij[10][13] = 1.0;
        GERG2008.gtij[10][13] = 1.055369591;
        GERG2008.bvij[10][14] = 1.001516371;
        GERG2008.gvij[10][14] = 1.013511439;
        GERG2008.btij[10][14] = 0.99764101;
        GERG2008.gtij[10][14] = 1.028939539;
        GERG2008.bvij[10][15] = 1.0;
        GERG2008.gvij[10][15] = 1.243461678;
        GERG2008.btij[10][15] = 1.0;
        GERG2008.gtij[10][15] = 3.021197546;
        GERG2008.bvij[10][16] = 1.0;
        GERG2008.gvij[10][16] = 1.0;
        GERG2008.btij[10][16] = 1.0;
        GERG2008.gtij[10][16] = 1.0;
        GERG2008.bvij[10][17] = 1.0;
        GERG2008.gvij[10][17] = 1.155145836;
        GERG2008.btij[10][17] = 1.0;
        GERG2008.gtij[10][17] = 1.233272781;
        GERG2008.bvij[10][18] = 1.0;
        GERG2008.gvij[10][18] = 1.170217596;
        GERG2008.btij[10][18] = 1.0;
        GERG2008.gtij[10][18] = 0.569681333;
        GERG2008.bvij[10][19] = 0.754473958;
        GERG2008.gvij[10][19] = 1.339283552;
        GERG2008.btij[10][19] = 0.985891113;
        GERG2008.gtij[10][19] = 0.956075596;
        GERG2008.bvij[10][20] = 1.0;
        GERG2008.gvij[10][20] = 1.0;
        GERG2008.btij[10][20] = 1.0;
        GERG2008.gtij[10][20] = 1.0;
        GERG2008.bvij[10][21] = 1.0;
        GERG2008.gvij[10][21] = 1.0;
        GERG2008.btij[10][21] = 1.0;
        GERG2008.gtij[10][21] = 1.0;
        GERG2008.bvij[11][12] = 1.0;
        GERG2008.gvij[11][12] = 1.006767176;
        GERG2008.btij[11][12] = 1.0;
        GERG2008.gtij[11][12] = 0.998793111;
        GERG2008.bvij[11][13] = 1.0;
        GERG2008.gvij[11][13] = 1.001370076;
        GERG2008.btij[11][13] = 1.0;
        GERG2008.gtij[11][13] = 1.001150096;
        GERG2008.bvij[11][14] = 1.0;
        GERG2008.gvij[11][14] = 1.002972346;
        GERG2008.btij[11][14] = 1.0;
        GERG2008.gtij[11][14] = 1.002229938;
        GERG2008.bvij[11][15] = 1.0;
        GERG2008.gvij[11][15] = 1.159131722;
        GERG2008.btij[11][15] = 1.0;
        GERG2008.gtij[11][15] = 3.169143057;
        GERG2008.bvij[11][16] = 1.0;
        GERG2008.gvij[11][16] = 1.0;
        GERG2008.btij[11][16] = 1.0;
        GERG2008.gtij[11][16] = 1.0;
        GERG2008.bvij[11][17] = 1.0;
        GERG2008.gvij[11][17] = 1.190354273;
        GERG2008.btij[11][17] = 1.0;
        GERG2008.gtij[11][17] = 1.256123503;
        GERG2008.bvij[11][18] = 1.0;
        GERG2008.gvij[11][18] = 1.0;
        GERG2008.btij[11][18] = 1.0;
        GERG2008.gtij[11][18] = 1.0;
        GERG2008.bvij[11][19] = 0.828967164;
        GERG2008.gvij[11][19] = 1.087956749;
        GERG2008.btij[11][19] = 0.988937417;
        GERG2008.gtij[11][19] = 1.013453092;
        GERG2008.bvij[11][20] = 1.0;
        GERG2008.gvij[11][20] = 1.0;
        GERG2008.btij[11][20] = 1.0;
        GERG2008.gtij[11][20] = 1.0;
        GERG2008.bvij[11][21] = 1.0;
        GERG2008.gvij[11][21] = 1.0;
        GERG2008.btij[11][21] = 1.0;
        GERG2008.gtij[11][21] = 1.0;
        GERG2008.bvij[12][13] = 1.0;
        GERG2008.gvij[12][13] = 1.001357085;
        GERG2008.btij[12][13] = 1.0;
        GERG2008.gtij[12][13] = 1.000235044;
        GERG2008.bvij[12][14] = 1.0;
        GERG2008.gvij[12][14] = 1.002553544;
        GERG2008.btij[12][14] = 1.0;
        GERG2008.gtij[12][14] = 1.007186267;
        GERG2008.bvij[12][15] = 1.0;
        GERG2008.gvij[12][15] = 1.305249405;
        GERG2008.btij[12][15] = 1.0;
        GERG2008.gtij[12][15] = 2.191555216;
        GERG2008.bvij[12][16] = 1.0;
        GERG2008.gvij[12][16] = 1.0;
        GERG2008.btij[12][16] = 1.0;
        GERG2008.gtij[12][16] = 1.0;
        GERG2008.bvij[12][17] = 1.0;
        GERG2008.gvij[12][17] = 1.219206702;
        GERG2008.btij[12][17] = 1.0;
        GERG2008.gtij[12][17] = 1.276565536;
        GERG2008.bvij[12][18] = 1.0;
        GERG2008.gvij[12][18] = 0.599484191;
        GERG2008.btij[12][18] = 1.0;
        GERG2008.gtij[12][18] = 0.662072469;
        GERG2008.bvij[12][19] = 1.0;
        GERG2008.gvij[12][19] = 1.0;
        GERG2008.btij[12][19] = 1.0;
        GERG2008.gtij[12][19] = 1.0;
        GERG2008.bvij[12][20] = 1.0;
        GERG2008.gvij[12][20] = 1.0;
        GERG2008.btij[12][20] = 1.0;
        GERG2008.gtij[12][20] = 1.0;
        GERG2008.bvij[12][21] = 1.0;
        GERG2008.gvij[12][21] = 1.0;
        GERG2008.btij[12][21] = 1.0;
        GERG2008.gtij[12][21] = 1.0;
        GERG2008.bvij[13][14] = 1.0;
        GERG2008.gvij[13][14] = 1.00081052;
        GERG2008.btij[13][14] = 1.0;
        GERG2008.gtij[13][14] = 1.000182392;
        GERG2008.bvij[13][15] = 1.0;
        GERG2008.gvij[13][15] = 1.342647661;
        GERG2008.btij[13][15] = 1.0;
        GERG2008.gtij[13][15] = 2.23435404;
        GERG2008.bvij[13][16] = 1.0;
        GERG2008.gvij[13][16] = 1.0;
        GERG2008.btij[13][16] = 1.0;
        GERG2008.gtij[13][16] = 1.0;
        GERG2008.bvij[13][17] = 1.0;
        GERG2008.gvij[13][17] = 1.252151449;
        GERG2008.btij[13][17] = 1.0;
        GERG2008.gtij[13][17] = 1.294070556;
        GERG2008.bvij[13][18] = 1.0;
        GERG2008.gvij[13][18] = 1.0;
        GERG2008.btij[13][18] = 1.0;
        GERG2008.gtij[13][18] = 1.0;
        GERG2008.bvij[13][19] = 1.0;
        GERG2008.gvij[13][19] = 1.082905109;
        GERG2008.btij[13][19] = 1.0;
        GERG2008.gtij[13][19] = 1.086557826;
        GERG2008.bvij[13][20] = 1.0;
        GERG2008.gvij[13][20] = 1.0;
        GERG2008.btij[13][20] = 1.0;
        GERG2008.gtij[13][20] = 1.0;
        GERG2008.bvij[13][21] = 1.0;
        GERG2008.gvij[13][21] = 1.0;
        GERG2008.btij[13][21] = 1.0;
        GERG2008.gtij[13][21] = 1.0;
        GERG2008.bvij[14][15] = 1.695358382;
        GERG2008.gvij[14][15] = 1.120233729;
        GERG2008.btij[14][15] = 1.064818089;
        GERG2008.gtij[14][15] = 3.786003724;
        GERG2008.bvij[14][16] = 1.0;
        GERG2008.gvij[14][16] = 1.0;
        GERG2008.btij[14][16] = 1.0;
        GERG2008.gtij[14][16] = 1.0;
        GERG2008.bvij[14][17] = 1.0;
        GERG2008.gvij[14][17] = 0.87018496;
        GERG2008.btij[14][17] = 1.049594632;
        GERG2008.gtij[14][17] = 1.803567587;
        GERG2008.bvij[14][18] = 1.0;
        GERG2008.gvij[14][18] = 0.551405318;
        GERG2008.btij[14][18] = 0.897162268;
        GERG2008.gtij[14][18] = 0.740416402;
        GERG2008.bvij[14][19] = 0.975187766;
        GERG2008.gvij[14][19] = 1.171714677;
        GERG2008.btij[14][19] = 0.973091413;
        GERG2008.gtij[14][19] = 1.103693489;
        GERG2008.bvij[14][20] = 1.0;
        GERG2008.gvij[14][20] = 1.0;
        GERG2008.btij[14][20] = 1.0;
        GERG2008.gtij[14][20] = 1.0;
        GERG2008.bvij[14][21] = 1.0;
        GERG2008.gvij[14][21] = 1.0;
        GERG2008.btij[14][21] = 1.0;
        GERG2008.gtij[14][21] = 1.0;
        GERG2008.bvij[15][16] = 1.0;
        GERG2008.gvij[15][16] = 1.0;
        GERG2008.btij[15][16] = 1.0;
        GERG2008.gtij[15][16] = 1.0;
        GERG2008.bvij[15][17] = 1.0;
        GERG2008.gvij[15][17] = 1.121416201;
        GERG2008.btij[15][17] = 1.0;
        GERG2008.gtij[15][17] = 1.377504607;
        GERG2008.bvij[15][18] = 1.0;
        GERG2008.gvij[15][18] = 1.0;
        GERG2008.btij[15][18] = 1.0;
        GERG2008.gtij[15][18] = 1.0;
        GERG2008.bvij[15][19] = 1.0;
        GERG2008.gvij[15][19] = 1.0;
        GERG2008.btij[15][19] = 1.0;
        GERG2008.gtij[15][19] = 1.0;
        GERG2008.bvij[15][20] = 1.0;
        GERG2008.gvij[15][20] = 1.0;
        GERG2008.btij[15][20] = 1.0;
        GERG2008.gtij[15][20] = 1.0;
        GERG2008.bvij[15][21] = 1.0;
        GERG2008.gvij[15][21] = 1.0;
        GERG2008.btij[15][21] = 1.0;
        GERG2008.gtij[15][21] = 1.0;
        GERG2008.bvij[16][17] = 1.0;
        GERG2008.gvij[16][17] = 1.0;
        GERG2008.btij[16][17] = 1.0;
        GERG2008.gtij[16][17] = 1.0;
        GERG2008.bvij[16][18] = 1.0;
        GERG2008.gvij[16][18] = 1.143174289;
        GERG2008.btij[16][18] = 1.0;
        GERG2008.gtij[16][18] = 0.964767932;
        GERG2008.bvij[16][19] = 1.0;
        GERG2008.gvij[16][19] = 1.0;
        GERG2008.btij[16][19] = 1.0;
        GERG2008.gtij[16][19] = 1.0;
        GERG2008.bvij[16][20] = 1.0;
        GERG2008.gvij[16][20] = 1.0;
        GERG2008.btij[16][20] = 1.0;
        GERG2008.gtij[16][20] = 1.0;
        GERG2008.bvij[16][21] = 0.999746847;
        GERG2008.gvij[16][21] = 0.993907223;
        GERG2008.btij[16][21] = 1.000023103;
        GERG2008.gtij[16][21] = 0.990430423;
        GERG2008.bvij[17][18] = 1.0;
        GERG2008.gvij[17][18] = 1.0;
        GERG2008.btij[17][18] = 1.0;
        GERG2008.gtij[17][18] = 1.0;
        GERG2008.bvij[17][19] = 0.795660392;
        GERG2008.gvij[17][19] = 1.101731308;
        GERG2008.btij[17][19] = 1.025536736;
        GERG2008.gtij[17][19] = 1.022749748;
        GERG2008.bvij[17][20] = 1.0;
        GERG2008.gvij[17][20] = 1.0;
        GERG2008.btij[17][20] = 1.0;
        GERG2008.gtij[17][20] = 1.0;
        GERG2008.bvij[17][21] = 1.0;
        GERG2008.gvij[17][21] = 1.159720623;
        GERG2008.btij[17][21] = 1.0;
        GERG2008.gtij[17][21] = 0.954215746;
        GERG2008.bvij[18][19] = 1.0;
        GERG2008.gvij[18][19] = 1.014832832;
        GERG2008.btij[18][19] = 1.0;
        GERG2008.gtij[18][19] = 0.940587083;
        GERG2008.bvij[18][20] = 1.0;
        GERG2008.gvij[18][20] = 1.0;
        GERG2008.btij[18][20] = 1.0;
        GERG2008.gtij[18][20] = 1.0;
        GERG2008.bvij[18][21] = 1.0;
        GERG2008.gvij[18][21] = 1.038993495;
        GERG2008.btij[18][21] = 1.0;
        GERG2008.gtij[18][21] = 1.070941866;
        GERG2008.bvij[19][20] = 1.0;
        GERG2008.gvij[19][20] = 1.0;
        GERG2008.btij[19][20] = 1.0;
        GERG2008.gtij[19][20] = 1.0;
        GERG2008.bvij[19][21] = 1.0;
        GERG2008.gvij[19][21] = 1.0;
        GERG2008.btij[19][21] = 1.0;
        GERG2008.gtij[19][21] = 1.0;
        GERG2008.bvij[20][21] = 1.0;
        GERG2008.gvij[20][21] = 1.0;
        GERG2008.btij[20][21] = 1.0;
        GERG2008.gtij[20][21] = 1.0;
        i = 1;
        while (i <= MaxFlds) {
            GERG2008.bvij[i][i] = 1.0;
            GERG2008.btij[i][i] = 1.0;
            GERG2008.gvij[i][i] = 1.0 / Dc[i];
            GERG2008.gtij[i][i] = Tc[i];
            j = i + 1;
            while (j <= MaxFlds) {
                GERG2008.gvij[i][j] = gvij[i][j] * bvij[i][j] * Math.pow(Vc3[i] + Vc3[j], 3.0);
                GERG2008.gtij[i][j] = gtij[i][j] * btij[i][j] * Tc2[i] * Tc2[j];
                GERG2008.bvij[i][j] = Math.pow(bvij[i][j], 2.0);
                GERG2008.btij[i][j] = Math.pow(btij[i][j], 2.0);
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= MaxMdl) {
            j = 1;
            while (j <= MaxTrmM) {
                GERG2008.gijk[i][j] = -cijk[i][j] * Math.pow(eijk[i][j], 2.0) + bijk[i][j] * gijk[i][j];
                GERG2008.eijk[i][j] = 2.0 * cijk[i][j] * eijk[i][j] - bijk[i][j];
                GERG2008.cijk[i][j] = -cijk[i][j];
                ++j;
            }
            ++i;
        }
        double T0 = 298.15;
        double d0 = 101.325 / RGERG / T0;
        i = 1;
        while (i <= MaxFlds) {
            GERG2008.n0i[i][3] = n0i[i][3] - 1.0;
            GERG2008.n0i[i][2] = n0i[i][2] + T0;
            j = 1;
            while (j <= 7) {
                GERG2008.n0i[i][j] = Rsr * n0i[i][j];
                ++j;
            }
            GERG2008.n0i[i][2] = n0i[i][2] - T0;
            GERG2008.n0i[i][1] = n0i[i][1] - Math.log(d0);
            ++i;
        }
    }

    public static void main(String[] args) {
        GERG2008 test2 = new GERG2008();
        GERG2008.SetupGERG();
        double T = 400.0;
        doubleW D = new doubleW(12.79828626082062);
        doubleW P = new doubleW(50000.0);
        intW ierr = new intW(0);
        doubleW Mm = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        int iFlag = 0;
        StringW herr = new StringW("");
        double[] x = new double[]{0.0, 0.77824, 0.02, 0.06, 0.08, 0.03, 0.0015, 0.003, 5.0E-4, 0.00165, 0.00215, 8.8E-4, 2.4E-4, 1.5E-4, 9.0E-5, 0.004, 0.005, 0.002, 1.0E-4, 0.0025, 0.007, 0.001};
        GERG2008.MolarMassGERG(x, Mm);
        System.out.println("mol mass " + Mm.val);
        GERG2008.PressureGERG(T, D.val, x, P, Z);
        System.out.println("pressure " + P.val);
        System.out.println("Z " + Z.val);
        GERG2008.DensityGERG(iFlag, T, P.val, x, D, ierr, herr);
        System.out.println("density " + D.val);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        GERG2008.PropertiesGERG(T, D.val, x, P, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa, A);
        System.out.println("Outputs-----\n");
        System.out.println("Molar mass [g/mol]:                 20.54274450160000 != %0.16g\n" + Mm.val);
        System.out.println("Molar density [mol/l]:              12.79828626082062 != %0.16g\n" + D.val);
        System.out.println("Pressure [kPa]:                     50000.00000000001 != %0.16g\n" + P.val);
        System.out.println("Compressibility factor:             1.174690666383717 != %0.16g\n" + Z.val);
        System.out.println("d(P)/d(rho) [kPa/(mol/l)]:          7000.694030193327 != %0.16g\n" + dPdD.val);
        System.out.println("d^2(P)/d(rho)^2 [kPa/(mol/l)^2]:    1130.481239114938 != %0.16g\n" + d2PdD2.val);
        System.out.println("d(P)/d(T) [kPa/K]:                  235.9832292593096 != %0.16g\n" + dPdT.val);
        System.out.println("Energy [J/mol]:                     -2746.492901212530 != %0.16g\n" + U.val);
        System.out.println("Enthalpy [J/mol]:                   1160.280160510973 != %0.16g\n" + H.val);
        System.out.println("Entropy [J/mol-K]:                  -38.57590392409089 != %0.16g\n" + S.val);
        System.out.println("Isochoric heat capacity [J/mol-K]:  39.02948218156372 != %0.16g\n" + Cv.val);
        System.out.println("Isobaric heat capacity [J/mol-K]:   58.45522051000366 != %0.16g\n" + Cp.val);
        System.out.println("Speed of sound [m/s]:               714.4248840596024 != %0.16g\n" + W.val);
        System.out.println("Gibbs energy [J/mol]:               16590.64173014733 != %0.16g\n" + G.val);
        System.out.println("Joule-Thomson coefficient [K/kPa]:  7.155629581480913E-05 != %0.16g\n" + JT.val);
        System.out.println("Isentropic exponent:                2.683820255058032 != %0.16g\n" + Kappa.val);
    }
}

