/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.GERG;

import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class DETAIL {
    static double RDetail;
    static int NcDetail;
    static int MaxFlds;
    static int NTerms;
    static double epsilon;
    static int[] fn;
    static int[] gn;
    static int[] qn;
    static double[] an;
    static double[] un;
    static int[] bn;
    static int[] kn;
    static double[][][] Bsnij2;
    static double[] Bs;
    static double[] Csn;
    static double[] Fi;
    static double[] Gi;
    static double[] Qi;
    static double[] Ki25;
    static double[] Ei25;
    static double[][] Kij5;
    static double[][] Uij5;
    static double[][] Gij5;
    static double[] Tun;
    static double Told;
    static double[][] n0i;
    static double[][] th0i;
    static double[] MMiDetail;
    static double[] xold;
    static double K3;
    static double dPdDsave;

    static {
        NcDetail = 21;
        MaxFlds = 21;
        NTerms = 58;
        epsilon = 1.0E-15;
        fn = new int[NTerms + 1];
        gn = new int[NTerms + 1];
        qn = new int[NTerms + 1];
        an = new double[NTerms + 1];
        un = new double[NTerms + 1];
        bn = new int[NTerms + 1];
        kn = new int[NTerms + 1];
        Bsnij2 = new double[MaxFlds + 1][MaxFlds + 1][19];
        Bs = new double[19];
        Csn = new double[NTerms + 1];
        Fi = new double[MaxFlds + 1];
        Gi = new double[MaxFlds + 1];
        Qi = new double[MaxFlds + 1];
        Ki25 = new double[MaxFlds + 1];
        Ei25 = new double[MaxFlds + 1];
        Kij5 = new double[MaxFlds + 1][MaxFlds + 1];
        Uij5 = new double[MaxFlds + 1][MaxFlds + 1];
        Gij5 = new double[MaxFlds + 1][MaxFlds + 1];
        Tun = new double[NTerms + 1];
        n0i = new double[MaxFlds + 1][8];
        th0i = new double[MaxFlds + 1][8];
        MMiDetail = new double[MaxFlds + 1];
        xold = new double[MaxFlds + 1];
    }

    public static double sq(double x) {
        return x * x;
    }

    public static void MolarMassDetail(double[] x, doubleW Mm) {
        Mm.val = 0.0;
        int i = 1;
        while (i <= NcDetail) {
            Mm.val += x[i] * MMiDetail[i];
            ++i;
        }
    }

    public static void PressureDetail(double T, double D, double[] x, doubleW P, doubleW Z) {
        doubleW[][] ar = new doubleW[4][4];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                ar[i][j] = new doubleW(0.0);
                ++j;
            }
            ++i;
        }
        DETAIL.xTermsDetail(x);
        DETAIL.AlpharDetail(0, 2, T, D, ar);
        Z.val = 1.0 + ar[0][1].val / RDetail / T;
        P.val = D * RDetail * T * Z.val;
        dPdDsave = RDetail * T + 2.0 * ar[0][1].val + ar[0][2].val;
    }

    public static void DensityDetail(double T, double P, double[] x, doubleW D, intW ierr, StringW herr) {
        doubleW P2 = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        ierr.val = 0;
        herr.val = "";
        if (Math.abs(P) < epsilon) {
            D.val = 0.0;
            return;
        }
        double tolr = 1.0E-7;
        D.val = D.val > -epsilon ? P / RDetail / T : Math.abs(D.val);
        double plog = Math.log(P);
        double vlog = -Math.log(D.val);
        int it = 1;
        while (it <= 20) {
            if (vlog < -7.0 || vlog > 100.0) {
                ierr.val = 1;
                herr.val = "Calculation failed to converge in DETAIL method, ideal gas density returned.";
                D.val = P / RDetail / T;
                return;
            }
            D.val = Math.exp(-vlog);
            DETAIL.PressureDetail(T, D.val, x, P2, Z);
            if (dPdDsave < epsilon || P2.val < epsilon) {
                vlog += 0.1;
            } else {
                double dpdlv = -D.val * dPdDsave;
                double vdiff = (Math.log(P2.val) - plog) * P2.val / dpdlv;
                vlog -= vdiff;
                if (Math.abs(vdiff) < tolr) {
                    D.val = Math.exp(-vlog);
                    return;
                }
            }
            ++it;
        }
        ierr.val = 1;
        herr.val = "Calculation failed to converge in DETAIL method, ideal gas density returned.";
        D.val = P / RDetail / T;
    }

    public static void PropertiesDetail(double T, double D, double[] x, doubleW P, doubleW Z, doubleW dPdD, doubleW d2PdD2, doubleW d2PdTD, doubleW dPdT, doubleW U, doubleW H, doubleW S, doubleW Cv, doubleW Cp, doubleW W, doubleW G, doubleW JT, doubleW Kappa) {
        doubleW A = new doubleW(0.0);
        doubleW[] a0 = new doubleW[3];
        int i = 0;
        while (i < 3) {
            a0[i] = new doubleW(0.0);
            ++i;
        }
        doubleW[][] ar = new doubleW[4][4];
        int i2 = 0;
        while (i2 < 4) {
            int j = 0;
            while (j < 4) {
                ar[i2][j] = new doubleW(0.0);
                ++j;
            }
            ++i2;
        }
        doubleW Mm = new doubleW(0.0);
        DETAIL.MolarMassDetail(x, Mm);
        DETAIL.xTermsDetail(x);
        DETAIL.Alpha0Detail(T, D, x, a0);
        DETAIL.AlpharDetail(2, 3, T, D, ar);
        double R = RDetail;
        double RT = R * T;
        Z.val = 1.0 + ar[0][1].val / RT;
        P.val = D * RT * Z.val;
        dPdD.val = RT + 2.0 * ar[0][1].val + ar[0][2].val;
        dPdT.val = D * R + D * ar[1][1].val;
        A.val = a0[0].val + ar[0][0].val;
        S.val = -a0[1].val - ar[1][0].val;
        U.val = A.val + T * S.val;
        Cv.val = -(a0[2].val + ar[2][0].val);
        if (D > epsilon) {
            H.val = U.val + P.val / D;
            G.val = A.val + P.val / D;
            Cp.val = Cv.val + T * DETAIL.sq(dPdT.val / D) / dPdD.val;
            d2PdD2.val = (2.0 * ar[0][1].val + 4.0 * ar[0][2].val + ar[0][3].val) / D;
            JT.val = (T / D * dPdT.val / dPdD.val - 1.0) / Cp.val / D;
        } else {
            H.val = U.val + RT;
            G.val = A.val + RT;
            Cp.val = Cv.val + R;
            d2PdD2.val = 0.0;
            JT.val = 1.0E20;
        }
        W.val = 1000.0 * Cp.val / Cv.val * dPdD.val / Mm.val;
        if (W.val < 0.0) {
            W.val = 0.0;
        }
        W.val = Math.sqrt(W.val);
        Kappa.val = W.val * W.val * Mm.val / (RT * 1000.0 * Z.val);
        d2PdTD.val = 0.0;
    }

    static void xTermsDetail(double[] x) {
        boolean icheck = false;
        int i = 1;
        while (i <= NcDetail) {
            if (Math.abs(x[i] - xold[i]) > 1.0E-7) {
                icheck = true;
            }
            DETAIL.xold[i] = x[i];
            ++i;
        }
        if (!icheck) {
            return;
        }
        K3 = 0.0;
        double U = 0.0;
        double G = 0.0;
        double Q = 0.0;
        double F = 0.0;
        int n = 1;
        while (n <= 18) {
            DETAIL.Bs[n] = 0.0;
            ++n;
        }
        i = 1;
        while (i <= NcDetail) {
            if (x[i] > 0.0) {
                double xi2 = DETAIL.sq(x[i]);
                K3 += x[i] * Ki25[i];
                U += x[i] * Ei25[i];
                G += x[i] * Gi[i];
                Q += x[i] * Qi[i];
                F += xi2 * Fi[i];
                int n2 = 1;
                while (n2 <= 18) {
                    DETAIL.Bs[n2] = Bs[n2] + xi2 * Bsnij2[i][i][n2];
                    ++n2;
                }
            }
            ++i;
        }
        K3 = DETAIL.sq(K3);
        U = DETAIL.sq(U);
        i = 1;
        while (i <= NcDetail - 1) {
            if (x[i] > 0.0) {
                int j = i + 1;
                while (j <= NcDetail) {
                    if (x[j] > 0.0) {
                        double xij = 2.0 * x[i] * x[j];
                        K3 += xij * Kij5[i][j];
                        U += xij * Uij5[i][j];
                        G += xij * Gij5[i][j];
                        int n3 = 1;
                        while (n3 <= 18) {
                            DETAIL.Bs[n3] = Bs[n3] + xij * Bsnij2[i][j][n3];
                            ++n3;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        K3 = Math.pow(K3, 0.6);
        U = Math.pow(U, 0.2);
        double Q2 = DETAIL.sq(Q);
        n = 13;
        while (n <= 58) {
            DETAIL.Csn[n] = an[n] * Math.pow(U, un[n]);
            if (gn[n] == 1) {
                DETAIL.Csn[n] = Csn[n] * G;
            }
            if (qn[n] == 1) {
                DETAIL.Csn[n] = Csn[n] * Q2;
            }
            if (fn[n] == 1) {
                DETAIL.Csn[n] = Csn[n] * F;
            }
            ++n;
        }
    }

    static void Alpha0Detail(double T, double D, double[] x, doubleW[] a0) {
        a0[0].val = 0.0;
        a0[1].val = 0.0;
        a0[2].val = 0.0;
        double LogD = D > epsilon ? Math.log(D) : Math.log(epsilon);
        double LogT = Math.log(T);
        int i = 1;
        while (i <= NcDetail) {
            if (x[i] > 0.0) {
                double LogxD = LogD + Math.log(x[i]);
                double SumHyp0 = 0.0;
                double SumHyp1 = 0.0;
                double SumHyp2 = 0.0;
                int j = 4;
                while (j <= 7) {
                    if (th0i[i][j] > 0.0) {
                        double LogHyp;
                        double th0T = th0i[i][j] / T;
                        double ep = Math.exp(th0T);
                        double em = 1.0 / ep;
                        double hsn = (ep - em) / 2.0;
                        double hcn = (ep + em) / 2.0;
                        if (j == 4 || j == 6) {
                            LogHyp = Math.log(Math.abs(hsn));
                            SumHyp0 += n0i[i][j] * LogHyp;
                            SumHyp1 += n0i[i][j] * (LogHyp - th0T * hcn / hsn);
                            SumHyp2 += n0i[i][j] * DETAIL.sq(th0T / hsn);
                        } else {
                            LogHyp = Math.log(Math.abs(hcn));
                            SumHyp0 += -n0i[i][j] * LogHyp;
                            SumHyp1 += -n0i[i][j] * (LogHyp - th0T * hsn / hcn);
                            SumHyp2 += n0i[i][j] * DETAIL.sq(th0T / hcn);
                        }
                    }
                    ++j;
                }
                a0[0].val += x[i] * (LogxD + n0i[i][1] + n0i[i][2] / T - n0i[i][3] * LogT + SumHyp0);
                a0[1].val += x[i] * (LogxD + n0i[i][1] - n0i[i][3] * (1.0 + LogT) + SumHyp1);
                a0[2].val += -x[i] * (n0i[i][3] + SumHyp2);
            }
            ++i;
        }
        a0[0].val = a0[0].val * RDetail * T;
        a0[1].val *= RDetail;
        a0[2].val *= RDetail;
    }

    static void AlpharDetail(int itau, int idel, double T, double D, doubleW[][] ar) {
        int n;
        double[] Sum0 = new double[NTerms + 1];
        double[] SumB = new double[NTerms + 1];
        double[] Dknn = new double[10];
        double[] Expn = new double[5];
        double[] CoefD1 = new double[NTerms + 1];
        double[] CoefD2 = new double[NTerms + 1];
        double[] CoefD3 = new double[NTerms + 1];
        double[] CoefT1 = new double[NTerms + 1];
        double[] CoefT2 = new double[NTerms + 1];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                ar[i][j].val = 0.0;
                ++j;
            }
            ++i;
        }
        if (Math.abs(T - Told) > 1.0E-7) {
            n = 1;
            while (n <= 58) {
                DETAIL.Tun[n] = Math.pow(T, -un[n]);
                ++n;
            }
        }
        Told = T;
        double Dred = K3 * D;
        Dknn[0] = 1.0;
        n = 1;
        while (n <= 9) {
            Dknn[n] = Dred * Dknn[n - 1];
            ++n;
        }
        Expn[0] = 1.0;
        n = 1;
        while (n <= 4) {
            Expn[n] = Math.exp(-Dknn[n]);
            ++n;
        }
        double RT = RDetail * T;
        n = 1;
        while (n <= 58) {
            CoefT1[n] = RDetail * (un[n] - 1.0);
            CoefT2[n] = CoefT1[n] * un[n];
            SumB[n] = 0.0;
            Sum0[n] = 0.0;
            if (n <= 18) {
                double Sum2 = Bs[n] * D;
                if (n >= 13) {
                    Sum2 += -Csn[n] * Dred;
                }
                SumB[n] = Sum2 * Tun[n];
            }
            if (n >= 13) {
                Sum0[n] = Csn[n] * Dknn[bn[n]] * Tun[n] * Expn[kn[n]];
                double bkd = (double)bn[n] - (double)kn[n] * Dknn[kn[n]];
                double ckd = (double)(kn[n] * kn[n]) * Dknn[kn[n]];
                CoefD1[n] = bkd;
                CoefD2[n] = bkd * (bkd - 1.0) - ckd;
                CoefD3[n] = (bkd - 2.0) * CoefD2[n] + ckd * ((double)(1 - kn[n]) - 2.0 * bkd);
            } else {
                CoefD1[n] = 0.0;
                CoefD2[n] = 0.0;
                CoefD3[n] = 0.0;
            }
            ++n;
        }
        n = 1;
        while (n <= 58) {
            double s0 = Sum0[n] + SumB[n];
            double s1 = Sum0[n] * CoefD1[n] + SumB[n];
            double s2 = Sum0[n] * CoefD2[n];
            double s3 = Sum0[n] * CoefD3[n];
            ar[0][0].val += RT * s0;
            ar[0][1].val += RT * s1;
            ar[0][2].val += RT * s2;
            ar[0][3].val += RT * s3;
            if (itau > 0) {
                ar[1][0].val -= CoefT1[n] * s0;
                ar[1][1].val -= CoefT1[n] * s1;
                ar[2][0].val += CoefT2[n] * s0;
            }
            ++n;
        }
    }

    public static void SetupDetail() {
        int j;
        int[] sn = new int[NTerms + 1];
        int[] wn = new int[NTerms + 1];
        double[] Ei = new double[MaxFlds + 1];
        double[] Ki = new double[MaxFlds + 1];
        double[] Si = new double[MaxFlds + 1];
        double[] Wi = new double[MaxFlds + 1];
        double[][] Kij = new double[MaxFlds + 1][MaxFlds + 1];
        double[][] Gij = new double[MaxFlds + 1][MaxFlds + 1];
        double[][] Eij = new double[MaxFlds + 1][MaxFlds + 1];
        double[][] Uij = new double[MaxFlds + 1][MaxFlds + 1];
        RDetail = 8.31451;
        DETAIL.MMiDetail[1] = 16.043;
        DETAIL.MMiDetail[2] = 28.0135;
        DETAIL.MMiDetail[3] = 44.01;
        DETAIL.MMiDetail[4] = 30.07;
        DETAIL.MMiDetail[5] = 44.097;
        DETAIL.MMiDetail[6] = 58.123;
        DETAIL.MMiDetail[7] = 58.123;
        DETAIL.MMiDetail[8] = 72.15;
        DETAIL.MMiDetail[9] = 72.15;
        DETAIL.MMiDetail[10] = 86.177;
        DETAIL.MMiDetail[11] = 100.204;
        DETAIL.MMiDetail[12] = 114.231;
        DETAIL.MMiDetail[13] = 128.258;
        DETAIL.MMiDetail[14] = 142.285;
        DETAIL.MMiDetail[15] = 2.0159;
        DETAIL.MMiDetail[16] = 31.9988;
        DETAIL.MMiDetail[17] = 28.01;
        DETAIL.MMiDetail[18] = 18.0153;
        DETAIL.MMiDetail[19] = 34.082;
        DETAIL.MMiDetail[20] = 4.0026;
        DETAIL.MMiDetail[21] = 39.948;
        Told = 0.0;
        int i = 1;
        while (i <= NTerms) {
            DETAIL.an[i] = 0.0;
            DETAIL.bn[i] = 0;
            DETAIL.gn[i] = 0;
            DETAIL.fn[i] = 0;
            DETAIL.kn[i] = 0;
            DETAIL.qn[i] = 0;
            sn[i] = 0;
            DETAIL.un[i] = 0.0;
            wn[i] = 0;
            ++i;
        }
        i = 1;
        while (i <= MaxFlds) {
            Ei[i] = 0.0;
            DETAIL.Fi[i] = 0.0;
            DETAIL.Gi[i] = 0.0;
            Ki[i] = 0.0;
            DETAIL.Qi[i] = 0.0;
            Si[i] = 0.0;
            Wi[i] = 0.0;
            DETAIL.xold[i] = 0.0;
            j = 1;
            while (j <= MaxFlds) {
                Eij[i][j] = 1.0;
                Gij[i][j] = 1.0;
                Kij[i][j] = 1.0;
                Uij[i][j] = 1.0;
                ++j;
            }
            ++i;
        }
        DETAIL.an[1] = 0.1538326;
        DETAIL.an[2] = 1.341953;
        DETAIL.an[3] = -2.998583;
        DETAIL.an[4] = -0.04831228;
        DETAIL.an[5] = 0.3757965;
        DETAIL.an[6] = -1.589575;
        DETAIL.an[7] = -0.05358847;
        DETAIL.an[8] = 0.88659463;
        DETAIL.an[9] = -0.71023704;
        DETAIL.an[10] = -1.471722;
        DETAIL.an[11] = 1.32185035;
        DETAIL.an[12] = -0.78665925;
        DETAIL.an[13] = 2.29129E-9;
        DETAIL.an[14] = 0.1576724;
        DETAIL.an[15] = -0.4363864;
        DETAIL.an[16] = -0.04408159;
        DETAIL.an[17] = -0.003433888;
        DETAIL.an[18] = 0.03205905;
        DETAIL.an[19] = 0.02487355;
        DETAIL.an[20] = 0.07332279;
        DETAIL.an[21] = -0.001600573;
        DETAIL.an[22] = 0.6424706;
        DETAIL.an[23] = -0.4162601;
        DETAIL.an[24] = -0.06689957;
        DETAIL.an[25] = 0.2791795;
        DETAIL.an[26] = -0.6966051;
        DETAIL.an[27] = -0.002860589;
        DETAIL.an[28] = -0.008098836;
        DETAIL.an[29] = 3.150547;
        DETAIL.an[30] = 0.007224479;
        DETAIL.an[31] = -0.7057529;
        DETAIL.an[32] = 0.5349792;
        DETAIL.an[33] = -0.07931491;
        DETAIL.an[34] = -1.418465;
        DETAIL.an[35] = -5.99905E-17;
        DETAIL.an[36] = 0.1058402;
        DETAIL.an[37] = 0.03431729;
        DETAIL.an[38] = -0.007022847;
        DETAIL.an[39] = 0.02495587;
        DETAIL.an[40] = 0.04296818;
        DETAIL.an[41] = 0.7465453;
        DETAIL.an[42] = -0.2919613;
        DETAIL.an[43] = 7.294616;
        DETAIL.an[44] = -9.936757;
        DETAIL.an[45] = -0.005399808;
        DETAIL.an[46] = -0.2432567;
        DETAIL.an[47] = 0.04987016;
        DETAIL.an[48] = 0.003733797;
        DETAIL.an[49] = 1.874951;
        DETAIL.an[50] = 0.002168144;
        DETAIL.an[51] = -0.6587164;
        DETAIL.an[52] = 2.05518E-4;
        DETAIL.an[53] = 0.009776195;
        DETAIL.an[54] = -0.02048708;
        DETAIL.an[55] = 0.01557322;
        DETAIL.an[56] = 0.006862415;
        DETAIL.an[57] = -0.001226752;
        DETAIL.an[58] = 0.002850908;
        DETAIL.bn[1] = 1;
        DETAIL.bn[2] = 1;
        DETAIL.bn[3] = 1;
        DETAIL.bn[4] = 1;
        DETAIL.bn[5] = 1;
        DETAIL.bn[6] = 1;
        DETAIL.bn[7] = 1;
        DETAIL.bn[8] = 1;
        DETAIL.bn[9] = 1;
        DETAIL.bn[10] = 1;
        DETAIL.bn[11] = 1;
        DETAIL.bn[12] = 1;
        DETAIL.bn[13] = 1;
        DETAIL.bn[14] = 1;
        DETAIL.bn[15] = 1;
        DETAIL.bn[16] = 1;
        DETAIL.bn[17] = 1;
        DETAIL.bn[18] = 1;
        DETAIL.bn[19] = 2;
        DETAIL.bn[20] = 2;
        DETAIL.bn[21] = 2;
        DETAIL.bn[22] = 2;
        DETAIL.bn[23] = 2;
        DETAIL.bn[24] = 2;
        DETAIL.bn[25] = 2;
        DETAIL.bn[26] = 2;
        DETAIL.bn[27] = 2;
        DETAIL.bn[28] = 3;
        DETAIL.bn[29] = 3;
        DETAIL.bn[30] = 3;
        DETAIL.bn[31] = 3;
        DETAIL.bn[32] = 3;
        DETAIL.bn[33] = 3;
        DETAIL.bn[34] = 3;
        DETAIL.bn[35] = 3;
        DETAIL.bn[36] = 3;
        DETAIL.bn[37] = 3;
        DETAIL.bn[38] = 4;
        DETAIL.bn[39] = 4;
        DETAIL.bn[40] = 4;
        DETAIL.bn[41] = 4;
        DETAIL.bn[42] = 4;
        DETAIL.bn[43] = 4;
        DETAIL.bn[44] = 4;
        DETAIL.bn[45] = 5;
        DETAIL.bn[46] = 5;
        DETAIL.bn[47] = 5;
        DETAIL.bn[48] = 5;
        DETAIL.bn[49] = 5;
        DETAIL.bn[50] = 6;
        DETAIL.bn[51] = 6;
        DETAIL.bn[52] = 7;
        DETAIL.bn[53] = 7;
        DETAIL.bn[54] = 8;
        DETAIL.bn[55] = 8;
        DETAIL.bn[56] = 8;
        DETAIL.bn[57] = 9;
        DETAIL.bn[58] = 9;
        DETAIL.kn[13] = 3;
        DETAIL.kn[14] = 2;
        DETAIL.kn[15] = 2;
        DETAIL.kn[16] = 2;
        DETAIL.kn[17] = 4;
        DETAIL.kn[18] = 4;
        DETAIL.kn[21] = 2;
        DETAIL.kn[22] = 2;
        DETAIL.kn[23] = 2;
        DETAIL.kn[24] = 4;
        DETAIL.kn[25] = 4;
        DETAIL.kn[26] = 4;
        DETAIL.kn[27] = 4;
        DETAIL.kn[29] = 1;
        DETAIL.kn[30] = 1;
        DETAIL.kn[31] = 2;
        DETAIL.kn[32] = 2;
        DETAIL.kn[33] = 3;
        DETAIL.kn[34] = 3;
        DETAIL.kn[35] = 4;
        DETAIL.kn[36] = 4;
        DETAIL.kn[37] = 4;
        DETAIL.kn[40] = 2;
        DETAIL.kn[41] = 2;
        DETAIL.kn[42] = 2;
        DETAIL.kn[43] = 4;
        DETAIL.kn[44] = 4;
        DETAIL.kn[46] = 2;
        DETAIL.kn[47] = 2;
        DETAIL.kn[48] = 4;
        DETAIL.kn[49] = 4;
        DETAIL.kn[51] = 2;
        DETAIL.kn[53] = 2;
        DETAIL.kn[54] = 1;
        DETAIL.kn[55] = 2;
        DETAIL.kn[56] = 2;
        DETAIL.kn[57] = 2;
        DETAIL.kn[58] = 2;
        DETAIL.un[1] = 0.0;
        DETAIL.un[2] = 0.5;
        DETAIL.un[3] = 1.0;
        DETAIL.un[4] = 3.5;
        DETAIL.un[5] = -0.5;
        DETAIL.un[6] = 4.5;
        DETAIL.un[7] = 0.5;
        DETAIL.un[8] = 7.5;
        DETAIL.un[9] = 9.5;
        DETAIL.un[10] = 6.0;
        DETAIL.un[11] = 12.0;
        DETAIL.un[12] = 12.5;
        DETAIL.un[13] = -6.0;
        DETAIL.un[14] = 2.0;
        DETAIL.un[15] = 3.0;
        DETAIL.un[16] = 2.0;
        DETAIL.un[17] = 2.0;
        DETAIL.un[18] = 11.0;
        DETAIL.un[19] = -0.5;
        DETAIL.un[20] = 0.5;
        DETAIL.un[21] = 0.0;
        DETAIL.un[22] = 4.0;
        DETAIL.un[23] = 6.0;
        DETAIL.un[24] = 21.0;
        DETAIL.un[25] = 23.0;
        DETAIL.un[26] = 22.0;
        DETAIL.un[27] = -1.0;
        DETAIL.un[28] = -0.5;
        DETAIL.un[29] = 7.0;
        DETAIL.un[30] = -1.0;
        DETAIL.un[31] = 6.0;
        DETAIL.un[32] = 4.0;
        DETAIL.un[33] = 1.0;
        DETAIL.un[34] = 9.0;
        DETAIL.un[35] = -13.0;
        DETAIL.un[36] = 21.0;
        DETAIL.un[37] = 8.0;
        DETAIL.un[38] = -0.5;
        DETAIL.un[39] = 0.0;
        DETAIL.un[40] = 2.0;
        DETAIL.un[41] = 7.0;
        DETAIL.un[42] = 9.0;
        DETAIL.un[43] = 22.0;
        DETAIL.un[44] = 23.0;
        DETAIL.un[45] = 1.0;
        DETAIL.un[46] = 9.0;
        DETAIL.un[47] = 3.0;
        DETAIL.un[48] = 8.0;
        DETAIL.un[49] = 23.0;
        DETAIL.un[50] = 1.5;
        DETAIL.un[51] = 5.0;
        DETAIL.un[52] = -0.5;
        DETAIL.un[53] = 4.0;
        DETAIL.un[54] = 7.0;
        DETAIL.un[55] = 3.0;
        DETAIL.un[56] = 0.0;
        DETAIL.un[57] = 1.0;
        DETAIL.un[58] = 0.0;
        DETAIL.fn[13] = 1;
        DETAIL.fn[27] = 1;
        DETAIL.fn[30] = 1;
        DETAIL.fn[35] = 1;
        DETAIL.gn[5] = 1;
        DETAIL.gn[6] = 1;
        DETAIL.gn[25] = 1;
        DETAIL.gn[29] = 1;
        DETAIL.gn[32] = 1;
        DETAIL.gn[33] = 1;
        DETAIL.gn[34] = 1;
        DETAIL.gn[51] = 1;
        DETAIL.gn[54] = 1;
        DETAIL.gn[56] = 1;
        DETAIL.qn[7] = 1;
        DETAIL.qn[16] = 1;
        DETAIL.qn[26] = 1;
        DETAIL.qn[28] = 1;
        DETAIL.qn[37] = 1;
        DETAIL.qn[42] = 1;
        DETAIL.qn[47] = 1;
        DETAIL.qn[49] = 1;
        DETAIL.qn[52] = 1;
        DETAIL.qn[58] = 1;
        sn[8] = 1;
        sn[9] = 1;
        wn[10] = 1;
        wn[11] = 1;
        wn[12] = 1;
        Ei[1] = 151.3183;
        Ei[2] = 99.73778;
        Ei[3] = 241.9606;
        Ei[4] = 244.1667;
        Ei[5] = 298.1183;
        Ei[6] = 324.0689;
        Ei[7] = 337.6389;
        Ei[8] = 365.5999;
        Ei[9] = 370.6823;
        Ei[10] = 402.636293;
        Ei[11] = 427.72263;
        Ei[12] = 450.325022;
        Ei[13] = 470.840891;
        Ei[14] = 489.558373;
        Ei[15] = 26.95794;
        Ei[16] = 122.7667;
        Ei[17] = 105.5348;
        Ei[18] = 514.0156;
        Ei[19] = 296.355;
        Ei[20] = 2.610111;
        Ei[21] = 119.6299;
        Ki[1] = 0.4619255;
        Ki[2] = 0.4479153;
        Ki[3] = 0.4557489;
        Ki[4] = 0.5279209;
        Ki[5] = 0.583749;
        Ki[6] = 0.6406937;
        Ki[7] = 0.6341423;
        Ki[8] = 0.6738577;
        Ki[9] = 0.6798307;
        Ki[10] = 0.7175118;
        Ki[11] = 0.7525189;
        Ki[12] = 0.784955;
        Ki[13] = 0.8152731;
        Ki[14] = 0.8437826;
        Ki[15] = 0.3514916;
        Ki[16] = 0.4186954;
        Ki[17] = 0.4533894;
        Ki[18] = 0.3825868;
        Ki[19] = 0.4618263;
        Ki[20] = 0.3589888;
        Ki[21] = 0.4216551;
        DETAIL.Gi[2] = 0.027815;
        DETAIL.Gi[3] = 0.189065;
        DETAIL.Gi[4] = 0.0793;
        DETAIL.Gi[5] = 0.141239;
        DETAIL.Gi[6] = 0.256692;
        DETAIL.Gi[7] = 0.281835;
        DETAIL.Gi[8] = 0.332267;
        DETAIL.Gi[9] = 0.366911;
        DETAIL.Gi[10] = 0.289731;
        DETAIL.Gi[11] = 0.337542;
        DETAIL.Gi[12] = 0.383381;
        DETAIL.Gi[13] = 0.427354;
        DETAIL.Gi[14] = 0.469659;
        DETAIL.Gi[15] = 0.034369;
        DETAIL.Gi[16] = 0.021;
        DETAIL.Gi[17] = 0.038953;
        DETAIL.Gi[18] = 0.3325;
        DETAIL.Gi[19] = 0.0885;
        DETAIL.Qi[3] = 0.69;
        DETAIL.Qi[18] = 1.06775;
        DETAIL.Qi[19] = 0.633276;
        DETAIL.Fi[15] = 1.0;
        Si[18] = 1.5822;
        Si[19] = 0.39;
        Wi[18] = 1.0;
        Eij[1][2] = 0.97164;
        Eij[1][3] = 0.960644;
        Eij[1][5] = 0.994635;
        Eij[1][6] = 1.01953;
        Eij[1][7] = 0.989844;
        Eij[1][8] = 1.00235;
        Eij[1][9] = 0.999268;
        Eij[1][10] = 1.107274;
        Eij[1][11] = 0.88088;
        Eij[1][12] = 0.880973;
        Eij[1][13] = 0.881067;
        Eij[1][14] = 0.881161;
        Eij[1][15] = 1.17052;
        Eij[1][17] = 0.990126;
        Eij[1][18] = 0.708218;
        Eij[1][19] = 0.931484;
        Eij[2][3] = 1.02274;
        Eij[2][4] = 0.97012;
        Eij[2][5] = 0.945939;
        Eij[2][6] = 0.946914;
        Eij[2][7] = 0.973384;
        Eij[2][8] = 0.95934;
        Eij[2][9] = 0.94552;
        Eij[2][15] = 1.08632;
        Eij[2][16] = 1.021;
        Eij[2][17] = 1.00571;
        Eij[2][18] = 0.746954;
        Eij[2][19] = 0.902271;
        Eij[3][4] = 0.925053;
        Eij[3][5] = 0.960237;
        Eij[3][6] = 0.906849;
        Eij[3][7] = 0.897362;
        Eij[3][8] = 0.726255;
        Eij[3][9] = 0.859764;
        Eij[3][10] = 0.855134;
        Eij[3][11] = 0.831229;
        Eij[3][12] = 0.80831;
        Eij[3][13] = 0.786323;
        Eij[3][14] = 0.765171;
        Eij[3][15] = 1.28179;
        Eij[3][17] = 1.5;
        Eij[3][18] = 0.849408;
        Eij[3][19] = 0.955052;
        Eij[4][5] = 1.02256;
        Eij[4][7] = 1.01306;
        Eij[4][9] = 1.00532;
        Eij[4][15] = 1.16446;
        Eij[4][18] = 0.693168;
        Eij[4][19] = 0.946871;
        Eij[5][7] = 1.0049;
        Eij[5][15] = 1.034787;
        Eij[6][15] = 1.3;
        Eij[7][15] = 1.3;
        Eij[10][19] = 1.008692;
        Eij[11][19] = 1.010126;
        Eij[12][19] = 1.011501;
        Eij[13][19] = 1.012821;
        Eij[14][19] = 1.014089;
        Eij[15][17] = 1.1;
        Uij[1][2] = 0.886106;
        Uij[1][3] = 0.963827;
        Uij[1][5] = 0.990877;
        Uij[1][7] = 0.992291;
        Uij[1][9] = 1.00367;
        Uij[1][10] = 1.302576;
        Uij[1][11] = 1.191904;
        Uij[1][12] = 1.205769;
        Uij[1][13] = 1.219634;
        Uij[1][14] = 1.233498;
        Uij[1][15] = 1.15639;
        Uij[1][19] = 0.736833;
        Uij[2][3] = 0.835058;
        Uij[2][4] = 0.816431;
        Uij[2][5] = 0.915502;
        Uij[2][7] = 0.993556;
        Uij[2][15] = 0.408838;
        Uij[2][19] = 0.993476;
        Uij[3][4] = 0.96987;
        Uij[3][10] = 1.066638;
        Uij[3][11] = 1.077634;
        Uij[3][12] = 1.088178;
        Uij[3][13] = 1.098291;
        Uij[3][14] = 1.108021;
        Uij[3][17] = 0.9;
        Uij[3][19] = 1.04529;
        Uij[4][5] = 1.065173;
        Uij[4][6] = 1.25;
        Uij[4][7] = 1.25;
        Uij[4][8] = 1.25;
        Uij[4][9] = 1.25;
        Uij[4][15] = 1.61666;
        Uij[4][19] = 0.971926;
        Uij[10][19] = 1.028973;
        Uij[11][19] = 1.033754;
        Uij[12][19] = 1.038338;
        Uij[13][19] = 1.042735;
        Uij[14][19] = 1.046966;
        Kij[1][2] = 1.00363;
        Kij[1][3] = 0.995933;
        Kij[1][5] = 1.007619;
        Kij[1][7] = 0.997596;
        Kij[1][9] = 1.002529;
        Kij[1][10] = 0.982962;
        Kij[1][11] = 0.983565;
        Kij[1][12] = 0.982707;
        Kij[1][13] = 0.981849;
        Kij[1][14] = 0.980991;
        Kij[1][15] = 1.02326;
        Kij[1][19] = 1.00008;
        Kij[2][3] = 0.982361;
        Kij[2][4] = 1.00796;
        Kij[2][15] = 1.03227;
        Kij[2][19] = 0.942596;
        Kij[3][4] = 1.00851;
        Kij[3][10] = 0.910183;
        Kij[3][11] = 0.895362;
        Kij[3][12] = 0.881152;
        Kij[3][13] = 0.86752;
        Kij[3][14] = 0.854406;
        Kij[3][19] = 1.00779;
        Kij[4][5] = 0.986893;
        Kij[4][15] = 1.02034;
        Kij[4][19] = 0.999969;
        Kij[10][19] = 0.96813;
        Kij[11][19] = 0.96287;
        Kij[12][19] = 0.957828;
        Kij[13][19] = 0.952441;
        Kij[14][19] = 0.948338;
        Gij[1][3] = 0.807653;
        Gij[1][15] = 1.95731;
        Gij[2][3] = 0.982746;
        Gij[3][4] = 0.370296;
        Gij[3][18] = 1.67309;
        DETAIL.n0i[1][3] = 4.00088;
        DETAIL.n0i[1][4] = 0.76315;
        DETAIL.n0i[1][5] = 0.0046;
        DETAIL.n0i[1][6] = 8.74432;
        DETAIL.n0i[1][7] = -4.46921;
        DETAIL.n0i[1][1] = 29.83843397;
        DETAIL.n0i[1][2] = -15999.69151;
        DETAIL.n0i[2][3] = 3.50031;
        DETAIL.n0i[2][4] = 0.13732;
        DETAIL.n0i[2][5] = -0.1466;
        DETAIL.n0i[2][6] = 0.90066;
        DETAIL.n0i[2][7] = 0.0;
        DETAIL.n0i[2][1] = 17.56770785;
        DETAIL.n0i[2][2] = -2801.729072;
        DETAIL.n0i[3][3] = 3.50002;
        DETAIL.n0i[3][4] = 2.04452;
        DETAIL.n0i[3][5] = -1.06044;
        DETAIL.n0i[3][6] = 2.03366;
        DETAIL.n0i[3][7] = 0.01393;
        DETAIL.n0i[3][1] = 20.65844696;
        DETAIL.n0i[3][2] = -4902.171516;
        DETAIL.n0i[4][3] = 4.00263;
        DETAIL.n0i[4][4] = 4.33939;
        DETAIL.n0i[4][5] = 1.23722;
        DETAIL.n0i[4][6] = 13.1974;
        DETAIL.n0i[4][7] = -6.01989;
        DETAIL.n0i[4][1] = 36.73005938;
        DETAIL.n0i[4][2] = -23639.65301;
        DETAIL.n0i[5][3] = 4.02939;
        DETAIL.n0i[5][4] = 6.60569;
        DETAIL.n0i[5][5] = 3.197;
        DETAIL.n0i[5][6] = 19.1921;
        DETAIL.n0i[5][7] = -8.37267;
        DETAIL.n0i[5][1] = 44.70909619;
        DETAIL.n0i[5][2] = -31236.63551;
        DETAIL.n0i[6][3] = 4.06714;
        DETAIL.n0i[6][4] = 8.97575;
        DETAIL.n0i[6][5] = 5.25156;
        DETAIL.n0i[6][6] = 25.1423;
        DETAIL.n0i[6][7] = 16.1388;
        DETAIL.n0i[6][1] = 34.30180349;
        DETAIL.n0i[6][2] = -38525.50276;
        DETAIL.n0i[7][3] = 4.33944;
        DETAIL.n0i[7][4] = 9.44893;
        DETAIL.n0i[7][5] = 6.89406;
        DETAIL.n0i[7][6] = 24.4618;
        DETAIL.n0i[7][7] = 14.7824;
        DETAIL.n0i[7][1] = 36.53237783;
        DETAIL.n0i[7][2] = -38957.80933;
        DETAIL.n0i[8][3] = 4.0;
        DETAIL.n0i[8][4] = 11.7618;
        DETAIL.n0i[8][5] = 20.1101;
        DETAIL.n0i[8][6] = 33.1688;
        DETAIL.n0i[8][7] = 0.0;
        DETAIL.n0i[8][1] = 43.17218626;
        DETAIL.n0i[8][2] = -51198.30946;
        DETAIL.n0i[9][3] = 4.0;
        DETAIL.n0i[9][4] = 8.95043;
        DETAIL.n0i[9][5] = 21.836;
        DETAIL.n0i[9][6] = 33.4032;
        DETAIL.n0i[9][7] = 0.0;
        DETAIL.n0i[9][1] = 42.67837089;
        DETAIL.n0i[9][2] = -45215.83;
        DETAIL.n0i[10][3] = 4.0;
        DETAIL.n0i[10][4] = 11.6977;
        DETAIL.n0i[10][5] = 26.8142;
        DETAIL.n0i[10][6] = 38.6164;
        DETAIL.n0i[10][7] = 0.0;
        DETAIL.n0i[10][1] = 46.99717188;
        DETAIL.n0i[10][2] = -52746.83318;
        DETAIL.n0i[11][3] = 4.0;
        DETAIL.n0i[11][4] = 13.7266;
        DETAIL.n0i[11][5] = 30.4707;
        DETAIL.n0i[11][6] = 43.5561;
        DETAIL.n0i[11][7] = 0.0;
        DETAIL.n0i[11][1] = 52.07631631;
        DETAIL.n0i[11][2] = -57104.81056;
        DETAIL.n0i[12][3] = 4.0;
        DETAIL.n0i[12][4] = 15.6865;
        DETAIL.n0i[12][5] = 33.8029;
        DETAIL.n0i[12][6] = 48.1731;
        DETAIL.n0i[12][7] = 0.0;
        DETAIL.n0i[12][1] = 57.25830934;
        DETAIL.n0i[12][2] = -60546.76385;
        DETAIL.n0i[13][3] = 4.0;
        DETAIL.n0i[13][4] = 18.0241;
        DETAIL.n0i[13][5] = 38.1235;
        DETAIL.n0i[13][6] = 53.3415;
        DETAIL.n0i[13][7] = 0.0;
        DETAIL.n0i[13][1] = 62.09646901;
        DETAIL.n0i[13][2] = -66600.12837;
        DETAIL.n0i[14][3] = 4.0;
        DETAIL.n0i[14][4] = 21.0069;
        DETAIL.n0i[14][5] = 43.4931;
        DETAIL.n0i[14][6] = 58.3657;
        DETAIL.n0i[14][7] = 0.0;
        DETAIL.n0i[14][1] = 65.93909154;
        DETAIL.n0i[14][2] = -74131.45483;
        DETAIL.n0i[15][3] = 2.47906;
        DETAIL.n0i[15][4] = 0.95806;
        DETAIL.n0i[15][5] = 0.45444;
        DETAIL.n0i[15][6] = 1.56039;
        DETAIL.n0i[15][7] = -1.3756;
        DETAIL.n0i[15][1] = 13.07520288;
        DETAIL.n0i[15][2] = -5836.943696;
        DETAIL.n0i[16][3] = 3.50146;
        DETAIL.n0i[16][4] = 1.07558;
        DETAIL.n0i[16][5] = 1.01334;
        DETAIL.n0i[16][6] = 0.0;
        DETAIL.n0i[16][7] = 0.0;
        DETAIL.n0i[16][1] = 16.8017173;
        DETAIL.n0i[16][2] = -2318.32269;
        DETAIL.n0i[17][3] = 3.50055;
        DETAIL.n0i[17][4] = 1.02865;
        DETAIL.n0i[17][5] = 0.00493;
        DETAIL.n0i[17][6] = 0.0;
        DETAIL.n0i[17][7] = 0.0;
        DETAIL.n0i[17][1] = 17.45786899;
        DETAIL.n0i[17][2] = -2635.244116;
        DETAIL.n0i[18][3] = 4.00392;
        DETAIL.n0i[18][4] = 0.01059;
        DETAIL.n0i[18][5] = 0.98763;
        DETAIL.n0i[18][6] = 3.06904;
        DETAIL.n0i[18][7] = 0.0;
        DETAIL.n0i[18][1] = 21.57882705;
        DETAIL.n0i[18][2] = -7766.733078;
        DETAIL.n0i[19][3] = 4.0;
        DETAIL.n0i[19][4] = 3.11942;
        DETAIL.n0i[19][5] = 1.00243;
        DETAIL.n0i[19][6] = 0.0;
        DETAIL.n0i[19][7] = 0.0;
        DETAIL.n0i[19][1] = 21.5830944;
        DETAIL.n0i[19][2] = -6069.035869;
        DETAIL.n0i[20][3] = 2.5;
        DETAIL.n0i[20][4] = 0.0;
        DETAIL.n0i[20][5] = 0.0;
        DETAIL.n0i[20][6] = 0.0;
        DETAIL.n0i[20][7] = 0.0;
        DETAIL.n0i[20][1] = 10.04639507;
        DETAIL.n0i[20][2] = -745.375;
        DETAIL.n0i[21][3] = 2.5;
        DETAIL.n0i[21][4] = 0.0;
        DETAIL.n0i[21][5] = 0.0;
        DETAIL.n0i[21][6] = 0.0;
        DETAIL.n0i[21][7] = 0.0;
        DETAIL.n0i[21][1] = 10.04639507;
        DETAIL.n0i[21][2] = -745.375;
        DETAIL.th0i[1][4] = 820.659;
        DETAIL.th0i[1][5] = 178.41;
        DETAIL.th0i[1][6] = 1062.82;
        DETAIL.th0i[1][7] = 1090.53;
        DETAIL.th0i[2][4] = 662.738;
        DETAIL.th0i[2][5] = 680.562;
        DETAIL.th0i[2][6] = 1740.06;
        DETAIL.th0i[2][7] = 0.0;
        DETAIL.th0i[3][4] = 919.306;
        DETAIL.th0i[3][5] = 865.07;
        DETAIL.th0i[3][6] = 483.553;
        DETAIL.th0i[3][7] = 341.109;
        DETAIL.th0i[4][4] = 559.314;
        DETAIL.th0i[4][5] = 223.284;
        DETAIL.th0i[4][6] = 1031.38;
        DETAIL.th0i[4][7] = 1071.29;
        DETAIL.th0i[5][4] = 479.856;
        DETAIL.th0i[5][5] = 200.893;
        DETAIL.th0i[5][6] = 955.312;
        DETAIL.th0i[5][7] = 1027.29;
        DETAIL.th0i[6][4] = 438.27;
        DETAIL.th0i[6][5] = 198.018;
        DETAIL.th0i[6][6] = 1905.02;
        DETAIL.th0i[6][7] = 893.765;
        DETAIL.th0i[7][4] = 468.27;
        DETAIL.th0i[7][5] = 183.636;
        DETAIL.th0i[7][6] = 1914.1;
        DETAIL.th0i[7][7] = 903.185;
        DETAIL.th0i[8][4] = 292.503;
        DETAIL.th0i[8][5] = 910.237;
        DETAIL.th0i[8][6] = 1919.37;
        DETAIL.th0i[8][7] = 0.0;
        DETAIL.th0i[9][4] = 178.67;
        DETAIL.th0i[9][5] = 840.538;
        DETAIL.th0i[9][6] = 1774.25;
        DETAIL.th0i[9][7] = 0.0;
        DETAIL.th0i[10][4] = 182.326;
        DETAIL.th0i[10][5] = 859.207;
        DETAIL.th0i[10][6] = 1826.59;
        DETAIL.th0i[10][7] = 0.0;
        DETAIL.th0i[11][4] = 169.789;
        DETAIL.th0i[11][5] = 836.195;
        DETAIL.th0i[11][6] = 1760.46;
        DETAIL.th0i[11][7] = 0.0;
        DETAIL.th0i[12][4] = 158.922;
        DETAIL.th0i[12][5] = 815.064;
        DETAIL.th0i[12][6] = 1693.07;
        DETAIL.th0i[12][7] = 0.0;
        DETAIL.th0i[13][4] = 156.854;
        DETAIL.th0i[13][5] = 814.882;
        DETAIL.th0i[13][6] = 1693.79;
        DETAIL.th0i[13][7] = 0.0;
        DETAIL.th0i[14][4] = 164.947;
        DETAIL.th0i[14][5] = 836.264;
        DETAIL.th0i[14][6] = 1750.24;
        DETAIL.th0i[14][7] = 0.0;
        DETAIL.th0i[15][4] = 228.734;
        DETAIL.th0i[15][5] = 326.843;
        DETAIL.th0i[15][6] = 1651.71;
        DETAIL.th0i[15][7] = 1671.69;
        DETAIL.th0i[16][4] = 2235.71;
        DETAIL.th0i[16][5] = 1116.69;
        DETAIL.th0i[16][6] = 0.0;
        DETAIL.th0i[16][7] = 0.0;
        DETAIL.th0i[17][4] = 1550.45;
        DETAIL.th0i[17][5] = 704.525;
        DETAIL.th0i[17][6] = 0.0;
        DETAIL.th0i[17][7] = 0.0;
        DETAIL.th0i[18][4] = 268.795;
        DETAIL.th0i[18][5] = 1141.41;
        DETAIL.th0i[18][6] = 2507.37;
        DETAIL.th0i[18][7] = 0.0;
        DETAIL.th0i[19][4] = 1833.63;
        DETAIL.th0i[19][5] = 847.181;
        DETAIL.th0i[19][6] = 0.0;
        DETAIL.th0i[19][7] = 0.0;
        DETAIL.th0i[20][4] = 0.0;
        DETAIL.th0i[20][5] = 0.0;
        DETAIL.th0i[20][6] = 0.0;
        DETAIL.th0i[20][7] = 0.0;
        DETAIL.th0i[21][4] = 0.0;
        DETAIL.th0i[21][5] = 0.0;
        DETAIL.th0i[21][6] = 0.0;
        DETAIL.th0i[21][7] = 0.0;
        i = 1;
        while (i <= MaxFlds) {
            DETAIL.Ki25[i] = Math.pow(Ki[i], 2.5);
            DETAIL.Ei25[i] = Math.pow(Ei[i], 2.5);
            ++i;
        }
        i = 1;
        while (i <= MaxFlds) {
            j = i;
            while (j <= MaxFlds) {
                int n = 1;
                while (n <= 18) {
                    double Bsnij = 1.0;
                    if (gn[n] == 1) {
                        Bsnij = Gij[i][j] * (Gi[i] + Gi[j]) / 2.0;
                    }
                    if (qn[n] == 1) {
                        Bsnij = Bsnij * Qi[i] * Qi[j];
                    }
                    if (fn[n] == 1) {
                        Bsnij = Bsnij * Fi[i] * Fi[j];
                    }
                    if (sn[n] == 1) {
                        Bsnij = Bsnij * Si[i] * Si[j];
                    }
                    if (wn[n] == 1) {
                        Bsnij = Bsnij * Wi[i] * Wi[j];
                    }
                    DETAIL.Bsnij2[i][j][n] = an[n] * Math.pow(Eij[i][j] * Math.sqrt(Ei[i] * Ei[j]), un[n]) * Math.pow(Ki[i] * Ki[j], 1.5) * Bsnij;
                    ++n;
                }
                DETAIL.Kij5[i][j] = (Math.pow(Kij[i][j], 5.0) - 1.0) * Ki25[i] * Ki25[j];
                DETAIL.Uij5[i][j] = (Math.pow(Uij[i][j], 5.0) - 1.0) * Ei25[i] * Ei25[j];
                DETAIL.Gij5[i][j] = (Gij[i][j] - 1.0) * (Gi[i] + Gi[j]) / 2.0;
                ++j;
            }
            ++i;
        }
        double d0 = 101.325 / RDetail / 298.15;
        i = 1;
        while (i <= MaxFlds) {
            DETAIL.n0i[i][3] = n0i[i][3] - 1.0;
            DETAIL.n0i[i][1] = n0i[i][1] - Math.log(d0);
            ++i;
        }
    }

    public static void main(String[] args) {
        DETAIL test2 = new DETAIL();
        DETAIL.SetupDetail();
        double T = 400.0;
        doubleW D = new doubleW(0.0);
        doubleW P = new doubleW(50000.0);
        intW ierr = new intW(0);
        doubleW Mm = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        boolean iFlag = false;
        StringW herr = new StringW("");
        double[] x = new double[]{0.0, 0.77824, 0.02, 0.06, 0.08, 0.03, 0.0015, 0.003, 5.0E-4, 0.00165, 0.00215, 8.8E-4, 2.4E-4, 1.5E-4, 9.0E-5, 0.004, 0.005, 0.002, 1.0E-4, 0.0025, 0.007, 0.001};
        DETAIL.MolarMassDetail(x, Mm);
        System.out.println("mol mass " + Mm.val);
        DETAIL.DensityDetail(T, P.val, x, D, ierr, herr);
        System.out.println("density " + D.val);
        DETAIL.PressureDetail(T, D.val, x, P, Z);
        System.out.println("pressure " + P.val);
        System.out.println("Z " + Z.val);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        DETAIL.PropertiesDetail(T, D.val, x, P, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa);
        System.out.println("JT " + JT.val);
        System.out.println("Kappa " + Kappa.val);
    }
}

