/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentPCSAFT;
import neqsim.thermo.phase.PhasePCSAFT;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhasePCSAFTRahmat
extends PhasePCSAFT {
    private static final long serialVersionUID = 1000L;
    double nSAFT = 1.0;
    double dnSAFTdV = 1.0;
    double dnSAFTdVdV = 1.0;
    double dnSAFTdVdVdV = 1.0;
    double dmeanSAFT = 0.0;
    double dSAFT = 1.0;
    double mSAFT = 1.0;
    double mdSAFT = 1.0;
    double nmSAFT = 1.0;
    double mmin1SAFT = 1.0;
    double ghsSAFT = 1.0;
    double aHSSAFT = 1.0;
    double volumeSAFT = 1.0;
    double daHCSAFTdN = 1.0;
    double daHSSAFTdN = 1.0;
    double dgHSSAFTdN = 1.0;
    double daHSSAFTdNdN = 1.0;
    double dgHSSAFTdNdN = 1.0;
    double daHSSAFTdNdNdN = 1.0;
    double dgHSSAFTdNdNdN = 1.0;
    double dNSAFTdT = 1.0;
    double dF1dispVolTermdT = 0.0;
    double dF1dispI1dT = 1.0;
    double dF2dispI2dT = 1.0;
    double dF2dispZHCdT = 1.0;
    double dF1dispSumTermdT = 1.0;
    double dF2dispSumTermdT = 1.0;
    int useHS = 1;
    int useDISP1 = 1;
    int useDISP2 = 1;
    private double[][] aConstSAFT = new double[][]{{0.9105631445, 0.6361281449, 2.6861347891, -26.547362491, 97.759208784, -159.59154087, 91.297774084}, {-0.3084016918, 0.1860531159, -2.5030047259, 21.419793629, -65.25588533, 83.318680481, -33.74692293}, {-0.0906148351, 0.4527842806, 0.5962700728, -1.7241829131, -4.1302112531, 13.77663187, -8.6728470368}};
    private double[][] bConstSAFT = new double[][]{{0.7240946941, 2.2382791861, -4.0025849485, -21.003576815, 26.855641363, 206.55133841, -355.60235612}, {-0.5755498075, 0.6995095521, 3.892567339, -17.215471648, 192.67226447, -161.82646165, -165.20769346}, {0.0976883116, -0.2557574982, -9.155856153, 20.642075974, -38.804430052, 93.626774077, -29.666905585}};
    private double F1dispVolTerm = 1.0;
    private double F1dispSumTerm = 1.0;
    private double F1dispI1 = 1.0;
    private double F2dispI2 = 1.0;
    private double F2dispZHC = 1.0;
    private double F2dispZHCdN = 1.0;
    private double F2dispZHCdm = 1.0;
    private double F2dispZHCdV = 1.0;
    private double F2dispI2dVdV;
    private double F2dispI2dVdVdV = 0.0;
    private double F2dispZHCdVdV = 1.0;
    private double F2dispZHCdVdVdV = 1.0;
    private double F1dispI1dNdN = 1.0;
    private double F1dispI1dNdNdN = 1.0;
    private double F1dispVolTermdV = 1.0;
    private double F1dispVolTermdVdV = 1.0;
    private double F1dispI1dN = 1.0;
    private double F1dispI1dm = 1.0;
    private double F1dispI1dV = 1.0;
    private double F2dispI2dV = 1.0;
    private double F2dispI2dN = 1.0;
    private double F2dispI2dm = 1.0;
    private double F2dispSumTerm = 0.0;
    private double F2dispZHCdNdN = 1.0;
    private double F2dispZHCdNdNdN = 1.0;
    private double F2dispI2dNdN = 1.0;
    private double F2dispI2dNdNdN = 1.0;
    private double F1dispI1dVdV = 1.0;
    private double F1dispI1dVdVdV = 1.0;
    private double F1dispVolTermdVdVdV = 1.0;
    static Logger logger = LogManager.getLogger(PhasePCSAFTRahmat.class);

    @Override
    public PhasePCSAFTRahmat clone() {
        PhasePCSAFTRahmat clonedPhase = null;
        try {
            clonedPhase = (PhasePCSAFTRahmat)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedPhase;
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentPCSAFT(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        int i = 0;
        while (i < numberOfComponents) {
            this.componentArray[i].Finit(this, this.temperature, this.pressure, totalNumberOfMoles, beta, numberOfComponents, type);
            ++i;
        }
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
    }

    @Override
    public void volInit() {
        this.volumeSAFT = this.getVolume() * 1.0E-5;
        this.setDmeanSAFT(this.calcdmeanSAFT());
        this.setDSAFT(this.calcdSAFT());
        this.setNSAFT(3.1536354218250004E23 * this.getNumberOfMolesInPhase() / this.volumeSAFT * this.getDSAFT());
        this.dnSAFTdV = -3.1536354218250004E23 * this.getNumberOfMolesInPhase() / Math.pow(this.volumeSAFT, 2.0) * this.getDSAFT();
        this.dnSAFTdVdV = 6.307270843650001E23 * this.getNumberOfMolesInPhase() / Math.pow(this.volumeSAFT, 3.0) * this.getDSAFT();
        this.dnSAFTdVdVdV = -1.892181253095E24 * this.getNumberOfMolesInPhase() / Math.pow(this.volumeSAFT, 4.0) * this.getDSAFT();
        this.dNSAFTdT = 3.1536354218250004E23 * this.getNumberOfMolesInPhase() / this.volumeSAFT * this.getdDSAFTdT();
        this.setGhsSAFT((1.0 - this.nSAFT / 2.0) / Math.pow(1.0 - this.nSAFT, 3.0));
        this.setmSAFT(this.calcmSAFT());
        this.setMmin1SAFT(this.calcmmin1SAFT());
        this.setmdSAFT(this.calcmdSAFT());
        this.setAHSSAFT((4.0 * this.getNSAFT() - 3.0 * Math.pow(this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 2.0));
        this.daHSSAFTdN = ((4.0 - 6.0 * this.getNSAFT()) * Math.pow(1.0 - this.getNSAFT(), 2.0) - (4.0 * this.getNSAFT() - 3.0 * Math.pow(this.getNSAFT(), 2.0)) * 2.0 * (1.0 - this.getNSAFT()) * -1.0) / Math.pow(1.0 - this.getNSAFT(), 4.0);
        this.daHSSAFTdNdN = (-6.0 * Math.pow(1.0 - this.getNSAFT(), 2.0) + 2.0 * (1.0 - this.getNSAFT()) * (4.0 - 6.0 * this.getNSAFT())) / Math.pow(1.0 - this.getNSAFT(), 4.0) + ((8.0 - 12.0 * this.getNSAFT()) * Math.pow(1.0 - this.getNSAFT(), 3.0) + (8.0 - 6.0 * Math.pow(this.getNSAFT(), 2.0)) * 3.0 * Math.pow(1.0 - this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 6.0);
        this.daHSSAFTdNdNdN = -36.0 / Math.pow(1.0 - this.getNSAFT(), 3.0) + 18.0 * (4.0 - 6.0 * this.getNSAFT()) / Math.pow(1.0 - this.getNSAFT(), 4.0) + 24.0 * (4.0 * this.getNSAFT() - 3.0 * Math.pow(this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 5.0);
        this.dgHSSAFTdN = (-0.5 * Math.pow(1.0 - this.getNSAFT(), 3.0) - (1.0 - this.getNSAFT() / 2.0) * 3.0 * Math.pow(1.0 - this.nSAFT, 2.0) * -1.0) / Math.pow(1.0 - this.getNSAFT(), 6.0);
        this.dgHSSAFTdNdN = -1.5 * Math.pow(1.0 - this.getNSAFT(), 2.0) / Math.pow(1.0 - this.getNSAFT(), 6.0) + (-1.5 * Math.pow(1.0 - this.getNSAFT(), 4.0) + 4.0 * Math.pow(1.0 - this.getNSAFT(), 3.0) * (3.0 - 1.5 * this.getNSAFT())) / Math.pow(1.0 - this.getNSAFT(), 8.0);
        this.dgHSSAFTdNdNdN = -6.0 / Math.pow(1.0 - this.getNSAFT(), 5.0) - 12.0 * (3.0 - 1.5 * this.getNSAFT()) / Math.pow(1.0 - this.getNSAFT(), 6.0) + 8.0 * (-1.5 * Math.pow(1.0 - this.getNSAFT(), 4.0) + 4.0 * Math.pow(1.0 - this.getNSAFT(), 3.0) * (3.0 - 1.5 * this.getNSAFT())) / Math.pow(1.0 - this.getNSAFT(), 9.0);
        this.setF1dispVolTerm(6.023E23 * this.getNumberOfMolesInPhase() / this.getVolumeSAFT());
        this.F1dispSumTerm = this.calcF1dispSumTerm();
        this.F1dispI1 = this.calcF1dispI1();
        this.F1dispVolTermdV = -6.023E23 * this.getNumberOfMolesInPhase() / Math.pow(this.getVolumeSAFT(), 2.0);
        this.F1dispVolTermdVdV = 1.2046E24 * this.getNumberOfMolesInPhase() / Math.pow(this.getVolumeSAFT(), 3.0);
        this.F1dispVolTermdVdVdV = -3.6137999999999997E24 * this.getNumberOfMolesInPhase() / Math.pow(this.getVolumeSAFT(), 4.0);
        this.dF1dispI1dT = this.calcdF1dispI1dT();
        this.dF2dispI2dT = this.calcdF2dispI2dT();
        this.dF1dispSumTermdT = this.calcdF1dispSumTermdT();
        this.dF2dispSumTermdT = this.calcdF2dispSumTermdT();
        this.dF2dispZHCdT = this.calcdF2dispZHCdT();
        this.F1dispI1dN = this.calcF1dispI1dN();
        this.F1dispI1dNdN = this.calcF1dispI1dNdN();
        this.F1dispI1dNdNdN = this.calcF1dispI1dNdNdN();
        this.F1dispI1dm = this.calcF1dispI1dm();
        this.F1dispI1dV = this.F1dispI1dN * this.getDnSAFTdV();
        this.F1dispI1dVdV = this.F1dispI1dNdN * this.getDnSAFTdV() * this.getDnSAFTdV() + this.F1dispI1dN * this.dnSAFTdVdV;
        this.F1dispI1dVdVdV = this.F1dispI1dNdNdN * this.getDnSAFTdV() * this.getDnSAFTdV() * this.getDnSAFTdV() + this.F1dispI1dN * 2.0 * this.getDnSAFTdV() * this.dnSAFTdVdV + this.F1dispI1dNdN * this.dnSAFTdVdV + this.F1dispI1dN * this.dnSAFTdVdVdV;
        this.setF2dispSumTerm(this.calcF2dispSumTerm());
        this.setF2dispI2(this.calcF2dispI2());
        this.F2dispI2dN = this.calcF2dispI2dN();
        this.F2dispI2dNdN = this.calcF2dispI2dNdN();
        this.F2dispI2dNdNdN = this.calcF2dispI2dNdNdN();
        this.F2dispI2dm = this.calcF2dispI2dm();
        this.F2dispI2dV = this.F2dispI2dN * this.getDnSAFTdV();
        this.F2dispI2dVdV = this.F2dispI2dNdN * this.getDnSAFTdV() * this.getDnSAFTdV() + this.F2dispI2dN * this.dnSAFTdVdV;
        this.F2dispI2dVdVdV = this.F2dispI2dNdNdN * this.getDnSAFTdV() * this.getDnSAFTdV() * this.getDnSAFTdV() + this.F2dispI2dN * 2.0 * this.getDnSAFTdV() * this.dnSAFTdVdV + this.F2dispI2dNdN * this.dnSAFTdVdV + this.F2dispI2dN * this.dnSAFTdVdVdV;
        this.F2dispZHC = this.calcF2dispZHC();
        this.F2dispZHCdN = this.calcF2dispZHCdN();
        this.F2dispZHCdNdN = this.calcF2dispZHCdNdN();
        this.F2dispZHCdNdNdN = this.calcF2dispZHCdNdNdN();
        this.setF2dispZHCdm(this.calcF2dispZHCdm());
        this.F2dispZHCdV = this.F2dispZHCdN * this.getDnSAFTdV();
        this.F2dispZHCdVdV = this.F2dispZHCdNdN * this.getDnSAFTdV() * this.getDnSAFTdV() + this.F2dispZHCdN * this.dnSAFTdVdV;
        this.F2dispZHCdVdVdV = this.F2dispZHCdNdNdN * this.getDnSAFTdV() * this.getDnSAFTdV() * this.getDnSAFTdV() + this.F2dispZHCdNdN * 2.0 * this.getDnSAFTdV() * this.dnSAFTdVdV + this.F2dispZHCdNdN * this.dnSAFTdVdV + this.F2dispZHCdN * this.dnSAFTdVdVdV;
    }

    @Override
    public double calcF2dispZHC() {
        double temp = 1.0 + this.getmSAFT() * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 4.0) + (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / Math.pow((1.0 - this.getNSAFT()) * (2.0 - this.getNSAFT()), 2.0);
        return 1.0 / temp;
    }

    @Override
    public double calcF2dispZHCdm() {
        double temp = -Math.pow(this.F2dispZHC, 2.0);
        return temp * ((8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 4.0) - (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / Math.pow((1.0 - this.getNSAFT()) * (2.0 - this.getNSAFT()), 2.0));
    }

    @Override
    public double calcF2dispZHCdN() {
        double temp0 = -Math.pow(this.F2dispZHC, 2.0);
        double temp1 = Math.pow((1.0 - this.getNSAFT()) * (2.0 - this.getNSAFT()), 2.0);
        double temp2 = 20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0);
        return temp0 * (this.getmSAFT() * ((8.0 - 4.0 * this.getNSAFT()) * Math.pow(1.0 - this.getNSAFT(), 4.0) - 4.0 * Math.pow(1.0 - this.getNSAFT(), 3.0) * -1.0 * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0))) / Math.pow(1.0 - this.getNSAFT(), 8.0) + (1.0 - this.getmSAFT()) * ((20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0)) * temp1 - 2.0 * (2.0 - 3.0 * this.getNSAFT() + Math.pow(this.getNSAFT(), 2.0)) * (-3.0 + 2.0 * this.getNSAFT()) * temp2) / Math.pow(temp1, 2.0));
    }

    @Override
    public double calcF2dispZHCdNdN() {
        double temp0 = 2.0 * Math.pow(this.F2dispZHC, 3.0);
        double temp1 = Math.pow((1.0 - this.getNSAFT()) * (2.0 - this.getNSAFT()), 2.0);
        double temp11 = Math.pow((1.0 - this.getNSAFT()) * (2.0 - this.getNSAFT()), 3.0);
        double temp2 = 20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0);
        double temp1der = 2.0 * (2.0 - 3.0 * this.getNSAFT() + Math.pow(this.getNSAFT(), 2.0)) * (-3.0 + 2.0 * this.getNSAFT());
        double temp11der = 3.0 * Math.pow(2.0 - 3.0 * this.getNSAFT() + Math.pow(this.getNSAFT(), 2.0), 2.0) * (-3.0 + 2.0 * this.getNSAFT());
        double temp3 = this.getmSAFT() * ((8.0 - 4.0 * this.getNSAFT()) * Math.pow(1.0 - this.getNSAFT(), 4.0) - 4.0 * Math.pow(1.0 - this.getNSAFT(), 3.0) * -1.0 * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0))) / Math.pow(1.0 - this.getNSAFT(), 8.0) + (1.0 - this.getmSAFT()) * ((20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0)) * temp1 - 2.0 * (2.0 - 3.0 * this.getNSAFT() + Math.pow(this.getNSAFT(), 2.0)) * (-3.0 + 2.0 * this.getNSAFT()) * temp2) / Math.pow(temp1, 2.0);
        double temp4 = -Math.pow(this.F2dispZHC, 2.0);
        double dZdndn = this.getmSAFT() * ((-4.0 * Math.pow(1.0 - this.getNSAFT(), 4.0) - 4.0 * Math.pow(1.0 - this.getNSAFT(), 3.0) * -1.0 * (8.0 - 4.0 * this.getNSAFT())) / Math.pow(1.0 - this.getNSAFT(), 8.0) + ((32.0 - 16.0 * this.getNSAFT()) * Math.pow(1.0 - this.getNSAFT(), 5.0) - 5.0 * Math.pow(1.0 - this.getNSAFT(), 4.0) * -1.0 * (32.0 * this.getNSAFT() - 8.0 * Math.pow(this.getNSAFT(), 2.0))) / Math.pow(1.0 - this.getNSAFT(), 10.0)) + (1.0 - this.getmSAFT()) * (((-54.0 + 72.0 * this.getNSAFT() - 24.0 * Math.pow(this.getNSAFT(), 2.0)) * temp1 - temp1der * (20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0))) / Math.pow(temp1, 2.0) - ((-40.0 * Math.pow(this.getNSAFT(), 4.0) + 240.0 * Math.pow(this.getNSAFT(), 3.0) - 540.0 * Math.pow(this.getNSAFT(), 2.0) + 484.0 * this.getNSAFT() - 120.0) * temp11 - temp11der * (-8.0 * Math.pow(this.getNSAFT(), 5.0) + 60.0 * Math.pow(this.getNSAFT(), 4.0) - 180.0 * Math.pow(this.getNSAFT(), 3.0) + 242.0 * Math.pow(this.getNSAFT(), 2.0) - 120.0 * this.getNSAFT())) / Math.pow(temp11, 2.0));
        return temp0 * Math.pow(temp3, 2.0) + temp4 * dZdndn;
    }

    public double calcF2dispZHCdNdNdN() {
        double temp = -6.0 * Math.pow(this.getmSAFT() * (8.0 - 4.0 * this.getNSAFT()) / Math.pow(1.0 - this.getNSAFT(), 4.0) + 4.0 * this.getmSAFT() * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0) / Math.pow(1.0 - this.getNSAFT(), 5.0) + (1.0 - this.getmSAFT()) * (20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 2.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 3.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 2.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 3.0))), 3.0) / Math.pow(1.0 + this.getmSAFT() * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 4.0) + (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)), 4.0) + 6.0 * (this.getmSAFT() * (8.0 - 4.0 * this.getNSAFT()) / Math.pow(1.0 - this.getNSAFT(), 4.0) + 4.0 * this.getmSAFT() * (8.0 * this.getNSAFT() - Math.pow(2.0 * this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 5.0) + (1.0 - this.getmSAFT()) * (20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 2.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 3.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 2.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 3.0))) * (-4.0 * this.getmSAFT() / Math.pow(1.0 - this.getNSAFT(), 4.0) + 8.0 * this.getmSAFT() * (8.0 - 4.0 * this.getNSAFT()) / Math.pow(1.0 - this.getNSAFT(), 5.0) + 20.0 * this.getmSAFT() * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 6.0) + (1.0 - this.getmSAFT()) * (-54.0 + 72.0 * this.getNSAFT() - 24.0 * Math.pow(this.getNSAFT(), 2.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 4.0 * (1.0 - this.getmSAFT()) * (20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0)) / (Math.pow(1.0 - this.getNSAFT(), 3.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 4.0 * (1.0 - this.getmSAFT()) * (20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 3.0)) + 6.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 4.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 8.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 3.0) * Math.pow(2.0 - this.getNSAFT(), 3.0)) + 6.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 4.0))) / Math.pow(1.0 + this.getmSAFT() * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 4.0) + (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)), 3.0) - (-48.0 * this.getmSAFT() / Math.pow(1.0 - this.getNSAFT(), 5.0) + 60.0 * this.getmSAFT() * (8.0 - 4.0 * this.getNSAFT()) / Math.pow(1.0 - this.getNSAFT(), 6.0) + 120.0 * this.getmSAFT() * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 7.0) + (1.0 - this.getmSAFT()) * (72.0 - 48.0 * this.getNSAFT()) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 6.0 * (1.0 - this.getmSAFT()) * (-54.0 + 72.0 * this.getNSAFT() - 24.0 * Math.pow(this.getNSAFT(), 2.0)) / (Math.pow(1.0 - this.getNSAFT(), 3.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 6.0 * (1.0 - this.getmSAFT()) * (-54.0 + 72.0 * this.getNSAFT() - 24.0 * Math.pow(this.getNSAFT(), 2.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 3.0)) + 18.0 * (1.0 - this.getmSAFT()) * (20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0)) / (Math.pow(1.0 - this.getNSAFT(), 4.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 24.0 * (1.0 - this.getmSAFT()) * (20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0)) / (Math.pow(1.0 - this.getNSAFT(), 3.0) * Math.pow(2.0 - this.getNSAFT(), 3.0)) + 18.0 * (1.0 - this.getmSAFT()) * (20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) - 8.0 * Math.pow(this.getNSAFT(), 3.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 4.0)) + 24.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 5.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)) + 36.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 4.0) * Math.pow(2.0 - this.getNSAFT(), 3.0)) + 36.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 3.0) * Math.pow(2.0 - this.getNSAFT(), 4.0)) + 24.0 * (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 5.0))) / Math.pow(1.0 + this.getmSAFT() * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0)) / Math.pow(1.0 - this.getNSAFT(), 4.0) + (1.0 - this.getmSAFT()) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0)) / (Math.pow(1.0 - this.getNSAFT(), 2.0) * Math.pow(2.0 - this.getNSAFT(), 2.0)), 2.0);
        return temp;
    }

    public double calcdF2dispZHCdT() {
        double temp0 = -Math.pow(this.F2dispZHC, 2.0);
        double temp1 = this.getmSAFT() * ((8.0 - 4.0 * this.getNSAFT()) * this.dNSAFTdT * Math.pow(1.0 - this.getNSAFT(), 4.0) + 4.0 * Math.pow(1.0 - this.getNSAFT(), 3.0) * this.dNSAFTdT * (8.0 * this.getNSAFT() - 2.0 * Math.pow(this.getNSAFT(), 2.0))) / Math.pow(1.0 - this.getNSAFT(), 8.0);
        double temp2a = (1.0 - this.getmSAFT()) * (20.0 - 54.0 * this.getNSAFT() + 36.0 * Math.pow(this.getNSAFT(), 2.0) + 8.0 * Math.pow(this.getNSAFT(), 3.0)) * this.dNSAFTdT * Math.pow((1.0 - this.getNSAFT()) * (2.0 - this.getNSAFT()), 2.0);
        double temp2b = (1.0 - this.getmSAFT()) * 2.0 * ((1.0 - this.getNSAFT()) * (2.0 - this.getNSAFT())) * (-1.0 * this.dNSAFTdT * (2.0 - this.getNSAFT()) + -1.0 * this.dNSAFTdT * (1.0 - this.getNSAFT())) * (20.0 * this.getNSAFT() - 27.0 * Math.pow(this.getNSAFT(), 2.0) + 12.0 * Math.pow(this.getNSAFT(), 3.0) - 2.0 * Math.pow(this.getNSAFT(), 4.0));
        double temp2 = (temp2a - temp2b) / Math.pow((1.0 - this.getNSAFT()) * (2.0 - this.getNSAFT()), 4.0);
        return temp0 * (temp1 + temp2);
    }

    @Override
    public double calcmSAFT() {
        double temp2 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            temp2 += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi() / this.getNumberOfMolesInPhase();
            ++i;
        }
        return temp2;
    }

    @Override
    public double calcF1dispSumTerm() {
        double temp1 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.numberOfComponents) {
                temp1 += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(j).getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi() * this.getComponent(j).getmSAFTi() * Math.sqrt(this.getComponent(i).getEpsikSAFT() / this.temperature * this.getComponent(j).getEpsikSAFT() / this.temperature) * (1.0 - this.mixRule.getBinaryInteractionParameter(i, j)) * Math.pow(0.5 * (this.getComponent(i).getSigmaSAFTi() + this.getComponent(j).getSigmaSAFTi()), 3.0);
                ++j;
            }
            ++i;
        }
        return temp1 / Math.pow(this.getNumberOfMolesInPhase(), 2.0);
    }

    public double calcdF1dispSumTermdT() {
        double temp1 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.numberOfComponents) {
                temp1 += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(j).getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi() * this.getComponent(j).getmSAFTi() * Math.sqrt(this.getComponent(i).getEpsikSAFT() / this.temperature * this.getComponent(j).getEpsikSAFT() / this.temperature) * (1.0 - this.mixRule.getBinaryInteractionParameter(i, j)) * Math.pow(0.5 * (this.getComponent(i).getSigmaSAFTi() + this.getComponent(j).getSigmaSAFTi()), 3.0) * (-1.0 / this.temperature);
                ++j;
            }
            ++i;
        }
        return temp1 / Math.pow(this.getNumberOfMolesInPhase(), 2.0);
    }

    public double calcdF2dispSumTermdT() {
        double temp1 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.numberOfComponents) {
                temp1 += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(j).getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi() * this.getComponent(j).getmSAFTi() * (this.getComponent(i).getEpsikSAFT() / this.temperature * this.getComponent(j).getEpsikSAFT() / this.temperature) * Math.pow(1.0 - this.mixRule.getBinaryInteractionParameter(i, j), 2.0) * Math.pow(0.5 * (this.getComponent(i).getSigmaSAFTi() + this.getComponent(j).getSigmaSAFTi()), 3.0) * (-2.0 / this.temperature);
                ++j;
            }
            ++i;
        }
        return temp1 / Math.pow(this.getNumberOfMolesInPhase(), 2.0);
    }

    @Override
    public double calcF2dispSumTerm() {
        double temp1 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.numberOfComponents) {
                temp1 += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(j).getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi() * this.getComponent(j).getmSAFTi() * this.getComponent(i).getEpsikSAFT() / this.temperature * this.getComponent(j).getEpsikSAFT() / this.temperature * Math.pow(1.0 - this.mixRule.getBinaryInteractionParameter(i, j), 2.0) * Math.pow(0.5 * (this.getComponent(i).getSigmaSAFTi() + this.getComponent(j).getSigmaSAFTi()), 3.0);
                ++j;
            }
            ++i;
        }
        return temp1 / Math.pow(this.getNumberOfMolesInPhase(), 2.0);
    }

    @Override
    public double calcF1dispI1dN() {
        double temp1 = 0.0;
        int i = 1;
        while (i < 7) {
            temp1 += (double)i * this.getaSAFT(i, this.getmSAFT(), this.aConstSAFT) * Math.pow(this.getNSAFT(), (double)i - 1.0);
            ++i;
        }
        return temp1;
    }

    @Override
    public double calcF1dispI1dNdN() {
        double temp1 = 0.0;
        int i = 2;
        while (i < 7) {
            temp1 += ((double)i - 1.0) * (double)i * this.getaSAFT(i, this.getmSAFT(), this.aConstSAFT) * Math.pow(this.getNSAFT(), (double)i - 2.0);
            ++i;
        }
        return temp1;
    }

    public double calcF1dispI1dNdNdN() {
        double temp1 = 0.0;
        int i = 2;
        while (i < 7) {
            temp1 += ((double)i - 1.0) * ((double)i - 2.0) * (double)i * this.getaSAFT(i, this.getmSAFT(), this.aConstSAFT) * Math.pow(this.getNSAFT(), (double)i - 3.0);
            ++i;
        }
        return temp1;
    }

    @Override
    public double calcF1dispI1dm() {
        double temp1 = 0.0;
        int i = 0;
        while (i < 7) {
            temp1 += this.getaSAFTdm(i, this.getmSAFT(), this.aConstSAFT) * Math.pow(this.getNSAFT(), i);
            ++i;
        }
        return temp1;
    }

    @Override
    public double calcF2dispI2dN() {
        double temp1 = 0.0;
        int i = 1;
        while (i < 7) {
            temp1 += (double)i * this.getaSAFT(i, this.getmSAFT(), this.bConstSAFT) * Math.pow(this.getNSAFT(), (double)i - 1.0);
            ++i;
        }
        return temp1;
    }

    @Override
    public double calcF2dispI2dNdN() {
        double temp1 = 0.0;
        int i = 2;
        while (i < 7) {
            temp1 += ((double)i - 1.0) * (double)i * this.getaSAFT(i, this.getmSAFT(), this.bConstSAFT) * Math.pow(this.getNSAFT(), (double)i - 2.0);
            ++i;
        }
        return temp1;
    }

    public double calcF2dispI2dNdNdN() {
        double temp1 = 0.0;
        int i = 2;
        while (i < 7) {
            temp1 += ((double)i - 1.0) * ((double)i - 2.0) * (double)i * this.getaSAFT(i, this.getmSAFT(), this.bConstSAFT) * Math.pow(this.getNSAFT(), (double)i - 3.0);
            ++i;
        }
        return temp1;
    }

    @Override
    public double calcF2dispI2dm() {
        double temp1 = 0.0;
        int i = 0;
        while (i < 7) {
            temp1 += this.getaSAFTdm(i, this.getmSAFT(), this.bConstSAFT) * Math.pow(this.getNSAFT(), i);
            ++i;
        }
        return temp1;
    }

    @Override
    public double calcF1dispI1() {
        double temp1 = 0.0;
        int i = 0;
        while (i < 7) {
            temp1 += this.getaSAFT(i, this.getmSAFT(), this.aConstSAFT) * Math.pow(this.getNSAFT(), i);
            ++i;
        }
        return temp1;
    }

    public double calcdF1dispI1dT() {
        double temp1 = 0.0;
        int i = 0;
        while (i < 7) {
            temp1 += this.getaSAFT(i, this.getmSAFT(), this.aConstSAFT) * (double)i * Math.pow(this.getNSAFT(), i - 1) * this.dNSAFTdT;
            ++i;
        }
        return temp1;
    }

    public double calcdF2dispI2dT() {
        double temp1 = 0.0;
        int i = 0;
        while (i < 7) {
            temp1 += this.getaSAFT(i, this.getmSAFT(), this.bConstSAFT) * (double)i * Math.pow(this.getNSAFT(), i - 1) * this.dNSAFTdT;
            ++i;
        }
        return temp1;
    }

    @Override
    public double calcF2dispI2() {
        double temp1 = 0.0;
        int i = 0;
        while (i < 7) {
            temp1 += this.getaSAFT(i, this.getmSAFT(), this.bConstSAFT) * Math.pow(this.getNSAFT(), i);
            ++i;
        }
        return temp1;
    }

    @Override
    public double getaSAFT(int i, double m, double[][] ab) {
        return ab[0][i] + (m - 1.0) / m * ab[1][i] + (m - 1.0) / m * (m - 2.0) / m * ab[2][i];
    }

    @Override
    public double getaSAFTdm(int i, double m, double[][] ab) {
        return (m - (m - 1.0)) / (m * m) * ab[1][i] + ((2.0 * m - 3.0) * m * m - 2.0 * m * (m * m - 3.0 * m + 2.0)) / Math.pow(m, 4.0) * ab[2][i];
    }

    @Override
    public double calcmdSAFT() {
        double temp2 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            temp2 += this.getComponent(i).getNumberOfMolesInPhase() / this.getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi() * Math.pow(((ComponentPCSAFT)this.getComponent(i)).getdSAFTi(), 3.0);
            ++i;
        }
        return temp2;
    }

    @Override
    public double calcmmin1SAFT() {
        double temp2 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            temp2 += this.getComponent(i).getNumberOfMolesInPhase() / this.getNumberOfMolesInPhase() * (this.getComponent(i).getmSAFTi() - 1.0);
            ++i;
        }
        return temp2;
    }

    @Override
    public double calcdmeanSAFT() {
        double temp = 0.0;
        double temp2 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            temp += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi() * Math.pow(((ComponentPCSAFT)this.getComponent(i)).getdSAFTi(), 3.0);
            temp2 += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi();
            ++i;
        }
        return Math.pow(temp / temp2, 0.3333333333333333);
    }

    @Override
    public double calcdSAFT() {
        double temp1 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            temp1 += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi() * Math.pow(((ComponentPCSAFT)this.getComponent(i)).getdSAFTi(), 3.0);
            ++i;
        }
        return temp1 / this.getNumberOfMolesInPhase();
    }

    @Override
    public double getNSAFT() {
        return this.nSAFT;
    }

    @Override
    public void setNSAFT(double nSAFT) {
        this.nSAFT = nSAFT;
    }

    @Override
    public double getDSAFT() {
        return this.dSAFT;
    }

    @Override
    public void setDSAFT(double dSAFT) {
        this.dSAFT = dSAFT;
    }

    @Override
    public double getGhsSAFT() {
        return this.ghsSAFT;
    }

    @Override
    public void setGhsSAFT(double ghsSAFT) {
        this.ghsSAFT = ghsSAFT;
    }

    @Override
    public double F_HC_SAFT() {
        return this.getNumberOfMolesInPhase() * (this.getmSAFT() * this.getAHSSAFT() - this.getMmin1SAFT() * Math.log(this.getGhsSAFT()));
    }

    @Override
    public double dF_HC_SAFTdV() {
        return this.getNumberOfMolesInPhase() * (this.getmSAFT() * this.daHSSAFTdN * this.getDnSAFTdV() - this.getMmin1SAFT() * 1.0 / this.getGhsSAFT() * this.getDgHSSAFTdN() * this.getDnSAFTdV());
    }

    @Override
    public double dFdT() {
        return (double)this.useHS * this.dF_HC_SAFTdT() + (double)this.useDISP1 * this.dF_DISP1_SAFTdT() + (double)this.useDISP2 * this.dF_DISP2_SAFTdT();
    }

    public double dF_HC_SAFTdT() {
        return this.getNumberOfMolesInPhase() * (this.getmSAFT() * this.daHSSAFTdN * this.dNSAFTdT - this.getMmin1SAFT() * 1.0 / this.getGhsSAFT() * this.getDgHSSAFTdN() * this.dNSAFTdT);
    }

    @Override
    public double dF_HC_SAFTdVdV() {
        return this.getNumberOfMolesInPhase() * (this.getmSAFT() * this.daHSSAFTdNdN * this.getDnSAFTdV() * this.getDnSAFTdV() + this.getmSAFT() * this.daHSSAFTdN * this.dnSAFTdVdV + this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -2.0) * Math.pow(this.getDgHSSAFTdN(), 2.0) * this.getDnSAFTdV() * this.getDnSAFTdV() - this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -1.0) * this.dgHSSAFTdNdN * this.dnSAFTdV * this.dnSAFTdV - this.getMmin1SAFT() * 1.0 / this.getGhsSAFT() * this.getDgHSSAFTdN() * this.dnSAFTdVdV);
    }

    @Override
    public double dF_HC_SAFTdVdVdV() {
        return this.getNumberOfMolesInPhase() * (this.getmSAFT() * this.daHSSAFTdNdNdN * this.getDnSAFTdV() * this.getDnSAFTdV() * this.getDnSAFTdV() + this.getmSAFT() * this.daHSSAFTdNdN * 2.0 * this.dnSAFTdV * this.dnSAFTdVdV + this.getmSAFT() * this.daHSSAFTdNdN * this.dnSAFTdV * this.dnSAFTdVdV + this.getmSAFT() * this.daHSSAFTdN * this.dnSAFTdVdVdV - 2.0 * this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -3.0) * Math.pow(this.getDgHSSAFTdN(), 3.0) * this.getDnSAFTdV() * this.getDnSAFTdV() * this.getDnSAFTdV() + this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -2.0) * 2.0 * this.getDgHSSAFTdN() * this.dgHSSAFTdNdN * this.getDnSAFTdV() * this.getDnSAFTdV() * this.getDnSAFTdV() + this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -2.0) * Math.pow(this.getDgHSSAFTdN(), 2.0) * 2.0 * this.getDnSAFTdV() * this.dnSAFTdVdV + this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -2.0) * this.getDgHSSAFTdN() * this.dgHSSAFTdNdN * this.dnSAFTdV * this.dnSAFTdV * this.dnSAFTdV - this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -1.0) * this.dgHSSAFTdNdNdN * this.dnSAFTdV * this.dnSAFTdV * this.dnSAFTdV - this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -1.0) * this.dgHSSAFTdNdN * 2.0 * this.dnSAFTdV * this.dnSAFTdVdV + this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -2.0) * Math.pow(this.getDgHSSAFTdN(), 2.0) * this.dnSAFTdV * this.dnSAFTdVdV - this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -1.0) * this.dgHSSAFTdNdN * this.dnSAFTdV * this.dnSAFTdVdV - this.getMmin1SAFT() * Math.pow(this.getGhsSAFT(), -1.0) * this.getDgHSSAFTdN() * this.dnSAFTdVdVdV);
    }

    @Override
    public double F_DISP1_SAFT() {
        return this.getNumberOfMolesInPhase() * (-6.2831853 * this.getF1dispVolTerm() * this.getF1dispSumTerm() * this.getF1dispI1());
    }

    @Override
    public double dF_DISP1_SAFTdV() {
        return this.getNumberOfMolesInPhase() * (-6.2831853 * this.F1dispVolTermdV * this.getF1dispSumTerm() * this.getF1dispI1() - 6.2831853 * this.F1dispVolTerm * this.getF1dispSumTerm() * this.F1dispI1dV);
    }

    @Override
    public double dF_DISP1_SAFTdVdV() {
        return this.getNumberOfMolesInPhase() * (-6.2831853 * this.F1dispVolTermdVdV * this.getF1dispSumTerm() * this.getF1dispI1() + -6.2831853 * this.F1dispVolTermdV * this.getF1dispSumTerm() * this.F1dispI1dV + -6.2831853 * this.F1dispVolTermdV * this.getF1dispSumTerm() * this.F1dispI1dV + -6.2831853 * this.F1dispVolTerm * this.getF1dispSumTerm() * this.F1dispI1dVdV);
    }

    public double dF_DISP1_SAFTdVdVdV() {
        return this.getNumberOfMolesInPhase() * (-6.2831853 * this.F1dispVolTermdVdVdV * this.getF1dispSumTerm() * this.getF1dispI1() + -6.2831853 * this.F1dispVolTermdVdV * this.getF1dispSumTerm() * this.F1dispI1dV + -6.2831853 * this.F1dispVolTermdVdV * this.getF1dispSumTerm() * this.F1dispI1dV + -6.2831853 * this.F1dispVolTermdV * this.getF1dispSumTerm() * this.F1dispI1dVdV + -6.2831853 * this.F1dispVolTermdVdV * this.getF1dispSumTerm() * this.F1dispI1dV + -6.2831853 * this.F1dispVolTermdV * this.getF1dispSumTerm() * this.F1dispI1dVdV + -6.2831853 * this.F1dispVolTermdV * this.getF1dispSumTerm() * this.F1dispI1dVdV + -6.2831853 * this.F1dispVolTerm * this.getF1dispSumTerm() * this.F1dispI1dVdVdV);
    }

    public double dF_DISP1_SAFTdT() {
        return this.getNumberOfMolesInPhase() * (-6.2831853 * (this.dF1dispVolTermdT * this.getF1dispSumTerm() * this.getF1dispI1() + this.dF1dispSumTermdT * this.getF1dispVolTerm() * this.getF1dispI1() + this.dF1dispI1dT * this.getF1dispVolTerm() * this.getF1dispSumTerm()));
    }

    public double dF_DISP2_SAFTdT() {
        return this.getNumberOfMolesInPhase() * (-3.14159265 * this.getmSAFT()) * this.getF1dispVolTerm() * (this.dF2dispSumTermdT * this.getF2dispI2() * this.getF2dispZHC() + this.dF2dispI2dT * this.getF2dispSumTerm() * this.getF2dispZHC() + this.dF2dispZHCdT * this.getF2dispSumTerm() * this.getF2dispI2());
    }

    @Override
    public double F_DISP2_SAFT() {
        return this.getNumberOfMolesInPhase() * (-3.14159265 * this.getmSAFT() * this.getF1dispVolTerm() * this.getF2dispSumTerm() * this.getF2dispI2() * this.getF2dispZHC());
    }

    @Override
    public double dF_DISP2_SAFTdV() {
        return this.getNumberOfMolesInPhase() * (-3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.getF2dispZHC() - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dV * this.getF2dispZHC() - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdV);
    }

    @Override
    public double dF_DISP2_SAFTdVdV() {
        return this.getNumberOfMolesInPhase() * (-3.14159265 * this.getmSAFT() * this.F1dispVolTermdVdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.getF2dispZHC() - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispZHC() * this.F2dispI2dV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.getF2dispZHC() - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dVdV * this.getF2dispZHC() - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdVdV);
    }

    public double dF_DISP2_SAFTdVdVdV() {
        return this.getNumberOfMolesInPhase() * (-3.14159265 * this.getmSAFT() * this.F1dispVolTermdVdVdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.getF2dispZHC() + -3.14159265 * this.getmSAFT() * this.F1dispVolTermdVdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.getF2dispZHC() + -3.14159265 * this.getmSAFT() * this.F1dispVolTermdVdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdV + -(3.14159265 * this.getmSAFT() * this.F1dispVolTermdVdV * this.getF2dispSumTerm() * this.getF2dispZHC() * this.F2dispI2dV) + -(3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispZHCdV * this.F2dispI2dV) + -(3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispZHC() * this.F2dispI2dVdV) + -(3.14159265 * this.getmSAFT() * this.F1dispVolTermdVdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdV) - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdVdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.getF2dispZHC() - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dVdV * this.getF2dispZHC() - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dVdV * this.getF2dispZHC() - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dVdVdV * this.getF2dispZHC() - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dVdV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dVdV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdVdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dVdV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdVdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdVdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dVdV * this.F2dispZHCdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTermdV * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.F2dispI2dV * this.F2dispZHCdVdV - 3.14159265 * this.getmSAFT() * this.F1dispVolTerm * this.getF2dispSumTerm() * this.getF2dispI2() * this.F2dispZHCdVdVdV);
    }

    @Override
    public double getF() {
        return (double)this.useHS * this.F_HC_SAFT() + (double)this.useDISP1 * this.F_DISP1_SAFT() + (double)this.useDISP2 * this.F_DISP2_SAFT();
    }

    @Override
    public double dFdV() {
        return ((double)this.useHS * this.dF_HC_SAFTdV() + (double)this.useDISP1 * this.dF_DISP1_SAFTdV() + (double)this.useDISP2 * this.dF_DISP2_SAFTdV()) * 1.0E-5;
    }

    @Override
    public double dFdVdV() {
        return ((double)this.useHS * this.dF_HC_SAFTdVdV() + (double)this.useDISP1 * this.dF_DISP1_SAFTdVdV() + (double)this.useDISP2 * this.dF_DISP2_SAFTdVdV()) * 1.0E-10;
    }

    @Override
    public double dFdVdVdV() {
        return ((double)this.useHS * this.dF_HC_SAFTdVdVdV() + (double)this.useDISP1 * this.dF_DISP1_SAFTdVdVdV() + (double)this.useDISP2 * this.dF_DISP2_SAFTdVdVdV()) * 1.0E-20;
    }

    @Override
    public double getmdSAFT() {
        return this.mdSAFT;
    }

    @Override
    public void setmdSAFT(double mdSAFT) {
        this.mdSAFT = mdSAFT;
    }

    @Override
    public double getmSAFT() {
        return this.mSAFT;
    }

    @Override
    public void setmSAFT(double mSAFT) {
        this.mSAFT = mSAFT;
    }

    @Override
    public double getAHSSAFT() {
        return this.aHSSAFT;
    }

    @Override
    public void setAHSSAFT(double aHSSAFT) {
        this.aHSSAFT = aHSSAFT;
    }

    @Override
    public double getMmin1SAFT() {
        return this.mmin1SAFT;
    }

    @Override
    public void setMmin1SAFT(double mmin1SAFT) {
        this.mmin1SAFT = mmin1SAFT;
    }

    @Override
    public double getVolumeSAFT() {
        return this.volumeSAFT;
    }

    @Override
    public void setVolumeSAFT(double volumeSAFT) {
        this.volumeSAFT = volumeSAFT;
    }

    @Override
    public double getDgHSSAFTdN() {
        return this.dgHSSAFTdN;
    }

    @Override
    public void setDgHSSAFTdN(double dgHSSAFTdN) {
        this.dgHSSAFTdN = dgHSSAFTdN;
    }

    @Override
    public double getDnSAFTdV() {
        return this.dnSAFTdV;
    }

    public double getdDSAFTdT() {
        double temp = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            temp += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getmSAFTi() / this.getNumberOfMolesInPhase() * 3.0 * Math.pow(((ComponentPCSAFT)this.getComponent(i)).getdSAFTi(), 2.0) * (-1.08 / Math.pow(this.temperature, 2.0)) * Math.pow(this.getComponent(i).getSigmaSAFTi(), 3.0) * Math.pow(1.0 - 0.12 * Math.exp(-3.0 * this.getComponent(i).getEpsikSAFT() / this.temperature), 2.0) * this.getComponent(i).getEpsikSAFT() * Math.exp(-3.0 * this.getComponent(i).getEpsikSAFT() / this.temperature);
            ++i;
        }
        return temp;
    }

    @Override
    public void setDnSAFTdV(double dnSAFTdV) {
        this.dnSAFTdV = dnSAFTdV;
    }

    @Override
    public double getF1dispVolTerm() {
        return this.F1dispVolTerm;
    }

    @Override
    public void setF1dispVolTerm(double F1dispVolTerm) {
        this.F1dispVolTerm = F1dispVolTerm;
    }

    @Override
    public double getF1dispSumTerm() {
        return this.F1dispSumTerm;
    }

    @Override
    public double getF1dispI1() {
        return this.F1dispI1;
    }

    @Override
    public double getF2dispI2() {
        return this.F2dispI2;
    }

    @Override
    public void setF2dispI2(double F2dispI2) {
        this.F2dispI2 = F2dispI2;
    }

    @Override
    public double getF2dispZHC() {
        return this.F2dispZHC;
    }

    @Override
    public void setF2dispZHC(double F2dispZHC) {
        this.F2dispZHC = F2dispZHC;
    }

    @Override
    public double getF2dispZHCdN() {
        return this.F2dispZHCdN;
    }

    @Override
    public double getF2dispZHCdm() {
        return this.F2dispZHCdm;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = phase == 0 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-6;
        }
        if (BonV > 1.0) {
            BonV = 0.999999;
        }
        double Btemp = 0.0;
        double dh = 0.0;
        double h = 0.0;
        double d1 = 0.0;
        Btemp = this.getB();
        if (Btemp <= 0.0) {
            logger.info("b negative in volume calc");
        }
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        double oldMolarVolume = 0.0;
        do {
            ++iterations;
            this.volInit();
            oldMolarVolume = this.getMolarVolume();
            h = pressure - this.calcPressure();
            dh = -this.calcPressuredV();
            d1 = -h / dh;
            double newVolume = this.getMolarVolume() + 0.9 * d1 / this.numberOfMolesInPhase;
            if (newVolume > 1.0E-100) {
                this.setMolarVolume(newVolume);
            } else {
                this.setMolarVolume(oldMolarVolume / 10.0);
            }
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((oldMolarVolume - this.getMolarVolume()) / oldMolarVolume) > 1.0E-10 && iterations < 100);
        return this.getMolarVolume();
    }

    @Override
    public double getDmeanSAFT() {
        return this.dmeanSAFT;
    }

    @Override
    public void setDmeanSAFT(double dmeanSAFT) {
        this.dmeanSAFT = dmeanSAFT;
    }

    @Override
    public double getNmSAFT() {
        return this.nmSAFT;
    }

    @Override
    public void setNmSAFT(double nmSAFT) {
        this.nmSAFT = nmSAFT;
    }

    @Override
    public double getF2dispSumTerm() {
        return this.F2dispSumTerm;
    }

    @Override
    public void setF2dispSumTerm(double F2dispSumTerm) {
        this.F2dispSumTerm = F2dispSumTerm;
    }

    @Override
    public void setF2dispZHCdm(double F2dispZHCdm) {
        this.F2dispZHCdm = F2dispZHCdm;
    }
}

