/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.mixingRule.EosMixingRules;
import neqsim.thermo.mixingRule.EosMixingRulesInterface;
import neqsim.thermo.phase.Phase;
import neqsim.thermo.phase.PhaseGEInterface;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseGE
extends Phase
implements PhaseGEInterface {
    private static final long serialVersionUID = 1000L;
    EosMixingRules mixSelect = new EosMixingRules();
    EosMixingRulesInterface mixRuleEos;
    static Logger logger = LogManager.getLogger(PhaseGE.class);

    public PhaseGE() {
        this.phaseTypeName = "liquid";
        this.componentArray = new ComponentGEInterface[100];
        this.useVolumeCorrection = false;
    }

    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int numberOfComponents, int type, int phase) {
        int i = 0;
        while (i < numberOfComponents) {
            this.componentArray[i].init(temperature, pressure, totalNumberOfMoles, beta, type);
            ++i;
        }
        this.getExessGibbsEnergy(this, numberOfComponents, temperature, pressure, type);
        double sumHydrocarbons = 0.0;
        double sumAqueous = 0.0;
        int i2 = 0;
        while (i2 < numberOfComponents) {
            if (this.getComponent(i2).isHydrocarbon() || this.getComponent(i2).isInert() || this.getComponent(i2).isIsTBPfraction()) {
                sumHydrocarbons += this.getComponent(i2).getx();
            } else {
                sumAqueous += this.getComponent(i2).getx();
            }
            ++i2;
        }
        this.phaseTypeName = sumHydrocarbons > sumAqueous ? "oil" : "aqueous";
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, initType, phase, beta);
        if (initType != 0) {
            this.getExessGibbsEnergy(this, numberOfComponents, this.temperature, this.pressure, phase);
        }
        double sumHydrocarbons = 0.0;
        double sumAqueous = 0.0;
        int i = 0;
        while (i < numberOfComponents) {
            if (this.getComponent(i).isHydrocarbon() || this.getComponent(i).isInert() || this.getComponent(i).isIsTBPfraction()) {
                sumHydrocarbons += this.getComponent(i).getx();
            } else {
                sumAqueous += this.getComponent(i).getx();
            }
            ++i;
        }
        this.phaseTypeName = sumHydrocarbons > sumAqueous ? "oil" : "aqueous";
    }

    @Override
    public void setMixingRule(int type) {
        this.mixingRuleDefined = true;
        super.setMixingRule(2);
        this.mixRuleEos = this.mixSelect.getMixingRule(2, this);
    }

    @Override
    public void resetMixingRule(int type) {
        this.mixingRuleDefined = true;
        super.setMixingRule(2);
        this.mixRuleEos = this.mixSelect.resetMixingRule(2, this);
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phase) {
        return 1.0;
    }

    public double molarVolumeAnalytic(double pressure, double temperature, double A, double B, int phase) {
        return 1.0;
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
    }

    public void setAlpha(double[][] alpha) {
    }

    public void setDij(double[][] Dij) {
    }

    @Override
    public double getExessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        logger.error("this getExxess should never be used.......");
        return 0.0;
    }

    @Override
    public double getGibbsEnergy() {
        return 0.0;
    }

    @Override
    public double getExessGibbsEnergy() {
        logger.error("this getExxess should never be used.......");
        return 0.0;
    }

    public void setDijT(double[][] DijT) {
    }

    @Override
    public double getActivityCoefficientSymetric(int k) {
        return ((ComponentGEInterface)this.getComponent(k)).getGamma();
    }

    @Override
    public double getActivityCoefficient(int k) {
        return ((ComponentGEInterface)this.getComponent(k)).getGamma();
    }

    public double getActivityCoefficientInfDilWater(int k, int p) {
        if (this.refPhase == null) {
            this.initRefPhases(false, this.getComponent(p).getName());
        }
        this.refPhase[k].setTemperature(this.temperature);
        this.refPhase[k].setPressure(this.pressure);
        this.refPhase[k].init(this.refPhase[k].getNumberOfMolesInPhase(), 2, 1, this.getPhaseType(), 1.0);
        ((PhaseGEInterface)((Object)this.refPhase[k])).getExessGibbsEnergy(this.refPhase[k], 2, this.refPhase[k].getTemperature(), this.refPhase[k].getPressure(), this.refPhase[k].getPhaseType());
        return ((ComponentGEInterface)this.refPhase[k].getComponent(0)).getGamma();
    }

    public double getActivityCoefficientInfDil(int k) {
        Phase dilphase = this.clone();
        dilphase.addMoles(k, -0.9999999999 * dilphase.getComponent(k).getNumberOfMolesInPhase());
        dilphase.getComponent(k).setx(1.0E-10);
        dilphase.init(dilphase.getNumberOfMolesInPhase(), dilphase.getNumberOfComponents(), 1, dilphase.getPhaseType(), 1.0);
        ((PhaseGEInterface)((Object)dilphase)).getExessGibbsEnergy(dilphase, 2, dilphase.getTemperature(), dilphase.getPressure(), dilphase.getPhaseType());
        return ((ComponentGEInterface)dilphase.getComponent(0)).getGamma();
    }

    @Override
    public double getEnthalpy() {
        return this.getCp() * this.temperature * this.numberOfMolesInPhase;
    }

    @Override
    public double getEntropy() {
        return this.getCp() * Math.log(this.temperature / 273.15);
    }

    @Override
    public double getCp() {
        double tempVar = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getPureComponentCpLiquid(this.temperature);
            ++i;
        }
        return tempVar;
    }

    @Override
    public double getCv() {
        return this.getCp();
    }

    @Override
    public double getZ() {
        double densityIdealGas = this.pressure * 100000.0 / 8.314 / this.temperature * this.getMolarMass();
        return densityIdealGas / this.getDensity("kg/m3");
    }

    @Override
    public double getSoundSpeed() {
        return 1470.0;
    }

    @Override
    public double getJouleThomsonCoefficient() {
        return -0.0125;
    }

    @Override
    public double getDensity() {
        return 997.0;
    }

    @Override
    public double getMolarVolume() {
        return 1.0 / (this.getDensity() / this.getMolarMass()) * 100000.0;
    }
}

