/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentElectrolyteCPAstatoil;
import neqsim.thermo.phase.PhaseElectrolyteCPA;

public class PhaseElectrolyteCPAstatoil
extends PhaseElectrolyteCPA {
    private static final long serialVersionUID = 1000L;

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(componentName, moles, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentElectrolyteCPAstatoil(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public PhaseElectrolyteCPAstatoil clone() {
        PhaseElectrolyteCPAstatoil clonedPhase = null;
        try {
            clonedPhase = (PhaseElectrolyteCPAstatoil)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedPhase;
    }

    @Override
    public double calc_g() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double g = 1.0 / (1.0 - x);
        return g;
    }

    @Override
    public double calc_lngV() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double gv = x / this.getTotalVolume() / (1.0 - x);
        return -gv;
    }

    @Override
    public double calc_lngVV() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double xV = -0.475 * this.getB() / Math.pow(this.getTotalVolume(), 2.0);
        double u = 1.0 - x;
        double val = -x / (Math.pow(this.getTotalVolume(), 2.0) * u) + xV / (this.getTotalVolume() * u) - x / (this.getTotalVolume() * u * u) * -1.0 * xV;
        return -val;
    }

    @Override
    public double calc_lngVVV() {
        double gvv = -0.21434375 / Math.pow(1.0 - 0.475 * this.getB() / this.getTotalVolume(), 3.0) * Math.pow(this.getB(), 3.0) / Math.pow(this.getTotalVolume(), 6.0) - 1.35375 / Math.pow(1.0 - 0.475 * this.getB() / this.getTotalVolume(), 2.0) * Math.pow(this.getB(), 2.0) / Math.pow(this.getTotalVolume(), 5.0) - 2.85 / (1.0 - 0.475 * this.getB() / this.getTotalVolume()) * this.getB() / Math.pow(this.getTotalVolume(), 4.0);
        return gvv;
    }
}

