/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveEosTerm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermBaseClass;

public class AttractiveTermTwuCoon
extends AttractiveTermBaseClass {
    private static final long serialVersionUID = 1000L;
    private double a = -0.201158;
    private double b = 0.141599;
    private double c = 2.29528;
    private double d = -0.660145;
    private double e = 0.500315;
    private double f = 2.63165;

    public AttractiveTermTwuCoon(ComponentEosInterface component) {
        super(component);
        this.m = component.getAcentricFactor();
    }

    @Override
    public AttractiveTermTwuCoon clone() {
        AttractiveTermTwuCoon attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermTwuCoon)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return attractiveTerm;
    }

    @Override
    public void init() {
    }

    @Override
    public double alpha(double temperature) {
        double Tr = temperature / this.getComponent().getTC();
        return Math.pow(Tr, this.a) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) + this.m * (Math.pow(Tr, this.d) * Math.exp(this.e * (1.0 - Math.pow(Tr, this.f))) - Math.pow(Tr, this.a) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))));
    }

    private double alphaCrit(double temperature) {
        return Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / this.getComponent().getTC(), 1.0 * this.d))), 2.0);
    }

    private double diffalphaCritT(double temperature) {
        this.c = 1.0 + this.m / 2.0 - this.parameters[0] * (1.0 + this.parameters[1] + this.parameters[2]);
        this.d = 1.0 - 1.0 / this.d;
        return -2.0 * Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / this.getComponent().getTC(), 1.0 * this.d))), 2.0) * this.c * Math.pow(temperature / this.getComponent().getTC(), 1.0 * this.d) * this.d / temperature;
    }

    private double diffdiffalphaCritT(double temperature) {
        double TC = this.getComponent().getTC();
        return 4.0 * Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / TC, 1.0 * this.d))), 2.0) * this.c * this.c * Math.pow(Math.pow(temperature / TC, 1.0 * this.d), 2.0) * this.d * this.d / (temperature * temperature) - 2.0 * Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / TC, 1.0 * this.d))), 2.0) * this.c * Math.pow(temperature / TC, 1.0 * this.d) * this.d * this.d / (temperature * temperature) + 2.0 * Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / TC, 1.0 * this.d))), 2.0) * this.c * Math.pow(temperature / TC, 1.0 * this.d) * this.d / (temperature * temperature);
    }

    @Override
    public double aT(double temperature) {
        if (temperature / this.getComponent().getTC() > 100.0) {
            return this.getComponent().geta() * this.alphaCrit(temperature);
        }
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        double t = temperature;
        double TC = this.getComponent().getTC();
        double Tr = t / TC;
        return Math.pow(Tr, this.a) * this.a / t * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) - Math.pow(Tr, this.a) * this.b * Math.pow(Tr, this.c) * this.c / t * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) + this.m * (Math.pow(Tr, this.d) * this.d / t * Math.exp(this.e * (1.0 - Math.pow(Tr, this.f))) - Math.pow(Tr, this.d) * this.e * Math.pow(Tr, this.f) * this.f / t * Math.exp(this.e * (1.0 - Math.pow(Tr, this.f))) - Math.pow(Tr, this.a) * this.a / t * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) + Math.pow(Tr, this.a) * this.b * Math.pow(Tr, this.c) * this.c / t * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))));
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        double t = temperature;
        double TC = this.getComponent().getTC();
        double Tr = t / TC;
        return Math.pow(Tr, this.a) * this.a * this.a / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) - Math.pow(Tr, this.a) * this.a / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) - 2.0 * Math.pow(Tr, this.a) * this.a / Math.pow(t, 2.0) * this.b * Math.pow(Tr, this.c) * this.c * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) - Math.pow(Tr, this.a) * this.b * Math.pow(Tr, this.c) * Math.pow(this.c, 2.0) / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) + Math.pow(Tr, this.a) * this.b * Math.pow(Tr, this.c) * this.c / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) + Math.pow(Tr, this.a) * Math.pow(this.b, 2.0) * Math.pow(Math.pow(Tr, this.c), 2.0) * Math.pow(this.c, 2.0) / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) + this.m * (Math.pow(Tr, this.d) * Math.pow(this.d, 2.0) / Math.pow(t, 2.0) * Math.exp(this.e * (1.0 - Math.pow(Tr, this.f))) - Math.pow(Tr, this.d) * this.d / Math.pow(t, 2.0) * Math.exp(this.e * (1.0 - Math.pow(Tr, this.f))) - 2.0 * Math.pow(Tr, this.d) * this.d / Math.pow(t, 2.0) * this.e * Math.pow(Tr, this.f) * this.f * Math.exp(this.e * (1.0 - Math.pow(Tr, this.f))) - Math.pow(Tr, this.d) * this.e * Math.pow(Tr, this.f) * Math.pow(this.f, 2.0) / Math.pow(t, 2.0) * Math.exp(this.e * (1.0 - Math.pow(Tr, this.f))) + Math.pow(Tr, this.d) * this.e * Math.pow(Tr, this.f) * this.f / Math.pow(t, 2.0) * Math.exp(this.e * (1.0 - Math.pow(Tr, this.f))) + Math.pow(Tr, this.d) * Math.pow(this.e, 2.0) * Math.pow(Math.pow(Tr, this.f), 2.0) * Math.pow(this.f, 2.0) / Math.pow(t, 2.0) * Math.exp(this.e * (1.0 - Math.pow(Tr, this.f))) - Math.pow(Tr, this.a) * Math.pow(this.a, 2.0) / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) + Math.pow(Tr, this.a) * this.a / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) + 2.0 * Math.pow(Tr, this.a) * this.a / Math.pow(t, 2.0) * this.b * Math.pow(Tr, this.c) * this.c * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) + Math.pow(Tr, this.a) * this.b * Math.pow(Tr, this.c) * Math.pow(this.c, 2.0) / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) - Math.pow(Tr, this.a) * this.b * Math.pow(Tr, this.c) * this.c / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))) - Math.pow(Tr, this.a) * Math.pow(this.b, 2.0) * Math.pow(Math.pow(Tr, this.c), 2.0) * Math.pow(this.c, 2.0) / Math.pow(t, 2.0) * Math.exp(this.b * (1.0 - Math.pow(Tr, this.c))));
    }

    @Override
    public double diffaT(double temperature) {
        if (temperature / this.getComponent().getTC() > 100.0) {
            return this.getComponent().geta() * this.diffalphaCritT(temperature);
        }
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        if (temperature / this.getComponent().getTC() > 100.0) {
            return this.getComponent().geta() * this.diffdiffalphaCritT(temperature);
        }
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

