/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveEosTerm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermBaseClass;

public class AttractiveTermSchwartzentruber
extends AttractiveTermBaseClass {
    private static final long serialVersionUID = 1000L;
    private double c = 0.0;
    private double d = 0.0;

    public AttractiveTermSchwartzentruber(ComponentEosInterface component) {
        super(component);
        this.m = 0.48508 + 1.55191 * component.getAcentricFactor() - 0.15613 * component.getAcentricFactor() * component.getAcentricFactor();
    }

    public AttractiveTermSchwartzentruber(ComponentEosInterface component, double[] params) {
        this(component);
        System.arraycopy(params, 0, this.parameters, 0, params.length);
        this.d = 1.0 + this.m / 2.0 - this.parameters[0] * (1.0 + this.parameters[1] + this.parameters[2]);
        this.c = 1.0 - 1.0 / this.d;
    }

    @Override
    public AttractiveTermSchwartzentruber clone() {
        AttractiveTermSchwartzentruber attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermSchwartzentruber)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return attractiveTerm;
    }

    @Override
    public void init() {
        this.m = 0.48508 + 1.55191 * this.getComponent().getAcentricFactor() - 0.15613 * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor();
    }

    @Override
    public double alpha(double temperature) {
        return Math.pow(1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC())) - this.parameters[0] * (1.0 - temperature / this.getComponent().getTC()) * (1.0 + this.parameters[1] * temperature / this.getComponent().getTC() + this.parameters[2] * Math.pow(temperature / this.getComponent().getTC(), 2.0)), 2.0);
    }

    private double alphaCrit(double temperature) {
        this.d = 1.0 + this.m / 2.0 - this.parameters[0] * (1.0 + this.parameters[1] + this.parameters[2]);
        this.c = 1.0 - 1.0 / this.d;
        return Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / this.getComponent().getTC(), 1.0 * this.d))), 2.0);
    }

    private double diffalphaCritT(double temperature) {
        this.d = 1.0 + this.m / 2.0 - this.parameters[0] * (1.0 + this.parameters[1] + this.parameters[2]);
        this.c = 1.0 - 1.0 / this.d;
        return -2.0 * Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / this.getComponent().getTC(), 1.0 * this.d))), 2.0) * this.c * Math.pow(temperature / this.getComponent().getTC(), 1.0 * this.d) * this.d / temperature;
    }

    private double diffdiffalphaCritT(double temperature) {
        this.d = 1.0 + this.m / 2.0 - this.parameters[0] * (1.0 + this.parameters[1] + this.parameters[2]);
        this.c = 1.0 - 1.0 / this.d;
        double TC = this.getComponent().getTC();
        return 4.0 * Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / TC, 1.0 * this.d))), 2.0) * this.c * this.c * Math.pow(Math.pow(temperature / TC, 1.0 * this.d), 2.0) * this.d * this.d / (temperature * temperature) - 2.0 * Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / TC, 1.0 * this.d))), 2.0) * this.c * Math.pow(temperature / TC, 1.0 * this.d) * this.d * this.d / (temperature * temperature) + 2.0 * Math.pow(Math.exp(this.c * (1.0 - Math.pow(temperature / TC, 1.0 * this.d))), 2.0) * this.c * Math.pow(temperature / TC, 1.0 * this.d) * this.d / (temperature * temperature);
    }

    @Override
    public double aT(double temperature) {
        if (temperature / this.getComponent().getTC() > 100.0) {
            return this.getComponent().geta() * this.alphaCrit(temperature);
        }
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        return 2.0 * (1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC())) - this.parameters[0] * (1.0 - temperature / this.getComponent().getTC()) * (1.0 + this.parameters[1] * temperature / this.getComponent().getTC() + this.parameters[2] * temperature * temperature / (this.getComponent().getTC() * this.getComponent().getTC()))) * (-this.m / Math.sqrt(temperature / this.getComponent().getTC()) / this.getComponent().getTC() / 2.0 + this.parameters[0] / this.getComponent().getTC() * (1.0 + this.parameters[1] * temperature / this.getComponent().getTC() + this.parameters[2] * temperature * temperature / (this.getComponent().getTC() * this.getComponent().getTC())) - this.parameters[0] * (1.0 - temperature / this.getComponent().getTC()) * (this.parameters[1] / this.getComponent().getTC() + 2.0 * this.parameters[2] * temperature / (this.getComponent().getTC() * this.getComponent().getTC())));
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        return 2.0 * Math.pow(-this.m / Math.sqrt(temperature / this.getComponent().getTC()) / this.getComponent().getTC() / 2.0 + this.parameters[0] / this.getComponent().getTC() * (1.0 + this.parameters[1] * temperature / this.getComponent().getTC() + this.parameters[2] * temperature * temperature / (this.getComponent().getTC() * this.getComponent().getTC())) - this.parameters[0] * (1.0 - temperature / this.getComponent().getTC()) * (this.parameters[1] / this.getComponent().getTC() + 2.0 * this.parameters[2] * temperature / (this.getComponent().getTC() * this.getComponent().getTC())), 2.0) + 2.0 * (1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC())) - this.parameters[0] * (1.0 - temperature / this.getComponent().getTC()) * (1.0 + this.parameters[1] * temperature / this.getComponent().getTC() + this.parameters[2] * temperature * temperature / (this.getComponent().getTC() * this.getComponent().getTC()))) * (this.m / Math.sqrt(temperature * temperature * temperature / (this.getComponent().getTC() * this.getComponent().getTC() * this.getComponent().getTC())) / (this.getComponent().getTC() * this.getComponent().getTC()) / 4.0 + 2.0 * this.parameters[0] / this.getComponent().getTC() * (this.parameters[1] / this.getComponent().getTC() + 2.0 * this.parameters[2] * temperature / (this.getComponent().getTC() * this.getComponent().getTC())) - 2.0 * this.parameters[0] * (1.0 - temperature / this.getComponent().getTC()) * this.parameters[2] / (this.getComponent().getTC() * this.getComponent().getTC()));
    }

    @Override
    public double diffaT(double temperature) {
        if (temperature / this.getComponent().getTC() > 100.0) {
            return this.getComponent().geta() * this.diffalphaCritT(temperature);
        }
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        if (temperature / this.getComponent().getTC() > 100.0) {
            return this.getComponent().geta() * this.diffdiffalphaCritT(temperature);
        }
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

