/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveEosTerm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermPr1978;

public class AttractiveTermPrDelft1998
extends AttractiveTermPr1978 {
    private static final long serialVersionUID = 1000L;
    boolean isMethane = false;

    public AttractiveTermPrDelft1998(ComponentEosInterface component) {
        super(component);
        if (component.getName().equals("methane")) {
            this.isMethane = true;
        }
    }

    @Override
    public AttractiveTermPrDelft1998 clone() {
        AttractiveTermPrDelft1998 attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermPrDelft1998)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return attractiveTerm;
    }

    @Override
    public double alpha(double temperature) {
        if (this.isMethane) {
            return 0.969617 + 0.20089 * temperature / this.getComponent().getTC() - 0.3256987 * Math.pow(temperature / this.getComponent().getTC(), 2.0) + 0.06653 * Math.pow(temperature / this.getComponent().getTC(), 3.0);
        }
        return Math.pow(1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC())), 2.0);
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        if (this.isMethane) {
            return 0.20089 / this.getComponent().getTC() - 0.6513974 * temperature / Math.pow(this.getComponent().getTC(), 2.0) + 0.19959000000000002 * Math.pow(temperature, 2.0) / Math.pow(this.getComponent().getTC(), 3.0);
        }
        return -(1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()))) * this.m / Math.sqrt(temperature / this.getComponent().getTC()) / this.getComponent().getTC();
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        if (this.isMethane) {
            return -0.6513974 / Math.pow(this.getComponent().getTC(), 2.0) + 0.39918000000000003 * temperature / Math.pow(this.getComponent().getTC(), 3.0);
        }
        return this.m * this.m / temperature / this.getComponent().getTC() / 2.0 + (1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()))) * this.m / Math.sqrt(temperature * temperature * temperature / Math.pow(this.getComponent().getTC(), 3.0)) / (this.getComponent().getTC() * this.getComponent().getTC()) / 2.0;
    }

    @Override
    public double diffaT(double temperature) {
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

