/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveEosTerm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermSrk;

public class AttractiveTermMatCop
extends AttractiveTermSrk {
    private static final long serialVersionUID = 1000L;
    double orgpar = 0.0;

    public AttractiveTermMatCop(ComponentEosInterface component) {
        super(component);
        this.m = 0.48 + 1.574 * component.getAcentricFactor() - 0.175 * component.getAcentricFactor() * component.getAcentricFactor();
    }

    public AttractiveTermMatCop(ComponentEosInterface component, double[] params) {
        this(component);
        System.arraycopy(params, 0, this.parameters, 0, params.length);
        this.orgpar = this.parameters[0];
        if (Math.abs(this.parameters[0]) < 1.0E-12) {
            this.parameters[0] = this.m;
        }
    }

    @Override
    public AttractiveTermMatCop clone() {
        AttractiveTermMatCop attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermMatCop)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return attractiveTerm;
    }

    @Override
    public void init() {
        super.init();
        this.parameters[0] = this.m;
    }

    @Override
    public double alpha(double temperature) {
        double Tr = temperature / this.getComponent().getTC();
        return Math.pow(1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0), 2.0);
    }

    @Override
    public double aT(double temperature) {
        if (temperature / this.getComponent().getTC() > 10000.0) {
            return super.aT(temperature);
        }
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        return 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0)) * (-this.parameters[0] / Math.sqrt(Tr) / TC / 2.0 - this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr) / TC - 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr) / TC);
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        return 2.0 * Math.pow(-this.parameters[0] / Math.sqrt(Tr) / TC / 2.0 - this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr) / TC - 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr) / TC, 2.0) + 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0)) * (this.parameters[0] / Math.sqrt(Tr * Tr * Tr) / (TC * TC) / 4.0 + this.parameters[1] / temperature / TC / 2.0 + this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr * Tr * Tr) / (TC * TC) / 2.0 + 1.5 * this.parameters[2] * (1.0 - Math.sqrt(Tr)) / temperature / TC + 0.75 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr * Tr * Tr) / (TC * TC));
    }

    @Override
    public double diffaT(double temperature) {
        if (temperature / this.getComponent().getTC() > 10000.0) {
            return super.diffaT(temperature);
        }
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        if (temperature / this.getComponent().getTC() > 10000.0) {
            return super.diffdiffaT(temperature);
        }
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

