/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentSrk;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermSrk;

public class ComponentSrkPeneloux
extends ComponentSrk {
    private static final long serialVersionUID = 1000L;
    private double factTemp = Math.pow(2.0, 0.3333333333333333);

    public ComponentSrkPeneloux() {
    }

    public ComponentSrkPeneloux(double moles) {
        this.numberOfMoles = moles;
    }

    public ComponentSrkPeneloux(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.a = 1.0 / (9.0 * (Math.pow(2.0, 0.3333333333333333) - 1.0)) * 8.3144621 * 8.3144621 * this.criticalTemperature * this.criticalTemperature / this.criticalPressure;
        this.b = (Math.pow(2.0, 0.3333333333333333) - 1.0) / 3.0 * 8.3144621 * this.criticalTemperature / this.criticalPressure;
        this.delta1 = 1.0;
        this.delta2 = 0.0;
        this.setAttractiveParameter(new AttractiveTermSrk(this));
        double[] surfTensInfluenceParamtemp = new double[]{-0.7708158524, 0.4990571549, 0.8645478315, -0.350981063, -0.1611763157};
        this.surfTensInfluenceParam = surfTensInfluenceParamtemp;
    }

    public ComponentSrkPeneloux(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentSrkPeneloux clone() {
        ComponentSrkPeneloux clonedComponent = null;
        try {
            clonedComponent = (ComponentSrkPeneloux)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public double getVolumeCorrection() {
        if (this.ionicCharge != 0) {
            return 0.0;
        }
        if (Math.abs(this.getRacketZ()) < 1.0E-10) {
            this.racketZ = 0.29056 - 0.08775 * this.getAcentricFactor();
        }
        return 0.40768 * (0.29441 - this.getRacketZ()) * 8.3144621 * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public double calcb() {
        double volCorr = this.getVolumeCorrection();
        return (this.factTemp - 1.0) / 3.0 * 8.3144621 * this.criticalTemperature / this.criticalPressure - volCorr;
    }
}

