/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEos;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermSrk;

public class ComponentSrk
extends ComponentEos {
    private static final long serialVersionUID = 1000L;
    private double factTemp = Math.pow(2.0, 0.3333333333333333);

    public ComponentSrk() {
    }

    public ComponentSrk(double moles) {
        this.numberOfMoles = moles;
    }

    public ComponentSrk(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.a = 1.0 / (9.0 * (Math.pow(2.0, 0.3333333333333333) - 1.0)) * 8.3144621 * 8.3144621 * this.criticalTemperature * this.criticalTemperature / this.criticalPressure;
        this.b = (Math.pow(2.0, 0.3333333333333333) - 1.0) / 3.0 * 8.3144621 * this.criticalTemperature / this.criticalPressure;
        this.delta1 = 1.0;
        this.delta2 = 0.0;
        this.setAttractiveParameter(new AttractiveTermSrk(this));
        double[] surfTensInfluenceParamtemp = new double[]{-0.7708158524, 0.4990571549, 0.8645478315, -0.350981063, -0.1611763157};
        this.surfTensInfluenceParam = surfTensInfluenceParamtemp;
    }

    public ComponentSrk(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentSrk clone() {
        ComponentSrk clonedComponent = null;
        try {
            clonedComponent = (ComponentSrk)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public double getVolumeCorrection() {
        if (this.ionicCharge != 0) {
            return 0.0;
        }
        if (Math.abs(this.getVolumeCorrectionConst()) > 1.0E-10) {
            return this.getVolumeCorrectionConst() * this.b;
        }
        if (Math.abs(this.getRacketZ()) < 1.0E-10) {
            this.racketZ = 0.29056 - 0.08775 * this.getAcentricFactor();
        }
        return 0.40768 * (0.29441 - this.getRacketZ()) * 8.3144621 * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public double calca() {
        return 1.0 / (9.0 * (this.factTemp - 1.0)) * 8.3144621 * 8.3144621 * this.criticalTemperature * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public double calcb() {
        return (this.factTemp - 1.0) / 3.0 * 8.3144621 * this.criticalTemperature / this.criticalPressure;
    }

    public double getQpure(double temperature) {
        return this.getaT() / (this.getb() * 8.3144621 * temperature);
    }

    public double getdQpuredT(double temperature) {
        return this.dqPuredT;
    }

    public double getdQpuredTdT(double temperature) {
        return this.dqPuredTdT;
    }

    @Override
    public double getSurfaceTenisionInfluenceParameter(double temperature) {
        double TR = 1.0 - temperature / this.getTC();
        if (TR < 0.0) {
            TR = this.componentName.equals("CO2") ? 0.09999999999999998 : 0.6;
        }
        double AA = this.surfTensInfluenceParam[0] + this.surfTensInfluenceParam[1] * this.getAcentricFactor();
        double BB = this.surfTensInfluenceParam[2] + this.surfTensInfluenceParam[3] * this.getAcentricFactor() + this.surfTensInfluenceParam[4] * this.getAcentricFactor() * this.getAcentricFactor();
        if (this.componentName.equals("water")) {
            return 1.9939776242117276E-20;
        }
        if (this.componentName.equals("MEG")) {
            return 9.784248343727627E-20;
        }
        if (this.componentName.equals("TEG")) {
            return 9.01662233371129E-19;
        }
        return this.aT * 1.0E-5 * Math.pow(this.b * 1.0E-5, 0.6666666666666666) * (AA * TR + BB) / Math.pow(6.023E23, 0.6666666666666666);
    }
}

