/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentSrk;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhasePCSAFT;

public class ComponentPCSAFT
extends ComponentSrk {
    private static final long serialVersionUID = 1000L;
    private double dSAFTi = 1.0;
    private double dmSAFTdi = 1.0;
    double dghsSAFTdi;
    double dnSAFTdi = 1.0;
    double dahsSAFTdi = 1.0;
    double dlogghsSAFTdi = 1.0;
    private double F1dispVolTermdn = 1.0;
    private double F1dispSumTermdn = 1.0;
    private double F1dispI1dn = 1.0;
    private double F2dispI2dn = 1.0;
    private double F2dispZHCdn = 1.0;
    private double F2dispVolTermdn = 1.0;
    private double F2dispSumTermdn = 1.0;
    int useHS = 1;
    int useDISP1 = 1;
    int useDISP2 = 1;

    public ComponentPCSAFT() {
    }

    public ComponentPCSAFT(double moles) {
        this.numberOfMoles = moles;
    }

    public ComponentPCSAFT(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    public ComponentPCSAFT(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentPCSAFT clone() {
        ComponentPCSAFT clonedComponent = null;
        try {
            clonedComponent = (ComponentPCSAFT)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        this.setdSAFTi(this.getSigmaSAFTi() * (1.0 - 0.12 * Math.exp(-3.0 * this.getEpsikSAFT() / temperature)));
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public void Finit(PhaseInterface phase, double temp, double pres, double totMoles, double beta, int numberOfComponents, int type) {
        super.Finit(phase, temp, pres, totMoles, beta, numberOfComponents, type);
        this.setDnSAFTdi(this.calcdnSAFTdi(phase, numberOfComponents, temp, pres));
        this.setDghsSAFTdi(this.calcdghsSAFTdi(phase, numberOfComponents, temp, pres));
        this.setDlogghsSAFTdi(1.0 / ((PhasePCSAFT)phase).getGhsSAFT() * this.getDghsSAFTdi());
        this.setDmSAFTdi(this.calcdmSAFTdi(phase, numberOfComponents, temp, pres));
        this.setdahsSAFTdi(this.calcdahsSAFTdi(phase, numberOfComponents, temp, pres));
        this.F2dispVolTermdn = this.F1dispVolTermdn = 6.023E23 / ((PhasePCSAFT)phase).getVolumeSAFT();
        this.F1dispSumTermdn = this.calcF1dispSumTermdn(phase, numberOfComponents, temp, pres);
        this.F2dispSumTermdn = this.calcF2dispSumTermdn(phase, numberOfComponents, temp, pres);
        this.F1dispI1dn = ((PhasePCSAFT)phase).calcF1dispI1dN() * this.getDnSAFTdi() + ((PhasePCSAFT)phase).calcF1dispI1dm() * this.getDmSAFTdi();
        this.F2dispI2dn = ((PhasePCSAFT)phase).calcF2dispI2dN() * this.getDnSAFTdi() + ((PhasePCSAFT)phase).calcF2dispI2dm() * this.getDmSAFTdi();
        this.F2dispZHCdn = ((PhasePCSAFT)phase).getF2dispZHCdN() * this.getDnSAFTdi() + ((PhasePCSAFT)phase).getF2dispZHCdm() * this.getDmSAFTdi();
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return (double)this.useHS * this.dF_HC_SAFTdN(phase, numberOfComponents, temperature, pressure) + (double)this.useDISP1 * this.dF_DISP1_SAFTdN(phase, numberOfComponents, temperature, pressure) + (double)this.useDISP2 * this.dF_DISP2_SAFTdN(phase, numberOfComponents, temperature, pressure);
    }

    public double dF_HC_SAFTdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhasePCSAFT)phase).F_HC_SAFT() / phase.getNumberOfMolesInPhase() + phase.getNumberOfMolesInPhase() * (this.getDmSAFTdi() * ((PhasePCSAFT)phase).getAHSSAFT() + ((PhasePCSAFT)phase).getmSAFT() * this.getdahsSAFTdi() - (this.mSAFTi - 1.0) / phase.getNumberOfMolesInPhase() * Math.log(((PhasePCSAFT)phase).getGhsSAFT()) + ((PhasePCSAFT)phase).getMmin1SAFT() / phase.getNumberOfMolesInPhase() * Math.log(((PhasePCSAFT)phase).getGhsSAFT()) - ((PhasePCSAFT)phase).getMmin1SAFT() * this.getDlogghsSAFTdi());
    }

    public double dF_DISP1_SAFTdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhasePCSAFT)phase).F_DISP1_SAFT() / phase.getNumberOfMolesInPhase() + phase.getNumberOfMolesInPhase() * (-6.2831853 * this.F1dispVolTermdn * ((PhasePCSAFT)phase).getF1dispSumTerm() * ((PhasePCSAFT)phase).getF1dispI1() - 6.2831853 * ((PhasePCSAFT)phase).getF1dispVolTerm() * this.F1dispSumTermdn * ((PhasePCSAFT)phase).getF1dispI1() - 6.2831853 * ((PhasePCSAFT)phase).getF1dispVolTerm() * ((PhasePCSAFT)phase).getF1dispSumTerm() * this.F1dispI1dn);
    }

    public double calcdmSAFTdi(PhaseInterface phase, int nuberOfComponents, double temp, double pres) {
        return this.mSAFTi / phase.getNumberOfMolesInPhase() - ((PhasePCSAFT)phase).getmSAFT() / phase.getNumberOfMolesInPhase();
    }

    public double dF_DISP2_SAFTdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhasePCSAFT)phase).F_DISP2_SAFT() / phase.getNumberOfMolesInPhase() + phase.getNumberOfMolesInPhase() * (-3.14159265 * this.getDmSAFTdi() * ((PhasePCSAFT)phase).getF1dispVolTerm() * ((PhasePCSAFT)phase).getF2dispSumTerm() * ((PhasePCSAFT)phase).getF2dispI2() * ((PhasePCSAFT)phase).getF2dispZHC() - 3.14159265 * ((PhasePCSAFT)phase).getmSAFT() * this.F2dispVolTermdn * ((PhasePCSAFT)phase).getF2dispSumTerm() * ((PhasePCSAFT)phase).getF2dispI2() * ((PhasePCSAFT)phase).getF2dispZHC() - 3.14159265 * ((PhasePCSAFT)phase).getmSAFT() * ((PhasePCSAFT)phase).getF1dispVolTerm() * this.F2dispSumTermdn * ((PhasePCSAFT)phase).getF2dispI2() * ((PhasePCSAFT)phase).getF2dispZHC() - 3.14159265 * ((PhasePCSAFT)phase).getmSAFT() * ((PhasePCSAFT)phase).getF1dispVolTerm() * ((PhasePCSAFT)phase).getF2dispSumTerm() * this.F2dispI2dn * ((PhasePCSAFT)phase).getF2dispZHC() - 3.14159265 * ((PhasePCSAFT)phase).getmSAFT() * ((PhasePCSAFT)phase).getF1dispVolTerm() * ((PhasePCSAFT)phase).getF2dispSumTerm() * ((PhasePCSAFT)phase).getF2dispI2() * this.F2dispZHCdn);
    }

    public double calcF1dispSumTermdn(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double temp1 = 0.0;
        int i = 0;
        while (i < phase.getNumberOfComponents()) {
            temp1 += phase.getComponent(i).getNumberOfMolesInPhase() * phase.getComponent(i).getmSAFTi() * this.getmSAFTi() * Math.sqrt(this.getEpsikSAFT() / temperature * phase.getComponent(i).getEpsikSAFT() / temperature) * (1.0 - ((PhaseEosInterface)phase).getMixingRule().getBinaryInteractionParameter(this.componentNumber, i)) * Math.pow(0.5 * (phase.getComponent(i).getSigmaSAFTi() + this.getSigmaSAFTi()), 3.0);
            ++i;
        }
        return -2.0 / Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * ((PhasePCSAFT)phase).getF1dispSumTerm() + 2.0 * temp1 / Math.pow(phase.getNumberOfMolesInPhase(), 2.0);
    }

    public double calcF2dispSumTermdn(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double temp1 = 0.0;
        int i = 0;
        while (i < phase.getNumberOfComponents()) {
            temp1 += phase.getComponent(i).getNumberOfMolesInPhase() * phase.getComponent(i).getmSAFTi() * this.getmSAFTi() * this.getEpsikSAFT() / temperature * phase.getComponent(i).getEpsikSAFT() / temperature * Math.pow(1.0 - ((PhaseEosInterface)phase).getMixingRule().getBinaryInteractionParameter(this.componentNumber, i), 2.0) * Math.pow(0.5 * (phase.getComponent(i).getSigmaSAFTi() + this.getSigmaSAFTi()), 3.0);
            ++i;
        }
        return -2.0 / Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * ((PhasePCSAFT)phase).getF2dispSumTerm() + 2.0 * temp1 / Math.pow(phase.getNumberOfMolesInPhase(), 2.0);
    }

    public double calcdghsSAFTdi(PhaseInterface phase, int nuberOfComponents, double temp, double pres) {
        double temp1 = ((PhasePCSAFT)phase).getDgHSSAFTdN();
        return temp1 * this.getDnSAFTdi();
    }

    public double calcdahsSAFTdi(PhaseInterface phase, int nuberOfComponents, double temp, double pres) {
        double temp1 = (4.0 - 6.0 * ((PhasePCSAFT)phase).getNSAFT()) * Math.pow(1.0 - ((PhasePCSAFT)phase).getNSAFT(), 2.0) - (4.0 * ((PhasePCSAFT)phase).getNSAFT() - 3.0 * Math.pow(((PhasePCSAFT)phase).getNSAFT(), 2.0)) * -2.0 * (1.0 - ((PhasePCSAFT)phase).getNSAFT());
        return temp1 / Math.pow(1.0 - ((PhasePCSAFT)phase).getNSAFT(), 4.0) * this.getDnSAFTdi();
    }

    public double calcdnSAFTdi(PhaseInterface phase, int nuberOfComponents, double temp, double pres) {
        double temp1 = phase.getNumberOfMolesInPhase() / ((PhasePCSAFT)phase).getVolumeSAFT() * this.getmSAFTi() * Math.pow(this.getdSAFTi(), 3.0) * 1.0 / phase.getNumberOfMolesInPhase() + 1.0 / ((PhasePCSAFT)phase).getVolumeSAFT() * ((PhasePCSAFT)phase).getDSAFT() - 1.0 / Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * phase.getNumberOfMolesInPhase() / ((PhasePCSAFT)phase).getVolumeSAFT() * ((PhasePCSAFT)phase).getDSAFT();
        return 3.1536354218250004E23 * temp1;
    }

    public double getdSAFTi() {
        return this.dSAFTi;
    }

    public void setdSAFTi(double di) {
        this.dSAFTi = di;
    }

    public double getDghsSAFTdi() {
        return this.dghsSAFTdi;
    }

    public void setDghsSAFTdi(double dghsSAFTdi) {
        this.dghsSAFTdi = dghsSAFTdi;
    }

    public double getDnSAFTdi() {
        return this.dnSAFTdi;
    }

    public void setDnSAFTdi(double dnSAFTdi) {
        this.dnSAFTdi = dnSAFTdi;
    }

    public double getdahsSAFTdi() {
        return this.dahsSAFTdi;
    }

    public void setdahsSAFTdi(double dahsSAFTdi) {
        this.dahsSAFTdi = dahsSAFTdi;
    }

    public double getDmSAFTdi() {
        return this.dmSAFTdi;
    }

    public void setDmSAFTdi(double dmSAFTdi) {
        this.dmSAFTdi = dmSAFTdi;
    }

    public double getDlogghsSAFTdi() {
        return this.dlogghsSAFTdi;
    }

    public void setDlogghsSAFTdi(double dlogghsSAFTdi) {
        this.dlogghsSAFTdi = dlogghsSAFTdi;
    }
}

