/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.Component;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentHydrateKluda
extends Component {
    private static final long serialVersionUID = 1000L;
    double par1_struc1 = 17.44;
    double par2_struc1 = -6003.9;
    double par1_struc2 = 17.332;
    double par2_struc2 = -6017.6;
    int hydrateStructure = 0;
    double[][][] coordNumb = new double[3][2][2];
    double[][][] cavRadius = new double[3][2][2];
    double[][] cavNumb = new double[2][2];
    double[][] cavprwat = new double[2][2];
    double[] reffug = new double[20];
    static Logger logger = LogManager.getLogger(ComponentHydrateKluda.class);

    public ComponentHydrateKluda() {
    }

    public ComponentHydrateKluda(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.coordNumb[0][0][0] = 20.0;
        this.coordNumb[0][0][1] = 24.0;
        this.cavRadius[0][0][0] = 3.906;
        this.cavRadius[0][0][1] = 4.326;
        this.coordNumb[1][0][0] = 20.0;
        this.coordNumb[1][0][1] = 24.0;
        this.cavRadius[1][0][0] = 6.593;
        this.cavRadius[1][0][1] = 7.078;
        this.coordNumb[2][0][0] = 50.0;
        this.coordNumb[2][0][1] = 50.0;
        this.cavRadius[2][0][0] = 8.086;
        this.cavRadius[2][0][1] = 8.285;
        this.cavNumb[0][0] = 2.0;
        this.cavNumb[0][1] = 6.0;
        this.cavprwat[0][0] = 0.043478260869565216;
        this.cavprwat[0][1] = 0.13043478260869565;
        this.coordNumb[0][1][0] = 20.0;
        this.coordNumb[0][1][1] = 28.0;
        this.cavRadius[0][1][0] = 3.902;
        this.cavRadius[0][1][1] = 4.683;
        this.cavNumb[1][0] = 16.0;
        this.cavNumb[1][1] = 8.0;
        this.cavprwat[1][0] = 0.11764705882352941;
        this.cavprwat[1][1] = 0.058823529411764705;
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        return this.fugcoef(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure());
    }

    public void setStructure(int structure) {
        this.hydrateStructure = structure;
    }

    public double fugcoef(PhaseInterface phase, int numberOfComps, double temp, double pres) {
        if (this.componentName.equals("water")) {
            double val = 1.0;
            double tempy = 1.0;
            double fugold = 0.0;
            do {
                val = 0.0;
                tempy = 0.0;
                fugold = this.fugacityCoefficient;
                int cavType = 0;
                while (cavType < 2) {
                    tempy = 0.0;
                    int j = 0;
                    while (j < phase.getNumberOfComponents()) {
                        logger.info("tempny " + (tempy += ((ComponentHydrateKluda)phase.getComponent(j)).calcYKI(this.hydrateStructure, cavType, phase)));
                        ++j;
                    }
                    val += this.cavprwat[this.hydrateStructure][cavType] * Math.log(1.0 - tempy);
                    ++cavType;
                }
                logger.info("val " + val);
                logger.info("fugacityCoefficient bef " + this.fugacityCoefficient);
                double solvol = 0.0011037527593818985 * this.getMolarMass();
                this.fugacityCoefficient = Math.exp(val) * this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp) * Math.exp(solvol / (8.3144621 * temp) * (pres - this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp)) * 100000.0) / pres;
                logger.info("fugacityCoefficient " + this.fugacityCoefficient);
            } while (Math.abs((this.fugacityCoefficient - fugold) / fugold) > 1.0E-8);
        } else {
            this.fugacityCoefficient = 100000.0;
        }
        return this.fugacityCoefficient;
    }

    public double dfugdt(PhaseInterface phase, int numberOfComps, double temp, double pres) {
        if (this.componentName.equals("water")) {
            double solvol = 1.0 / this.getPureComponentSolidDensity(this.getMeltingPointTemperature()) * this.molarMass;
            this.dfugdt = Math.log(this.getEmptyHydrateStructureVapourPressuredT(this.hydrateStructure, temp) / pres);
        } else {
            this.dfugdt = 0.0;
        }
        return this.dfugdt;
    }

    public double getEmptyHydrateStructureVapourPressure(int type, double temperature) {
        double par1_struc1 = 4.6477;
        double par2_struc1 = -5242.979;
        double par3_struc1 = 2.7789;
        double par4_struc1 = -0.0087156;
        if (type == 0) {
            return Math.exp(par1_struc1 * Math.log(temperature) + par2_struc1 / temperature + par3_struc1 + par4_struc1 * temperature) / 100000.0;
        }
        if (type == 1) {
            return Math.exp(this.par1_struc2 + this.par2_struc2 / temperature) * 1.01325;
        }
        return 0.0;
    }

    public double getEmptyHydrateStructureVapourPressuredT(int type, double temperature) {
        if (type == 0) {
            return -this.par2_struc1 / (temperature * temperature) * Math.exp(this.par1_struc1 + this.par2_struc1 / temperature);
        }
        if (type == 1) {
            return -this.par2_struc2 / (temperature * temperature) * Math.exp(this.par1_struc2 + this.par2_struc2 / temperature);
        }
        return 0.0;
    }

    public double calcYKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("methane")) {
            double yki = this.calcCKI(stucture, cavityType, phase) * this.reffug[this.componentNumber];
            double temp = 1.0;
            int i = 0;
            while (i < phase.getNumberOfComponents()) {
                if (phase.getComponent(i).isHydrateFormer()) {
                    temp += ((ComponentHydrateKluda)phase.getComponent(i)).calcCKI(stucture, cavityType, phase) * this.reffug[i];
                }
                ++i;
            }
            return yki / temp;
        }
        return 0.0;
    }

    public double calcCKI(int stucture, int cavityType, PhaseInterface phase) {
        double cki = 12.5663706 / (1.38066E-23 * phase.getTemperature()) * this.potIntegral(0, stucture, cavityType, phase);
        return cki;
    }

    public void setRefFug(int compNumbm, double val) {
        this.reffug[compNumbm] = val;
    }

    public double potIntegral(int intnumb, int stucture, int cavityType, PhaseInterface phase) {
        double step;
        double val = 0.0;
        double endval = this.cavRadius[intnumb][stucture][cavityType] - this.getSphericalCoreRadius();
        double x = 0.0;
        x = step = endval / 100.0;
        int i = 1;
        while (i < 100) {
            val += step * ((this.getPot(intnumb, x, stucture, cavityType, phase) + 4.0 * this.getPot(intnumb, x + 0.5 * step, stucture, cavityType, phase) + this.getPot(intnumb, x + step, stucture, cavityType, phase)) / 6.0);
            x = (double)i * step;
            ++i;
        }
        return val / 100000.0;
    }

    public double getPot(int intnumb, double radius, int struccture, int cavityType, PhaseInterface phase) {
        double lenjonsenergy = Math.sqrt(this.getLennardJonesEnergyParameter() * phase.getComponent("water").getLennardJonesEnergyParameter());
        double diam = (this.getLennardJonesMolecularDiameter() + phase.getComponent("water").getLennardJonesMolecularDiameter()) / 2.0;
        double corerad = (this.getSphericalCoreRadius() + phase.getComponent("water").getSphericalCoreRadius()) / 2.0;
        double pot = 2.0 * this.coordNumb[intnumb][struccture][cavityType] * lenjonsenergy * (Math.pow(diam, 12.0) / (Math.pow(this.cavRadius[intnumb][struccture][cavityType], 11.0) * radius) * (this.delt(intnumb, 10.0, radius, struccture, cavityType, phase) + corerad / this.cavRadius[intnumb][struccture][cavityType] * this.delt(intnumb, 11.0, radius, struccture, cavityType, phase)) - Math.pow(diam, 6.0) / (Math.pow(this.cavRadius[intnumb][struccture][cavityType], 5.0) * radius) * (this.delt(intnumb, 4.0, radius, struccture, cavityType, phase) + corerad / this.cavRadius[intnumb][struccture][cavityType] * this.delt(intnumb, 5.0, radius, struccture, cavityType, phase)));
        pot = Math.exp(-pot / phase.getTemperature()) * radius * radius / 1.0E20;
        return pot;
    }

    public double delt(int intnumb, double n, double radius, int struccture, int cavityType, PhaseInterface phase) {
        double lenjonsenergy = Math.sqrt(this.getLennardJonesEnergyParameter() * phase.getComponent("water").getLennardJonesEnergyParameter());
        double diam = (this.getLennardJonesMolecularDiameter() + phase.getComponent("water").getLennardJonesMolecularDiameter()) / 2.0;
        double corerad = (this.getSphericalCoreRadius() + phase.getComponent("water").getSphericalCoreRadius()) / 2.0;
        double delt = 1.0 / n * (Math.pow(1.0 - radius / this.cavRadius[intnumb][struccture][cavityType] - corerad / this.cavRadius[intnumb][struccture][cavityType], -n) - Math.pow(1.0 + radius / this.cavRadius[intnumb][struccture][cavityType] - corerad / this.cavRadius[intnumb][struccture][cavityType], -n));
        return delt;
    }
}

