/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentGE;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentGEUniquac
extends ComponentGE {
    private static final long serialVersionUID = 1000L;
    double r = 0.0;
    double q = 0.0;
    static Logger logger = LogManager.getLogger(ComponentGEUniquac.class);

    public ComponentGEUniquac() {
    }

    public ComponentGEUniquac(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        if (!this.getClass().equals(ComponentGEUniquac.class)) {
            return;
        }
        if (component_name.contains("_PC")) {
            this.r = 1.0;
            this.q = 1.0;
            return;
        }
        try {
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM unifaccomp WHERE Name='" + component_name + "'");
                dataSet.next();
                dataSet.getClob("name");
            }
            catch (Exception e) {
                dataSet.close();
                dataSet = database.getResultSet("SELECT * FROM unifaccomp WHERE Name='" + component_name + "'");
                dataSet.next();
            }
            this.r = Double.parseDouble(dataSet.getString("rUNIQUAQ"));
            this.q = Double.parseDouble(dataSet.getString("qUNIQUAQ"));
            dataSet.close();
            database.getConnection().close();
        }
        catch (Exception e) {
            String err = e.toString();
            logger.error(err);
        }
    }

    public double fugcoef(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.fugacityCoefficient = this.getGamma(phase, numberOfComponents, temperature, pressure, phasetype) * this.getAntoineVaporPressure(temperature) / pressure;
        return this.fugacityCoefficient;
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype, double[][] HValpha, double[][] HVgij, double[][] intparam, String[][] mixRule) {
        return 0.0;
    }

    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        return this.gamma;
    }

    public double fugcoefDiffPres(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.dfugdp = (Math.log(this.fugcoef(phase, numberOfComponents, temperature, pressure + 0.01, phasetype)) - Math.log(this.fugcoef(phase, numberOfComponents, temperature, pressure - 0.01, phasetype))) / 0.02;
        return this.dfugdp;
    }

    public double fugcoefDiffTemp(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.dfugdt = (Math.log(this.fugcoef(phase, numberOfComponents, temperature + 0.01, pressure, phasetype)) - Math.log(this.fugcoef(phase, numberOfComponents, temperature - 0.01, pressure, phasetype))) / 0.02;
        return this.dfugdt;
    }

    public double getr() {
        return this.r;
    }

    public double getq() {
        return this.q;
    }

    @Override
    public double getlnGammadt() {
        return this.dlngammadt;
    }

    @Override
    public double getlnGammadn(int k) {
        return this.dlngammadn[k];
    }
}

