/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentGE;
import neqsim.thermo.phase.PhaseDesmukhMather;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentDesmukhMather
extends ComponentGE {
    private static final long serialVersionUID = 1000L;
    private double deshMathIonicDiameter;
    static Logger logger = LogManager.getLogger(ComponentDesmukhMather.class);

    public ComponentDesmukhMather() {
        this.deshMathIonicDiameter = 1.0;
    }

    public ComponentDesmukhMather(String component_name, double moles, double molesInPhase, int compnumber) {
        block19: {
            super(component_name, moles, molesInPhase, compnumber);
            this.deshMathIonicDiameter = 1.0;
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = null;
            try {
                try {
                    if (component_name.equals("default")) break block19;
                    try {
                        dataSet = database.getResultSet("SELECT * FROM comptemp WHERE name='" + component_name + "'");
                        dataSet.next();
                        dataSet.getString("FORMULA");
                    }
                    catch (Exception e) {
                        dataSet.close();
                        logger.info("no parameters in tempcomp -- trying comp.. " + component_name);
                        dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + component_name + "'");
                        dataSet.next();
                    }
                    this.deshMathIonicDiameter = Double.parseDouble(dataSet.getString("DeshMatIonicDiameter"));
                }
                catch (Exception e) {
                    logger.error("error in comp", (Throwable)e);
                    try {
                        if (dataSet != null) {
                            dataSet.close();
                        }
                        if (database.getStatement() != null) {
                            database.getStatement().close();
                        }
                        if (database.getConnection() != null) {
                            database.getConnection().close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("error closing database.....", (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e) {
                    logger.error("error closing database.....", (Throwable)e);
                }
            }
        }
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype, double[][] HValpha, double[][] HVgij, double[][] intparam, String[][] mixRule) {
        return this.getGamma(phase, numberOfComponents, temperature, pressure, phasetype);
    }

    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        double A = 1.174;
        double B = 3.32384E9;
        double Iion = ((PhaseDesmukhMather)phase).getIonicStrength();
        double temp = 0.0;
        int i = 0;
        while (i < phase.getNumberOfComponents()) {
            if (!phase.getComponent(i).getComponentName().equals("water")) {
                temp += 2.0 * ((PhaseDesmukhMather)phase).getBetaDesMatij(i, this.getComponentNumber()) * phase.getComponent(i).getMolality(phase);
            }
            ++i;
        }
        this.lngamma = -A * Math.pow(this.getIonicCharge(), 2.0) * Math.sqrt(Iion) / (1.0 + B * this.deshMathIonicDiameter * 1.0E-10 * Math.sqrt(Iion)) + temp;
        this.gamma = this.getMolality(phase) * ((PhaseDesmukhMather)phase).getSolventMolarMass() * Math.exp(this.lngamma) / this.getx();
        this.lngamma = Math.log(this.gamma);
        logger.info("gamma " + this.componentName + " " + this.gamma);
        return this.gamma;
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            double watervol = 0.001 * this.getMolarMass();
            double watervappres = this.getAntoineVaporPressure(phase.getTemperature());
            this.fugacityCoefficient = this.gamma * watervappres * Math.exp(watervol / (8.3144621 * phase.getTemperature()) * (phase.getPressure() - watervappres) * 100000.0) / phase.getPressure();
        } else {
            this.fugacityCoefficient = this.ionicCharge == 0 && this.referenceStateType.equals("solvent") ? this.gamma * this.getAntoineVaporPressure(phase.getTemperature()) / phase.getPressure() : (this.ionicCharge == 0 && this.referenceStateType.equals("solute") ? this.gamma * this.getHenryCoef(phase.getTemperature()) / phase.getPressure() : 1.0E-15);
        }
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }

    public double getLngamma() {
        return this.lngamma;
    }

    @Override
    public double getMolality(PhaseInterface phase) {
        return this.getNumberOfMolesInPhase() / ((PhaseDesmukhMather)phase).getSolventWeight();
    }
}

