/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentSrk;
import neqsim.thermo.phase.PhaseBWRSEos;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentBWRS
extends ComponentSrk {
    private static final long serialVersionUID = 1000L;
    int OP = 9;
    int OE = 6;
    private double[] aBWRS = new double[32];
    private double[] BP = new double[this.OP];
    private double[] BE = new double[this.OE];
    private double[] BPdT = new double[this.OP];
    private double[] BEdT = new double[this.OE];
    private double[] BPdTdT = new double[this.OP];
    private double[] BEdTdT = new double[this.OE];
    double rhoc = 0.0;
    double gammaBWRS = 0.0;
    PhaseBWRSEos refPhaseBWRS = null;
    static Logger logger = LogManager.getLogger(ComponentBWRS.class);

    public ComponentBWRS() {
    }

    public ComponentBWRS(double moles) {
        this.numberOfMoles = moles;
    }

    public ComponentBWRS(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        try {
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM mbwr32param WHERE name='" + component_name + "'");
                dataSet.next();
                dataSet.getClob("name");
            }
            catch (Exception e) {
                dataSet.close();
                dataSet = database.getResultSet("SELECT * FROM mbwr32param WHERE name='" + component_name + "'");
                dataSet.next();
            }
            int i = 0;
            while (i < 32) {
                this.aBWRS[i] = Double.parseDouble(dataSet.getString("a" + i));
                ++i;
            }
            this.rhoc = Double.parseDouble(dataSet.getString("rhoc"));
            this.gammaBWRS = 1.0 / (this.rhoc * this.rhoc);
            dataSet.close();
            database.getConnection().close();
        }
        catch (Exception e) {
            String err = e.toString();
            logger.error(err);
        }
    }

    public ComponentBWRS(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentBWRS clone() {
        ComponentBWRS clonedComponent = null;
        try {
            clonedComponent = (ComponentBWRS)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
        this.BP[0] = 8.3144621 * temperature;
        this.BP[1] = this.aBWRS[0] * temperature + this.aBWRS[1] * Math.sqrt(temperature) + this.aBWRS[2] + this.aBWRS[3] / temperature + this.aBWRS[4] / Math.pow(temperature, 2.0);
        this.BP[2] = this.aBWRS[5] * temperature + this.aBWRS[6] + this.aBWRS[7] / temperature + this.aBWRS[8] / Math.pow(temperature, 2.0);
        this.BP[3] = this.aBWRS[9] * temperature + this.aBWRS[10] + this.aBWRS[11] / temperature;
        this.BP[4] = this.aBWRS[12];
        this.BP[5] = this.aBWRS[13] / temperature + this.aBWRS[14] / Math.pow(temperature, 2.0);
        this.BP[6] = this.aBWRS[15] / temperature;
        this.BP[7] = this.aBWRS[16] / temperature + this.aBWRS[17] / Math.pow(temperature, 2.0);
        this.BP[8] = this.aBWRS[18] / Math.pow(temperature, 2.0);
        this.BE[0] = this.aBWRS[19] / Math.pow(temperature, 2.0) + this.aBWRS[20] / Math.pow(temperature, 3.0);
        this.BE[1] = this.aBWRS[21] / Math.pow(temperature, 2.0) + this.aBWRS[22] / Math.pow(temperature, 4.0);
        this.BE[2] = this.aBWRS[23] / Math.pow(temperature, 2.0) + this.aBWRS[24] / Math.pow(temperature, 3.0);
        this.BE[3] = this.aBWRS[25] / Math.pow(temperature, 2.0) + this.aBWRS[26] / Math.pow(temperature, 4.0);
        this.BE[4] = this.aBWRS[27] / Math.pow(temperature, 2.0) + this.aBWRS[28] / Math.pow(temperature, 3.0);
        this.BE[5] = this.aBWRS[29] / Math.pow(temperature, 2.0) + this.aBWRS[30] / Math.pow(temperature, 3.0) + this.aBWRS[31] / Math.pow(temperature, 4.0);
        this.BPdT[0] = 8.3144621;
        this.BPdT[1] = this.aBWRS[0] + this.aBWRS[1] / (2.0 * Math.sqrt(temperature)) - this.aBWRS[3] / Math.pow(temperature, 2.0) - 2.0 * this.aBWRS[4] / Math.pow(temperature, 3.0);
        this.BPdT[2] = this.aBWRS[5] - this.aBWRS[7] / Math.pow(temperature, 2.0) - 2.0 * this.aBWRS[8] / Math.pow(temperature, 3.0);
        this.BPdT[3] = this.aBWRS[9] - this.aBWRS[11] / Math.pow(temperature, 2.0);
        this.BPdT[4] = 0.0;
        this.BPdT[5] = -this.aBWRS[13] / Math.pow(temperature, 2.0) - 2.0 * this.aBWRS[14] / Math.pow(temperature, 3.0);
        this.BPdT[6] = -this.aBWRS[15] / Math.pow(temperature, 2.0);
        this.BPdT[7] = -this.aBWRS[16] / Math.pow(temperature, 2.0) - 2.0 * this.aBWRS[17] / Math.pow(temperature, 3.0);
        this.BPdT[8] = -2.0 * this.aBWRS[18] / Math.pow(temperature, 3.0);
        this.BEdT[0] = -2.0 * this.aBWRS[19] / Math.pow(temperature, 3.0) - 3.0 * this.aBWRS[20] / Math.pow(temperature, 4.0);
        this.BEdT[1] = -2.0 * this.aBWRS[21] / Math.pow(temperature, 3.0) - 4.0 * this.aBWRS[22] / Math.pow(temperature, 5.0);
        this.BEdT[2] = -2.0 * this.aBWRS[23] / Math.pow(temperature, 3.0) - 3.0 * this.aBWRS[24] / Math.pow(temperature, 4.0);
        this.BEdT[3] = -2.0 * this.aBWRS[25] / Math.pow(temperature, 3.0) - 4.0 * this.aBWRS[26] / Math.pow(temperature, 5.0);
        this.BEdT[4] = -2.0 * this.aBWRS[27] / Math.pow(temperature, 3.0) - 3.0 * this.aBWRS[28] / Math.pow(temperature, 4.0);
        this.BEdT[5] = -2.0 * this.aBWRS[29] / Math.pow(temperature, 3.0) - 3.0 * this.aBWRS[30] / Math.pow(temperature, 4.0) - 4.0 * this.aBWRS[31] / Math.pow(temperature, 5.0);
        this.BPdTdT[0] = 0.0;
        this.BPdTdT[1] = 0.0;
        this.BPdTdT[2] = 0.0;
        this.BPdTdT[3] = 0.0;
        this.BPdTdT[4] = 0.0;
        this.BPdTdT[5] = 0.0;
        this.BPdTdT[6] = 0.0;
        this.BPdTdT[7] = 0.0;
        this.BPdTdT[8] = 0.0;
        this.BEdTdT[0] = 0.0;
        this.BEdTdT[1] = 0.0;
        this.BEdTdT[2] = 0.0;
        this.BEdTdT[3] = 0.0;
        this.BEdTdT[4] = 0.0;
        this.BEdTdT[5] = 0.0;
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponentphases, double temperature, double pressure) {
        return this.refPhaseBWRS.getF() / phase.getNumberOfMolesInPhase();
    }

    public double getFpoldn(PhaseInterface phase, int numberOfComponentphases, double temperature, double pressure) {
        double temp = 0.0;
        int i = 1;
        while (i < this.OP) {
            temp += (double)i * this.getBP(i) / ((double)i - 0.0) * Math.pow(((PhaseBWRSEos)phase).getMolarDensity(), (double)i - 1.0) * this.getdRhodn(phase, numberOfComponentphases, temperature, pressure);
            ++i;
        }
        return phase.getNumberOfMolesInPhase() / (8.3144621 * temperature) * temp + ((PhaseBWRSEos)phase).getFpol() / phase.getNumberOfMolesInPhase();
    }

    public double getdRhodn(PhaseInterface phase, int numberOfComponentphases, double temperature, double pressure) {
        return ((PhaseBWRSEos)phase).getMolarDensity() / phase.getNumberOfMolesInPhase();
    }

    public double getELdn(PhaseInterface phase, int numberOfComponentphases, double temperature, double pressure) {
        return -2.0 * ((PhaseBWRSEos)phase).getMolarDensity() * this.getGammaBWRS() * Math.exp(-this.getGammaBWRS() * Math.pow(((PhaseBWRSEos)phase).getMolarDensity(), 2.0)) * this.getdRhodn(phase, numberOfComponentphases, temperature, pressure);
    }

    public double getFexpdn(PhaseInterface phase, int numberOfComponentphases, double temperature, double pressure) {
        double oldTemp = 0.0;
        double temp = 0.0;
        oldTemp = -this.getBE(0) / (2.0 * this.getGammaBWRS()) * this.getELdn(phase, numberOfComponentphases, temperature, pressure);
        temp += oldTemp;
        int i = 1;
        while (i < this.OE) {
            oldTemp = -this.getBE(i) / (2.0 * this.getGammaBWRS()) * Math.pow(((PhaseBWRSEos)phase).getMolarDensity(), 2 * i) * this.getELdn(phase, numberOfComponentphases, temperature, pressure) - 2.0 * (double)i * this.getBE(i) / (2.0 * this.getGammaBWRS()) * ((PhaseBWRSEos)phase).getEL() * Math.pow(((PhaseBWRSEos)phase).getMolarDensity(), 2.0 * (double)i - 1.0) + this.getBE(i) / (2.0 * this.getGammaBWRS()) * (2.0 * (double)i) / this.getBE(i - 1) * oldTemp;
            temp += oldTemp;
            ++i;
        }
        return phase.getNumberOfMolesInPhase() / (8.3144621 * temperature) * temp + ((PhaseBWRSEos)phase).getFexp() / phase.getNumberOfMolesInPhase();
    }

    public double[] getABWRS() {
        return this.aBWRS;
    }

    public double getABWRS(int i) {
        return this.aBWRS[i];
    }

    public void setABWRS(double[] aBWRS) {
        this.aBWRS = aBWRS;
    }

    public double getBP(int i) {
        return this.BP[i];
    }

    public void setBP(double[] BP) {
        this.BP = BP;
    }

    public double[] getBE() {
        return this.BE;
    }

    public double getBE(int i) {
        return this.BE[i];
    }

    public void setBE(double[] BE) {
        this.BE = BE;
    }

    public void setRefPhaseBWRS(PhaseBWRSEos refPhaseBWRS) {
        this.refPhaseBWRS = refPhaseBWRS;
    }

    public double getGammaBWRS() {
        return this.gammaBWRS;
    }

    public void setGammaBWRS(double gammaBWRS) {
        this.gammaBWRS = gammaBWRS;
    }

    public double[] getBPdT() {
        return this.BPdT;
    }

    public double getBPdT(int i) {
        return this.BPdT[i];
    }

    public void setBPdT(double[] BPdT) {
        this.BPdT = BPdT;
    }

    public double[] getBEdT() {
        return this.BEdT;
    }

    public double getBEdT(int i) {
        return this.BEdT[i];
    }

    public void setBEdT(double[] BEdT) {
        this.BEdT = BEdT;
    }

    public double getRhoc() {
        return this.rhoc;
    }

    public void setRhoc(double rhoc) {
        this.rhoc = rhoc;
    }
}

