/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.thermo.characterization.TBPCharacterize;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewtonSolveABCD
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int iter = 0;
    Matrix Jac;
    Matrix fvec;
    Matrix sol;
    Matrix dx;
    int numberOfComponents = 0;
    TBPCharacterize characterizeClass;
    double[] calcTPBfraction = null;
    static Logger logger = LogManager.getLogger(NewtonSolveABCD.class);

    public NewtonSolveABCD() {
    }

    public NewtonSolveABCD(SystemInterface system, TBPCharacterize characterizeClass) {
        this.characterizeClass = characterizeClass;
        this.numberOfComponents = system.getPhase(0).getNumberOfComponents();
        this.Jac = new Matrix(2 * characterizeClass.getLength(), 4);
        this.fvec = new Matrix(2 * characterizeClass.getLength(), 1);
        this.sol = new Matrix(4, 1);
        this.sol.set(0, 0, characterizeClass.getCoef(0));
        this.sol.set(1, 0, characterizeClass.getCoef(1));
        this.sol.set(2, 0, characterizeClass.getCoef(2));
        this.sol.set(3, 0, characterizeClass.getCoef(3));
        this.calcTPBfraction = new double[characterizeClass.getLength()];
    }

    public void setfvec() {
        int i = 0;
        while (i < this.characterizeClass.getLength()) {
            this.fvec.set(i, 0, Math.log(this.characterizeClass.getTBPfractions(i)) - this.characterizeClass.getCoef(0) - this.characterizeClass.getCoef(1) * (double)(i + this.characterizeClass.getFirstPlusFractionNumber()));
            ++i;
        }
        i = this.characterizeClass.getLength();
        while (i < 2 * this.characterizeClass.getLength()) {
            this.fvec.set(i, 0, this.characterizeClass.getTBPdens(i - this.characterizeClass.getLength()) - this.characterizeClass.getCoef(2) - this.characterizeClass.getCoef(3) * Math.log(i + this.characterizeClass.getFirstPlusFractionNumber() - this.characterizeClass.getLength()));
            ++i;
        }
        i = 0;
        while (i < this.characterizeClass.getLength()) {
            this.calcTPBfraction[i] = Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)(i + this.characterizeClass.getFirstPlusFractionNumber()));
            ++i;
        }
        this.characterizeClass.setCalcTBPfractions(this.calcTPBfraction);
    }

    public void setJac() {
        int j;
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double tempJ = 0.0;
        double sumdyidbeta = 0.0;
        double sumdxidbeta = 0.0;
        int nofc = this.numberOfComponents;
        int i = 0;
        while (i < this.characterizeClass.getLength()) {
            j = 0;
            while (j < 4) {
                tempJ = j == 0 ? -1.0 : (j == 1 ? (double)(-(i + this.characterizeClass.getFirstPlusFractionNumber())) : 0.0);
                this.Jac.set(i, j, tempJ);
                ++j;
            }
            ++i;
        }
        i = this.characterizeClass.getLength();
        while (i < 2 * this.characterizeClass.getLength()) {
            j = 0;
            while (j < 4) {
                tempJ = j == 2 ? -1.0 : (j == 3 ? -Math.log(i + this.characterizeClass.getFirstPlusFractionNumber() - this.characterizeClass.getLength()) : 0.0);
                this.Jac.set(i, j, tempJ);
                ++j;
            }
            ++i;
        }
    }

    public void solve() {
        do {
            ++this.iter;
            this.setfvec();
            this.fvec.print(10, 2);
            this.setJac();
            this.Jac.print(10, 2);
            this.dx = this.Jac.solve(this.fvec);
            logger.info("dx: ");
            this.dx.print(10, 3);
            this.sol.minusEquals(this.dx.times(0.5));
            this.characterizeClass.setCoefs(this.sol.transpose().copy().getArray()[0]);
        } while ((this.dx.norm2() / this.sol.norm2() < 1.0E-6 || this.iter < 15) && this.iter < 50);
        logger.info("ok char: ");
        this.sol.print(10, 10);
    }
}

