/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.parameterFitting.nonLinearParameterFitting;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;

public class LevenbergMarquardtBiasDev
extends LevenbergMarquardt {
    @Override
    public LevenbergMarquardtBiasDev clone() {
        LevenbergMarquardtBiasDev clonedClass = null;
        try {
            clonedClass = (LevenbergMarquardtBiasDev)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedClass;
    }

    @Override
    public double calcChiSquare() {
        double chiSquare = 0.0;
        int i = 0;
        while (i < this.sampleSet.getLength()) {
            chiSquare += (this.sampleSet.getSample(i).getSampleValue() - this.calcValue(this.sampleSet.getSample(i))) / this.sampleSet.getSample(i).getStandardDeviation();
            ++i;
        }
        return chiSquare;
    }

    @Override
    public double[][] calcAlphaMatrix() {
        double[][] alpha = new double[this.sampleSet.getSample(0).getFunction().getFittingParams().length][this.sampleSet.getSample(0).getFunction().getFittingParams().length];
        int i = 0;
        while (i < alpha.length) {
            int j = 0;
            while (j < alpha[0].length) {
                alpha[i][j] = 0.0;
                int k = 0;
                while (k < this.sampleSet.getLength()) {
                    double[] dArray = alpha[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.dyda[k][i] * this.dyda[k][j] / this.sampleSet.getSample(k).getStandardDeviation();
                    ++k;
                }
                if (i == j) {
                    double[] dArray = alpha[i];
                    int n = j;
                    dArray[n] = dArray[n] * (1.0 + this.multiFactor);
                }
                ++j;
            }
            ++i;
        }
        return alpha;
    }

    @Override
    public double[] calcBetaMatrix() {
        double[] beta = new double[this.sampleSet.getSample(0).getFunction().getFittingParams().length];
        int i = 0;
        while (i < beta.length) {
            beta[i] = 0.0;
            int j = 0;
            while (j < this.sampleSet.getLength()) {
                int n = i;
                beta[n] = beta[n] + (this.sampleSet.getSample(j).getSampleValue() - this.calcValue(this.sampleSet.getSample(j))) / this.sampleSet.getSample(j).getStandardDeviation() * this.dyda[j][i];
                ++j;
            }
            ++i;
        }
        return beta;
    }
}

