/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.parameterFitting.nonLinearParameterFitting;

import Jama.Matrix;
import neqsim.statistics.parameterFitting.StatisticsBaseClass;

public class LevenbergMarquardt
extends StatisticsBaseClass {
    double oldChiSquare = 1.0E100;
    double newChiSquare = 0.0;
    Matrix parameterStdDevMatrix;
    Matrix parameterUncertaintyMatrix;
    Thread thisThread = new Thread();
    boolean solved = false;
    private int maxNumberOfIterations = 50;

    @Override
    public LevenbergMarquardt clone() {
        LevenbergMarquardt clonedClass = null;
        try {
            clonedClass = (LevenbergMarquardt)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedClass;
    }

    @Override
    public void init() {
        this.chiSquare = this.calcChiSquare();
        System.out.println("Chi square: " + this.chiSquare);
        this.dyda = this.calcDerivatives();
        this.beta = this.calcBetaMatrix();
        this.alpha = this.calcAlphaMatrix();
    }

    @Override
    public void solve() {
        Matrix newParameters;
        Matrix betaMatrix;
        this.setFittingParameters(this.sampleSet.getSample(0).getFunction().getFittingParams());
        int n = 0;
        this.init();
        do {
            ++n;
            if (this.chiSquare < this.oldChiSquare) {
                this.oldChiSquare = this.chiSquare;
            }
            betaMatrix = new Matrix(this.beta, 1).transpose();
            Matrix alphaMatrix = new Matrix(this.alpha);
            betaMatrix.print(10, 3);
            alphaMatrix.print(10, 3);
            Matrix solvedMatrix = alphaMatrix.solve(betaMatrix);
            Matrix oldParameters = new Matrix(this.sampleSet.getSample(0).getFunction().getFittingParams(), 1).copy();
            newParameters = oldParameters.copy().plus(solvedMatrix.transpose());
            Matrix diffMat = newParameters.copy().minus(oldParameters);
            this.checkBounds(newParameters);
            this.setFittingParameters(newParameters.copy().getArray()[0]);
            this.newChiSquare = this.calcChiSquare();
            if (this.newChiSquare >= this.oldChiSquare || Double.isNaN(this.newChiSquare)) {
                this.newChiSquare = this.oldChiSquare;
                this.multiFactor *= 10.0;
                System.out.println("keeping old values");
                this.setFittingParameters(oldParameters.getArray()[0]);
            } else {
                this.multiFactor /= 10.0;
                System.out.println("Chi square ok : ");
            }
            System.out.println("Chi after : " + this.newChiSquare);
            System.out.println("iterations: " + n);
            this.calcAbsDev();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Parameters:");
            newParameters.print(100, 100);
            this.init();
        } while (Math.abs(this.newChiSquare) > 1.0E-6 && n < this.maxNumberOfIterations && Math.abs(betaMatrix.norm2()) > 1.0E-6 || n < 5);
        this.solved = true;
        System.out.println("iterations: " + n);
        System.out.println("Chi square: " + this.chiSquare);
        System.out.println("Parameters:");
        newParameters.print(10, 10);
    }

    public static void main(String[] args) {
    }

    public int getMaxNumberOfIterations() {
        return this.maxNumberOfIterations;
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }
}

