/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.parameterFitting;

import Jama.Matrix;
import cern.jet.stat.Gamma;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.dataPresentation.fileHandeling.createNetCDF.netCDF2D.NetCdf2D;
import neqsim.dataPresentation.fileHandeling.createTextFile.TextFile;
import neqsim.dataPresentation.visAD.visAd2D.statistical2DPlot.lineFitPlot;
import neqsim.statistics.monteCarloSimulation.MonteCarloSimulation;
import neqsim.statistics.parameterFitting.NumericalDerivative;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.StatisticsInterface;

public abstract class StatisticsBaseClass
implements Cloneable,
StatisticsInterface {
    protected SampleSet sampleSet = new SampleSet();
    protected double chiSquare = 0.0;
    protected double[][] dyda;
    protected double[] beta;
    protected double[][] alpha;
    protected double[] parameterStandardDeviation;
    protected double[] parameterUncertainty;
    protected double multiFactor = 10.0;
    private int numberOfTuningParameters = 1;
    protected Matrix coVarianceMatrix;
    protected Matrix parameterCorrelationMatrix;
    protected double[][] xVal;
    protected double[] expVal;
    protected double[] absDev;
    protected double[] reldeviation;
    protected double[] calcVal;
    protected String[][] valTable;
    protected double absStdDev = 0.0;
    protected double biasdev = 0.0;
    protected double incompleteGammaComplemented = 0.0;

    public StatisticsBaseClass clone() {
        StatisticsBaseClass clonedClass = null;
        try {
            clonedClass = (StatisticsBaseClass)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        clonedClass.sampleSet = this.sampleSet.clone();
        return clonedClass;
    }

    public void setSampleSet(SampleSet sampleSet) {
        this.sampleSet = sampleSet;
    }

    public void addSampleSet(SampleSet sampleSet) {
        this.sampleSet.addSampleSet(sampleSet);
    }

    @Override
    public StatisticsBaseClass createNewRandomClass() {
        StatisticsBaseClass newClass = this.clone();
        newClass.setSampleSet(this.sampleSet.createNewNormalDistributedSet());
        return newClass;
    }

    public double calcValue(SampleValue sample) {
        return sample.getFunction().calcValue(sample.getDependentValues());
    }

    public void checkBounds(Matrix newParameters) {
        String okstring = "";
        int errors = 0;
        if (this.sampleSet.getSample(0).getFunction().getBounds() != null) {
            int i = 0;
            while (i < newParameters.getColumnDimension()) {
                if (newParameters.get(0, i) < this.sampleSet.getSample(0).getFunction().getLowerBound(i)) {
                    okstring = String.valueOf(okstring) + "parameter " + i + " lower than bound: " + newParameters.get(0, i) + "\n";
                    ++errors;
                    newParameters.set(0, i, this.sampleSet.getSample(0).getFunction().getLowerBound(i));
                }
                if (newParameters.get(0, i) > this.sampleSet.getSample(0).getFunction().getUpperBound(i)) {
                    okstring = String.valueOf(okstring) + "parameter " + i + " higher than bound: " + newParameters.get(0, i) + "\n";
                    ++errors;
                    newParameters.set(0, i, this.sampleSet.getSample(0).getFunction().getUpperBound(i));
                }
                ++i;
            }
            System.out.println("bounds checked - errors: " + errors);
            System.out.println(okstring);
        }
    }

    public double calcTrueValue(SampleValue sample) {
        return sample.getFunction().calcTrueValue(this.calcValue(sample));
    }

    public double calcTrueValue(double val, SampleValue sample) {
        return sample.getFunction().calcTrueValue(val);
    }

    public void setFittingParameters(double[] parameterVals) {
        int i = 0;
        while (i < this.sampleSet.getLength()) {
            int k = 0;
            while (k < this.sampleSet.getSample(i).getFunction().getFittingParams().length) {
                this.sampleSet.getSample(i).getFunction().setFittingParams(k, parameterVals[k]);
                ++k;
            }
            ++i;
        }
    }

    public void setFittingParameter(int parameterNumber, double parameterVal) {
        int i = 0;
        while (i < this.sampleSet.getLength()) {
            this.sampleSet.getSample(i).getFunction().setFittingParams(parameterNumber, parameterVal);
            ++i;
        }
    }

    public SampleValue getSample(int i) {
        return this.sampleSet.getSample(i);
    }

    @Override
    public SampleSet getSampleSet() {
        return this.sampleSet;
    }

    public double calcChiSquare() {
        this.calcVal = new double[this.sampleSet.getLength()];
        double chiSquare = 0.0;
        int i = 0;
        while (i < this.sampleSet.getLength()) {
            this.calcVal[i] = this.calcValue(this.sampleSet.getSample(i));
            chiSquare += Math.pow((this.sampleSet.getSample(i).getSampleValue() - this.calcVal[i]) / this.sampleSet.getSample(i).getStandardDeviation(), 2.0);
            ++i;
        }
        return chiSquare;
    }

    public double[][] calcAlphaMatrix() {
        double[][] alpha = new double[this.sampleSet.getSample(0).getFunction().getFittingParams().length][this.sampleSet.getSample(0).getFunction().getFittingParams().length];
        int i = 0;
        while (i < alpha.length) {
            int j = 0;
            while (j < alpha[0].length) {
                alpha[i][j] = 0.0;
                int k = 0;
                while (k < this.sampleSet.getLength()) {
                    double[] dArray = alpha[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.dyda[k][i] * this.dyda[k][j] / Math.pow(this.sampleSet.getSample(k).getStandardDeviation(), 2.0);
                    ++k;
                }
                if (i == j) {
                    double[] dArray = alpha[i];
                    int n = j;
                    dArray[n] = dArray[n] * (1.0 + this.multiFactor);
                }
                ++j;
            }
            ++i;
        }
        return alpha;
    }

    public double[] calcBetaMatrix() {
        double[] beta = new double[this.sampleSet.getSample(0).getFunction().getFittingParams().length];
        int i = 0;
        while (i < beta.length) {
            beta[i] = 0.0;
            int j = 0;
            while (j < this.sampleSet.getLength()) {
                int n = i;
                beta[n] = beta[n] + (this.sampleSet.getSample(j).getSampleValue() - this.calcVal[j]) / Math.pow(this.sampleSet.getSample(j).getStandardDeviation(), 2.0) * this.dyda[j][i];
                ++j;
            }
            ++i;
        }
        return beta;
    }

    public double[][] calcDerivatives() {
        this.dyda = new double[this.sampleSet.getLength()][this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams()];
        int i = 0;
        while (i < this.sampleSet.getLength()) {
            int j = 0;
            while (j < this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams()) {
                this.dyda[i][j] = NumericalDerivative.calcDerivative(this, i, j);
                ++j;
            }
            ++i;
        }
        return this.dyda;
    }

    public void calcParameterStandardDeviation() {
        this.parameterStandardDeviation = new double[this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams()];
        int j = 0;
        while (j < this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams()) {
            this.parameterStandardDeviation[j] = Math.sqrt(this.coVarianceMatrix.get(j, j));
            ++j;
        }
    }

    public void calcParameterUncertainty() {
        this.parameterUncertainty = new double[this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams()];
        int j = 0;
        while (j < this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams()) {
            this.parameterUncertainty[j] = Math.sqrt(4.0) * Math.sqrt(this.coVarianceMatrix.get(j, j));
            ++j;
        }
    }

    public void calcCoVarianceMatrix() {
        double old = this.multiFactor;
        this.multiFactor = 0.0;
        this.calcAlphaMatrix();
        this.coVarianceMatrix = new Matrix(this.alpha).inverse();
        this.multiFactor = old;
    }

    public void calcCorrelationMatrix() {
        this.parameterCorrelationMatrix = new Matrix(this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams(), this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams());
        int i = 0;
        while (i < this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams()) {
            int j = 0;
            while (j < this.sampleSet.getSample(0).getFunction().getNumberOfFittingParams()) {
                double temp = this.coVarianceMatrix.get(i, j) / Math.sqrt(this.coVarianceMatrix.get(j, j) * this.coVarianceMatrix.get(i, i));
                this.parameterCorrelationMatrix.set(i, j, temp);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public abstract void init();

    @Override
    public abstract void solve();

    public void runMonteCarloSimulation() {
        MonteCarloSimulation montCarlSim = new MonteCarloSimulation(this, 10);
        montCarlSim.runSimulation();
    }

    @Override
    public void runMonteCarloSimulation(int numRuns) {
        MonteCarloSimulation montCarlSim = new MonteCarloSimulation(this, numRuns);
        montCarlSim.runSimulation();
    }

    public void calcAbsDev() {
        this.setFittingParameters(this.sampleSet.getSample(0).getFunction().getFittingParams());
        this.xVal = new double[this.sampleSet.getSample(0).getDependentValues().length][this.sampleSet.getLength()];
        this.expVal = new double[this.sampleSet.getLength()];
        this.absDev = new double[this.sampleSet.getLength()];
        this.calcVal = new double[this.sampleSet.getLength()];
        double rmsDev = 0.0;
        double dev = 0.0;
        double dev2 = 0.0;
        double shiSq = 0.0;
        this.biasdev = 0.0;
        this.absStdDev = 0.0;
        int i = 0;
        while (i < this.sampleSet.getLength()) {
            this.expVal[i] = this.calcTrueValue(this.sampleSet.getSample(i).getSampleValue(), this.sampleSet.getSample(i));
            this.calcVal[i] = this.calcTrueValue(this.sampleSet.getSample(i));
            shiSq += Math.pow((this.calcVal[i] - this.expVal[i]) / this.sampleSet.getSample(i).getStandardDeviation(), 2.0);
            this.absDev[i] = Math.abs((this.calcVal[i] - this.expVal[i]) / this.expVal[i] * 100.0);
            dev = Math.abs((this.calcVal[i] - this.expVal[i]) / this.expVal[i] * 100.0);
            dev2 = Math.pow(this.calcVal[i] - this.expVal[i], 2.0);
            this.absStdDev += dev;
            rmsDev += dev2;
            System.out.println("x " + this.sampleSet.getSample(i).getDependentValue(0) + "  val: " + this.calcVal[i] + " exp val " + this.expVal[i] + "  deviation " + dev);
            int j = 0;
            while (j < this.sampleSet.getSample(0).getDependentValues().length) {
                this.xVal[j][i] = this.sampleSet.getSample(i).getDependentValue(j);
                ++j;
            }
            this.biasdev += (this.calcVal[i] - this.expVal[i]) / this.expVal[i] * 100.0;
            ++i;
        }
        this.absStdDev /= (double)this.sampleSet.getLength();
        rmsDev = Math.sqrt(rmsDev / (double)this.sampleSet.getLength());
        this.biasdev /= (double)this.sampleSet.getLength();
        this.chiSquare = shiSq;
        System.out.println("Shi-Square: " + shiSq);
        System.out.println("bias dev: " + this.biasdev);
        System.out.println("abs dev " + this.absStdDev);
        System.out.println("rms dev " + rmsDev * 100.0);
    }

    public void displayValues() {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Results from Parameter Fitting");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        this.valTable = new String[this.sampleSet.getLength() + 10][this.sampleSet.getSample(0).getDependentValues().length + 7];
        Object[] names = new String[]{"point", "x", "expY", "calcY", "abs dev [%]", "reference", "description"};
        this.valTable[0][0] = "";
        this.valTable[0][1] = "";
        this.valTable[0][2] = "";
        this.valTable[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        int j = 0;
        while (j < this.sampleSet.getLength()) {
            this.valTable[j + 1][0] = "" + j;
            buf = new StringBuffer();
            this.valTable[j + 1][1] = nf.format(this.xVal[0][j], buf, test2).toString();
            buf = new StringBuffer();
            this.valTable[j + 1][2] = nf.format(this.expVal[j], buf, test2).toString();
            buf = new StringBuffer();
            this.valTable[j + 1][3] = nf.format(this.calcVal[j], buf, test2).toString();
            buf = new StringBuffer();
            this.valTable[j + 1][4] = nf.format(this.absDev[j], buf, test2).toString();
            buf = new StringBuffer();
            this.valTable[j + 1][5] = this.sampleSet.getSample(j).getReference();
            this.valTable[j + 1][6] = this.sampleSet.getSample(j).getDescription();
            ++j;
        }
        j = 0;
        while (j < this.sampleSet.getLength()) {
            int i = 0;
            while (i < this.sampleSet.getSample(j).getDependentValues().length) {
                buf = new StringBuffer();
                this.valTable[j + 1][7 + i] = nf.format(this.sampleSet.getSample(j).getDependentValue(i), buf, test2).toString();
                ++i;
            }
            ++j;
        }
        JTable Jtab = new JTable(this.valTable, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void displayResult() {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.###E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Results from Parameter Fitting");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        Object[][] table = new String[15][5];
        Object[] names = new String[]{"Parameter", "Value", "Standard deviation", "Uncertatnty ", "--"};
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        int j = 0;
        while (j < this.sampleSet.getSample(0).getFunction().getFittingParams().length) {
            table[j + 1][0] = "parameter " + j;
            buf = new StringBuffer();
            table[j + 1][1] = nf.format(this.sampleSet.getSample(0).getFunction().getFittingParams()[j], buf, test2).toString();
            ++j;
        }
        int numb = this.sampleSet.getSample(0).getFunction().getFittingParams().length;
        table[numb + 2][0] = "Number Of Data Points ";
        buf = new StringBuffer();
        nf.applyPattern("#");
        table[numb + 2][1] = nf.format((long)this.sampleSet.getLength(), buf, test2).toString();
        table[numb + 3][0] = "Shi-Square ";
        buf = new StringBuffer();
        nf.applyPattern("#.###E0");
        table[numb + 3][1] = nf.format(this.chiSquare, buf, test2).toString();
        table[numb + 4][0] = "Abs.rel.dev (%) ";
        buf = new StringBuffer();
        table[numb + 4][1] = nf.format(this.absStdDev, buf, test2).toString();
        table[numb + 5][0] = "Bias.dev (%) ";
        buf = new StringBuffer();
        table[numb + 5][1] = nf.format(this.biasdev, buf, test2).toString();
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void displayResultWithDeviation() {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.###E0");
        this.calcDeviation();
        JDialog dialog = new JDialog((Frame)new JFrame(), "Results from Parameter Fitting");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        Object[][] table = new String[15][5];
        Object[] names = new String[]{"Parameter", "Value", "Standard deviation", "Uncertatnty ", "--"};
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        int j = 0;
        while (j < this.sampleSet.getSample(0).getFunction().getFittingParams().length) {
            table[j + 1][0] = "parameter " + j;
            buf = new StringBuffer();
            table[j + 1][1] = nf.format(this.sampleSet.getSample(0).getFunction().getFittingParams()[j], buf, test2).toString();
            buf = new StringBuffer();
            table[j + 1][2] = nf.format(this.parameterStandardDeviation[j], buf, test2).toString();
            buf = new StringBuffer();
            table[j + 1][3] = nf.format(this.parameterUncertainty[j], buf, test2).toString();
            table[j + 1][4] = "[-]";
            ++j;
        }
        int numb = this.sampleSet.getSample(0).getFunction().getFittingParams().length;
        table[numb + 2][0] = "Number Of Data Points ";
        buf = new StringBuffer();
        nf.applyPattern("#");
        table[numb + 2][1] = nf.format((long)this.sampleSet.getLength(), buf, test2).toString();
        table[numb + 3][0] = "Shi-Square ";
        buf = new StringBuffer();
        nf.applyPattern("#.###E0");
        table[numb + 3][1] = nf.format(this.chiSquare, buf, test2).toString();
        table[numb + 4][0] = "Abs.rel.dev (%) ";
        buf = new StringBuffer();
        table[numb + 4][1] = nf.format(this.absStdDev, buf, test2).toString();
        table[numb + 5][0] = "Bias.dev (%) ";
        buf = new StringBuffer();
        table[numb + 5][1] = nf.format(this.biasdev, buf, test2).toString();
        table[numb + 6][0] = "Goodnes Of Fit (0-1)";
        buf = new StringBuffer();
        nf.applyPattern("#.###E0");
        table[numb + 6][1] = nf.format(this.incompleteGammaComplemented, buf, test2).toString();
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
        this.displayMatrix(this.coVarianceMatrix, "CoVariance", 5);
        this.displayMatrix(this.parameterCorrelationMatrix, "Correlation", 5);
    }

    public void displayMatrix(Matrix coVarianceMatrix, String name, int d) {
        int m = coVarianceMatrix.getRowDimension();
        int n = coVarianceMatrix.getColumnDimension();
        Object[] names = new String[m];
        StringBuffer buf = new StringBuffer();
        DecimalFormat form = new DecimalFormat();
        form.setMinimumIntegerDigits(1);
        form.setMaximumFractionDigits(d);
        form.setMinimumFractionDigits(d);
        form.setGroupingUsed(false);
        form.applyPattern("#.##E0");
        FieldPosition test2 = new FieldPosition(0);
        Object[][] X = new String[m][n];
        int i = 0;
        while (i < m) {
            names[i] = String.valueOf(name) + " " + i;
            int j = 0;
            while (j < n) {
                buf = new StringBuffer();
                X[i][j] = form.format(coVarianceMatrix.get(i, j), buf, test2).toString();
                ++j;
            }
            ++i;
        }
        JDialog dialog = new JDialog((Frame)new JFrame(), name);
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        JTable Jtab = new JTable(X, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void calcDeviation() {
        this.setFittingParameters(this.sampleSet.getSample(0).getFunction().getFittingParams());
        this.init();
        System.out.println("");
        System.out.println("Co-variance matrix : ");
        this.calcCoVarianceMatrix();
        System.out.println("");
        System.out.println("Parameter uncertanty : ");
        this.calcParameterUncertainty();
        System.out.println("");
        System.out.println("Parameter std deviation : ");
        this.calcParameterStandardDeviation();
        this.calcCorrelationMatrix();
        this.incompleteGammaComplemented = Gamma.incompleteGammaComplement((double)((double)(this.sampleSet.getLength() - this.sampleSet.getSample(0).getFunction().getFittingParams().length) / 2.0), (double)(0.5 * this.chiSquare));
    }

    public void displayGraph() {
        try {
            if (this.sampleSet.getSample(0).getDependentValues().length <= 1) {
                lineFitPlot plot = new lineFitPlot("test", "test");
                plot.setXYVals(this.xVal[0], this.calcVal);
                plot.setLineXYVals(this.xVal[0], this.expVal);
                plot.init();
            } else {
                lineFitPlot plot = new lineFitPlot("test", "test");
                plot.setXYVals(this.xVal[0], this.expVal);
                plot.setLineXYVals(this.xVal[0], this.calcVal);
                plot.init();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void writeToCdfFile(String name) {
        NetCdf2D file = new NetCdf2D();
        file.setOutputFileName(name);
        file.setXvalues(this.xVal[0], "x", "sec");
        file.setYvalues(this.expVal, "experimental", "meter");
        file.setYvalues(this.calcVal, "calculated", "meter");
        file.createFile();
    }

    @Override
    public void writeToTextFile(String name) {
        TextFile tempfile = new TextFile();
        tempfile.setOutputFileName(name);
        tempfile.setValues(this.valTable);
        tempfile.createFile();
    }

    public void displaySimple() {
        this.calcAbsDev();
        try {
            this.displayGraph();
        }
        catch (Exception e) {
            System.out.println("could not display graph");
            e.printStackTrace();
        }
        try {
            this.displayResult();
        }
        catch (Exception e) {
            System.out.println("could not display graph");
            e.printStackTrace();
        }
        try {
            this.displayValues();
        }
        catch (Exception e) {
            System.out.println("could not display graph");
            e.printStackTrace();
        }
    }

    @Override
    public void displayCurveFit() {
        this.calcAbsDev();
        try {
            this.displayGraph();
        }
        catch (Exception e) {
            System.out.println("could not display graph");
            e.printStackTrace();
        }
        try {
            this.displayResult();
        }
        catch (Exception e) {
            System.out.println("could not display graph");
            e.printStackTrace();
        }
        try {
            this.displayValues();
        }
        catch (Exception e) {
            System.out.println("could not display graph");
            e.printStackTrace();
        }
        try {
            this.displayResultWithDeviation();
        }
        catch (Exception e) {
            System.out.println("could not calc deviation");
            e.printStackTrace();
        }
    }

    @Override
    public int getNumberOfTuningParameters() {
        return this.numberOfTuningParameters;
    }

    @Override
    public void setNumberOfTuningParameters(int numberOfTuningParameters) {
        this.numberOfTuningParameters = numberOfTuningParameters;
    }
}

