/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.parameterFitting;

import neqsim.statistics.parameterFitting.BaseFunction;
import neqsim.statistics.parameterFitting.FunctionInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class SampleValue
implements Cloneable {
    protected FunctionInterface testFunction;
    double sampleValue = 0.0;
    double[] dependentValues;
    String reference = "unknown";
    String description = "unknown";
    double standardDeviation = 1.0E-4;
    public SystemInterface system;
    public ThermodynamicOperations thermoOps;
    double[] standardDeviations;

    public SampleValue() {
    }

    public SampleValue(double sampleValue, double standardDeviation, double[] dependentValues) {
        this.dependentValues = new double[dependentValues.length];
        this.sampleValue = sampleValue;
        this.standardDeviation = standardDeviation;
        System.arraycopy(dependentValues, 0, this.dependentValues, 0, dependentValues.length);
    }

    public SampleValue(double sampleValue, double standardDeviation, double[] dependentValues, double[] standardDeviations) {
        this(sampleValue, standardDeviation, dependentValues);
        this.standardDeviations = standardDeviations;
    }

    public SampleValue clone() {
        SampleValue clonedValue = null;
        try {
            clonedValue = (SampleValue)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        clonedValue.testFunction = this.testFunction.clone();
        clonedValue.dependentValues = (double[])this.dependentValues.clone();
        System.arraycopy(this.dependentValues, 0, clonedValue.dependentValues, 0, this.dependentValues.length);
        return clonedValue;
    }

    public void setThermodynamicSystem(SystemInterface system) {
        this.system = system;
        this.thermoOps = new ThermodynamicOperations(system);
        this.getFunction().setThermodynamicSystem(this.system);
    }

    public void setFunction(BaseFunction function) {
        this.testFunction = function;
    }

    public FunctionInterface getFunction() {
        return this.testFunction;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double getStandardDeviation(int i) {
        return this.standardDeviations[i];
    }

    public double getSampleValue() {
        return this.sampleValue;
    }

    public double[] getDependentValues() {
        return this.dependentValues;
    }

    public double getDependentValue(int i) {
        return this.dependentValues[i];
    }

    public void setDependentValues(double[] vals) {
        System.arraycopy(vals, 0, this.dependentValues, 0, this.dependentValues.length);
    }

    public void setDependentValue(int i, double val) {
        this.dependentValues[i] = val;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

