/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.salesContract;

import java.awt.BorderLayout;
import java.awt.Container;
import java.sql.ResultSet;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.standards.StandardInterface;
import neqsim.standards.gasQuality.BestPracticeHydrocarbonDewPoint;
import neqsim.standards.gasQuality.Draft_ISO18453;
import neqsim.standards.gasQuality.GasChromotograpyhBase;
import neqsim.standards.gasQuality.Standard_ISO6976;
import neqsim.standards.gasQuality.SulfurSpecificationMethod;
import neqsim.standards.gasQuality.UKspecifications_ICF_SI;
import neqsim.standards.salesContract.ContractInterface;
import neqsim.standards.salesContract.ContractSpecification;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.database.NeqSimDataBase;

public class BaseContract
implements ContractInterface {
    private String[][] resultTable = new String[50][9];
    double waterDewPointTemperature = -12.0;
    double waterDewPointSpecPressure = 70.0;
    private String contractName = "";
    ContractSpecification[] spesifications = new ContractSpecification[50];
    private int specificationsNumber = 0;

    public BaseContract() {
    }

    public BaseContract(SystemInterface system) {
        Draft_ISO18453 standard = new Draft_ISO18453(system);
        this.spesifications[0] = new ContractSpecification("", "", "", "water dew point specification", standard, 0.0, 0.0, "degC", 0.0, 0.0, 0.0, "");
    }

    public BaseContract(SystemInterface system, String terminal, String country) {
        int numb = 0;
        this.setContractName(this.contractName);
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = null;
        try {
            try {
                dataSet = database.getResultSet("SELECT * FROM gascontractspecifications WHERE TERMINAL='" + terminal + "'" + " AND COUNTRY='" + country + "'");
                while (dataSet.next()) {
                    StandardInterface method = this.getMethod(system, dataSet.getString("METHOD"));
                    this.spesifications[++numb - 1] = this.getSpecification(method, dataSet.getString("NAME"), dataSet.getString("SPECIFICATION"), dataSet.getString("COUNTRY"), dataSet.getString("TERMINAL"), Double.parseDouble(dataSet.getString("MINVALUE")), Double.parseDouble(dataSet.getString("MAXVALUE")), dataSet.getString("UNIT"), Double.parseDouble(dataSet.getString("ReferenceTmeasurement")), Double.parseDouble(dataSet.getString("ReferenceTcombustion")), Double.parseDouble(dataSet.getString("ReferencePbar")), dataSet.getString("Comments"));
                    System.out.println("specification added..." + numb);
                }
            }
            catch (Exception e) {
                System.out.println("error in comp");
                e.printStackTrace();
                this.specificationsNumber = numb;
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e2) {
                    System.out.println("error closing database.....");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            this.specificationsNumber = numb;
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception e) {
                System.out.println("error closing database.....");
                e.printStackTrace();
            }
        }
    }

    public StandardInterface getMethod(SystemInterface system, String methodName) {
        if (methodName.equals("ISO18453")) {
            return new Draft_ISO18453(system);
        }
        if (methodName.equals("CO2")) {
            return new GasChromotograpyhBase(system, "CO2");
        }
        if (methodName.equals("H2S")) {
            return new GasChromotograpyhBase(system, "H2S");
        }
        if (methodName.equals("Total sulphur")) {
            return new GasChromotograpyhBase(system, "H2S");
        }
        if (methodName.equals("oxygen")) {
            return new GasChromotograpyhBase(system, "oxygen");
        }
        if (methodName.equals("ISO6976")) {
            return new Standard_ISO6976(system);
        }
        if (methodName.equals("SulfurSpecificationMethod")) {
            return new SulfurSpecificationMethod(system);
        }
        if (methodName.equals("BestPracticeHydrocarbonDewPoint")) {
            return new BestPracticeHydrocarbonDewPoint(system);
        }
        if (methodName.equals("UKspecifications")) {
            return new UKspecifications_ICF_SI(system);
        }
        return null;
    }

    public ContractSpecification getSpecification(StandardInterface method, String specificationName, String specificationName2, String country, String terminal, double minValue, double maxValue, String unit, double referenceTemperature, double referenceTemperatureComb, double referencePressure, String comments) {
        return new ContractSpecification(specificationName, specificationName2, country, terminal, method, minValue, maxValue, unit, referenceTemperature, referenceTemperatureComb, referencePressure, comments);
    }

    @Override
    public void runCheck() {
        int j = 0;
        this.resultTable = new String[this.specificationsNumber][12];
        int i = 0;
        while (i < this.specificationsNumber) {
            if (this.spesifications[i] != null) {
                try {
                    this.spesifications[i].getStandard().calculate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.spesifications[i].getStandard().setSalesContract(this);
                System.out.println("Type: " + this.spesifications[i].getDescription() + " Standard " + this.spesifications[i].getStandard().getName() + " : " + this.spesifications[i].getStandard().isOnSpec());
                this.getResultTable()[j][0] = this.spesifications[i].getDescription();
                this.getResultTable()[j][1] = Double.toString(this.spesifications[i].getStandard().getValue(this.spesifications[i].getName(), this.spesifications[i].getUnit()));
                this.getResultTable()[j][2] = this.spesifications[i].getCountry();
                this.getResultTable()[j][3] = this.spesifications[i].getTerminal();
                this.getResultTable()[j][4] = Double.toString(this.spesifications[i].getMinValue());
                this.getResultTable()[j][5] = Double.toString(this.spesifications[i].getMaxValue());
                this.getResultTable()[j][6] = this.spesifications[i].getUnit();
                this.getResultTable()[j][7] = this.spesifications[i].getStandard().getName();
                this.getResultTable()[j][8] = Double.toString(this.spesifications[i].getReferenceTemperatureMeasurement());
                this.getResultTable()[j][9] = Double.toString(this.spesifications[i].getReferenceTemperatureCombustion());
                this.getResultTable()[j][10] = Double.toString(this.spesifications[i].getReferencePressure());
                this.getResultTable()[j][11] = this.spesifications[i].getComments();
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void display() {
        JFrame dialog = new JFrame("Specification check against sales specifications: " + this.getContractName());
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[]{"Specification", "Value", "Country", "Terminal", "Minimum", "Maximum", "Unit", "Method", "Reference temperature measurement", "Reference temperature of combustion", "Reference pressure", "Comments"};
        JTable Jtab = new JTable(this.getResultTable(), names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void setContract(String name) {
        this.waterDewPointTemperature = -12.0;
        this.waterDewPointSpecPressure = 70.0;
    }

    @Override
    public double getWaterDewPointTemperature() {
        return this.waterDewPointTemperature;
    }

    @Override
    public void setWaterDewPointTemperature(double waterDewPointTemperature) {
        this.waterDewPointTemperature = waterDewPointTemperature;
    }

    @Override
    public double getWaterDewPointSpecPressure() {
        return this.waterDewPointSpecPressure;
    }

    @Override
    public void setWaterDewPointSpecPressure(double waterDewPointSpecPressure) {
        this.waterDewPointSpecPressure = waterDewPointSpecPressure;
    }

    @Override
    public int getSpecificationsNumber() {
        return this.specificationsNumber;
    }

    @Override
    public void setSpecificationsNumber(int specificationsNumber) {
        this.specificationsNumber = specificationsNumber;
    }

    @Override
    public String[][] getResultTable() {
        return this.resultTable;
    }

    @Override
    public void setResultTable(String[][] resultTable) {
        this.resultTable = resultTable;
    }

    @Override
    public String getContractName() {
        return this.contractName;
    }

    @Override
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
}

