/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasQuality;

import neqsim.standards.Standard;
import neqsim.standards.gasQuality.Standard_ISO6976;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class UKspecifications_ICF_SI
extends Standard {
    String componentName = "";
    String unit = "-";
    Standard_ISO6976 iso6976 = null;
    double propaneNumber = 0.0;

    public UKspecifications_ICF_SI() {
        this.name = "UKspecifications_ICF_SI";
        this.standardDescription = "UKspecifications_ICF_SI";
    }

    public UKspecifications_ICF_SI(SystemInterface thermoSystem) {
        super(thermoSystem);
        this.name = "UKspecifications_ICF_SI";
        this.iso6976 = new Standard_ISO6976(thermoSystem, 15.0, 15.0, "volume");
    }

    @Override
    public void calculate() {
        this.iso6976.calculate();
        this.propaneNumber = this.calcPropaneNumber();
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        if (returnParameter.equals("PropaneNumber")) {
            return this.propaneNumber;
        }
        if (returnParameter.equals("IncompleteCombustionFactor")) {
            return (this.iso6976.getValue("SuperiorWobbeIndex") / 1000.0 - 50.73 + 0.03 * this.propaneNumber) / 1.56;
        }
        if (returnParameter.equals("SootIndex")) {
            return 0.896 * Math.atan(0.0255 * this.thermoSystem.getPhase(0).getComponent("propane").getz() - 0.0233 * this.thermoSystem.getPhase(0).getComponent("nitrogen").getz() + 0.617);
        }
        return this.thermoSystem.getPhase(0).getComponent(this.componentName).getz();
    }

    @Override
    public double getValue(String returnParameter) {
        return this.thermoSystem.getPhase(0).getComponent(this.componentName).getz();
    }

    @Override
    public String getUnit(String returnParameter) {
        return this.unit;
    }

    @Override
    public boolean isOnSpec() {
        return true;
    }

    public double calcPropaneNumber() {
        double avgCarbon = this.iso6976.getAverageCarbonNumber();
        double[][] Amatrix = new double[][]{{1.0, 1.0}, {1.0, 3.0}};
        double[] bmatrix = new double[]{this.thermoSystem.getTotalNumberOfMoles() - this.iso6976.getTotalMolesOfInerts(), avgCarbon * (this.thermoSystem.getTotalNumberOfMoles() - this.iso6976.getTotalMolesOfInerts())};
        Array2DRowRealMatrix fmatrixJama = new Array2DRowRealMatrix(Amatrix);
        DecompositionSolver solver1 = new LUDecomposition(fmatrixJama).getSolver();
        RealMatrix ans2 = solver1.solve(new Array2DRowRealMatrix(bmatrix));
        double nitrogenCalc = this.calcWithNitrogenAsInert();
        System.out.println("nitrogen content pn " + nitrogenCalc);
        System.out.println("methane content pn " + ans2.getEntry(0, 0));
        System.out.println("propane content pn " + ans2.getEntry(1, 0));
        try {
            System.out.println("propane number " + (nitrogenCalc + ans2.getEntry(1, 0)) / this.thermoSystem.getTotalNumberOfMoles() * 100.0);
            return nitrogenCalc + ans2.getEntry(1, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0;
        }
    }

    public double calcWithNitrogenAsInert() {
        SystemInterface tempThermo = this.thermoSystem.clone();
        Standard_ISO6976 localIso6976 = new Standard_ISO6976(tempThermo);
        localIso6976.calculate();
        double targetWI = localIso6976.getValue("SuperiorWobbeIndex");
        if (!localIso6976.getThermoSystem().getPhase(0).hasComponent("nitrogen")) {
            localIso6976.getThermoSystem().addComponent("nitrogen", localIso6976.getThermoSystem().getNumberOfMoles() * 1.0E-50);
            localIso6976 = new Standard_ISO6976(tempThermo);
        }
        localIso6976.removeInertsButNitrogen();
        double newWI = targetWI / 1.01;
        double oldWI = 0.0;
        double dWIdN2 = 0.0;
        double dn2 = 0.1;
        int iter = 0;
        do {
            double olddn2 = dn2;
            dn2 = ++iter > 1 ? -(newWI - targetWI) / ((newWI - oldWI) / olddn2) : 0.1;
            oldWI = newWI;
            localIso6976.getThermoSystem().addComponent("nitrogen", dn2);
            localIso6976.getThermoSystem().init_x_y();
            localIso6976.calculate();
            newWI = localIso6976.getValue("SuperiorWobbeIndex");
            dWIdN2 = newWI - oldWI / 1.0;
            System.out.println("WI " + newWI);
            System.out.println("error " + Math.abs(targetWI - newWI));
        } while (Math.abs(targetWI - newWI) > 1.0E-6 && iter < 100);
        return tempThermo.getPhase(0).getComponent("nitrogen").getNumberOfmoles();
    }
}

