/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.util.monitor;

import neqsim.processSimulation.processEquipment.compressor.Compressor;

public class CompressorResponse {
    public String name = "test";
    public Double suctionTemperature;
    public Double dischargeTemperature;
    public Double suctionPressure;
    public Double dischargePressure;
    public Double polytropicHead;
    public Double polytropicEfficiency;
    public Double power;
    public Double suctionVolumeFlow;
    public Double internalVolumeFlow;
    public Double dischargeVolumeFlow;
    public Double molarMass;
    public Double suctionMassDensity;
    public Double dischargeMassDensity;
    public Double massflow;
    public Integer speed;

    public CompressorResponse() {
    }

    public CompressorResponse(Compressor inputCompressor) {
        this.name = inputCompressor.getName();
        this.molarMass = inputCompressor.getInStream().getFluid().getMolarMass();
        this.suctionMassDensity = inputCompressor.getInStream().getFluid().getDensity("kg/m3");
        this.dischargeMassDensity = inputCompressor.getOutStream().getFluid().getDensity("kg/m3");
        this.massflow = inputCompressor.getInStream().getFluid().getFlowRate("kg/hr");
        this.suctionVolumeFlow = inputCompressor.getInStream().getFluid().getFlowRate("m3/hr");
        this.dischargeVolumeFlow = inputCompressor.getOutStream().getFluid().getFlowRate("m3/hr");
        this.suctionPressure = inputCompressor.getInStream().getPressure("bara");
        this.suctionTemperature = inputCompressor.getInStream().getTemperature("C");
        this.dischargeTemperature = inputCompressor.getOutStream().getTemperature("C");
        this.dischargePressure = inputCompressor.getOutStream().getPressure("bara");
        this.polytropicHead = inputCompressor.getPolytropicFluidHead();
        this.polytropicEfficiency = inputCompressor.getPolytropicEfficiency();
        this.power = inputCompressor.getPower("kW");
        this.speed = inputCompressor.getSpeed();
        if (inputCompressor.getAntiSurge().isActive()) {
            this.internalVolumeFlow = inputCompressor.getCompressorChart().getSurgeCurve().getSurgeFlow(this.polytropicHead);
        }
    }
}

