/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processSystem.processModules;

import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.compressor.Compressor;
import neqsim.processSimulation.processEquipment.heatExchanger.Cooler;
import neqsim.processSimulation.processEquipment.heatExchanger.Heater;
import neqsim.processSimulation.processEquipment.mixer.Mixer;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.separator.ThreePhaseSeparator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processEquipment.util.Recycle;
import neqsim.processSimulation.processEquipment.valve.ThrottlingValve;
import neqsim.processSimulation.processSystem.ProcessModuleBaseClass;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;

public class SeparationTrainModuleSimple
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    protected StreamInterface feedStream = null;
    protected StreamInterface gasExitStream = null;
    protected StreamInterface oilExitStream = null;
    Separator gasInletScrubber = null;
    Cooler oilCooler;
    double secondstagePressure = 15.0;
    double thirdstagePressure = 1.5;
    double heatedOilTemperature = 323.15;
    double exitGasScrubberTemperature = 303.15;
    double firstStageCompressorAfterCoolerTemperature = 303.15;
    double exportOilTemperature = 303.15;

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("feed stream")) {
            this.feedStream = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (streamName.equals("gas exit stream")) {
            return this.gasExitStream;
        }
        if (streamName.equals("oil exit stream")) {
            return this.oilExitStream;
        }
        return null;
    }

    @Override
    public void run() {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        this.getOperations().run();
        this.gasExitStream = this.gasInletScrubber.getGasOutStream();
        this.oilExitStream = this.oilCooler.getOutStream();
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        double inletPressure = this.feedStream.getPressure();
        Separator inletSeparator = new Separator("Inlet separator", this.feedStream);
        Heater liquidOutHeater = new Heater("oil/water heater", inletSeparator.getLiquidOutStream());
        liquidOutHeater.setOutTemperature(this.heatedOilTemperature);
        ThreePhaseSeparator firstStageSeparator = new ThreePhaseSeparator("1st stage separator", liquidOutHeater.getOutStream());
        ThrottlingValve valve1 = new ThrottlingValve("1stTo2ndStageOilValve", firstStageSeparator.getOilOutStream());
        valve1.setOutletPressure(this.secondstagePressure);
        ThreePhaseSeparator secondStageSeparator = new ThreePhaseSeparator("2nd stage Separator", valve1.getOutStream());
        ThrottlingValve thirdStageValve = new ThrottlingValve("2-3stageOilValve", secondStageSeparator.getLiquidOutStream());
        thirdStageValve.setOutletPressure(this.thirdstagePressure);
        ThreePhaseSeparator thirdStageSeparator = new ThreePhaseSeparator("3rd stage Separator", thirdStageValve.getOutStream());
        this.oilCooler = new Cooler("export oil cooler", thirdStageSeparator.getLiquidOutStream());
        this.oilCooler.setOutTemperature(this.exportOilTemperature);
        Compressor thirdStageCompressor = new Compressor("3rd stage recompressor", thirdStageSeparator.getGasOutStream());
        thirdStageCompressor.setOutletPressure(this.secondstagePressure);
        Cooler thirdSstageCoooler = new Cooler("3rd stage cooler", thirdStageCompressor.getOutStream());
        thirdSstageCoooler.setOutTemperature(this.firstStageCompressorAfterCoolerTemperature);
        Mixer thirdStageMixer = new Mixer("1st and 2nd stage gas mixer");
        thirdStageMixer.addStream(thirdSstageCoooler.getOutStream());
        thirdStageMixer.addStream(secondStageSeparator.getGasOutStream());
        Separator thirdStageScrubber = new Separator("recompression scrubber", thirdStageMixer.getOutStream());
        secondStageSeparator.addStream(thirdStageScrubber.getLiquidOutStream());
        Compressor secondStageCompressor = new Compressor("2nd stage recompressor", thirdStageScrubber.getGasOutStream());
        secondStageCompressor.setOutletPressure(inletPressure);
        Mixer HPgasMixer = new Mixer("HPgas mixer");
        HPgasMixer.addStream(firstStageSeparator.getGasOutStream());
        HPgasMixer.addStream(secondStageCompressor.getOutStream());
        HPgasMixer.addStream(inletSeparator.getGasOutStream());
        Cooler inletGasCooler = new Cooler("HP gas cooler", HPgasMixer.getOutStream());
        inletGasCooler.setOutTemperature(this.exitGasScrubberTemperature);
        this.gasInletScrubber = new Separator("HP gas scrubber", inletGasCooler.getOutStream());
        Recycle HPliquidRecycle = new Recycle("Resycle");
        double tolerance = 1.0E-10;
        HPliquidRecycle.setTolerance(tolerance);
        HPliquidRecycle.addStream(this.gasInletScrubber.getLiquidOutStream());
        inletSeparator.addStream(HPliquidRecycle.getOutStream());
        this.getOperations().add(inletSeparator);
        this.getOperations().add(liquidOutHeater);
        this.getOperations().add(firstStageSeparator);
        this.getOperations().add(valve1);
        this.getOperations().add(secondStageSeparator);
        this.getOperations().add(thirdStageValve);
        this.getOperations().add(thirdStageSeparator);
        this.getOperations().add(thirdStageCompressor);
        this.getOperations().add(thirdStageMixer);
        this.getOperations().add(thirdSstageCoooler);
        this.getOperations().add(thirdStageScrubber);
        this.getOperations().add(HPliquidRecycle);
        this.getOperations().add(secondStageCompressor);
        this.getOperations().add(this.oilCooler);
        this.getOperations().add(HPgasMixer);
        this.getOperations().add(inletGasCooler);
        this.getOperations().add(this.gasInletScrubber);
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
    }

    @Override
    public void runTransient(double dt) {
        this.getOperations().runTransient();
    }

    @Override
    public void calcDesign() {
    }

    @Override
    public void setDesign() {
    }

    @Override
    public void setSpecification(String specificationName, double value) {
        if (specificationName.equals("Second stage pressure")) {
            this.secondstagePressure = value;
        }
        if (specificationName.equals("heated oil temperature")) {
            this.heatedOilTemperature = value;
        }
        if (specificationName.equals("Third stage pressure")) {
            this.thirdstagePressure = value;
        }
        if (specificationName.equals("Gas exit temperature")) {
            this.exitGasScrubberTemperature = value;
        }
        if (specificationName.equals("First stage compressor after cooler temperature")) {
            this.firstStageCompressorAfterCoolerTemperature = value;
        }
        if (specificationName.equals("Export oil temperature")) {
            this.exportOilTemperature = value;
        }
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(323.15, 65.0);
        testSystem.addComponent("methane", 95.0);
        testSystem.addComponent("nC10", 6.0);
        testSystem.addComponent("water", 12.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.setMultiPhaseCheck(true);
        testSystem.init(0);
        testSystem.init(3);
        double a = testSystem.getTotalNumberOfMoles();
        Stream wellStream = new Stream("Well stream", testSystem);
        SeparationTrainModuleSimple separationModule = new SeparationTrainModuleSimple();
        separationModule.addInputStream("feed stream", wellStream);
        separationModule.setSpecification("Second stage pressure", 15.0);
        separationModule.setSpecification("heated oil temperature", 328.15);
        separationModule.setSpecification("Third stage pressure", 1.0);
        separationModule.setSpecification("Gas exit temperature", 298.15);
        separationModule.setSpecification("First stage compressor after cooler temperature", 298.15);
        separationModule.setSpecification("Export oil temperature", 298.15);
        ProcessSystem operations = new ProcessSystem();
        operations.add(wellStream);
        operations.add(separationModule);
        operations.run();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("Inlet separator")).getMechanicalDesign().calcDesign();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("Inlet separator")).getMechanicalDesign().displayResults();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("1st stage separator")).getMechanicalDesign().calcDesign();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("1st stage separator")).getMechanicalDesign().displayResults();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("2nd stage Separator")).getMechanicalDesign().calcDesign();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("2nd stage Separator")).getMechanicalDesign().displayResults();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("3rd stage Separator")).getMechanicalDesign().calcDesign();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("3rd stage Separator")).getMechanicalDesign().displayResults();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("2nd stage recompressor")).getMechanicalDesign().calcDesign();
        ((ProcessEquipmentInterface)separationModule.getOperations().getUnit("2nd stage recompressor")).getMechanicalDesign().displayResults();
        operations.getSystemMechanicalDesign().runDesignCalculation();
        operations.getSystemMechanicalDesign().getTotalPlotSpace();
        System.out.println("Modules " + operations.getSystemMechanicalDesign().getTotalVolume());
        System.out.println("Modules " + operations.getSystemMechanicalDesign().getTotalNumberOfModules());
        System.out.println("Weight " + operations.getSystemMechanicalDesign().getTotalWeight());
        System.out.println("Plot space " + operations.getSystemMechanicalDesign().getTotalPlotSpace());
        System.out.println("CAPEX " + operations.getCostEstimator().getWeightBasedCAPEXEstimate());
        System.out.println("CAPEX " + operations.getCostEstimator().getCAPEXestimate());
    }
}

