/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processSystem.processModules;

import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.adsorber.SimpleAdsorber;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessModuleBaseClass;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;

public class AdsorptionDehydrationlModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    protected StreamInterface gasStreamToAdsorber = null;
    protected StreamInterface gasStreamFromAdsorber = null;
    protected SimpleAdsorber[] adsorber = null;
    double regenerationCycleTime = 1.0;
    double waterDewPontTemperature = 263.15;
    double designFlow = 1.0;
    double designAdsorptionTemperature = 298.0;
    double designRegenerationTemperature = 440.0;
    double designAdsorptionPressure = 60.0;
    int numberOfAdorptionBeds = 3;
    double adsorberInternalDiameter = 1.0;
    double adsorbentFillingHeight = 3.0;

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("gasStreamToAdsorber")) {
            this.gasStreamToAdsorber = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (streamName.equals("gasStreamFromAdsorber")) {
            return this.gasStreamFromAdsorber;
        }
        return null;
    }

    @Override
    public ProcessEquipmentInterface getUnit(String unitName) {
        if (unitName.equals("adorber_0")) {
            return this.adsorber[0];
        }
        if (unitName.equals("adorber_1")) {
            return this.adsorber[1];
        }
        if (unitName.equals("adorber_2")) {
            return this.adsorber[2];
        }
        return null;
    }

    @Override
    public void run() {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        this.gasStreamToAdsorber.run();
        this.getOperations().run();
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
        try {
            this.adsorber = new SimpleAdsorber[this.numberOfAdorptionBeds];
            int i = 0;
            while (i < this.numberOfAdorptionBeds) {
                this.adsorber[i] = new SimpleAdsorber(this.gasStreamToAdsorber);
                ++i;
            }
            this.gasStreamFromAdsorber = (Stream)this.gasStreamToAdsorber.clone();
            this.gasStreamFromAdsorber.setName("Stream from Adsorber");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        this.getOperations().add(this.gasStreamToAdsorber);
    }

    @Override
    public void runTransient(double dt) {
        this.getOperations().runTransient();
    }

    @Override
    public void setSpecification(String specificationName, double value) {
        if (specificationName.equals("water dew point temperature")) {
            this.waterDewPontTemperature = value;
        }
        if (specificationName.equals("designFlow")) {
            this.designFlow = value;
        }
        if (specificationName.equals("designAdsorptionTemperature")) {
            this.designAdsorptionTemperature = value;
        }
        if (specificationName.equals("designRegenerationTemperature")) {
            this.designRegenerationTemperature = value;
        }
        if (specificationName.equals("designAdsorptionPressure")) {
            this.designAdsorptionPressure = value;
        }
        if (specificationName.equals("regenerationCycleTime")) {
            this.regenerationCycleTime = value;
        }
    }

    @Override
    public void calcDesign() {
        Stream tempStream = (Stream)this.gasStreamToAdsorber.clone();
        tempStream.getThermoSystem().setPressure(this.designAdsorptionPressure);
        tempStream.getThermoSystem().setTemperature(this.designAdsorptionTemperature);
        tempStream.run();
        tempStream.getThermoSystem().initPhysicalProperties();
        double gasDensity = tempStream.getThermoSystem().getPhase(0).getPhysicalProperties().getDensity();
        double gasVelocity = 67.0 / Math.sqrt(gasDensity);
        double qa = this.designFlow / ((double)this.numberOfAdorptionBeds - 1.0) / 1440.0 * (1.01325 / this.designAdsorptionPressure) * (this.designAdsorptionTemperature / 288.15) * tempStream.getThermoSystem().getPhase(0).getZ();
        this.adsorberInternalDiameter = Math.sqrt(4.0 * qa / Math.PI / gasVelocity);
        double waterLoadingCycle = this.regenerationCycleTime * this.designFlow * 42.29489667 * tempStream.getThermoSystem().getPhase(0).getComponent("water").getx() * tempStream.getThermoSystem().getPhase(0).getComponent("water").getMolarMass();
        double usefulDesiccantCapacity = 10.0;
        double bulkDensityDesiccant = 750.0;
        this.adsorbentFillingHeight = 400.0 * waterLoadingCycle / (Math.PI * usefulDesiccantCapacity * bulkDensityDesiccant * this.adsorberInternalDiameter * this.adsorberInternalDiameter);
    }

    @Override
    public void setDesign() {
        int i = 0;
        while (i < this.numberOfAdorptionBeds) {
            this.adsorber[i].getMechanicalDesign().setInnerDiameter(this.adsorberInternalDiameter);
            this.adsorber[i].getMechanicalDesign().setTantanLength(this.adsorbentFillingHeight * 1.5);
            ++i;
        }
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(303.15, 10.0);
        testSystem.addComponent("methane", 1.0);
        testSystem.addComponent("water", 1.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        Stream inletStream = new Stream(testSystem);
        Separator separator = new Separator("Separator 1", inletStream);
        AdsorptionDehydrationlModule adsorptionPlant = new AdsorptionDehydrationlModule();
        adsorptionPlant.addInputStream("gasStreamToAdsorber", separator.getGasOutStream());
        adsorptionPlant.setSpecification("water dew point temperature", 173.14999999999998);
        adsorptionPlant.setSpecification("designFlow", 2.0E7);
        adsorptionPlant.setSpecification("designAdsorptionTemperature", 303.15);
        adsorptionPlant.setSpecification("designRegenerationTemperature", 523.15);
        adsorptionPlant.setSpecification("designAdsorptionPressure", 60.0);
        adsorptionPlant.setSpecification("regenerationCycleTime", 1.0);
        adsorptionPlant.setSpecification("maxDesignPressure", 100.0);
        adsorptionPlant.setSpecification("maxDesignTemperature", 100.0);
        ProcessSystem operations = new ProcessSystem();
        operations.add(inletStream);
        operations.add(separator);
        operations.add(adsorptionPlant);
        operations.run();
        adsorptionPlant.calcDesign();
    }
}

