/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import java.io.Serializable;
import java.util.ArrayList;
import neqsim.processSimulation.processEquipment.util.Recycle;

public class RecycleController
implements Serializable {
    private static final long serialVersionUID = 1000L;
    ArrayList<Recycle> recycleArray = new ArrayList();
    ArrayList<Integer> priorityArray = new ArrayList();
    private int currentPriorityLevel = 100;
    private int minimumPriorityLevel = 100;
    private int maximumPriorityLevel = 100;

    public void init() {
        for (Recycle recyc : this.recycleArray) {
            if (recyc.getPriority() < this.minimumPriorityLevel) {
                this.minimumPriorityLevel = recyc.getPriority();
            }
            if (recyc.getPriority() <= this.maximumPriorityLevel) continue;
            this.maximumPriorityLevel = recyc.getPriority();
        }
        this.currentPriorityLevel = this.minimumPriorityLevel;
    }

    public void resetPriorityLevel() {
        this.currentPriorityLevel = this.minimumPriorityLevel;
    }

    public void addRecycle(Recycle recycle) {
        this.recycleArray.add(recycle);
        this.priorityArray.add(recycle.getPriority());
    }

    public boolean doSolveRecycle(Recycle recycle) {
        return recycle.getPriority() == this.getCurrentPriorityLevel();
    }

    public boolean isHighestPriority(Recycle recycle) {
        return recycle.getPriority() == this.maximumPriorityLevel;
    }

    public boolean solvedCurrentPriorityLevel() {
        for (Recycle recyc : this.recycleArray) {
            if (recyc.getPriority() != this.currentPriorityLevel || recyc.solved()) continue;
            return false;
        }
        return true;
    }

    public void nextPriorityLevel() {
        this.currentPriorityLevel = this.maximumPriorityLevel;
    }

    public boolean hasLoverPriorityLevel() {
        return this.currentPriorityLevel > this.minimumPriorityLevel;
    }

    public boolean hasHigherPriorityLevel() {
        return this.currentPriorityLevel < this.maximumPriorityLevel;
    }

    public boolean solvedAll() {
        for (Recycle recyc : this.recycleArray) {
            if (recyc.solved()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.recycleArray.clear();
        this.priorityArray.clear();
    }

    public static void main(String[] args) {
    }

    public int getCurrentPriorityLevel() {
        return this.currentPriorityLevel;
    }

    public void setCurrentPriorityLevel(int currentPriorityLevel) {
        this.currentPriorityLevel = currentPriorityLevel;
    }
}

