/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import neqsim.processSimulation.measurementDevice.MultiPhaseMeter;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class GORfitter
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    public StreamInterface inletStream = null;
    public StreamInterface outletStream = null;
    double pressure = 1.01325;
    double temperature = 15.0;
    private String referenceConditions = "standard";
    private boolean fitAsGVF = false;
    private double GOR = 120.0;
    private double GVF;
    String unitT = "C";
    String unitP = "bara";

    public GORfitter() {
        this.name = "GOR fitter";
    }

    public GORfitter(StreamInterface stream) {
        this();
        this.name = "GOR fitter";
        this.inletStream = stream;
        this.outletStream = stream.clone();
    }

    public double getGFV() {
        return this.GVF;
    }

    public GORfitter(String name, StreamInterface stream) {
        this(stream);
        this.name = name;
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        try {
            this.outletStream = inletStream.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StreamInterface getOutStream() {
        return this.outletStream;
    }

    @Override
    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double pressure, String unitP) {
        this.pressure = pressure;
        this.unitP = unitP;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature, String unitT) {
        this.temperature = temperature;
        this.unitT = unitT;
    }

    @Override
    public void run() {
        SystemInterface tempFluid = this.inletStream.getThermoSystem().clone();
        double flow = tempFluid.getFlowRate("kg/sec");
        if (!this.getReferenceConditions().equals("actual")) {
            tempFluid.setTemperature(15.0, "C");
            tempFluid.setPressure(1.01325, "bara");
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
        try {
            thermoOps.TPflash();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!tempFluid.hasPhaseType("gas") || !tempFluid.hasPhaseType("oil")) {
            this.outletStream = this.inletStream.clone();
            return;
        }
        tempFluid.initPhysicalProperties("density");
        double currGOR = tempFluid.getPhase("gas").getCorrectedVolume() / tempFluid.getPhase("oil").getCorrectedVolume();
        if (this.fitAsGVF) {
            this.GOR = tempFluid.getPhase("oil").getCorrectedVolume() * this.getGOR() / (tempFluid.getPhase("oil").getCorrectedVolume() - tempFluid.getPhase("oil").getCorrectedVolume() * this.getGOR());
        }
        double dev = this.getGOR() / currGOR;
        double[] moleChange = new double[tempFluid.getNumberOfComponents()];
        int i = 0;
        while (i < tempFluid.getNumberOfComponents()) {
            moleChange[i] = (dev - 1.0) * tempFluid.getPhase("gas").getComponent(i).getNumberOfMolesInPhase();
            ++i;
        }
        tempFluid.init(0);
        i = 0;
        while (i < tempFluid.getNumberOfComponents()) {
            tempFluid.addComponent(i, moleChange[i]);
            ++i;
        }
        tempFluid.setPressure(this.inletStream.getThermoSystem().getPressure());
        tempFluid.setTemperature(this.inletStream.getThermoSystem().getTemperature());
        tempFluid.setTotalFlowRate(flow, "kg/sec");
        try {
            thermoOps.TPflash();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.outletStream.setThermoSystem(tempFluid);
        this.GVF = tempFluid.getPhase("gas").getCorrectedVolume() / (tempFluid.getPhase("oil").getCorrectedVolume() + tempFluid.getPhase("gas").getCorrectedVolume());
    }

    public static void main(String[] args) {
        SystemSrkEos testFluid = new SystemSrkEos(338.15, 50.0);
        testFluid.addComponent("nitrogen", 1.205);
        testFluid.addComponent("CO2", 1.34);
        testFluid.addComponent("methane", 87.974);
        testFluid.addComponent("ethane", 5.258);
        testFluid.addComponent("propane", 3.283);
        testFluid.addComponent("i-butane", 0.082);
        testFluid.addComponent("n-butane", 0.487);
        testFluid.addComponent("i-pentane", 0.056);
        testFluid.addComponent("n-pentane", 1.053);
        testFluid.addComponent("nC10", 4.053);
        testFluid.setMixingRule(2);
        testFluid.setMultiPhaseCheck(true);
        testFluid.setTemperature(90.0, "C");
        testFluid.setPressure(60.0, "bara");
        testFluid.setTotalFlowRate(1000000.0, "kg/hr");
        Stream stream_1 = new Stream("Stream1", testFluid);
        MultiPhaseMeter multiPhaseMeter = new MultiPhaseMeter("test", stream_1);
        multiPhaseMeter.setTemperature(90.0, "C");
        multiPhaseMeter.setPressure(60.0, "bara");
        GORfitter gORFItter = new GORfitter("test", stream_1);
        gORFItter.setTemperature(15.0, "C");
        gORFItter.setPressure(1.01325, "bara");
        gORFItter.setReferenceConditions("actual");
        gORFItter.setGOR(10.1);
        Stream stream_2 = new Stream(gORFItter.getOutStream());
        MultiPhaseMeter multiPhaseMeter2 = new MultiPhaseMeter("test", stream_2);
        multiPhaseMeter2.setTemperature(90.0, "C");
        multiPhaseMeter2.setPressure(60.0, "bara");
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(multiPhaseMeter);
        operations.add(gORFItter);
        operations.add(stream_2);
        operations.add(multiPhaseMeter2);
        operations.run();
        System.out.println("GOR " + multiPhaseMeter.getMeasuredValue("GOR"));
        System.out.println("GOR_std " + multiPhaseMeter.getMeasuredValue("GOR_std"));
        System.out.println("GOR2 " + multiPhaseMeter2.getMeasuredValue("GOR"));
        System.out.println("GOR2_std " + multiPhaseMeter2.getMeasuredValue("GOR_std"));
        System.out.println("stream_2 flow " + stream_2.getFlowRate("kg/hr"));
    }

    public double getGOR() {
        return this.GOR;
    }

    public void setGOR(double gOR) {
        this.fitAsGVF = false;
        this.GOR = gOR;
    }

    public void setGVF(double gvf) {
        this.fitAsGVF = true;
        this.GOR = gvf;
    }

    public String getReferenceConditions() {
        return this.referenceConditions;
    }

    public void setReferenceConditions(String referenceConditions) {
        this.referenceConditions = referenceConditions;
    }

    public boolean isFitAsGVF() {
        return this.fitAsGVF;
    }

    public void setFitAsGVF(boolean fitAsGVF) {
        this.fitAsGVF = fitAsGVF;
    }
}

