/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.splitter;

import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.splitter.SplitterInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Splitter
extends ProcessEquipmentBaseClass
implements SplitterInterface {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    StreamInterface inletStream;
    StreamInterface[] splitStream;
    protected int splitNumber;
    double[] splitFactor = new double[1];

    public Splitter() {
    }

    public Splitter(StreamInterface inletStream) {
        this.setInletStream(inletStream);
    }

    public Splitter(String name, StreamInterface inletStream, int i) {
        this(inletStream);
        this.name = name;
        this.setSplitNumber(i);
        this.splitFactor = new double[i];
    }

    @Override
    public void setSplitNumber(int i) {
        this.splitNumber = i;
        this.setInletStream(this.inletStream);
        this.splitFactor = new double[this.splitNumber];
        this.splitFactor[0] = 1.0;
    }

    public void setSplitFactors(double[] splitFact) {
        double sum = 0.0;
        int i = 0;
        while (i < splitFact.length) {
            if (splitFact[i] < 0.0) {
                splitFact[i] = 0.0;
            }
            sum += splitFact[i];
            ++i;
        }
        this.splitFactor = new double[splitFact.length];
        i = 0;
        while (i < splitFact.length) {
            this.splitFactor[i] = splitFact[i] / sum;
            ++i;
        }
        this.splitNumber = splitFact.length;
        this.setInletStream(this.inletStream);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.splitStream = new Stream[this.splitNumber];
        try {
            int i = 0;
            while (i < this.splitNumber) {
                this.splitStream[i] = new Stream("Split Stream", inletStream.getThermoSystem().clone());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Stream getSplitStream(int i) {
        return (Stream)this.splitStream[i];
    }

    @Override
    public void run() {
        int i = 0;
        while (i < this.splitNumber) {
            this.thermoSystem = this.inletStream.getThermoSystem().clone();
            this.thermoSystem.init(0);
            this.splitStream[i].setThermoSystem(this.thermoSystem);
            int j = 0;
            while (j < this.inletStream.getThermoSystem().getPhase(0).getNumberOfComponents()) {
                int index = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getComponentNumber();
                double moles = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getNumberOfmoles();
                this.splitStream[i].getThermoSystem().addComponent(index, moles * this.splitFactor[i] - moles);
                ++j;
            }
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.splitStream[i].getThermoSystem());
            thermoOps.TPflash();
            ++i;
        }
    }

    @Override
    public void displayResult() {
    }

    @Override
    public void runTransient(double dt) {
    }
}

