/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.separator.sectionType;

import java.io.Serializable;
import neqsim.processSimulation.mechanicalDesign.separator.sectionType.SepDesignSection;
import neqsim.processSimulation.processEquipment.separator.Separator;

public class SeparatorSection
implements Serializable {
    private static final long serialVersionUID = 1000L;
    private double efficiency = 0.95;
    public Separator separator = null;
    private boolean calcEfficiency = false;
    private double pressureDrop = 0.0066;
    protected String name = "1";
    String type;
    public double outerDiameter = 1.0;
    public SepDesignSection mechanicalDesign = null;

    public SeparatorSection(String type, Separator sep) {
        this.type = type;
        this.separator = sep;
        this.mechanicalDesign = new SepDesignSection(this);
    }

    public SeparatorSection(String name, String type, Separator sep) {
        this(type, sep);
        this.name = name;
    }

    public double calcEfficiency() {
        return this.efficiency;
    }

    public double getEfficiency() {
        if (this.isCalcEfficiency()) {
            return this.calcEfficiency();
        }
        return this.efficiency;
    }

    public void setEfficiency(double efficiency) {
        this.efficiency = efficiency;
    }

    public boolean isCalcEfficiency() {
        return this.calcEfficiency;
    }

    public void setCalcEfficiency(boolean calcEfficiency) {
        this.calcEfficiency = calcEfficiency;
    }

    public double getMinimumLiquidSealHeight() {
        return this.getPressureDrop() * 100000.0 / 9.80665 / (this.getSeparator().getThermoSystem().getPhase(1).getPhysicalProperties().getDensity() - this.getSeparator().getThermoSystem().getPhase(0).getPhysicalProperties().getDensity());
    }

    public double getPressureDrop() {
        return this.pressureDrop;
    }

    public void setPressureDrop(double pressureDrop) {
        this.pressureDrop = pressureDrop;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SepDesignSection getMechanicalDesign() {
        return this.mechanicalDesign;
    }

    public void setMechanicalDesign(SepDesignSection mechanicalDesign) {
        this.mechanicalDesign = mechanicalDesign;
    }

    public Separator getSeparator() {
        return this.separator;
    }

    public void setSeparator(Separator separator) {
        this.separator = separator;
    }

    public double getOuterDiameter() {
        return this.outerDiameter;
    }

    public void setOuterDiameter(double outerDiameter) {
        this.outerDiameter = outerDiameter;
    }
}

