/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.separator;

import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;

public class TwoPhaseSeparator
extends Separator {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    StreamInterface inletStream;
    StreamInterface gasOutStream;
    StreamInterface liquidOutStream;
    String name = new String();

    public TwoPhaseSeparator() {
    }

    public TwoPhaseSeparator(StreamInterface inletStream) {
        this.setInletStream(inletStream);
    }

    public TwoPhaseSeparator(String name, StreamInterface inletStream) {
        this.name = name;
        this.setInletStream(inletStream);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasOutStream = new Stream(this.gasSystem);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidOutStream = new Stream(this.liquidSystem);
    }

    @Override
    public StreamInterface getLiquidOutStream() {
        return this.liquidOutStream;
    }

    @Override
    public StreamInterface getGasOutStream() {
        return this.gasOutStream;
    }

    @Override
    public StreamInterface getGas() {
        return this.getGasOutStream();
    }

    @Override
    public StreamInterface getLiquid() {
        return this.getLiquidOutStream();
    }

    @Override
    public void run() {
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasSystem.setNumberOfPhases(1);
        this.gasOutStream.setThermoSystem(this.gasSystem);
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidSystem.setNumberOfPhases(1);
        this.liquidOutStream.setThermoSystem(this.liquidSystem);
    }

    @Override
    public void displayResult() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void runTransient() {
    }
}

