/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.separator;

import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class ThreePhaseSeparator
extends Separator {
    private static final long serialVersionUID = 1000L;
    StreamInterface waterOutStream;
    String specifiedStream;
    double gasInAqueous;
    String gasInAqueousSpec;
    double gasInOil;
    String gasInOilSpec;
    double oilInGas;
    String oilInGasSpec;
    double oilInAqueous;
    String oilInAqueousSpec;
    double aqueousInGas;
    String aqueousInGasSpec;
    double aqueousInOil;
    String aqueousInOilSpec;

    public ThreePhaseSeparator() {
        this.waterOutStream = new Stream(this.waterSystem);
        this.specifiedStream = "feed";
        this.gasInAqueous = 0.0;
        this.gasInAqueousSpec = "mole";
        this.gasInOil = 0.0;
        this.gasInOilSpec = "mole";
        this.oilInGas = 0.0;
        this.oilInGasSpec = "mole";
        this.oilInAqueous = 0.0;
        this.oilInAqueousSpec = "mole";
        this.aqueousInGas = 0.0;
        this.aqueousInGasSpec = "mole";
        this.aqueousInOil = 0.0;
        this.aqueousInOilSpec = "mole";
    }

    public ThreePhaseSeparator(StreamInterface inletStream) {
        this();
        this.addStream(inletStream);
    }

    public ThreePhaseSeparator(String name, StreamInterface inletStream) {
        this();
        this.setName(name);
        this.addStream(inletStream);
    }

    public void setEntrainment(double val, String specType, String specifiedStream, String phaseFrom, String phaseTo) {
        this.specifiedStream = specifiedStream;
        if (phaseFrom.equals("gas") && phaseTo.equals("aqueous")) {
            this.gasInAqueous = val;
            this.gasInAqueousSpec = specType;
        }
        if (phaseFrom.equals("gas") && phaseTo.equals("oil")) {
            this.gasInOil = val;
            this.gasInOilSpec = specType;
        }
        if (phaseFrom.equals("oil") && phaseTo.equals("aqueous")) {
            this.oilInAqueous = val;
            this.oilInAqueousSpec = specType;
        }
        if (phaseFrom.equals("oil") && phaseTo.equals("gas")) {
            this.oilInGas = val;
            this.oilInGasSpec = specType;
        }
        if (phaseFrom.equals("aqueous") && phaseTo.equals("gas")) {
            this.aqueousInGas = val;
            this.aqueousInGasSpec = specType;
        }
        if (phaseFrom.equals("aqueous") && phaseTo.equals("oil")) {
            this.aqueousInOil = val;
            this.aqueousInOilSpec = specType;
        }
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        super.setInletStream(inletStream);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.waterSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.waterOutStream = new Stream(this.waterSystem);
    }

    public StreamInterface getWaterOutStream() {
        return this.waterOutStream;
    }

    public StreamInterface getOilOutStream() {
        return this.liquidOutStream;
    }

    @Override
    public void run() {
        this.inletStreamMixer.run();
        this.thermoSystem = this.inletStreamMixer.getOutStream().getThermoSystem().clone();
        this.thermoSystem.setMultiPhaseCheck(true);
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.TPflash();
        this.thermoSystem.addPhaseFractionToPhase(this.gasInAqueous, this.gasInAqueousSpec, this.specifiedStream, "gas", "aqueous");
        this.thermoSystem.addPhaseFractionToPhase(this.gasInOil, this.gasInOilSpec, this.specifiedStream, "gas", "oil");
        this.thermoSystem.addPhaseFractionToPhase(this.oilInAqueous, this.oilInAqueousSpec, this.specifiedStream, "oil", "aqueous");
        this.thermoSystem.addPhaseFractionToPhase(this.oilInGas, this.oilInGasSpec, this.specifiedStream, "oil", "gas");
        this.thermoSystem.addPhaseFractionToPhase(this.aqueousInGas, this.aqueousInGasSpec, this.specifiedStream, "aqueous", "gas");
        this.thermoSystem.addPhaseFractionToPhase(this.aqueousInOil, this.aqueousInOilSpec, this.specifiedStream, "aqueous", "oil");
        if (this.thermoSystem.hasPhaseType("gas")) {
            this.gasOutStream.setThermoSystemFromPhase(this.thermoSystem, "gas");
        } else {
            this.gasOutStream.setThermoSystem(this.thermoSystem.getEmptySystemClone());
        }
        if (this.thermoSystem.hasPhaseType("oil")) {
            this.liquidOutStream.setThermoSystemFromPhase(this.thermoSystem, "oil");
        } else {
            this.liquidOutStream.setThermoSystem(this.thermoSystem.getEmptySystemClone());
        }
        if (this.thermoSystem.hasPhaseType("aqueous")) {
            this.waterOutStream.setThermoSystemFromPhase(this.thermoSystem, "aqueous");
        } else {
            this.waterOutStream.setThermoSystem(this.thermoSystem.getEmptySystemClone());
        }
        this.gasOutStream.run();
        this.liquidOutStream.run();
        this.waterOutStream.run();
    }

    @Override
    public void displayResult() {
        this.thermoSystem.display("from here " + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void runTransient() {
    }

    @Override
    public double getEntropyProduction(String unit) {
        double entrop = 0.0;
        int i = 0;
        while (i < this.numberOfInputStreams) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            entrop += this.inletStreamMixer.getStream(i).getFluid().getEntropy(unit);
            ++i;
        }
        this.getWaterOutStream().getThermoSystem().init(3);
        this.getOilOutStream().getThermoSystem().init(3);
        this.getGasOutStream().getThermoSystem().init(3);
        return this.getWaterOutStream().getThermoSystem().getEntropy(unit) + this.getOilOutStream().getThermoSystem().getEntropy(unit) + this.getGasOutStream().getThermoSystem().getEntropy(unit) - entrop;
    }

    @Override
    public double getExergyChange(String unit, double sourrondingTemperature) {
        double entrop = 0.0;
        int i = 0;
        while (i < this.numberOfInputStreams) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            entrop += this.inletStreamMixer.getStream(i).getFluid().getExergy(sourrondingTemperature, unit);
            ++i;
        }
        this.getWaterOutStream().getThermoSystem().init(3);
        this.getOilOutStream().getThermoSystem().init(3);
        this.getGasOutStream().getThermoSystem().init(3);
        return this.getWaterOutStream().getThermoSystem().getExergy(sourrondingTemperature, unit) + this.getOilOutStream().getThermoSystem().getEntropy(unit) + this.getGasOutStream().getThermoSystem().getExergy(sourrondingTemperature, unit) - entrop;
    }
}

