/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.reservoir;

import java.io.Serializable;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Well
implements Serializable {
    private static final long serialVersionUID = 1000L;
    private StreamInterface stream = null;
    private String name;
    double x;
    double y;
    double z;

    public Well() {
    }

    public Well(String name) {
        this.setName(name);
    }

    public StreamInterface getStream() {
        return this.stream;
    }

    public void setStream(StreamInterface stream) {
        this.stream = stream;
    }

    public double getGOR() {
        SystemInterface locStream = this.stream.getFluid().clone();
        locStream.setTemperature(288.15);
        locStream.setPressure(1.01325);
        ThermodynamicOperations ops = new ThermodynamicOperations(locStream);
        ops.TPflash();
        double GOR2 = Double.NaN;
        if (locStream.hasPhaseType("gas") && locStream.hasPhaseType("oil")) {
            GOR2 = locStream.getPhase("gas").getVolume("m3") / locStream.getPhase("oil").getVolume("m3");
        }
        return GOR2;
    }

    public double getStdGasProduction() {
        SystemInterface locStream = this.stream.getFluid().clone();
        locStream.setTemperature(288.15);
        locStream.setPressure(1.01325);
        ThermodynamicOperations ops = new ThermodynamicOperations(locStream);
        ops.TPflash();
        double volume = Double.NaN;
        if (locStream.hasPhaseType("gas")) {
            volume = locStream.getPhase("gas").getVolume("m3");
        }
        return volume;
    }

    public double getStdOilProduction() {
        SystemInterface locStream = this.stream.getFluid().clone();
        locStream.setTemperature(288.15);
        locStream.setPressure(1.01325);
        ThermodynamicOperations ops = new ThermodynamicOperations(locStream);
        ops.TPflash();
        double volume = Double.NaN;
        if (locStream.hasPhaseType("oil")) {
            volume = locStream.getPhase("oil").getVolume("m3");
        }
        return volume;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

